package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.AT;
import ibase.webitm.bean.gst.InvLineItem;

public class ATSerializer extends BaseSerializer<AT>
{
	@Override
	public void serialize(AT at, JsonGenerator json, SerializerProvider serializeProvider) throws IOException, JsonProcessingException
	{
		json.writeStartObject();
		
		if(at.taxPayerAction != null && "D".equalsIgnoreCase(at.taxPayerAction))
		{
			json.writeStringField("flag", at.taxPayerAction);
			json.writeStringField("pos", at.pos);
			json.writeStringField("sply_ty", at.supplyType);
		}
		else
		{
			json.writeStringField("pos", at.pos);
			json.writeStringField("sply_ty", at.supplyType);
			
			writeLineItems(at, json);
		}
		
		json.writeEndObject();
	}
	
	 private void writeLineItems(AT at, JsonGenerator json) throws IOException 
	    {
	        json.writeFieldName("itms");
	        
	        json.writeStartArray();
	        
	        for(InvLineItem li : at.itms)
	        {
	        	writeLineItem(json, at, li);
	        }

	        json.writeEndArray();
	    }

	    private void writeLineItem(JsonGenerator json, AT at, InvLineItem li) 
	    {
	        try 
	        {
	            json.writeStartObject();
	            
	            if("2".equalsIgnoreCase(at.recType))
	            {
	            	json.writeNumberField("num", li.num);
	            }
	            json.writeNumberField("rt", li.rate);
	            if("1".equalsIgnoreCase(at.recType))
	            {
	            	json.writeNumberField("ad_amt", li.taxval);
	            }
	            if("2".equalsIgnoreCase(at.recType))
	            {
	            	json.writeNumberField("adamt", li.taxval);
	            }

	            if(li.iamt > 0)
	            {
	            	json.writeNumberField("iamt", li.iamt);
	            }
	            if(li.camt > 0)
	            {
	            	json.writeNumberField("camt", li.camt);
	            }
	            if(li.samt > 0)
	            {
	            	json.writeNumberField("samt", li.samt);
	            }
	            if(li.csamt > 0)
	            {
	            	json.writeNumberField("csamt", li.csamt);
	            }
	            
	            json.writeEndObject();
	        }
	        catch (Exception e) 
	        {
	        	System.out.println("ATSearializer.writeLineItem()["+e.getMessage()+"]");
	            e.printStackTrace();
	        }
	    }
}
