package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.ComplianceRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import javax.servlet.http.HttpSession;

public class ComplianceSummaryFrmDateServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		ComplianceRemote complianceRemote = null;
		InitialContext context            = null;
		AppConnectParm appConnectParm     = new AppConnectParm();
		JSONObject jsonObjData            = null;
		OutputStream outputStream         = null;
		String dataSourceName             = "";
		String loginId = "";
		String frmDate = "";
		String toDate  = "";
		try
		{
			response.setContentType("application/xml");			
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();			
			
			dataSourceName       = request.getParameter("dataSourceName");
			frmDate              = request.getParameter("frmDate");
			toDate               = request.getParameter("toDate");
			System.out.println("Login code==="+loginId +"frmDate =" + frmDate+" toDate="+toDate);
			context             = new InitialContext(appConnectParm.getProperty());
			complianceRemote    = (ComplianceRemote) context.lookup("ibase/Compliance/remote");
			jsonObjData         = (JSONObject) complianceRemote.getComplianceSummaryFrmDate(loginId,dataSourceName,frmDate,toDate);
			outputStream        = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ComplianceSummaryFrmDateServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : ComplianceSummaryFrmDateServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}