package ibase.e12ria.e12widgets.client;

import com.google.gwt.dom.client.Touch;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Event.NativePreviewEvent;
import com.google.gwt.user.client.Event.NativePreviewHandler;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Used for WallToWall panel.
 * A widget that represents a single label. A label might represent a feed, and
 * entry in a feed, or some other named action.
 */
public class PanelLabel extends SimplePanel implements HasText 
{
	//Added by Prajyot P. Rumde on 20-Jul-2011 [To enable/disable SubFormFeed ]
	//final Command primary;
	private Command primary;
	private Widget widget;
	//Added by Dnyaneshwar Chavna on 15-JAN-13 [ Added touch event but implement be later ] Start
	private boolean touchAvailable = false;
	private boolean touchMoved = false;
	private int touchId;
	private int startX = 0;
	private int startY = 0;
	private HandlerRegistration handlerRegistration;
	private boolean isTouchEnd = false;
	//Added by Dnyaneshwar Chavna on 15-JAN-13 [ Added touch event but implement be later ] End
	
	public PanelLabel( String text ) 
	{
		this(text, null, false);
	}
	
	public PanelLabel( String text, Command primary ) 
	{
		this( text, primary, false );
	}

	public PanelLabel( String text, Command primary, boolean html ) 
	{
		this( html ? new UnsunkLabel( text, true ) : new UnsunkLabel( text ), primary );
	}
	
	public PanelLabel( Widget widget, Command primary ) 
	{
		this.primary = primary;
		this.widget = widget;
		
		add(widget);
		addStyleName( "PanelLabel" );
		
		if (primary != null)
		{
			sinkEvents( Event.ONCLICK | Event.TOUCHEVENTS );			
			addStyleName( "hasCommand" );
		}
	}

	public String getText() 
	{
		if ( widget instanceof HasText )
		{
			return ( ( HasText ) widget ).getText();
		} 
		else 
		{
			return widget.toString();
		}
	}
	
	
	public void onBrowserEvent( Event e )
	{
		switch ( DOM.eventGetType( e ) )
		{
			//Touch event implement be later 
			case Event.ONTOUCHSTART:
				this.onTouchStart(e);
				break;
			case Event.ONTOUCHMOVE:
				this.onTouchMove(e);
				break;
			case Event.ONTOUCHCANCEL:
			case Event.ONTOUCHEND:
				this.onTouchEnd(e);
				break;
			case Event.ONCLICK:
				primary.execute();
				//primary.execute();
				//Touch event implement be later
				/*if (!touchAvailable)
				{
					primary.execute();
				}*/
				
		}
	}
	
	public void setBusy( boolean busy ) 
	{
		if ( busy ) 
		{
			addStyleName( "busy" );
		}
		else 
		{
			removeStyleName( "busy" );
		}
	}
	
	public void setText( String text ) 
	{
		if ( widget instanceof HasText )
		{
			( ( HasText ) widget ).setText( text );
		}
	}
	
	//Added by Prajyot P. Rumde on 20-Jul-2011 [To enable/disable SubFormFeed ] Starts
	public void setCommand( Command primary ) 
	{
		this.primary = primary;
		if (primary != null)
		{
			sinkEvents( Event.ONCLICK | Event.TOUCHEVENTS );
			addStyleName( "hasCommand" );
		}
		else
		{
			removeStyleName( "hasCommand" );
		}
	}

	public Command getCommand( ) 
	{
		return primary;
	}
	//Added by Prajyot P. Rumde on 20-Jul-2011 [To enable/disable SubFormFeed ] Ends
	
	//Added by Prajyot P. Rumde on 22-Nov-2011 [To setPanelWidget ] Starts
	public void setPanelWidget( Widget panelWidget )
	{
		remove(widget);
		widget = panelWidget;
		add(panelWidget);
	}
	//Added by Prajyot P. Rumde on 22-Nov-2011 [To setPanelWidget ] Ends
	
	private void onTouchStart(Event event) 
	{
		// Stop the event from bubbling up
		event.stopPropagation();
		// Only handle if we have exactly one touch
		if (event.getTargetTouches().length() == 1) 
		{
			Touch start = event.getTargetTouches().get(0);
			touchId = start.getIdentifier();
			touchMoved = false;
		}

	}

    /**
     * Check to see if the touch has moved off of the element.
     *
     * NOTE that in iOS the elasticScroll may make the touch/move cancel more difficult.
     *
     * @param event
     */
	private void onTouchMove(Event event) 
	{
		if (!touchMoved) 
		{
			Touch move = null;
			for (int i = 0; i < event.getChangedTouches().length(); i++) 
			{
				if (event.getChangedTouches().get(i).getIdentifier() == touchId) 
				{
					move = event.getChangedTouches().get(i);
				}
			}
			// Check to see if we moved off of the original element

			// Use Page coordinates since we compare with widget's absolute
			// coordinates
			int yCord = move.getPageY();
			int xCord = move.getPageX();

			boolean yTop = getWidget().getAbsoluteTop() > yCord; // is y above
																	// element
			boolean yBottom = (getWidget().getAbsoluteTop() + getWidget()
					.getOffsetHeight()) < yCord; // y
													// below
			boolean xLeft = getWidget().getAbsoluteLeft() > xCord; // is x to
																	// the left
																	// of
																	// element
			boolean xRight = (getWidget().getAbsoluteLeft() + getWidget()
					.getOffsetWidth()) < xCord; // x
												// to
												// the
												// right
			
			if (yTop || yBottom || xLeft || xRight) 
			{
				touchMoved = true;
			}
		}

	}

	private void onTouchEnd(Event event) 
	{
		if (!touchMoved) 
		{
			if ( "iOS".equalsIgnoreCase( getDeviceOS() )  )
			{
				event.preventDefault();
				fireClick();
			}
			else if( "Android".equalsIgnoreCase( getDeviceOS() ) )
			{
				//touchHandledHidden.setValue( "true" );
				event.preventDefault();
				handlerRegistration = Event.addNativePreviewHandler( new NativePreviewHandler() 
				{
					@Override
					public void onPreviewNativeEvent(NativePreviewEvent event) 
					{
						
						if( isTouchEnd &&  event.getTypeInt() == Event.ONCLICK )
						{
							event.cancel();
							removePreviewHandler();
							isTouchEnd = false;
						}
					}
				});
				fireClick();
				
			}
		}
	}
    
    /**
     * @param executor
     * @return
     */
    private void fireClick() 
    {
    	primary.execute();
    	isTouchEnd = true;
    }
    
    private void removePreviewHandler()
    {
    	handlerRegistration.removeHandler();
    }
	
	private native String getDeviceOS( )
	/*-{
		var deviceOS = $doc.deviceOS;
		return deviceOS;
	}-*/;
	
	private native String getDeviceType( )
	/*-{
		var deviceType = $doc.deviceType;
		return deviceType;
	}-*/;
}
	
	