package ibase.dashboard.calendar.servlet;

import ibase.dashboard.calendar.ejb.CalendarDBRRemote;
import ibase.system.config.AppConnectParm;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class CalendarDBRServlet extends HttpServlet 
{
	
	private static final long serialVersionUID = 1L;
	
	public void doGet( HttpServletRequest request, HttpServletResponse response )throws IOException, ServletException
	{
		doPost(request, response);
	}
	
	public void doPost( HttpServletRequest request, HttpServletResponse response )throws IOException, ServletException
	{
		try 
		{
			System.out.println("**************** inside CalendarDBR servlet ***********");
			CalendarDBRRemote calendarDBRRemote = null;
			InitialContext context              = null;
			AppConnectParm appConnectParm       = new AppConnectParm();
			String dataSourceName               = "";
			String displayView = "";
			String period = "";
			String loginCode = "";
			
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");

			dataSourceName = request.getParameter("dataSourceName");
			displayView = request.getParameter("DISPLAY_VIEW");
			period = request.getParameter("PERIOD");
			loginCode = userInfo.getLoginCode();
			
			context = new InitialContext(appConnectParm.getProperty());
			calendarDBRRemote           = (CalendarDBRRemote) context.lookup("ibase/CalendarDBR/remote");
			calendarDBRRemote.setUserInfo(userInfo);
			//JSONObject jsonObjData      = (JSONObject) calendarDBRRemote.getPlacesVisitedCount( dataSourceName, period, loginCode );
			//JSONObject jsonObjData      = (JSONObject) calendarDBRRemote.getStationCount( period, loginCode );
			JSONObject jsonObjData      = (JSONObject) calendarDBRRemote.getStationCountNew(period, loginCode);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for CalendarDBR is ===" + jsonObjData);					
		}
		catch (Exception e)
		{
			System.out.println("Exception in CalendarDBRServlet : "+e);
		}
	}
}
