
CREATE TABLE  LOP_HDR (
	LOP_REF_NO CHAR(20) NOT NULL,
	LOP_DATE 	DATE NOT NULL,
	AUTH_LOC CHAR(40),  -- New field authorizing location
	VALID_FROM DATE,
	VALID_TO DATE,
	 SITE_CODE CHAR(5) NOT NULL,
	 EMP_CODE__APRV CHAR(10),
	 CONFIRMED CHAR(1),
	 CONF_DATE  DATE,
	 CHG_DATE DATE NOT NULL,
	 CHG_USER CHAR(10) NOT NULL,
	 CHG_TERM   VARCHAR2(15) NOT NULL
	) tablespace itm_dis_d2;
ALTER TABLE  LOP_HDR  
		ADD CONSTRAINT LOP_HDR_X PRIMARY KEY (LOP_REF_NO) using index tablespace itm_dis_i1;

CREATE TABLE  LOP_DET(
	 LOP_REF_NO CHAR(20) NOT NULL,
	 LINE_NO		NUMBER(3) NOT NULL,
	 ITEM_CODE CHAR(10) NOT NULL,
	 ITEM_DESCR VARCHAR2(120),
	 ITEM_STATUS CHAR(1), -- ITEM ACTIVE/INCATIVE
	 BUY_SELL_FLAG CHAR(1),  --BUY/SELL INDICATOR
	 TARIFF_HEAD VARCHAR2(40)
	) tablespace itm_dis_d2;
ALTER TABLE    LOP_DET
		ADD CONSTRAINT LOP_DET_X PRIMARY KEY (LOP_REF_NO,LINE_NO) using index tablespace itm_dis_i1;
					LOP AMENDMENT
CREATE TABLE  LOP_AMD_HDR (
	TRAN_ID CHAR(10) NOT NULL,
	TRAN_DATE 	DATE NOT NULL,
	LOP_REF_NO CHAR(20) NOT NULL,
	SITE_CODE CHAR(5) NOT NULL,
	AUTH_LOC__O CHAR(40),  -- New field authorizing location
	AUTH_LOC CHAR(40),
	VALID_FROM__O DATE,
	VALID_FROM DATE,
	VALID_TO__O DATE,
	VALID_TO DATE,
	EMP_CODE__APRV CHAR(10),
	CONFIRMED CHAR(1),
	CONF_DATE  DATE,
	CHG_DATE DATE NOT NULL,
	CHG_USER CHAR(10) NOT NULL,
	CHG_TERM   VARCHAR2(15) NOT NULL
	) tablespace itm_dis_d2;
ALTER TABLE   LOP_AMD_HDR
		ADD CONSTRAINT LOP_AMD_HDR_X PRIMARY KEY (TRAN_ID) using index tablespace itm_dis_i1;
CREATE TABLE  LOP_AMD_DET (
	 TRAN_ID CHAR(10) NOT NULL,
	 LINE_NO		NUMBER(3) NOT NULL,
	  LINE_NO_LOP		NUMBER(3),
	  ITEM_CODE__O CHAR(10),
	 ITEM_CODE CHAR(10) NOT NULL,
	 ITEM_DESCR__O VARCHAR2(120),
	ITEM_DESCR VARCHAR2(120),
	 BUY_SELL_FLAG__O CHAR(1),  --BUY/SELL INDICATOR
	BUY_SELL_FLAG CHAR(1),
	ITEM_STATUS__O CHAR(1), -- ITEM ACTIVE/INCATIVE
	ITEM_STATUS CHAR(1), 
	 TARIFF_HEAD__O VARCHAR2(40),
	 TARIFF_HEAD VARCHAR2(40)
	) tablespace itm_dis_d2;
ALTER TABLE    LOP_AMD_DET
		ADD CONSTRAINT LOP_AMD_DET_X PRIMARY KEY (TRAN_ID,LINE_NO) using index tablespace itm_dis_i1;

		
CREATE TABLE  CT3FORM_HDR (
	 TRAN_ID CHAR(10) NOT NULL,
	 TRAN_DATE DATE,
	 SITE_CODE CHAR(5),
	 FORM_NO VARCHAR2(20) NOT NULL,
	 EFF_FROM  DATE, 
	 VALID_UPTO DATE,
	 STATUS   CHAR(1),
	 STATUS_DATE   DATE,
	 EMP_CODE__APRV CHAR(10),
	 CONFIRMED CHAR(1),
	 CONF_DATE  DATE,
	 REMARKS VARCHAR2(60),
	 CHG_DATE DATE NOT NULL,
	 CHG_USER CHAR(10) NOT NULL,
	 CHG_TERM   VARCHAR2(15) NOT NULL
	) tablespace itm_dis_d2;
	
ALTER TABLE  CT3FORM_HDR 
			ADD CONSTRAINT CT3FORM_HDR_X PRIMARY KEY ( TRAN_ID) using index tablespace itm_dis_i1;
ALTER TABLE  CT3FORM_HDR 
			ADD CONSTRAINT UK_CT3FORM_HDR UNIQUE ( FORM_NO) using index tablespace itm_dis_i1;
CREATE TABLE  CT3FORM_DET (
	 TRAN_ID		CHAR(10) NOT NULL,
	 LINE_NO		NUMBER(3) NOT NULL,
	 DOC_TYPE		CHAR(1),
	 DATE_OF_ISS		DATE,
	 SUPP_CODE		CHAR(10),
	 CT3_VALUE		NUMBER(14,3), 
	 ITEM_CODE		CHAR(10), 
	 QUANTITY		NUMBER(14,3),
	 QTY_USED		NUMBER(14,3),
	 TAX_RATE		NUMBER(14,3),
	 EXG_RATE		NUMBER(14,3),
	 BILL_REF		CHAR(10), --  PARTY'S BILL REF
	 BILL_OF_LADING		CHAR(10),
	 PURC_ORDER		CHAR(10)
	) tablespace itm_dis_d2;
ALTER TABLE  CT3FORM_DET 
		ADD CONSTRAINT CT3FORM_DET_X PRIMARY KEY ( TRAN_ID,LINE_NO) using index tablespace itm_dis_i1;
	ALTER TABLE  CT3FORM_DET 	ADD CONSTRAINT UK_CT3FORM_DET UNIQUE ( TRAN_ID,ITEM_CODE) using index tablespace itm_dis_i1;
CREATE TABLE  B17_BOND (
	 BOND_NO CHAR(10) NOT NULL,
	 BOND_DATE DATE,
	 SITE_CODE CHAR(5),
	 BOND_VALUE NUMBER(14,3),
	 EFF_FROM DATE,
	 VALID_UPTO DATE,
	 BANK_GUARANTEE NUMBER(14,3),
	 EMP_CODE__APRV CHAR(10),
	 CONFIRMED CHAR(1),
	 CONF_DATE  DATE,
	 CHG_DATE DATE NOT NULL,
	 CHG_USER CHAR(10) NOT NULL,
	 CHG_TERM   VARCHAR2(15) NOT NULL
	) tablespace itm_dis_d2;
ALTER TABLE  B17_BOND 
		ADD CONSTRAINT B17_BOND_X PRIMARY KEY ( BOND_NO) using index tablespace itm_dis_i1;
CREATE TABLE  PROOF_OF_EXP_HDR (
	 TRAN_ID CHAR(10) NOT NULL,
	 TRAN_DATE DATE,
	 SITE_CODE CHAR(5),
	 EMP_CODE__APRV CHAR(10),
	 CONFIRMED CHAR(1),
	 CONF_DATE  DATE,
	 REMARKS VARCHAR2(60),
	 CHG_DATE DATE NOT NULL,
	 CHG_USER CHAR(10) NOT NULL,
	 CHG_TERM   VARCHAR2(15) NOT NULL
	) tablespace itm_dis_d2;
ALTER TABLE  PROOF_OF_EXP_HDR 
		ADD CONSTRAINT PROOF_OF_EXP_HDR_X PRIMARY KEY ( TRAN_ID) using index tablespace itm_dis_i1;
CREATE TABLE  PROOF_OF_EXP_DET (
	 TRAN_ID		CHAR(10) NOT NULL,
	 LINE_NO		NUMBER(3) NOT NULL,
	 REF_SER                VARCHAR2(6),
	 REF_ID                 CHAR(10),
	 TAX_AMT		NUMBER(14,3)  --duty
	) tablespace itm_dis_d2;
ALTER TABLE  PROOF_OF_EXP_DET 
		ADD CONSTRAINT PROOF_OF_EXP_DET_X PRIMARY KEY ( TRAN_ID,LINE_NO) using index tablespace itm_dis_i1;

INSERT INTO transetup (tran_window,
	save_flag,
	val_flag,
	key_flag,
	key_string,
	repeate_add,
	chg_date,
	chg_user,
	chg_term,
	edi_option,
	site_acc_col,
	confirm_col,
	confirm_val,
	repeat_add_det,
	ledg_post_conf,
	tran_id_col,
	table_name,
	tran_date_col,
	multitire_opt,
	ref_ser,
	tax_forms,
	childdata_argopt,
	edit_opt,
	rate_col,
	qty_col)
VALUES (
	'w_lop',
	'2',
	'2',
	'M',
	'seq06',
	'N',
	TO_DATE('16-01-2008 15:36:30','DD-MM-YYYY HH24:MI:SS'),
	'BASE      ',
	'07BASE215      ',
	'0',
	NULL,
	'CONFIRMED',
	'Y',
	'Y',
	'N',
	'lop_ref_no',
	'lop_hdr',
	NULL,
	NULL,
	'S-AMD',
	NULL,
	'2',
	'3',
	NULL,
	NULL);
INSERT INTO transetup (tran_window,
	save_flag,
	val_flag,
	key_flag,
	key_string,
	repeate_add,
	chg_date,
	chg_user,
	chg_term,
	edi_option,
	site_acc_col,
	confirm_col,
	confirm_val,
	repeat_add_det,
	ledg_post_conf,
	tran_id_col,
	table_name,
	tran_date_col,
	multitire_opt,
	ref_ser,
	tax_forms,
	childdata_argopt,
	edit_opt,
	rate_col,
	qty_col)
VALUES (
	'w_b17_bond',
	'2',
	'2',
	'M',
	'seq10',
	'N',
	TO_DATE('17-10-2008 10:19:11','DD-MM-YYYY HH24:MI:SS'),
	'pankaj    ',
	'BASE204        ',
	'0',
	NULL,
	'CONFIRMED',
	'Y',
	NULL,
	'N',
	'TRAN_ID',
	'b17_bond',
	NULL,
	NULL,
	'W-PRD',
	NULL,
	NULL,
	'3',
	NULL,
	NULL);
INSERT INTO transetup(tran_window,
	save_flag,
	val_flag,
	key_flag,
	key_string,
	repeate_add,
	chg_date,
	chg_user,
	chg_term,
	edi_option,
	site_acc_col,
	confirm_col,
	confirm_val,
	repeat_add_det,
	ledg_post_conf,
	tran_id_col,
	table_name,
	tran_date_col,
	multitire_opt,
	ref_ser,
	tax_forms,
	childdata_argopt,
	edit_opt,
	rate_col,
	qty_col)
 VALUES (
	'w_proof_of_exp',
	'2',
	'2',
	'A',
	'seq10',
	NULL,
	TO_DATE('17-10-2008 14:12:14','DD-MM-YYYY HH24:MI:SS'),
	'pankaj    ',
	'BASE204        ',
	'0',
	NULL,
	'CONFIRMED',
	'Y',
	NULL,
	NULL,
	'TRAN_ID',
	NULL,
	NULL,
	NULL,
	'W-PRF',
	NULL,
	NULL,
	'3',
	NULL,
	NULL);
INSERT INTO transetup (tran_window,
	save_flag,
	val_flag,
	key_flag,
	key_string,
	repeate_add,
	chg_date,
	chg_user,
	chg_term,
	edi_option,
	site_acc_col,
	confirm_col,
	confirm_val,
	repeat_add_det,
	ledg_post_conf,
	tran_id_col,
	table_name,
	tran_date_col,
	multitire_opt,
	ref_ser,
	tax_forms,
	childdata_argopt,
	edit_opt,
	rate_col,
	qty_col)
VALUES (
	'w_close_ct',
	'2',
	'2',
	'M',
	'seq10',
	'N',
	TO_DATE('2-12-2008 11:42:33','DD-MM-YYYY HH24:MI:SS'),
	'BASE204   ',
	'1              ',
	'0',
	NULL,
	NULL,
	'Y',
	NULL,
	'N',
	'TRAN_ID',
	NULL,
	NULL,
	'2',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);
INSERT INTO transetup (tran_window,
	save_flag,
	val_flag,
	key_flag,
	key_string,
	repeate_add,
	chg_date,
	chg_user,
	chg_term,
	edi_option,
	site_acc_col,
	confirm_col,
	confirm_val,
	repeat_add_det,
	ledg_post_conf,
	tran_id_col,
	table_name,
	tran_date_col,
	multitire_opt,
	ref_ser,
	tax_forms,
	childdata_argopt,
	edit_opt,
	rate_col,
	qty_col)
VALUES (
	'w_ctform',
	'2',
	'2',
	'A',
	'seq10',
	'N',
	TO_DATE('16-01-2008 15:36:30','DD-MM-YYYY HH24:MI:SS'),
	'BASE      ',
	'07BASE215      ',
	'0',
	NULL,
	'CONFIRMED',
	'Y',
	NULL,
	NULL,
	'TRAN_ID',
	NULL,
	NULL,
	NULL,
	'S-CTF',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);
INSERT INTO transetup (tran_window,
	save_flag,
	val_flag,
	key_flag,
	key_string,
	repeate_add,
	chg_date,
	chg_user,
	chg_term,
	edi_option,
	site_acc_col,
	confirm_col,
	confirm_val,
	repeat_add_det,
	ledg_post_conf,
	tran_id_col,
	table_name,
	tran_date_col,
	multitire_opt,
	ref_ser,
	tax_forms,
	childdata_argopt,
	edit_opt,
	rate_col,
	qty_col)
VALUES (
	'w_ctformamd',
	'2',
	'2',
	'A',
	'seq10',
	'N',
	TO_DATE('16-01-2008 15:36:30','DD-MM-YYYY HH24:MI:SS'),
	'BASE      ',
	'07BASE215      ',
	'0',
	NULL,
	'CONFIRMED',
	'Y',
	NULL,
	NULL,
	'TRAN_ID',
	NULL,
	NULL,
	NULL,
	'S-CTF',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);
		
INSERT INTO itm2menu 
 (
	application ,
	level_1,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name,
	descr,
	comments ,
	menu_path,
	icon_path,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user )
VALUES
(
	'EOU',
	0,
	0,
	0,
	0,
	0,
	NULL,
	'EOU',
	NULL,
	'EOU.0.0.0.0.0',
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'01BASE78',
	'BASE      ');
INSERT INTO itm2menu 
(
	application ,
	level_1,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name,
	descr,
	comments ,
	menu_path,
	icon_path,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user )
VALUES (
	'EOU',
	1,
	0,
	0,
	0,
	0,
	NULL,
	'Master',
	NULL,
	'EOU.1.0.0.0.0',
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'EO89SUN004',
	'BASE      ');
INSERT INTO itm2menu 
(
	application ,
	level_1,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name,
	descr,
	comments ,
	menu_path,
	icon_path,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user )
VALUES (
	'EOU',
	1,
	1,
	0,
	0,
	0,
	'w_lop',
	'LOP',
	NULL,
	'EOU.1.1.0.0.0',
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'EO89SUN004',
	'BASE      ');
INSERT INTO itm2menu
(
	application ,
	level_1,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name,
	descr,
	comments ,
	menu_path,
	icon_path,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user )
 VALUES (
	'EOU',
	1,
	2,
	0,
	0,
	0,
	'w_b17_bond',
	'B17 Bond',
	NULL,
	'EOU.1.2.0.0.0',
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'EO89SUN004',
	'BASE      ');
INSERT INTO itm2menu
(
	application ,
	level_1,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name,
	descr,
	comments ,
	menu_path,
	icon_path,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user )
 VALUES (
	'EOU',
	2,
	0,
	0,
	0,
	0,
	NULL,
	'Transaction',
	NULL,
	'EOU.2.0.0.0.0',
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'EO89SUN004',
	'BASE      ');
INSERT INTO itm2menu
(
	application ,
	level_1,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name,
	descr,
	comments ,
	menu_path,
	icon_path,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user )
 VALUES (
	'EOU',
	2,
	1,
	0,
	0,
	0,
	'w_ctform',
	'CTFORM',
	NULL,
	'EOU.2.1.0.0.0',
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'EO89SUN004',
	'BASE      ');
INSERT INTO itm2menu
(
	application ,
	level_1,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name,
	descr,
	comments ,
	menu_path,
	icon_path,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user )
 VALUES (
	'EOU',
	2,
	2,
	0,
	0,
	0,
	'w_proof_of_exp',
	'Proof Of Export',
	NULL,
	'EOU.2.2.0.0.0',
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'EO89SUN004',
	'BASE      ');

insert into obj_forms (win_name,form_no) values ('w_ctform',1);
insert into obj_forms (win_name,form_no) values ('w_ctform',2);
INSERT INTO obj_actions
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
 VALUES (
	'ctform',
	1,
	'A',
	'a',
	'a',
	'Adding New',
	'Add',
	'add.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions 
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
VALUES
 (
	'ctform',
	2,
	'E',
	'a',
	'a',
	'Editing Existing Record',
	'Edit',
	'edit.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions 
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
VALUES (
	'ctform',
	3,
	'D',
	'a',
	'a',
	'Delete',
	'Delete',
	'delete.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
 VALUES (
	'ctform',
	4,
	'S',
	'a',
	'a',
	'Saving',
	'Save',
	'save.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'ctform',
	'pre_validate',
	'1',
	'prv_default_ejb',
	NULL,
	fn_sysdate(),
	'manazir  ',
	'manazir',
	'2',
	'0',
	'EJB',
	'CTFORM',
	NULL);
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'ctform',
	'post_item_change',
	'1',
	'poic_default_ejb',
	NULL,
	fn_sysdate(),
	'manazir  ',
	'manazir',
	'2',
	'0',
	'EJB',
	'CTFORM',
	NULL);
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTDUPCT','Duplicate CT3/PC !','Duplicate CT3/PC should not exists for same site,supplier,item_code and validity period','E','Y');
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTCTFNL','FormNo Null !','Please Enter form no','E','Y');
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VMBNVFNL','Bond Value Null !','Bond value cannot be null ','E','Y');
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTQTYGQT','Qty Used greater then qty','Quantity used cannot be greater the quantity','E','Y');
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTVLEFN','Date cant be null','Please enter valid upto and effective from dates','E','Y');
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('CTCLOSUCC','CT3 Transaction Closed!','CT3 Form Transaction closed successfully!','P','Y');
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTDUPCF','Duplicate Form No !','Please enter unique Form No','E','Y');
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTQTYGT','Quantity greater then PO qty !','Quantity entered can not be greater then quatity for same PO and item ','E','Y');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTPRFTD','Invalid Refference Id or is not confirmed!','Refference Id eneterd does not exist in distord_iss !','E','Y');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTPRFTDE','Invalid Refference Id !','Refference Id eneterd does not exist in despatch or is not confirmed!','E','Y');

INSERT INTO obj_itemchange VALUES (
	'ctform',
	'1',
	'itm_default',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'ctform',
	'2',
	'itm_defaultedit',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'ctform',
	'1',
	'site_code',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'ctform',
	'2',
	'itm_default',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'ctform',
	'2',
	'supp_code',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'ctform',
	'2',
	'item_code',
	NULL);
insert into obj_forms (win_name,form_no) values ('w_lop',1);
INSERT INTO obj_actions
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
 VALUES (
	'lop',
	1,
	'A',
	'a',
	'a',
	'Adding New',
	'Add',
	'add.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions 
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
VALUES (
	'lop',
	2,
	'E',
	'a',
	'a',
	'Editing Existing Record',
	'Edit',
	'edit.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
 VALUES (
	'lop',
	3,
	'D',
	'a',
	'a',
	'Delete',
	'Delete',
	'delete.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
 VALUES (
	'lop',
	4,
	'S',
	'a',
	'a',
	'Saving',
	'Save',
	'save.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'lop',
	'pre_validate',
	'1',
	'prv_default_ejb',
	NULL,
	fn_sysdate(),
	'manazir  ',
	'manazir',
	'2',
	'0',
	'EJB',
	'LOP',
	NULL);
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'lop',
	'post_item_change',
	'1',
	'poic_default_ejb',
	NULL,
	fn_sysdate(),
	'manazir  ',
	'manazir',
	'2',
	'0',
	'EJB',
	'LOP',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'lop',
	'1',
	'item_code',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'lop',
	'1',
	'itm_default',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'lop',
	'1',
	'site_code',
	NULL);
 INSERT INTO obj_forms (
	win_name ,
	title ,
	obj_brow_name ,
	obj_edit_name ,
	cross_update_expr ,
	expr_fld_info ,
	target_fld_info ,
	expr_comment ,
	form_no ,
	scr_flag ,
	scan_flag ,
	scan_metadata ,
	auto_accept_scan )
 VALUES (
	'w_proof_of_exp',
	'Proof Of Export ',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'1',
	NULL,
	NULL,
	NULL,
	NULL);
INSERT INTO obj_forms (
	win_name ,
	title ,
	obj_brow_name ,
	obj_edit_name ,
	cross_update_expr ,
	expr_fld_info ,
	target_fld_info ,
	expr_comment ,
	form_no ,
	scr_flag ,
	scan_flag ,
	scan_metadata ,
	auto_accept_scan )
 VALUES (
	'w_proof_of_exp',
	'Proof Of Export Tax',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'2',
	NULL,
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions (obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	form_no,
	service_handler,
	placement,
	action_type)
VALUES (
	'proof_of_exp',
	1,
	'A',
	'a',
	'a',
	'a',
	'Add',
	'add.gif',
	'1',
	NULL,
	NULL,
	'S');
INSERT INTO obj_actions (obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	form_no,
	service_handler,
	placement,
	action_type)
VALUES (
	'proof_of_exp',
	2,
	'E',
	'a',
	'a',
	'a',
	'Edit',
	'edit.gif',
	'1',
	NULL,
	NULL,
	'S');
INSERT INTO obj_actions (obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	form_no,
	service_handler,
	placement,
	action_type)
VALUES (
	'proof_of_exp',
	3,
	'D',
	'a',
	'a',
	'a',
	'Delete',
	'delete.gif',
	'1',
	NULL,
	NULL,
	'S');
INSERT INTO obj_actions (obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	form_no,
	service_handler,
	placement,
	action_type)
VALUES (
	'proof_of_exp',
	4,
	'S',
	'a',
	'a',
	'a',
	'Save',
	'save.gif',
	'1',
	NULL,
	NULL,
	'S');
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'proof_of_exp',
	'post_item_change',
	'1',
	'poic_default_ejb',
	NULL,
	fn_sysdate(),
	'pankaj  ',
	'pankaj',
	'2',
	'0',
	'EJB',
	'ProofOfExp',
	NULL);
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'proof_of_exp',
	'pre_validate',
	'1',
	'prv_default_ejb',
	NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	'2',
	'0',
	'EJB',
	'ProofOfExp',
	NULL);
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)
values(
	'proof_of_exp',
	'1',
	'itm_default');	
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)
values(
	'proof_of_exp',
	'1',
	'site_code');	
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)	
values(
	'proof_of_exp',
	'1',
	'emp_code__aprv');
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)	
values(
	'proof_of_exp',
	'2',
	'itm_default');
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)	
values(
	'proof_of_exp',
	'2',
	'ref_id');
INSERT INTO obj_forms (
	win_name ,
	title ,
	obj_brow_name ,
	obj_edit_name ,
	cross_update_expr ,
	expr_fld_info ,
	target_fld_info ,
	expr_comment ,
	form_no ,
	scr_flag ,
	scan_flag ,
	scan_metadata ,
	auto_accept_scan )
 VALUES (
	'w_b17_bond',
	'B17 Bond ',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'1',
	NULL,
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions (obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	form_no,
	service_handler,
	placement,
	action_type)
VALUES (
	'b17_bond',
	1,
	'A',
	'a',
	'a',
	'a',
	'Add',
	'add.gif',
	'1',
	NULL,
	NULL,
	'S');
INSERT INTO obj_actions (obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	form_no,
	service_handler,
	placement,
	action_type)
VALUES (
	'b17_bond',
	2,
	'E',
	'a',
	'a',
	'a',
	'Edit',
	'edit.gif',
	'1',
	NULL,
	NULL,
	'S');
INSERT INTO obj_actions (obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	form_no,
	service_handler,
	placement,
	action_type)
VALUES (
	'b17_bond',
	3,
	'D',
	'a',
	'a',
	'a',
	'Delete',
	'delete.gif',
	'1',
	NULL,
	NULL,
	'S');
INSERT INTO obj_actions (obj_name,
	line_no,
	rights_char,
	interactive,
	service_code,
	description,
	title,
	image,
	form_no,
	service_handler,
	placement,
	action_type)
VALUES (
	'b17_bond',
	4,
	'S',
	'a',
	'a',
	'a',
	'Save',
	'save.gif',
	'1',
	NULL,
	NULL,
	'S');
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'b17_bond',
	'post_item_change',
	'1',
	'poic_default_ejb',
	NULL,
	fn_sysdate(),
	'pankaj  ',
	'pankaj',
	'2',
	'0',
	'EJB',
	'Bond',
	NULL);
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'b17_bond',
	'pre_validate',
	'1',
	'prv_default_ejb',
	NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	'2',
	'0',
	'EJB',
	'Bond',
	NULL);
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)
values(
	'b17_bond',
	'1',
	'itm_default');	
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)
values(
	'b17_bond',
	'1',
	'site_code');	
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)	
values(
	'b17_bond',
	'1',
	'emp_code__aprv');
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)	
values(
	'b17_bond',
	'1',
	'bank_guarantee');
insert into messages
(msg_no,msg_str,msg_descr,msg_type,msg_opt)
values('VTDUBND','Duplicate Bond Value !','Duplicate bond value should not exists for same site and validity period','E','Y');
INSERT INTO system_events(
	obj_name ,
	event_code,
	event_context,
	service_code,
	method_rule,
	chg_date,
	chg_user,
	chg_term,
	result_handle,
	overwrite_core,
	comp_type ,
	comp_name ,
	comm_format
) VALUES (
	'close_ct',
	'process',
	'1',
	'pcs_close_ct',
	NULL,
	fn_sysdate(),
	'pankaj',
	'Base204',
	'2',
	'0',
	'EJB',
	'CloseCTPrc',
	NULL);
INSERT INTO system_event_services (
	service_code ,
	service_descr,
	service_uri ,
	service_provider,
	method_name ,
	return_value,
	return_type,
	return_descr ,
	return_xfrm ,
	chg_date ,
	chg_user ,
	chg_term 
)values(
	'pcs_close_ct',
	'process',
	'http://localhost:9090/axis/services/ProcessService',
	'BASE',
	'process',
	NULL,
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'pankaj',
	'Base206');

INSERT INTO system_service_args VALUES (
	'pcs_close_ct',
	1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'C.String',
	NULL,
	TO_DATE('16-05-2008 14:33:48','DD-MM-YYYY HH24:MI:SS'),
	'pankaj    ',
	'BASE207        ',
	'EJB');
INSERT INTO system_service_args VALUES (
	'pcs_close_ct',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'C.String',
	NULL,
	TO_DATE('16-05-2008 14:33:48','DD-MM-YYYY HH24:MI:SS'),
	'pankaj    ',
	'BASE207        ',
	'CloseCTPrc');
INSERT INTO system_service_args VALUES (
	'pcs_close_ct',
	3,
	'XML_DATA_1',
	'I',
	'XML data of form no 1',
	'S',
	NULL,
	TO_DATE('16-05-2008 14:33:48','DD-MM-YYYY HH24:MI:SS'),
	'pankaj    ',
	'BASE207        ',
	NULL);
INSERT INTO system_service_args VALUES (
	'pcs_close_ct',
	4,
	'XML_DATA__ALL',
	'I',
	'XML data of form no 1',
	'S',
	NULL,
	TO_DATE('16-05-2008 14:33:48','DD-MM-YYYY HH24:MI:SS'),
	'pankaj    ',
	'BASE207        ',
	NULL);
INSERT INTO system_service_args VALUES (
	'pcs_close_ct',
	5,
	'WINDOW_NAME',
	'I',
	'Object Context',
	'S',
	NULL,
	TO_DATE('16-05-2008 14:33:48','DD-MM-YYYY HH24:MI:SS'),
	'pankaj    ',
	'BASE207        ',
	'w_close_ct');
INSERT INTO system_service_args VALUES (
	'pcs_close_ct',
	6,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	TO_DATE('16-05-2008 14:33:48','DD-MM-YYYY HH24:MI:SS'),
	'pankaj    ',
	'BASE207        ',
	NULL);
INSERT INTO obj_forms(
	win_name ,
	title ,
	obj_brow_name ,
	obj_edit_name ,
	cross_update_expr ,
	expr_fld_info ,
	target_fld_info ,
	expr_comment ,
	form_no )
VALUES (
	'w_close_ct',
	'Close Ct3/PC',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'1');
insert into obj_actions(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE)
	VALUES(
	'ctform',  
	11,
	'F',
	'a',
	'act_confirm',
	'Confirm',
	'Confirm',
	NULL,
	'1',
	'2',
	NULL,
	'U');
insert into system_events(
	obj_name,
	event_code,
	event_context,
	service_code,
	method_rule,
	chg_date,
	chg_user,
	chg_term,
	result_handle,
	overwrite_core,
	comp_type,
	comp_name,
	comm_format)
values(
	'ctform',
	'act_confirm',
	'1',
	'confirm_ct',
	NULL,
	fn_sysdate(),
	'SYSTEM'  ,
	'SYSTEM',
	'2',
	'0',
	'EJB',
	'ConfirmCTFORM',
	NULL);
insert into system_event_services(
	service_code,
	service_descr,
	service_uri,
	service_provider,
	method_name,
	return_value,
	return_type,
	return_descr,
	return_xfrm,
	chg_date,
	chg_user,
	chg_term)
values(
	'confirm_ct',
	'Action To confirm',
	'http://localhost:9090/axis/services/ActionHandlerService',
	'Base Information',
	'actionHandler',
	'String',
	'S',
	NULL,
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ct',
         1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	'EJB');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ct',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	'ConfirmCTFORM');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ct',
	3,
	'<tran_id>',
	'I',
	'tranid',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ct',
	4,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ct',
	5,
	'FORCED_FLAG',
	'I',
	'Forced Flag',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	NULL);
insert into obj_actions(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE)
	VALUES(
	'proof_of_exp',  
	11,
	'F',
	'a',
	'act_confirm',
	'Confirm',
	'Confirm',
	NULL,
	'1',
	'2',
	NULL,
	'U');
insert into system_events(
	obj_name,
	event_code,
	event_context,
	service_code,
	method_rule,
	chg_date,
	chg_user,
	chg_term,
	result_handle,
	overwrite_core,
	comp_type,
	comp_name,
	comm_format)
values(
	'proof_of_exp',
	'act_confirm',
	'1',
	'confirm_prf',
	NULL,
	fn_sysdate(),
	'SYSTEM'  ,
	'SYSTEM',
	'2',
	'0',
	'EJB',
	'ConfirmProofOfExp',
	NULL);
insert into system_event_services(
	service_code,
	service_descr,
	service_uri,
	service_provider,
	method_name,
	return_value,
	return_type,
	return_descr,
	return_xfrm,
	chg_date,
	chg_user,
	chg_term)
values(
	'confirm_prf',
	'Action To confirm',
	'http://localhost:9090/axis/services/ActionHandlerService',
	'Base Information',
	'actionHandler',
	'String',
	'S',
	NULL,
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_prf',
         1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	'EJB');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_prf',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	'ConfirmProofOfExp');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_prf',
	3,
	'<tran_id>',
	'I',
	'tranid',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_prf',
	4,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_prf',
	5,
	'FORCED_FLAG',
	'I',
	'Forced Flag',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	NULL);
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'CONCTSUCC',
	'CT3 Form Confirmed !',
	 'CT3 Form Transation Confirmed Successfully ! ',
	 'P',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL);
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'VTCTFIT',
	'Invalid Item !',
	 'Item and purcahe order does not match! ',
	 'E',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL);
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'CONPRFSUCC',
	'Proof Of Export Confirmed !',
	 'Proof Of Export Transation Confirmed Successfully ! ',
	 'P',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL);
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'CONBNDSUCC',
	'B17 Bond Confirmed !',
	 'B17 Bond  Confirmed Successfully ! ',
	 'P',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL);
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'CLOCTN',
	'Can not close CT3 !',
	 'Please confirmed CT3 transaction first! ! ',
	 'P',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL);
	
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'VTPRFTS',
	'Invalid transaction series !',
	 'Please enter on D-ISS for distibution or S-DSP for dispatch ! ',
	 'E',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL)	;
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'VTCTNL',
	'Ct3 Value null !',
	 'Please enter CT3 value ! ',
	 'E',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL)	;
insert into obj_actions(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE)
	VALUES(
	'b17_bond',  
	11,
	'F',
	'a',
	'act_confirm',
	'Confirm',
	'Confirm',
	NULL,
	'1',
	'2',
	NULL,
	'U');
insert into system_events(
	obj_name,
	event_code,
	event_context,
	service_code,
	method_rule,
	chg_date,
	chg_user,
	chg_term,
	result_handle,
	overwrite_core,
	comp_type,
	comp_name,
	comm_format)
values(
	'b17_bond',
	'act_confirm',
	'1',
	'confirm_bnd',
	NULL,
	fn_sysdate(),
	'SYSTEM'  ,
	'SYSTEM',
	'2',
	'0',
	'EJB',
	'ConfirmBond',
	NULL);
insert into system_event_services(
	service_code,
	service_descr,
	service_uri,
	service_provider,
	method_name,
	return_value,
	return_type,
	return_descr,
	return_xfrm,
	chg_date,
	chg_user,
	chg_term)
values(
	'confirm_bnd',
	'Action To confirm',
	'http://localhost:9090/axis/services/ActionHandlerService',
	'Base Information',
	'actionHandler',
	'String',
	'S',
	NULL,
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_bnd',
         1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	'EJB');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_bnd',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	'ConfirmBond');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_bnd',
	3,
	'<tran_id>',
	'I',
	'tranid',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_bnd',
	4,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_bnd',
	5,
	'FORCED_FLAG',
	'I',
	'Forced Flag',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	NULL);
	
	
INSERT INTO obj_actions (
	obj_name ,
	line_no ,
	rights_char ,
	interactive ,
	service_code ,
	description ,
	title ,
	image ,
	form_no ,
	service_handler ,
	placement ,
	action_type ,
	tran_type ) 
VALUES (
	'ctform',
	6,
	'X',
	'a',
	'act_cancel',
	'CT Cancellation',
	'Close',
	NULL,
	'1',
	'2',
	NULL,
	'U',
	NULL);
INSERT INTO system_events (
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
VALUES (
	'ctform',
	'act_cancel',
	'1',
	'acancel_ct',
	NULL,
	fn_sysdate(),
	'Gulzar',
	'BASE217',
	'2',
	'0',
	'EJB',
	'CloseCT',
	NULL);
INSERT INTO system_event_services (
	service_code ,
	service_descr ,
	service_uri ,
	service_provider ,
	method_name ,
	return_value ,
	return_type ,
	return_descr ,
	return_xfrm ,
	chg_date ,
	chg_user ,
	chg_term )
VALUES (
	'acancel_ct',
	'Action For Cancel',
	'http://localhost:9090/axis/services/ActionHandlerService',
	'Base Information',
	'actionHandler',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'Gulzar',
	'BASE217');
INSERT INTO system_service_args (
	service_code ,
	line_no ,
	arg_name ,
	arg_mode ,
	descr ,
	arg_type ,
	arg_xfrm ,
	chg_date ,
	chg_user ,
	chg_term ,
	arg_value )
VALUES (
	'acancel_ct',
	1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'C.String',
	NULL,
	fn_sysdate(),
	'Gulzar',
	'BASE217',
	'EJB');
INSERT INTO system_service_args (
	service_code ,
	line_no ,
	arg_name ,
	arg_mode ,
	descr ,
	arg_type ,
	arg_xfrm ,
	chg_date ,
	chg_user ,
	chg_term ,
	arg_value )
VALUES (
	'acancel_ct',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'C.String',
	NULL,
	fn_sysdate(),
	'Gulzar',
	'BASE217',
	'CloseCT');
INSERT INTO system_service_args (
	service_code ,
	line_no ,
	arg_name ,
	arg_mode ,
	descr ,
	arg_type ,
	arg_xfrm ,
	chg_date ,
	chg_user ,
	chg_term ,
	arg_value )
VALUES (
	'acancel_ct',
	3,
	'<tran_id>',
	'I',
	'tranID',
	'C.String',
	NULL,
	fn_sysdate(),
	'Gulzar',
	'BASE217',
	NULL);
INSERT INTO system_service_args (
	service_code ,
	line_no ,
	arg_name ,
	arg_mode ,
	descr ,
	arg_type ,
	arg_xfrm ,
	chg_date ,
	chg_user ,
	chg_term ,
	arg_value )
VALUES (
	'acancel_ct',
	4,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	fn_sysdate(),
	'Gulzar',
	'BASE217',
	NULL);
INSERT INTO system_service_args (
	service_code ,
	line_no ,
	arg_name ,
	arg_mode ,
	descr ,
	arg_type ,
	arg_xfrm ,
	chg_date ,
	chg_user ,
	chg_term ,
	arg_value )
VALUES (
	'acancel_ct',
	5,
	'FORCED_FLAG',
	'I',
	'Forced Flag',
	'S',
	NULL,
	fn_sysdate(),
	'Gulzar',
	'BASE217',
	NULL);
	ALTER TABLE B17_BOND MODIFY  BOND_NO CHAR(20);
ALTER TABLE B17_BOND ADD BANK_CODE CHAR(10);
ALTER TABLE B17_BOND ADD BOND_TYPE CHAR(1); -- BANK GURANTEE/STATUS HOLDER
ALTER TABLE B17_BOND ADD GURANTEE_CERTIFICATE_NO CHAR(20);
ALTER TABLE B17_BOND DROP CONSTRAINT  B17_BOND_X;
ALTER TABLE  B17_BOND 
		ADD CONSTRAINT B17_BOND_X PRIMARY KEY ( BOND_NO,BANK_CODE,EFF_FROM,VALID_UPTO) using index tablespace itm_dis_i1;
ALTER TABLE  B17_BOND 
		ADD CONSTRAINT FK_B17_BOND_BANK_CODE FOREIGN KEY ( BANK_CODE) 
REFERENCES BANK(BANK_CODE) ;
delete from obj_forms where win_name = 'w_lop';
insert into obj_forms (win_name,form_no,title) values ('w_lop',1,'Lop Header');
insert into obj_forms (win_name,form_no,title) values ('w_lop',2,'Lop Detail');

insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)
values(
	'b17_bond',
	'1',
	'bank_code');	
insert into obj_itemchange(
	obj_name,
	form_no,
	field_name)
values(
	'b17_bond',
	'1',
	'bond_type');			
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'VMBBGGB',
	'Invalid Bond Value',
	 'Bond Value can not be graeter then Bank Gurantee',
	 'E',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL);
insert into obj_actions(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE)
	VALUES(
	'lop',  
	11,
	'F',
	'a',
	'act_confirm',
	'Confirm',
	'Confirm',
	NULL,
	'1',
	'2',
	NULL,
	'U');
insert into system_events(
	obj_name,
	event_code,
	event_context,
	service_code,
	method_rule,
	chg_date,
	chg_user,
	chg_term,
	result_handle,
	overwrite_core,
	comp_type,
	comp_name,
	comm_format)
values(
	'lop',
	'act_confirm',
	'1',
	'confirm_lop',
	NULL,
	fn_sysdate(),
	'SYSTEM'  ,
	'SYSTEM',
	'2',
	'0',
	'EJB',
	'ConfirmLop',
	NULL);
insert into system_event_services(
	service_code,
	service_descr,
	service_uri,
	service_provider,
	method_name,
	return_value,
	return_type,
	return_descr,
	return_xfrm,
	chg_date,
	chg_user,
	chg_term)
values(
	'confirm_lop',
	'Action To confirm',
	'http://localhost:9090/axis/services/ActionHandlerService',
	'Base Information',
	'actionHandler',
	'String',
	'S',
	NULL,
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_lop',
         1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	'EJB');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_lop',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	'ConfirmLop');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_lop',
	3,
	'<tran_id>',
	'I',
	'tranid',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_lop',
	4,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_lop',
	5,
	'FORCED_FLAG',
	'I',
	'Forced Flag',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	NULL);
	
INSERT INTO messages(
	msg_no,
	msg_str,
	msg_descr,
	msg_type,
	msg_opt,
	alarm,
	err_source,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
 VALUES (
	'CONLOPSUCC',
	'LOP Confirmed !',
	 'LOP Transation Confirmed Successfully ! ',
	 'P',
	'Y',
	 NULL,
	 NULL,
	fn_sysdate(),
	'pankaj',
	'pankaj',
	NULL,
	NULL);
insert into obj_forms (win_name,form_no) values ('w_ctform',2);
INSERT INTO itm2menu
(
	application ,
	level_1,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name,
	descr,
	comments ,
	menu_path,
	icon_path,
	close_icon,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user )
 VALUES (
	'EOU',
	1,
	3,
	0,
	0,
	0,
	'w_lop_amd',
	'Lop Amendment',
	NULL,
	'EOU.1.3.0.0.0',
	NULL,
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'EO89SUN004',
	'BASE      ');
insert into obj_forms (win_name,form_no) values ('w_lop_amd',1);
insert into obj_forms (win_name,form_no) values ('w_lop_amd',2);
INSERT INTO obj_actions
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
 VALUES (
	'lop_amd',
	1,
	'A',
	'a',
	'a',
	'Adding New',
	'Add',
	'add.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions 
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
VALUES
 (
	'lop_amd',
	2,
	'E',
	'a',
	'a',
	'Editing Existing Record',
	'Edit',
	'edit.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions 
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
VALUES (
	'lop_amd',
	3,
	'D',
	'a',
	'a',
	'Delete',
	'Delete',
	'delete.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions
(
	obj_name ,
	line_no ,
	rights_char,
	interactive,
	service_code,
	description,
	title ,
	image ,
	action_type,
	form_no,
	service_handler,
	placement ,
	tran_type
)
 VALUES (
	'lop_amd',
	4,
	'S',
	'a',
	'a',
	'Saving',
	'Save',
	'save.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'lop_amd',
	'pre_validate',
	'1',
	'prv_default_ejb',
	NULL,
	fn_sysdate(),
	'manazir  ',
	'manazir',
	'2',
	'0',
	'EJB',
	'LopAmd',
	NULL);
INSERT INTO system_events(
	obj_name ,
	event_code ,
	event_context ,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core ,
	comp_type ,
	comp_name ,
	comm_format )
 VALUES (
	'lop_amd',
	'post_item_change',
	'1',
	'poic_default_ejb',
	NULL,
	fn_sysdate(),
	'manazir  ',
	'manazir',
	'2',
	'0',
	'EJB',
	'LopAmd',
	NULL);


alter table ct3form_det add amount number(14,3);
alter table ct3form_det add curr_code char(5);

CREATE TABLE CT3FORM_HDR_AMD(
	FORM_NO VARCHAR2(20) NOT NULL,
	TRAN_DATE DATE NOT NULL,
	SITE_CODE CHAR(5) NOT NULL,	
	EFF_FROM DATE,
	EFF_FROM__O DATE,
	VALID_UPTO DATE,
	VALID_UPTO__O DATE,
	STATUS CHAR(1), 
	STATUS_DATE DATE, 
	EMP_CODE__APRV CHAR(10), 
	CONFIRMED CHAR(1), 
	CONF_DATE DATE,
	REMARKS VARCHAR2(60), 
	CHG_DATE DATE NOT NULL,
	CHG_USER CHAR(10) NOT NULL,
	CHG_TERM VARCHAR2(15) NOT NULL) ;
ALTER table CT3FORM_HDR_AMD ADD ( CONSTRAINT CT3FORM_HDR_AMD_X PRIMARY KEY ( FORM_NO )) ;

CREATE TABLE CT3FORM_DET_AMD 
	(FORM_NO VARCHAR2(20) NOT NULL,
	LINE_NO NUMBER(3,0) NOT NULL, 
	DOC_TYPE CHAR(1),
	DOC_TYPE__O CHAR(1),	
	DATE_OF_ISS DATE, 
	SUPP_CODE CHAR(10),
	SUPP_CODE__O CHAR(10),	
	CT3_VALUE NUMBER(14,3) NOT NULL,
	CT3_VALUE__O NUMBER(14,3) NOT NULL,	
	ITEM_CODE CHAR(10) NOT NULL, 
	ITEM_CODE__O CHAR(10) NOT NULL,
	QUANTITY NUMBER(14,3),
	QUANTITY__O NUMBER(14,3), 	
	QTY_USED NUMBER(14,3),
	QTY_USED__O NUMBER(14,3),	
	TAX_RATE NUMBER(14,3),
	TAX_RATE__O NUMBER(14,3),	
	EXG_RATE NUMBER(14,3),
	EXG_RATE__O NUMBER(14,3),	
	BILL_REF CHAR(10),
	BILL_REF__O CHAR(10),	
	BILL_OF_LADING CHAR(10),
	BILL_OF_LADING__O CHAR(10),	
	PURC_ORDER CHAR(10),
	PURC_ORDER__O CHAR(10),	
	AMOUNT NUMBER(14,3),
	AMOUNT__O NUMBER(14,3),	
	CURR_CODE CHAR(5),
	CURR_CODE__O CHAR(5)) ;
	
ALTER table CT3FORM_DET_AMD ADD ( CONSTRAINT CT3FORM_DET_AMD_X PRIMARY KEY ( FORM_NO, LINE_NO )) ;
alter table CT3FORM_HDR_AMD add ct_ref_no CHAR(20) NOT NULL;
alter table CT3FORM_DET_AMD add line_ref_no NUMBER(3) not null ;

INSERT INTO itm2menu 
	(application ,
	level_1 ,
	level_2 ,
	level_3 ,
	level_4 ,
	level_5 ,
	win_name ,
	descr ,
	comments ,
	menu_path ,
	icon_path ,
	close_icon,
	open_icon ,
	obj_type ,
	chg_date ,
	chg_term ,
	chg_user ) VALUES (
	'EOU',
	2,
	4,
	0,
	0,
	0,
	'w_ctformamd',
	'CTFORMAMD',
	NULL,
	'EOU.2.4.0.0.0',
	NULL,
	NULL,
	NULL,
	NULL,
	TO_DATE('18-10-2007 09:29:28','DD-MM-YYYY HH24:MI:SS'),
	'EO89SUN004',
	'BASE');	

INSERT INTO system_events
	(obj_name ,
	event_code ,
	event_context,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core,
	comp_type ,
	comp_name ,
	comm_format ) VALUES (
	'ctformamd',
	'post_item_change',
	'1',
	'poic_default_ejb',
	NULL,
	TO_DATE('21-11-2008 14:25:02','DD-MM-YYYY HH24:MI:SS'),
	'manazir   ',
	'manazir',
	'2',
	'0',
	'EJB',
	'CTFORMAMD',
	NULL);
INSERT INTO system_events
	(obj_name ,
	event_code ,
	event_context,
	service_code ,
	method_rule ,
	chg_date ,
	chg_user ,
	chg_term ,
	result_handle ,
	overwrite_core,
	comp_type ,
	comp_name ,
	comm_format ) 
	VALUES (
	'ctformamd',
	'pre_validate',
	'1',
	'prv_default_ejb',
	NULL,
	TO_DATE('21-11-2008 14:25:02','DD-MM-YYYY HH24:MI:SS'),
	'manazir   ',
	'manazir',
	'2',
	'0',
	'EJB',
	'CTFORMAMD',
	NULL);

INSERT INTO system_event_services(service_code ,
	service_descr ,
	service_uri ,
	service_provider ,
	method_name ,
	return_value ,
	return_type ,
	return_descr ,
	return_xfrm,
	chg_date ,
	chg_user ,
	chg_term ) VALUES (
	'poic_default_ejb',
	' method for itemchange',
	'http://localhost:9090/axis/services/ValidatorService',
	'BASE',
	'itemChanged',
	'String',
	'S',
	NULL,
	NULL,
	TO_DATE('21-11-2008 11:04:29','DD-MM-YYYY HH24:MI:SS'),
	'rajendra  ',
	'rajendra');
INSERT INTO system_event_services 
	(service_code ,
	service_descr ,
	service_uri ,
	service_provider ,
	method_name ,
	return_value ,
	return_type ,
	return_descr ,
	return_xfrm,
	chg_date ,
	chg_user ,
	chg_term ) VALUES (
	'prv_default_ejb',
	'method for validation',
	'http://localhost:9090/axis/services/ValidatorService',
	'BASE',
	'wfValData',
	'String',
	'S',
	NULL,
	NULL,
	TO_DATE('21-11-2008 11:04:30','DD-MM-YYYY HH24:MI:SS'),
	'rajendra  ',
	'rajendra');
	
insert into system_events(
	obj_name,
	event_code,
	event_context,
	service_code,
	method_rule,
	chg_date,
	chg_user,
	chg_term,
	result_handle,
	overwrite_core,
	comp_type,
	comp_name,
	comm_format)
values(
	'ctformamd',
	'act_confirm',
	'1',
	'confirm_ctformamd',
	NULL,
	fn_sysdate(),
	'SYSTEM'  ,
	'SYSTEM',
	'2',
	'0',
	'EJB',
	'ConfirmCTFormAmd',
	NULL);
insert into system_event_services(
	service_code,
	service_descr,
	service_uri,
	service_provider,
	method_name,
	return_value,
	return_type,
	return_descr,
	return_xfrm,
	chg_date,
	chg_user,
	chg_term)
values(
	'confirm_ctformamd',
	'Action To confirm',
	'http://localhost:9090/axis/services/ActionHandlerService',
	'Base Information',
	'actionHandler',
	'String',
	'S',
	NULL,
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ctformamd',
         1,
	'COMPONENT_TYPE',
	'I',
	'Component Type',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	'EJB');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ctformamd',
	2,
	'COMPONENT_NAME',
	'I',
	'Component Name',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	'ConfirmCTFormAmd');
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ctformamd',
	3,
	'<tran_id>',
	'I',
	'tranid',
	'C.String',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ctformamd',
	4,
	'XTRA_PARAMS',
	'I',
	'Extra Arguments',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra',
	'Base34',
	null);
	
insert into system_service_args(
	service_code,
	line_no,
	arg_name,
	arg_mode,
	descr,
	arg_type,
	arg_xfrm,
	chg_date,
	chg_user,
	chg_term,
	arg_value)
values(
	'confirm_ctformamd',
	5,
	'FORCED_FLAG',
	'I',
	'Forced Flag',
	'S',
	NULL,
	FN_SYSDATE(),
	'rajendra' ,
	'Base34',
	NULL);

INSERT INTO messages
	(msg_no ,
	msg_str,
	msg_descr ,
	msg_type ,
	msg_opt ,
	msg_time ,
	alarm ,
	err_source ,
	chg_date ,
	chg_user ,
	chg_term ,
	override_input,
	mail_option)
	VALUES (
	'VTPORD1   ',
	'Purchase Order Not Found!',
	'Purchase order you have entered is not existing in site master',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	TO_DATE('22-10-1999 18:31:20','DD-MM-YYYY HH24:MI:SS'),
	'SUN       ',
	'RITESH         ',
	NULL,
	NULL);
	

INSERT INTO obj_actions
	(obj_name ,
	line_no ,
	rights_char ,
	interactive ,
	service_code ,
	description ,
	title ,
	image ,
	action_type,
	form_no ,
	service_handler ,
	placement ,
	tran_type)
	VALUES (
	'ctformamd',
	1,
	'A',
	'a',
	'a',
	'Adding New',
	'Add',
	'add.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions
	(obj_name ,
	line_no ,
	rights_char ,
	interactive ,
	service_code ,
	description ,
	title ,
	image ,
	action_type,
	form_no ,
	service_handler ,
	placement ,
	tran_type)
	VALUES (
	'ctformamd',
	2,
	'E',
	'a',
	'a',
	'Editing Existing Record',
	'Edit',
	'edit.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions
	(obj_name ,
	line_no ,
	rights_char ,
	interactive ,
	service_code ,
	description ,
	title ,
	image ,
	action_type,
	form_no ,
	service_handler ,
	placement ,
	tran_type)
	VALUES (
	'ctformamd',
	3,
	'D',
	'a',
	'a',
	'Delete',
	'Delete',
	'delete.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions
	(obj_name ,
	line_no ,
	rights_char ,
	interactive ,
	service_code ,
	description ,
	title ,
	image ,
	action_type,
	form_no ,
	service_handler ,
	placement ,
	tran_type)
	VALUES (
	'ctformamd',
	4,
	'S',
	'a',
	'a',
	'Saving',
	'Save',
	'save.gif',
	'S',
	'1',
	NULL,
	NULL,
	NULL);
INSERT INTO obj_actions
	(obj_name ,
	line_no ,
	rights_char ,
	interactive ,
	service_code ,
	description ,
	title ,
	image ,
	action_type,
	form_no ,
	service_handler ,
	placement ,
	tran_type) VALUES (
	'ctformamd',
	6,
	'X',
	'a',
	'act_cancel',
	'CT Cancellation',
	'Close',
	NULL,
	'U',
	'1',
	'2',
	NULL,
	NULL);
INSERT INTO obj_actions
	(obj_name ,
	line_no ,
	rights_char ,
	interactive ,
	service_code ,
	description ,
	title ,
	image ,
	action_type,
	form_no ,
	service_handler ,
	placement ,
	tran_type)
	VALUES (
	'ctformamd',
	11,
	'F',
	'a',
	'act_confirm',
	'Confirm',
	'Confirm',
	NULL,
	'U',
	'1',
	'2',
	NULL,
	NULL);


INSERT INTO obj_itemchange(
	obj_name ,
	form_no ,
	field_name ,
	mandatory ) VALUES (
	'ctformamd',
	'1',
	'itm_default',
	NULL);
INSERT INTO obj_itemchange(
	obj_name ,
	form_no ,
	field_name ,
	mandatory ) VALUES (
	'ctformamd',
	'1',
	'site_code',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'ctformamd',
	'2',
	'item_code',
	NULL);
INSERT INTO obj_itemchange(
	obj_name ,
	form_no ,
	field_name ,
	mandatory ) VALUES (
	'ctformamd',
	'2',
	'supp_code',
	NULL);
INSERT INTO obj_itemchange VALUES (
	'ctformamd',
	'2',
	'itm_default',
	NULL);
INSERT INTO obj_itemchange(
	obj_name ,
	form_no ,
	field_name ,
	mandatory ) VALUES (
	'ctformamd',
	'2',
	'purc_order',
	NULL);
INSERT INTO obj_itemchange(
	obj_name ,
	form_no ,
	field_name ,
	mandatory ) VALUES (
	'ctformamd',
	'2',
	'itm_defaultedit',
	NULL);

INSERT INTO obj_itemchange(
	obj_name ,
	form_no ,
	field_name ,
	mandatory ) VALUES (
	'ctformamd',
	'1',
	'ct_ref_no',
	NULL);
	
INSERT INTO obj_itemchange(
	obj_name ,
	form_no ,
	field_name ,
	mandatory ) VALUES (
	'ctformamd',
	'2',
	'line_ref_no',
	NULL);

INSERT INTO obj_itemchange (obj_name,
	form_no ,
	field_name ,
	mandatory )
	VALUES (
	'ctform',
	'2',
	'curr_code',
	NULL);
INSERT INTO obj_itemchange 
	(obj_name,
	form_no ,
	field_name ,
	mandatory )
	VALUES (
	'ctform',
	'2',
	'supp_code',
	NULL);	
	
INSERT INTO obj_itemchange 
	(obj_name,
	form_no ,
	field_name ,
	mandatory )
	VALUES (
	'ctform',
	'2',
	'emp_code__aprv',
	NULL);	

	
	
INSERT INTO obj_forms
	(win_name ,
	title ,		
	form_no)
	VALUES (
	'w_ctformamd',
	'CTFRMHeaderAmd',	
	'1'	);
INSERT INTO obj_forms
	(win_name ,
	title ,		
	form_no)
	VALUES (
	'w_ctformamd',
	'CTFRMDetailAmd',	
	'2');	
	
INSERT INTO messages VALUES (
	'VMFORMAMD ',
	'Invalid FormRefNo.',
	'The FormRefNo entered does not exist in the ctform. First you have to used of  master',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	TO_DATE('19-04-2006 11:21:05','DD-MM-YYYY HH24:MI:SS'),
	'BASE      ',
	'01BASE94       ',
	NULL,
	NULL);

INSERT INTO messages VALUES (
	'CONCTFSUCC',
	'Amend Of Ct3Form is Confirmed!',
	'Amendment Of Ct3From is Confirmed Successfully ! ',
	'P',
	'Y',
	NULL,
	NULL,
	NULL,
	TO_DATE('10-12-2008 12:01:28','DD-MM-YYYY HH24:MI:SS'),
	'manaz     ',
	'manaz          ',
	NULL,
	NULL);

commit;