package ibase.webitm.ejb.wms;
/*
 * Author:Wasim Ansari
 * Date:02-APR-15
 * Request ID:D15AKAT002 (PO Case Label Mobile Wizard)
 */


import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class POCaseWizIC extends ValidatorEJB implements POCaseWizICRemote, POCaseWizICLocal
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	@Override
	public String wfValData(String xmlString, String xmlString1,
			String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("xmlString:::"+xmlString);
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : Cpp : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		
		return(errString);
	}

	@Override
	public String wfValData(Document dom, Document dom1, Document dom2,	String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException
	{
		String errString = "";
		
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;
		PreparedStatement pstmt = null ;
		
		String userId = "";
		int currentFormNo = 0;
		
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength;
		int ctr = 0;
		long cnt = 0;
		String childNodeName = null;
		
		String errCode = "";
		String errorType = "";
		
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		
		String status = "";
		String confirmed = "";
		
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");	
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					
					for(ctr=0;ctr<childNodeListLength;ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						
						
						if (childNodeName.equalsIgnoreCase("purc_order")) 
						{
							int paramName = 0;
							String purc_order = genericUtility.getColumnValue("purc_order", dom);
							
							if(purc_order != null)
							{
								String countSerSql = "	select status, confirmed from porder where purc_order = ? ";
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, purc_order);
								ResultSet rsCnt = pstmtParamName.executeQuery();
								
								System.out.println("countSerSql" + countSerSql);
								int counter=0;
								if(rsCnt.next())
								{   
									counter++;
									status = rsCnt.getString("status");
									confirmed = rsCnt.getString("confirmed");
								}
								rsCnt.close();
								rs = null;
								pstmtParamName.close(); 
								pstmt = null;
	
								if( counter == 0 )
								{
									errCode = "VTPORD1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								} 
								else if( "C".equalsIgnoreCase(status) || "X".equalsIgnoreCase(status))
								{
									errCode = "VTCLOSE1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}	
								else if (!("Y".equalsIgnoreCase(confirmed)))
								{
									errCode = "VTNOTCONF";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								
							}
							else
							{
								errCode = "VTPORD1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						else if (childNodeName.equalsIgnoreCase("printer_name")) 
						{
							int paramName = 0;
							String printerName = genericUtility.getColumnValue("printer_name", dom);
							System.out.println("Entered Printer is="+printerName);
							if(printerName != null)
							{	
								String countSerSql = "SELECT COUNT(1) AS COUNT FROM net_printers WHERE TRIM(printer_name) = ?";
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, printerName);
								ResultSet rsCnt = pstmtParamName.executeQuery();
								
								System.out.println("countSerSql" + countSerSql);
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								if (paramName == 0) 
								{
									errCode = "INVPRINTER";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							else
							{
								errCode = "NLLPRINTER";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						
						
					}
					
				break;	
			
				case 2:
						parentNodeList = dom.getElementsByTagName("Detail2");
						parentNode = parentNodeList.item(0);
						childNodeList = parentNode.getChildNodes();
						childNodeListLength = childNodeList.getLength();
						
						for(ctr=0;ctr<childNodeListLength;ctr++)
						{
							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();
							
							if (childNodeName.equalsIgnoreCase("item_code")) 
							{
								int paramName = 0;
								String itemCode = genericUtility.getColumnValue("item_code", dom);
								System.out.println("Item Code is="+itemCode);
								
								if (itemCode != null) 
								{	
									String countSerSql = "SELECT COUNT(1) AS COUNT FROM item WHERE TRIM(ITEM_CODE) = ?";
									PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
									pstmtParamName.setString(1, itemCode);
									ResultSet rsCnt = pstmtParamName.executeQuery();
									
									System.out.println("countSerSql" + countSerSql);
									if (rsCnt.next()) 
									{
										paramName = rsCnt.getInt("COUNT");
									}
									// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
									if( pstmtParamName != null )
									{
										pstmtParamName.close();
										pstmtParamName = null;
									}
									if ( rsCnt != null )
									{
										rsCnt.close();
										rsCnt = null;
									}
									// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
									
									if (paramName == 0) 
									{
										errCode = "VMITMC1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								else
								{
									errCode = "VMITEMCD1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
				
				}
					
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
			
			
		}//end of try
		
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				//Commented by Santosh on 14-06-2016
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		
		errString = errStringXml.toString();
		return errString;  
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1,
			String xmlString2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		String errString="";
		
		try
		{
			System.out.println("xmlString["+xmlString+"]");
			System.out.println("xmlString1["+xmlString1+"]");
			System.out.println("xmlString2["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("xmlString["+xmlString+"]");
				
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
				
				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :DDProductWizEJB:itemChanged(String,String,String,String,String,String):" + e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return valueXmlString;
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("Heloooooooooooo");
		String errString="";
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		int currentFormNo = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String userId = "";
		String currDate = "";
		String siteDescr = "";
		String randomNum = "",purcOrder = "",itemCode = "",lineNo = "",descr = "",shipperSize = "";		
		int counter = 0;
		
		String sql = "",sql2 = "";
		ResultSet rs = null, rs2 = null;
		PreparedStatement pstmt = null, pstmt2 = null ;
		
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?>\r\n<Root>\r\n<header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate = sdf.format(new java.util.Date());
			
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			String siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			String empCode =  genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			
			switch(currentFormNo)
			{
				case 1: 
				{	
					System.out.println("************* Inside Case 1 ******************");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r\n");
						
							valueXmlString.append("<purc_order>").append("<![CDATA[]]>").append("</purc_order>\r\n");	
							valueXmlString.append("<printer_name>").append("<![CDATA[]]>").append("</printer_name>\r\n");
					}
					valueXmlString.append("</Detail1>\r\n");
					
					break;
				}
				case 2:
				{
					System.out.println("=========Inside Case 2========");
					String quantity = "";
					String itemCodeCaseLabel = "", labelNo = "", barCode = "", refSer = "";
					
					System.out.println("item change of detail2........");					
					//purcOrder = genericUtility.getColumnValue( "purc_order", dom );
					purcOrder = genericUtility.getColumnValue( "purc_order", dom1 );
					purcOrder = purcOrder ==null ? "" : purcOrder.trim();
					System.out.println("purcOrder------>["+purcOrder+"]");
					
					sql2 = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_porder'";
					pstmt2 = conn.prepareStatement(sql2);
					rs2 = pstmt2.executeQuery();
					if(rs2.next())
					{
						refSer = checkNullAndTrim(rs2.getString("REF_SER"));
						System.out.println("Ref Series"+refSer);
					}
					rs2.close();
					rs2 = null;
					pstmt2.close();
					pstmt2 = null;
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
					{
						//sql = "select * from CASE_LABEL where purc_order = ? ";
						sql = "select * from CASE_LABEL where order_no = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrder);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							System.out.println("Purchase order present in CASE_LABEL table");
						
							sql = "SELECT D.ITEM_CODE,D.LINE_NO,D.QUANTITY FROM PORDER H, PORDDET D "
									+ " WHERE H.PURC_ORDER = D.PURC_ORDER AND H.PURC_ORDER = ? ";
									//+ "AND D.ITEM_CODE NOT IN (SELECT ITEM_CODE FROM CASE_LABEL WHERE ORDER_NO = ?) ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, purcOrder);
							//pstmt.setString(2, purcOrder);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								itemCodeCaseLabel = "";
								itemCode = checkNullAndTrim(rs.getString("ITEM_CODE")); 
								lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
								quantity = checkNullAndTrim(rs.getString("QUANTITY"));
								
								//Changed by wasim on 15-12-2015 to get shippersize so it will act as quantity [START]
								//sql2 = "SELECT DESCR,UDF__STR2 FROM ITEM WHERE ITEM_CODE = ? ";
								sql2 =  " SELECT I.DESCR,I.UDF__STR2,L.SHIPPER_SIZE FROM ITEM I,ITEM_LOT_PACKSIZE L"
								       +" WHERE I.ITEM_CODE = ?"
								       +" AND I.ITEM_CODE = L.ITEM_CODE";
								//Changed by wasim on 15-12-2015 to get shippersize so it will act as quantity [END]
								pstmt2 = conn.prepareStatement(sql2);
								pstmt2.setString(1, itemCode);
								rs2 = pstmt2.executeQuery();
								if(rs2.next())
								{
									descr   = checkNullAndTrim(rs2.getString("DESCR"));
									barCode = checkNullAndTrim(rs2.getString("UDF__STR2"));
									shipperSize = checkNullAndTrim(rs2.getString("SHIPPER_SIZE"));//Changed by wasim to get shipper size on 15-12-2015
								}
								rs2.close();
								rs2 = null;
								pstmt2.close();
								pstmt2 = null;
								
								sql2 = "SELECT ITEM_CODE FROM CASE_LABEL WHERE ORDER_NO = ? AND ITEM_CODE = ? ";
								pstmt2 = conn.prepareStatement(sql2);
								pstmt2.setString(1, purcOrder);
								pstmt2.setString(2, itemCode);
								rs2 = pstmt2.executeQuery();
								if(rs2.next())
								{
									itemCodeCaseLabel = checkNullAndTrim(rs2.getString("ITEM_CODE"));
									System.out.println("Item Code is present in case label"+itemCode);
								}
								rs2.close();
								rs2 = null;
								pstmt2.close();
								pstmt2 = null;
								
								System.out.println("Quantity Length="+quantity.length());
								System.out.println("Shipper Size="+shipperSize);
								
								//Changed by wasim to get shipper size for considering as quantity on 15-12-2015 [START]
								/*if(quantity.length() == 1)
								{
									quantity = "000"+quantity;
								}
								else if(quantity.length() == 2)
								{
									quantity = "00"+quantity;
								}
								else if(quantity.length() == 3)
								{
									quantity = "0"+quantity;
								}
								
								labelNo = purcOrder + quantity + barCode;*/
								 
								if(shipperSize.length() == 1)
								{
									shipperSize = "000"+shipperSize;
								}
								else if(shipperSize.length() == 2)
								{
									shipperSize = "00"+shipperSize;
								}
								else if(shipperSize.length() == 3)
								{
									shipperSize = "0"+shipperSize;
								}
								
								System.out.println("New Quantity="+shipperSize);
								
								labelNo = purcOrder + shipperSize + barCode;
								System.out.println("Label Number is="+labelNo);
								
								//Changed by wasim to get shipper size for considering as quantity on 15-12-2015 [END]
								
								if(itemCodeCaseLabel != null && itemCodeCaseLabel.length() > 0)
								{
									valueXmlString.append("<Detail2 domID='"+lineNo+"' objContext = '"+currentFormNo+"' objName=\"po_case_wiz\" selected=\"Y\">\r\n");
									valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
								}
								else
								{
									valueXmlString.append("<Detail2 domID='"+lineNo+"' objContext = '"+currentFormNo+"' objName=\"po_case_wiz\" selected=\"N\">\r\n");
									valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
								}
								
								
								valueXmlString.append( "<order_no><![CDATA[" ).append( purcOrder ).append( "]]></order_no>\r\n" );
								valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
								valueXmlString.append( "<lot_no><![CDATA[" ).append("  ").append( "]]></lot_no>\r\n" );
								//Changed by wasim to get shipper size for considering as quantity on 15-12-2015
								//valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
								valueXmlString.append( "<quantity><![CDATA[" ).append( shipperSize ).append( "]]></quantity>\r\n" );
								valueXmlString.append( "<label_no><![CDATA[" ).append(labelNo).append( "]]></label_no>\r\n" );
								valueXmlString.append( "<ref_ser><![CDATA[" ).append(refSer).append( "]]></ref_ser>\r\n" );
								valueXmlString.append( "<descr><![CDATA[" ).append( descr ).append( "]]></descr>\r\n" );
								valueXmlString.append( "<chg_date><![CDATA[" ).append( currDate ).append( "]]></chg_date>\r\n" );
								valueXmlString.append( "<chg_user><![CDATA[" ).append( empCode ).append( "]]></chg_user>\r\n" );
								valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
								valueXmlString.append("</Detail2>\r\n");
								
								counter++;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							System.out.println("Counter="+counter);
						}
						//if(counter==0)
						else
						{	
							sql = "SELECT  D.ITEM_CODE,D.LINE_NO,D.QUANTITY FROM PORDER H, PORDDET D "
									+ " WHERE H.PURC_ORDER = D.PURC_ORDER AND H.PURC_ORDER = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, purcOrder);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								itemCode = checkNullAndTrim(rs.getString("ITEM_CODE")); 
								lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
								quantity = checkNullAndTrim(rs.getString("QUANTITY"));
								
								//Changed by wasim on 15-12-2015 to get shippersize so it will act as quantity [START]
								//sql2 = "SELECT DESCR,UDF__STR2 FROM ITEM WHERE ITEM_CODE = ? ";
								sql2 =  " SELECT I.DESCR,I.UDF__STR2,L.SHIPPER_SIZE FROM ITEM I,ITEM_LOT_PACKSIZE L"
								       +" WHERE I.ITEM_CODE = ?"
								       +" AND I.ITEM_CODE = L.ITEM_CODE";
								//Changed by wasim on 15-12-2015 to get shippersize so it will act as quantity [END]
								pstmt2 = conn.prepareStatement(sql2);
								pstmt2.setString(1, itemCode);
								rs2 = pstmt2.executeQuery();
								if(rs2.next())
								{
									descr   = checkNullAndTrim(rs2.getString("DESCR"));
									barCode = checkNullAndTrim(rs2.getString("UDF__STR2"));
									shipperSize = checkNullAndTrim(rs2.getString("SHIPPER_SIZE"));
								}
								rs2.close();
								rs2 = null;
								pstmt2.close();
								pstmt2 = null;
								
								
								System.out.println("Quantity Length="+quantity.length());
								System.out.println("Shipper Size="+shipperSize);
								
								//Changed by wasim to get shipper size for considering as quantity on 15-12-2015 [START]
								/*if(quantity.length() == 1)
								{
									quantity = "000"+quantity;
								}
								else if(quantity.length() == 2)
								{
									quantity = "00"+quantity;
								}
								else if(quantity.length() == 3)
								{
									quantity = "0"+quantity;
								}
								
								System.out.println("New Quantity="+quantity);
								
								labelNo = purcOrder + quantity + barCode;
								System.out.println("Label Number is="+labelNo);*/
								
								if(shipperSize.length() == 1)
								{
									shipperSize = "000"+shipperSize;
								}
								else if(shipperSize.length() == 2)
								{
									shipperSize = "00"+shipperSize;
								}
								else if(shipperSize.length() == 3)
								{
									shipperSize = "0"+shipperSize;
								}
								
								System.out.println("New Quantity="+shipperSize);
								
								labelNo = purcOrder + shipperSize + barCode;
								System.out.println("Label Number is="+labelNo);
								
								//Changed by wasim to get shipper size for considering as quantity on 15-12-2015 [END]
								
								valueXmlString.append("<Detail2 domID='"+lineNo+"' objContext = '"+currentFormNo+"' objName=\"po_case_wiz\" selected=\"N\">\r\n");
								valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
								//valueXmlString.append( "<purc_order><![CDATA[" ).append( purcOrder ).append( "]]></purc_order>\r\n" );
								valueXmlString.append( "<order_no><![CDATA[" ).append( purcOrder ).append( "]]></order_no>\r\n" );
								valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
								//valueXmlString.append( "<line_no><![CDATA[" ).append( lineNo ).append( "]]></line_no>\r\n" );
								valueXmlString.append( "<lot_no><![CDATA[" ).append( "  " ).append( "]]></lot_no>\r\n" );
								//Changed by wasim to get shipper size for considering as quantity on 15-12-2015
								//valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
								valueXmlString.append( "<quantity><![CDATA[" ).append( shipperSize ).append( "]]></quantity>\r\n" );
								valueXmlString.append( "<label_no><![CDATA[" ).append(labelNo).append( "]]></label_no>\r\n" );
								valueXmlString.append( "<ref_ser><![CDATA[" ).append(refSer).append( "]]></ref_ser>\r\n" );
								valueXmlString.append( "<descr><![CDATA[" ).append( descr ).append( "]]></descr>\r\n" );
								valueXmlString.append( "<chg_date><![CDATA[" ).append( currDate ).append( "]]></chg_date>\r\n" );
								valueXmlString.append( "<chg_user><![CDATA[" ).append( empCode ).append( "]]></chg_user>\r\n" );
								valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
								valueXmlString.append("</Detail2>\r\n");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						
					}
					
				}
				
			}
			
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				//Commented by Santosh on 14-06-2016
				//connDriver = null;
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}
		
		valueXmlString.append( "</Root>\r\n" );	
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		
		return valueXmlString.toString();
	}
	
	public static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	public String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	public int GetRandomNumber()
    {
        long timeSeed = System.nanoTime(); // to get the current date time value
        double randSeed = Math.random() * 1000; // random number generation
        long midSeed = (long) (timeSeed * randSeed); 
        String s = midSeed + "";
        String subStr = s.substring(0, 9);
        int finalSeed = Integer.parseInt(subStr);    // integer value
        return finalSeed;
    }
}
	

