package ibase.dashboard.mfg.servlet;
import ibase.dashboard.mfg.ejb.WIPStatusRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class WIPStatusGridLinkServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		WIPStatusRemote wipStatusRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String month = "";
		String loginId ="";
		String city = "";
		String category = "";
		String siteCode = "";
		try
		{
			response.setContentType("application/xml");
			
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();
			
			month = request.getParameter("month");
			city = request.getParameter("city");
			category = request.getParameter("category");
			siteCode = request.getParameter("siteCode");
			System.out.println("WIPStatusGridLinkServlet siteCode :"+siteCode);
			System.out.println("category :"+category);
			System.out.println("month :"+month+"---city :"+city+"----category :"+category);
			
			dataSourceName    = request.getParameter("dataSourceName"); 
			context = new InitialContext(appConnectParm.getProperty());
			wipStatusRemote       = (WIPStatusRemote) context.lookup("ibase/WIPStatus/remote");
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			wipStatusRemote.setUserInfo(userInfo);
			JSONObject jsonObjData      = (JSONObject)wipStatusRemote.getWIPStatusLinkGrid(city,siteCode,month,category,dataSourceName);
			OutputStream outputStream   = response.getOutputStream();			
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set inside WIPStatusGridLinkServlet build the Graph is===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception : WIPStatusGridLinkServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}