<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:template match="/">
<html>
	<head>
		<link type="text/css" rel="stylesheet" href="/ibase/css/workflowsign.css"/>
	</head>
	<body> 
		<div>					
			<table width="100%" class="tTableHeader">
				<tr>
					<td colspan="4" align="center" class="tTitle">Purchase Voucher</td>
				</tr>
				<tr>
					<td>
						<span class="tLabel">Voucher No. : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/tran_id"/></span>
					</td>
					<td>
						<span class="tLabel">Transaction Date : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/tran_date"/></span>
					</td>
					<td>
						<span class="tLabel">Voucher Type : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/vouch_type"/> </span>
					</td>
					<td>
						<span class="tLabel">Transaction Type : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/tran_type"/> </span>
					</td>
				</tr>
				<tr>
					<td>
						<span class="tLabel">Purchase order : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/purc_order"/></span>
					</td>
					<td>
						<span class="tLabel">Supplier : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/supp_code"/> [<xsl:value-of select="//Detail1/supp_name"/>]</span>
					</td>
					<td>
						<span class="tLabel">Station : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/stan_descr"/></span>
					</td>
					<td>
						<span class="tLabel">Bill No. : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/bill_no"/></span>
					</td>
				</tr>
				<tr>
					<td>
						<span class="tLabel">Bill Date : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/bill_date"/></span>
					</td>
					<td>
						<span class="tLabel">Bill Amount : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/supp_bill_amt"/> [<xsl:value-of select="//Detail/advance"/>]</span>
					</td>
					<td colspan="2">
						<span class="tLabel">Site: </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/site_code"/> [<xsl:value-of select="//Detail1/site_descr"/>]</span>
					</td>
				</tr>
				<tr>
					<td colspan="4">
						<span class="tLabel">Remarks : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/remarks"/></span>
					</td>
				</tr>
			</table>
		</div>		
		
		<br /><br />
		
		<xsl:if test="//Detail2/line_no!=''">
		<div>
		<table width="100%" class="tTableDetail">					
			<tr>
				<td colspan="9" align="center" class="tTitleD">Advance</td>
			</tr>
			<tr>
				<td class="tLabelD">Reference Series</td>
				<td class="tLabelD">Reference No.</td>
				<td class="tLabelD">Total Amount</td>
				<td class="tLabelD">Adjusted Amount</td>
				<td class="tLabelD">Diff Amt Exch</td>
				<td class="tLabelD">Currency</td>
				<td class="tLabelD">Exchange Rate</td>
				<td class="tLabelD">Account</td>
				<td class="tLabelD">Cost Center</td>
			</tr>								
			<tr>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/ref_ser"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/ref_no"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/tot_amt"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/adj_amt"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/diff_amt__exch"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/curr_code"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/exch_rate__vouch"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/acct_code"/>[<xsl:value-of select="accounts_descr"/>]</td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail2/cctr_code"/></td>
			</tr>			
		</table>
		</div>
		</xsl:if>
		
		<br />
		
		<xsl:if test="//Detail3/line_no!=''">				
		<div>
		<table width="100%" class="tTableDetail">			
			<tr>
				<td colspan="10" align="center"><h4>Receipt</h4></td>
			</tr>
			<tr>
				<td class="tLabelD">Line No.</td>
				<td class="tLabelD">Purchase Receipt No.</td>
				<td class="tLabelD">Line No. Receipt</td>
				<td class="tLabelD">Item</td>
				<td class="tLabelD">Item Description</td>
				<td class="tLabelD">Voucher Quantity</td>
				<td class="tLabelD">Voucher Rate</td>
				<td class="tLabelD">Voucher Amount</td>
				<td class="tLabelD">Voucher No.</td>
				<td class="tLabelD">Unit</td>
			</tr>
			<xsl:for-each select="//Detail3">				
			<tr>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/line_no"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/prcp_id"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/line_no__rcp"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/item_code"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/item_descr"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/vouch_qty"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/vouch_rate"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/vouch_amt"/>[<xsl:value-of select="accounts_descr"/>]</td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/tran_id"/></td>
				<td class="tLabelDataD"><xsl:value-of select="//Detail3/unit"/></td>
			</tr>
			</xsl:for-each>			
		</table>
		</div>
		</xsl:if>
		
		<br />
		
		<xsl:if test="//Detail4/line_no!=''">				
		<div>
		<table width="100%" class="tTableDetail">			
			<tr>
				<td colspan="11" align="center" class="tTitleD">Detail</td>
			</tr>
			<tr>
				<td class="tLabelD">Transaction ID</td>
				<td class="tLabelD">Line No.</td>
				<td class="tLabelD">Account</td>
				<td class="tLabelD">Cost Center</td>
				<td class="tLabelD">Department Code</td>
				<td class="tLabelD">Amount</td>
				<td class="tLabelD">Apply Tax</td>
				<td class="tLabelD">Tax Amount</td>
				<td class="tLabelD">Tax Class</td>
				<td class="tLabelD">Tax Chap</td>
				<td class="tLabelD">Tax Env</td>
			</tr>
			
			<xsl:for-each select="//Detail4">				
			<tr>
				<td class="tLabelDataD"><xsl:value-of select="tran_id"/></td>
				<td class="tLabelDataD"><xsl:value-of select="line_no"/></td>
				<td class="tLabelDataD"><xsl:value-of select="acct_code"/>[<xsl:value-of select="accounts_descr"/>]</td>
				<td class="tLabelDataD"><xsl:value-of select="cctr_code"/></td>
				<td class="tLabelDataD"><xsl:value-of select="dept_code"/></td>
				<td class="tLabelDataD"><xsl:value-of select="amount"/></td>
				<td class="tLabelDataD"><xsl:value-of select="apply_tax"/></td>
				<td class="tLabelDataD"><xsl:value-of select="tax_amt"/></td>
				<td class="tLabelDataD"><xsl:value-of select="tax_class"/></td>
				<td class="tLabelDataD"><xsl:value-of select="tax_chap"/></td>
				<td class="tLabelDataD"><xsl:value-of select="tax_env"/></td>
			</tr>
			</xsl:for-each>
		</table>				
		</div>
		</xsl:if>
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
