package ibase.webitm.ejb.wms;

import ibase.webitm.bean.wms.Stock;
import ibase.webitm.ejb.ValidatorEJB;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class WMSWebServiceDao extends ValidatorEJB
{
	boolean isError = false;
	public List<Stock> getSKUStockData(String itemParnt, String colorCode) 
	{
		Connection conn = null;
		List<Stock> stockList = new ArrayList<Stock>();
		String stockSQL = "",sql = "";
		Stock stock = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		
		try
		{
			System.out.println("itemParnt["+itemParnt+"] colorcode ["+colorCode+"]");
			conn = getConnection();
			//Changed by Santosh on 18/11/16 to add size in stock response
			//stockSQL = "SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = ? AND PHY_ATTRIB_2 = ?";
			stockSQL = "SELECT ITEM_CODE,PHY_ATTRIB_1 FROM ITEM WHERE ITEM_PARNT = ? AND PHY_ATTRIB_2 = ?";
			pstmt = conn.prepareStatement(stockSQL);
			pstmt.setString(1, itemParnt);
			pstmt.setString(2, colorCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				int stockQty = 0, pendPOQty = 0;
				String sku = rs.getString("ITEM_CODE");
				//Added by Santosh on 18/11/16 to add size in stock response
				String size = rs.getString("PHY_ATTRIB_1");
				
				sql = " SELECT S.ITEM_CODE, SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN HOLD_QTY IS NULL THEN 0 ELSE HOLD_QTY END) AS STOCK_QTY"
					+ " FROM STOCK S WHERE S.INV_STAT IN ('ACTPK','CASPK') AND S.ITEM_CODE = ? GROUP BY S.ITEM_CODE HAVING SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN HOLD_QTY IS NULL THEN 0 ELSE HOLD_QTY END) > 0";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,sku);
				rs1 = pstmt1.executeQuery();
				
				if(rs1.next())
				{
					stockQty = rs1.getInt("STOCK_QTY");
				}
				
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				
				sql = " SELECT PD.ITEM_CODE, SUM(PD.QUANTITY - PD.DLV_QTY) AS PEND_PO_QTY FROM PORDER P,PORDDET PD"
					+ " WHERE P.PURC_ORDER = PD.PURC_ORDER AND P.CONFIRMED = 'Y' AND P.STATUS NOT IN ('C','X') AND PD.STATUS NOT IN('C','X')"
					+ " AND PD.ITEM_CODE = ? GROUP BY PD.ITEM_CODE HAVING SUM(PD.QUANTITY - PD.DLV_QTY) > 0";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,sku);
				rs1 = pstmt1.executeQuery();
				
				if(rs1.next())
				{
					pendPOQty = rs1.getInt("PEND_PO_QTY");
				}
				
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//Changed by Santosh on 18/11/16 to add size in stock response
				//stock = new Stock(sku.trim(),stockQty,pendPOQty);
				stock = new Stock(size.trim(),stockQty,pendPOQty);
				stockList.add(stock);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			
		}
		catch (Exception e)
		{
			isError = true;
			System.out.println("StockWebServiceDao.getSKUStockData()");
			e.printStackTrace();
			
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(conn != null && !conn.isClosed())
					{
						conn.close();
						conn = null;
					}
					
				}
			}
			catch(Exception e)
			{
				System.out.println("StockWebServiceDao.getSKUStockData()");
				e.printStackTrace();
			}
			
		}
		return stockList;
	}

}
