package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.GSTR2;

public class GSTR2Serailizer extends JsonSerializer<GSTR2> {
    @Override
    public void serialize(GSTR2 gstr2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
    {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("gstin", gstr2.gstin);
        if(gstr2.b2b != null)
        {
        	jsonGenerator.writeObjectField("b2b", gstr2.b2b);
        } 
        if(gstr2.b2bur != null)
        {
        	jsonGenerator.writeObjectField("b2bur", gstr2.b2bur);
        }
        if(gstr2.cdnr != null)
        {
        	jsonGenerator.writeObjectField("cdn", gstr2.cdnr);
        }
        if(gstr2.hsn != null)
        {
        	jsonGenerator.writeObjectField("hsnsum", gstr2.hsn);
        }
        if(gstr2.impg != null)
        {
        	jsonGenerator.writeObjectField("imp_g", gstr2.impg);
        }
        jsonGenerator.writeEndObject();
    }
}
