
/********************************************************
	Title : PalletReqGenIC
    Request id:W16DSUN008
 ********************************************************/

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class PalletReqGenIC extends ValidatorEJB implements PalletReqGenICLocal, PalletReqGenICRemote 
{
	DistCommon discommon = new DistCommon();
	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, xtraParams,editFlag);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String xtraParams,String editFlag) throws RemoteException, ITMException
	{   				
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String>errFields = new ArrayList <String> ();
		E12GenericUtility genericUtility;
		String siteCode = "",userId = "",childNodeName = "",errString = "",reqType= "";
		int ctr = 0, currentFormNo = 0, childNodeListLength = 0,cnt=0,cnt3=0,cnt4=0,cntLoc=0,palcnt=0;
		String objName="",criteria= "";
		objName = getObjNameFromDom(dom, "objName", "2");
		System.out.println("objName----->>["+objName+"]");	
		System.out.println("editFlag----->>["+editFlag+"]");	
		genericUtility = new E12GenericUtility();	
		Connection conn = null;

		try
		{	
			System.out.println("xtraParam in PalletReqGenIC----->>["+xtraParams+"]");
			siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;
			PreparedStatement pstmt=null;
			ResultSet rs =null;
			String pallet_no="",item_code="",sql="",locSuffixDisp="",stkSql="";
			char lastChar;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}	

			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");
				System.out.println("editFlag----->>["+editFlag+"]");	

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				locSuffixDisp = checkNullAndTrim(discommon.getDisparams("999999", "AWMS_LOCATION_SUFFIX", conn));
				System.out.println("AWMS_LOCATION_SUFFIX["+locSuffixDisp+"]");
				String[] locS = locSuffixDisp.split(",");
				
				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName11------->>["+childNodeName+"]");
					if("req_type".equalsIgnoreCase(childNodeName))
					{

						reqType = checkNullAndTrim(genericUtility.getColumnValue("req_type",dom));
						criteria = checkNullAndTrim(genericUtility.getColumnValue("criteria",dom));
						System.out.println("request type ---------->>["+reqType+"]");	

						if(reqType.length() == 0)
						{
							errCode = "VMPALRENUL";//Please select reqType
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}	
					else if("criteria".equalsIgnoreCase(childNodeName))
					{

						reqType = checkNullAndTrim(genericUtility.getColumnValue("req_type",dom));
						criteria = checkNullAndTrim(genericUtility.getColumnValue("criteria",dom));
						System.out.println("criteria ---------->>["+criteria+"]");	

						if(criteria.length() == 0)
						{
							errCode = "VMCRITENUL";//Please select criteria
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							if(("S".equalsIgnoreCase(reqType)) && ( !"P".equalsIgnoreCase(criteria)))
							{
								errCode = "VMCRITERIA";//Invalid criteria for Stock
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					else if("pallet_no".equalsIgnoreCase(childNodeName) )
					{
						pallet_no = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",dom));
						pallet_no = pallet_no==null ? "" : pallet_no.trim();
						System.out.println("pallet_no:::::"+pallet_no);
						if(pallet_no.trim().length() > 0){
						sql = "SELECT COUNT(1) FROM LOCATION WHERE INV_STAT = ?  AND LOC_CODE =? ";							
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, "AWMS");
						pstmt.setString(2, pallet_no);
						rs = pstmt.executeQuery();
						if(rs.next())
						{	
							cntLoc = rs.getInt(1);
							System.out.println( "cntLoc:::"+cntLoc);
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						
						if(cntLoc > 0)
						{
							lastChar=pallet_no.charAt(pallet_no.trim().length()-1);
							System.out.println("lastChar:"+lastChar); 
							System.out.println("locSuffix disparm=["+locSuffixDisp+"] and lastChar["+lastChar+"]");

							if(locSuffixDisp.contains(String.valueOf(lastChar)))
							{
								System.out.println("****Match found in disparm for"+lastChar);
								System.out.println("location with suffix");
								errCode = "VTPALLEEXT";
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}
							else
							{
								//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
								stkSql = "SELECT COUNT(1) FROM STOCK WHERE INV_STAT IN(?,?)  AND LOC_CODE IN (?,?,?,?,?,?,?,?,?)  AND SITE_CODE=? AND QUANTITY>0";

								pstmt = conn.prepareStatement(stkSql);
								pstmt.setString(1, "AWMS");
								pstmt.setString(2, "AWMSQ");
								pstmt.setString(3, pallet_no);
								pstmt.setString(4, pallet_no+"Q");
								pstmt.setString(5, pallet_no+"B");
								pstmt.setString(6, pallet_no+"X");
								pstmt.setString(7, pallet_no+"M");
								pstmt.setString(8, pallet_no+"U");
								pstmt.setString(9, pallet_no+"P");
								pstmt.setString(10,pallet_no+"S");
								//Changed by Jagruti Shinde ,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022]
								pstmt.setString(11,pallet_no+"R");
								pstmt.setString(12, siteCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{	
									palcnt = rs.getInt(1);
								}
								if (pstmt != null)
								{ 
									pstmt.close(); 
									pstmt = null; 
								}
								if (rs != null) 
								{ 
									rs.close(); 
									rs = null; 
								}

								if(palcnt == 0)
								{
									System.out.println("awms pallet count" +palcnt);
									errCode = "VMPALLETQN";//pallet quantity should be more than zero
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
							}
						}
						else
						{
							System.out.println("pallet not in AWMS" +cntLoc);
							errCode = "VTPALLEEXT";//pallet 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						}//Change by Jagruti Shinde Request Id:[W15JSUN017]  requirement change for Exempted/BSR location inv_stat[End]
					}
					else if("item_code".equalsIgnoreCase(childNodeName))
					{
						item_code = checkNullAndTrim(genericUtility.getColumnValue("item_code",dom));
						item_code = item_code==null ? "" : item_code.trim();
						System.out.println("item_code:::"+item_code);
						if(item_code.trim().length()>0){
						sql="select count(*) as count from siteitem where item_code=? and site_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, item_code);
						pstmt.setString(2, siteCode);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							cnt3=rs.getInt("count");
						}
						if(cnt3==0)
						{
							errCode = "VMINVIC";//Invalid item_code for Stock
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							String sql2="select count(*) as count from stock where site_code = ? and quantity > 0 and inv_stat in ('AWMS','AWMSQ') and item_code=?";
							pstmt = conn.prepareStatement(sql2);
							pstmt.setString(1, siteCode);
							pstmt.setString(2, item_code);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								cnt4=rs.getInt("count");
							}
							if(cnt4==0)
							{
								errCode = "VMICNF";//Invalid item_code for Stock
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					}
				}
				break;
			} //switch end
			System.out.println("after switch"+errList);
			int errListSize = errList.size();
			System.out.println("errListSize .........." + errListSize);
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);

					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );

					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			errString = errStringXml.toString();
		}//try end
		catch ( Exception e )
		{
			System.out.println ( "Exception: PalletReqGenIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			throw new ITMException(e);		
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : PalletReqGenIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}//wf end

	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	/**
	 * The public method is defined without any parameters and returns blank string
	 */
	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(dom)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :PalletReqGenIC :itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from PalletReqGenIC itemChanged \n[" + errString + "]" );

		return errString;
	}
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 */
	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		Connection conn = null;

		StringBuffer valueXmlString;		
		String siteDescr = "",tranDate = "" ,siteCode = "";
		int currentFormNo = 0;

		System.out.println("xtraParams=["+xtraParams+"]");
		E12GenericUtility genericUtility = new E12GenericUtility();		

		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
		try
		{			
			siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));	

			System.out.println("currFormDataDom---->>["+genericUtility.serializeDom(currFormDataDom)+"] ");
			System.out.println("hdrDataDom---->>["+genericUtility.serializeDom(hdrDataDom)+"] ");
			System.out.println("allFormDataDom---->>["+genericUtility.serializeDom(allFormDataDom)+"] ");
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormatObj.format(currentDate.getTime());
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			System.out.println("editFlag-------->["+editFlag+"]");
			System.out.println("objContext------>["+objContext+"]");

			valueXmlString.append("</editFlag>\r\n</Header>\r\n");
			switch ( currentFormNo )  
			{
			case 1:
			{
				valueXmlString.append( "<Detail1>\r\n" );
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("editFlag  CASE 1["+editFlag+"]");
					System.out.println("objContext  CASE 1["+objContext+"]");
					System.out.println("siteCode : ["+siteCode+"]");
					siteDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "site", "site_code", siteCode));
					valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
					valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
					valueXmlString.append( "<req_type><![CDATA[" ).append("S").append( "]]></req_type>\r\n" );
					valueXmlString.append( "<criteria protect='1'><![CDATA[" ).append("P").append( "]]></criteria>\r\n" );
				}
				valueXmlString.append( "<tran_date><![CDATA[" ).append( tranDate ).append( "]]></tran_date>\r\n" );
				valueXmlString.append("</Detail1>\r\n");
			} //Case 1. End
			break;
			}//switch
			valueXmlString.append( "</Root>\r\n" );	 
		}//End of try block
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{	
			try
			{				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string.  
	 * @param input
	 */
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}

	private String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in getColumnDescr ");
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;
	}

	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				if( objName != null && objName.trim().length() > 0)
				{				
					return objName;
				}
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
}


