package ibase.webitm.ejb.fin;

/********************************************************
Title :InvoiceReportSch[D16CSUN011]
Date  : 23/06/16
Developer: Bhushan
Purpose: For sending mail to customer with Invoice in CSV format
********************************************************/

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ParameterMode;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TranXmlData;

public class InvoiceReportSch implements Schedule
{
	E12GenericUtility genericUtility = new E12GenericUtility();

	@Override
	public String schedule(String scheduleParamXML) throws Exception, ITMException
	{
		System.out.println("Inside InvoiceReportSch scheduleParamXML:::::::[" + scheduleParamXML + "]");
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String XmlData = "";
		String tranName = "";
		String sqlInvc ="";
		String noOfDay ="";
		String invcId = "";
		//Added by Bhushan on 15-07-16
		String finEnty = "";
		Document dom = null;
		E12GenericUtility genericUtility= new  E12GenericUtility();
		
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			tranName = "INVOICE_DOWNLOAD";
			DistCommon distCommon = new DistCommon();
			noOfDay = distCommon.getDisparams("999999", "INVOICE_MAIL_GR_DAYS", conn);
			System.out.println("noOfDay::::[" + noOfDay + "]");
			if(noOfDay.equalsIgnoreCase("NULLFOUND"))
			{
				noOfDay= null;
				System.out.println("No records found in Disparm master....");
			}
			
			//Added by Bhushan on 15-07-16:START[For getting FIN_ENTITY value from scheduler formal parameter]
			if(scheduleParamXML != null && scheduleParamXML.trim().length() > 0)
			{
				dom = genericUtility.parseString(scheduleParamXML);
			}
			finEnty = genericUtility.getColumnValue("ACTUALPARAMETER",dom);
			System.out.println("finEnty::::[" + finEnty + "]");
			//Added by Bhushan on 15-07-16:END
			//Commented and Changed by Bhushan on 15-07-16 :START
			//sqlInvc ="SELECT INVOICE_ID FROM INVOICE  WHERE TO_DATE(SYSDATE) - TO_DATE(INVOICE.TRAN_DATE) < " +noOfDay+" AND DOWNLOAD_FLAG ='N'";
			if(finEnty != null && finEnty.trim().length() > 0 && !(finEnty.equalsIgnoreCase("null")) )
			{
				sqlInvc ="SELECT INVOICE_ID FROM INVOICE  WHERE TO_DATE(SYSDATE) - TO_DATE(INVOICE.TRAN_DATE) < " +noOfDay+" " +
						"AND DOWNLOAD_FLAG ='N' AND FIN_ENTITY = '" +finEnty+"'";
			}
			else
			{
				sqlInvc ="SELECT INVOICE_ID FROM INVOICE  WHERE TO_DATE(SYSDATE) - TO_DATE(INVOICE.TRAN_DATE) < " +noOfDay+" AND DOWNLOAD_FLAG ='N'";
			}
			//Commented and Changed by Bhushan on 15-07-16 :END
			System.out.println( "sqlInvc::[" + sqlInvc +"]");
			pstmt = conn.prepareStatement(sqlInvc);
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				invcId = checkNull(rs.getString("INVOICE_ID"));
				System.out.println("invcId::::["+invcId+"]");
				
				if(invcId != null && invcId.trim().length() > 0)
				{
					XmlData = sendInvoiceData(invcId, scheduleParamXML, conn);
				}
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		} 
		catch (Exception e)
		{

			System.out.println("Exception :InvoiceReportSch :schedule :Exception :==>\n" + e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				if ( conn != null)
				{ 
					conn.close();
					conn = null;
				}
			} catch (Exception e)
			{
				System.out.println("Exception" + e.getMessage());
			}
		}
		return "";
	}

	@Override
	public String schedule(HashMap arg0) throws Exception
	{
		return null;
	}

	@Override
	public String schedulePriority(String arg0) throws Exception
	{
		return null;
	}
	
	private String sendInvoiceData(String invcId, String scheduleParamXML, Connection conn)throws ITMException
	{
		System.out.println("Inside sendInvoiceData.......");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String xmlData = "";
		String saveLocation = "";
		String fileName = "";
		String csvData = null;
		String entityType = null;
		String entityCode = null;
		String templUpld = null;
		String templTypeUpld = null;
		String templDnld = null;
		String templTypeDnld = null;
		String objName = null;
		String sql = null;
		boolean isTemplateExist = false;
		ibase.utility.UserInfoBean userInfo = null;

		try
		{
			userInfo = new ibase.utility.UserInfoBean(scheduleParamXML);
			entityCode = userInfo.getEntityCode();
			entityType = userInfo.getUserType();
			objName = "invoice_download";
			System.out.println("objName::["+objName+"]  entityCode::["+entityCode+"]  entityType::["+entityType+"]" );
			
			sql = " select OBJ_NAME, TEMPL_UPLD, TEMPL_TYPE_UPLD, TEMPL_DNLD, TEMPL_TYPE_DNLD" 
				+" from OBJECT_EXIM_FMT "
				+" where OBJ_NAME  = '" + objName + "'" 
				+"	and OBJ_CONTEXT = '" + entityType.trim() + "-" + entityCode.trim() + "'"; 
			//System.out.println( "SQL : " + sql );

			pstmt = conn.prepareStatement( sql );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				objName = rs.getString( "OBJ_NAME" ); 
				templUpld = rs.getString( "TEMPL_UPLD" ); 
				templTypeUpld = rs.getString( "TEMPL_TYPE_UPLD" ); 
				templDnld = rs.getString( "TEMPL_DNLD" ); 
				templTypeDnld = rs.getString( "TEMPL_TYPE_DNLD" ); 
				isTemplateExist = true;
			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if ( ! isTemplateExist )
			{
				sql = " select OBJ_NAME, TEMPL_UPLD, TEMPL_TYPE_UPLD, TEMPL_DNLD, TEMPL_TYPE_DNLD" 
					+" from OBJECT_EXIM_FMT " 
					+" where OBJ_NAME  = '" + objName + "'" 
					+"	and OBJ_CONTEXT = '" + entityType.trim() + "'"; 
				//System.out.println( "SQL : " + sql );

				pstmt = conn.prepareStatement( sql );
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					objName = rs.getString( "OBJ_NAME" ); 
					templUpld = rs.getString( "TEMPL_UPLD" ); 
					templTypeUpld = rs.getString( "TEMPL_TYPE_UPLD" ); 
					templDnld = rs.getString( "TEMPL_DNLD" ); 
					templTypeDnld = rs.getString( "TEMPL_TYPE_DNLD" ); 
					isTemplateExist = true;
				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;				
			}
			
			if ( ! isTemplateExist )
			{
				sql = " select OBJ_NAME, TEMPL_UPLD, TEMPL_TYPE_UPLD, TEMPL_DNLD, TEMPL_TYPE_DNLD" //$NON-NLS-1$
					+" from OBJECT_EXIM_FMT " 
					+" where OBJ_NAME  = '" + objName + "'"
					+"	and OBJ_CONTEXT = 'X'"; 
				//System.out.println( "SQL : " + sql );

				pstmt = conn.prepareStatement( sql );
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					objName = rs.getString( "OBJ_NAME" ); 
					templUpld = rs.getString( "TEMPL_UPLD" ); 
					templTypeUpld = rs.getString( "TEMPL_TYPE_UPLD" ); 
					templDnld = rs.getString( "TEMPL_DNLD" ); 
					templTypeDnld = rs.getString( "TEMPL_TYPE_DNLD" ); 
					isTemplateExist = true;
				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;				
			}
			System.out.println("isTemplateExist::>>["+isTemplateExist+"] templDnld::["+templDnld+"] templTypeDnld::["+templTypeDnld+"] ");
			if( isTemplateExist )
			{
				if( templTypeDnld.equalsIgnoreCase( "C" ) ) 
				{
					ibase.webitm.utility.XML2CSVCustomConverter csvConverter = null;
					csvConverter = new ibase.webitm.utility.XML2CSVCustomConverter();
					
					TranXmlData client = null;
					client = new TranXmlData();
					xmlData = client.getTranXml( "invoice",
										java.sql.Timestamp.valueOf( "2016-06-01 00:00:00" ),
										java.sql.Timestamp.valueOf( "2016-06-01 00:00:00" ),
										invcId, invcId, conn );
					
					System.out.println("xmlData::::>>["+xmlData+"]");
					
					DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
					javax.xml.parsers.DocumentBuilder db = dbf.newDocumentBuilder();
					Document dom = db.parse(File.separator+"IBASEHOME"+ File.separator +"ibase.xml");
					
					saveLocation = dom.getElementsByTagName("invoice_csv_attachpath").item(0).getFirstChild().getNodeValue();
					System.out.println("CSV File saveLocation::::>>["+saveLocation+"]");
					
					if(xmlData != null && saveLocation != null)
					{
						csvData = csvConverter.convert( xmlData,  
														CommonConstants.JBOSSHOME + File.separator + "DOWNLOAD" 
														+ File.separator + "template"
														+ File.separator + templDnld + ".xml", 
														null );
						System.out.println("csvData::::>> ["+csvData+"]");
						
						fileName = saveLocation + File.separator + invcId + ".csv";
						System.out.println("fileName::::>>["+fileName+"]");
						
						FileOutputStream out = new FileOutputStream(fileName);
						if(csvData != null && csvData.trim().length() > 0)
						{
							out.write( csvData.getBytes());
							out.flush();
							out.close();
							System.out.println("CSV File created....");
							
							String result = sendInvoiceMail(invcId, fileName, conn);
							System.out.println("result>>>["+result+"]");
						}
					}
				}
			}
		} 
		catch (Exception e)
		{
			System.out.println("Exception :InvoiceReportSch :sendInvoiceData():Exception :==>\n" + e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return "";
	}
	
	private String sendInvoiceMail(String invcId, String fileName, Connection conn)throws ITMException
	{
		System.out.println("Inside sendInvoiceMail.......");
		String sqlHdr = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer commInfo = new StringBuffer();
		String userType = "";
		String empCode = "";
		String custCode = "";
		String custCodeBil = "";
		String tranDt = "";
		
		String siteCode = "";
		String formatCode = "";
		String mailRetStr = "";
		String updtStatus = "N";
		
		try
		{
			sqlHdr = "SELECT TRAN_DATE ,CUST_CODE__BIL, CUST_CODE , SITE_CODE  FROM INVOICE WHERE INVOICE_ID = ? ";
			pstmt = conn.prepareStatement(sqlHdr);
			pstmt.setString(1, invcId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranDt = checkNull(rs.getString("TRAN_DATE"));
				custCodeBil = checkNull(rs.getString("CUST_CODE__BIL"));
				custCode = checkNull(rs.getString("CUST_CODE"));
				siteCode = checkNull(rs.getString("SITE_CODE"));
				System.out.println("tranDt::::>>["+tranDt+"]  custCodeBil:::>>["+custCodeBil+"]");
				System.out.println("custCode::::>>["+custCode+"]  siteCode:::>>["+siteCode+"]");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			//tranDt= genericUtility.getValidDateString(tranDt, "dd/mm/yy");
			tranDt= genericUtility.getValidDateString(tranDt, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			System.out.println("tranDt::::["+tranDt+"]");
			formatCode = "INVCE_MAIL";
			System.out.println("formatCode::::>>["+formatCode+"]");
			
			commInfo.append("<ROOT>");
			commInfo.append("<MAIL><EMAIL_TYPE>page</EMAIL_TYPE><ENTITY_CODE>BASE</ENTITY_CODE>");
			commInfo.append("<ENTITY_TYPE>"+userType+"</ENTITY_TYPE>");
			commInfo.append("<TO_ADD></TO_ADD>");
			commInfo.append("<BCC_ADD></BCC_ADD>");
			commInfo.append("<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>");							
			commInfo.append("<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>");
			commInfo.append("</MAIL>");
			commInfo.append("<XML_DATA><ROOT><Detail1><tran_date>"+tranDt+"</tran_date><invoice_id>"+invcId+"</invoice_id>" +
					"<cust_code>"+custCode+"</cust_code><cust_code__bil>"+custCodeBil+"</cust_code__bil>" +
					"<site_code>"+siteCode+"</site_code><emp_code>"+empCode+"</emp_code>");
			commInfo.append("<cc_to></cc_to></Detail1></ROOT></XML_DATA>");
			commInfo.append("<EMAIL_TYPE>page</EMAIL_TYPE><XML_DATA_FILE_PATH>"+fileName
					+"</XML_DATA_FILE_PATH><ENTITY_CODE></ENTITY_CODE>");
			commInfo.append("</ROOT>");
			//Add by Bhushan on 30-06-16 :SATRT
			String emailAddr = getCustEmailAddr(custCode, conn);
			if(emailAddr != null && emailAddr.trim().length() > 0)
			{
				EMail email = new EMail();
				mailRetStr = email.sendMail(commInfo.toString(), "ITM");
				System.out.println("Mail return String:::>>[" + mailRetStr+ "]");
			}
			else
			{
				System.out.println("Not found Email_address for Customer code::[" + custCode + "]");
			}
			//Add by Bhushan on 30-06-16 :END
			if(mailRetStr.equalsIgnoreCase("S"))
			{						
				System.out.println("InvoiceEmail send SUCCESSFULLY for Customer code::[" + custCode + "]");
				
				pstmt = conn.prepareStatement( "UPDATE INVOICE SET DOWNLOAD_FLAG='Y', INV_EXP_DATE = SYSDATE WHERE INVOICE_ID = ? " );
				pstmt.setString(1, invcId);
				int uptCnt = pstmt.executeUpdate();
				if(uptCnt > 0)
				{
					updtStatus ="Y";
				}
				pstmt.close();
				pstmt = null;
			}
			else
			{
				System.out.println("InvoiceEmail sending FAIL for Customer code :- [" + custCode + "]");
			}
			
			
		} 
		catch (Exception e)
		{
			System.out.println("Exception :InvoiceReportSch :sendInvoiceMail :Exception :==>\n" + e.getMessage());
			e.printStackTrace();
			//throw new ITMException(e);
			try
			{
				System.out.println("Rollbacking transaction....");
				conn.rollback();
				updtStatus = e.getMessage();
			}
			catch(Exception e1)
			{
				System.out.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn !=null)
				{
					if("Y".equalsIgnoreCase(updtStatus))
					{
						conn.commit();
						System.out.println("InvoiceReportSch :sendInvoiceMail commit successfully::::::");
					}
					//conn.close();
					//conn = null;
				}
				
			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return updtStatus;
	}
	//Add by Bhushan on 30-06-16 :SATRT
	private String getCustEmailAddr(String custCode, Connection conn) throws ITMException
	{
		String sql = "", emailAddr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT EMAIL_ADDR FROM CUSTOMER WHERE CUST_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, custCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				emailAddr = checkNull(rs.getString("EMAIL_ADDR"));
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			
		} 
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("getCustEmailAddr() emailAddr::["+emailAddr+"]");
		return emailAddr;
	}
	//Add by Bhushan on 30-06-16 :END
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
}
