package ibase.webitm.ejb.dis;

import ibase.webitm.ejb.ValidatorEJB;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class ItemDetails extends ValidatorEJB
{
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ArrayList getItemListDetails(String itemCode) 
	{
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList itemList = new ArrayList();
		
		String phyAttrib2IT = "", phyAttrib2 = "", phyAttrib6IT = "", phyAttrib6 = "", phyAttrib4IT = "", phyAttrib4 = "", itemParent = "",
				parentDesrc = "", unit = "",hsnNo = "";
		int quantity = 0, allocQty = 0, holdQty = 0, availQty = 0;
		try 
		{
			conn = getConnection();
			
			/*sql = "SELECT I1.ITEM_PARNT, I1.DESCR AS PARENT_DESCR, I1.PHY_ATTRIB_2, I1.PHY_ATTRIB_6, I1.PHY_ATTRIB_4, I.DESCR, " +
				" (SELECT SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END )  FROM STOCK S  " +
				" WHERE S.ITEM_CODE = ? GROUP BY S.ITEM_CODE) AS STOCk FROM ITEM I1, ITEM I WHERE I1.ITEM_PARNT = I.ITEM_CODE (+) AND I1.ITEM_CODE = ?";*/
			sql = "SELECT  IT.PHY_ATTRIB_2 as IT_PHY_ATTRIB_2, I.PHY_ATTRIB_2, IT.PHY_ATTRIB_6 AS IT_PHY_ATTRIB_6, I.PHY_ATTRIB_6, " +
				 " IT.PHY_ATTRIB_4 AS IT_PHY_ATTRIB_4, I.PHY_ATTRIB_4 " +
				 " FROM  ITEM I,  ITEM_TYPE IT WHERE  I.ITEM_CODE = ? AND TRIM(I.ITEM_TYPE) = TRIM(IT.ITEM_TYPE) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, checkNull(itemCode));
			rs = pstmt.executeQuery();
			if ( rs.next())
			{
				phyAttrib2IT = checkNull( rs.getString("IT_PHY_ATTRIB_2"));
				phyAttrib2 = checkNull( rs.getString("PHY_ATTRIB_2"));
				phyAttrib6IT = checkNull( rs.getString("IT_PHY_ATTRIB_6"));
				phyAttrib6 = checkNull( rs.getString("PHY_ATTRIB_6"));
				phyAttrib4IT = checkNull( rs.getString("IT_PHY_ATTRIB_4"));
				phyAttrib4 = checkNull( rs.getString("PHY_ATTRIB_4"));
			}
			if (rs != null) 
			{					
				rs.close();
				rs = null;
			}
			if (pstmt != null ) 
			{					
				pstmt.close();
				pstmt = null;
			}
			
			sql = "SELECT I1.ITEM_PARNT, I1.DESCR AS PARENT_DESCR, I.UNIT, " +
				 " (SELECT  SUM(S.QUANTITY)  FROM STOCK S WHERE S.ITEM_CODE = ? GROUP BY S.ITEM_CODE) AS QUANTITY, " +
				 " (SELECT  SUM(S.ALLOC_QTY)  FROM STOCK S WHERE S.ITEM_CODE = ? GROUP BY S.ITEM_CODE) AS ALLOC_QTY, " +
				 " (SELECT  SUM(S.HOLD_QTY)  FROM STOCK S WHERE S.ITEM_CODE = ? GROUP BY S.ITEM_CODE) AS HOLD_QTY, " +
				 " (SELECT  SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END ) FROM STOCK S WHERE " +
				 " S.ITEM_CODE = ? GROUP BY S.ITEM_CODE ) AS AVAIL_QTY ," +
				 " I1.HSN_NO AS HSN_NO"+
				 " FROM ITEM I1, ITEM I WHERE I1.ITEM_PARNT = I.ITEM_CODE (+) AND I1.ITEM_CODE = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, checkNull(itemCode));
			pstmt.setString(2, checkNull(itemCode));
			pstmt.setString(3, checkNull(itemCode));
			pstmt.setString(4, checkNull(itemCode));
			pstmt.setString(5, checkNull(itemCode));
			rs = pstmt.executeQuery();
			if ( rs.next())
			{
				itemParent = checkNull( rs.getString("ITEM_PARNT"));
				parentDesrc = checkNull( rs.getString("PARENT_DESCR"));
				unit = checkNull( rs.getString("UNIT"));
				quantity = rs.getInt("QUANTITY");
				allocQty = rs.getInt("ALLOC_QTY");
				holdQty = rs.getInt("HOLD_QTY");
				availQty = rs.getInt("AVAIL_QTY");
				hsnNo = rs.getString("HSN_NO");
			}
			if (rs != null) 
			{					
				rs.close();
				rs = null;
			}
			if (pstmt != null ) 
			{					
				pstmt.close();
				pstmt = null;
			}

			itemList.add(itemParent);
			itemList.add(parentDesrc);
			itemList.add(phyAttrib2IT);
			itemList.add(phyAttrib2);
			itemList.add(phyAttrib6);
			itemList.add(phyAttrib6IT);
			itemList.add(phyAttrib4IT);
			itemList.add(phyAttrib4);
			itemList.add(unit);
			itemList.add(String.valueOf(quantity));
			itemList.add(String.valueOf(allocQty));
			itemList.add(String.valueOf(holdQty));
			itemList.add(String.valueOf(availQty));
			itemList.add(String.valueOf(hsnNo));
		}
		catch (Exception e) 
		{
			System.out.println("ItemListDetails.getItemListDetails()["+e.getMessage()+"]");
			e.printStackTrace();
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				if (conn != null ) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("ItemListDetails.getItemListDetails()");
				e.printStackTrace();
			}
		}
		System.out.println("ItemListDetails from ItemListDetails =======>>["+itemList+"]");
		return itemList;
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public String getDocId(String itemCode) 
	{
		System.out.println("inside getDocIDImages");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String errString = "";
		Connection conn = null;
		ArrayList itemList = new ArrayList();
		try
		{	
			conn = getConnection();

			sql = " SELECT DOC_TRANSACTION_LINK.DOC_ID FROM  DOC_TRANSACTION_LINK DOC_TRANSACTION_LINK, DOC_CONTENTS DOC_CONTENTS, ITEM ITEM " 
				+ " WHERE  DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND (TRIM(DOC_TRANSACTION_LINK.REF_ID) = TRIM(ITEM.ITEM_PARNT) OR " 
				+ " TRIM(DOC_TRANSACTION_LINK.REF_ID) = TRIM(ITEM.ITEM_CODE)) AND  ITEM.ITEM_CODE =  ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				itemList.add(checkNull(rs.getString("DOC_ID")));
			}
			if (rs != null) 
			{	
				rs.close();
				rs = null;
			}
			if (pstmt != null ) 
			{	
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception ex)
		{	
			System.out.println("Inside catch getDocIDImages");
			ex.printStackTrace();
		}
		finally 
		{
			try 
			{
				if (rs != null) 
				{	
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{	
					pstmt.close();
					pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{	
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("ItemListDetails.getDocId()["+e.getMessage()+"]");
			}
		}
		errString = itemList.toString();
		errString = errString.substring(1, errString.length() - 1);
		System.out.println("errString ::::::::["+errString+"]");
		return errString;
	}
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}
	

}
