package ibase.dashboard.wms.servlet;

import ibase.dashboard.wms.ejb.WMS3PLDashboardRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class OrderStatusDueDateWiseSummaryServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		WMS3PLDashboardRemote wms3PLDashboardRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		
		String dataSourceName = "";
		String siteCode = "";
		JSONObject jsonObjData = null;
		OutputStream outputStream = null;
		
		try
		{
			
			response.setContentType("application/xml");
			siteCode = request.getParameter("siteCode");
			dataSourceName = request.getParameter("dataSourceName");

			
			System.out.println("*********** In OrderStatusDueDateWiseSummaryServlet siteCode is *************** =" + siteCode);
			
			context = new InitialContext(appConnectParm.getProperty());
			wms3PLDashboardRemote = (WMS3PLDashboardRemote) context.lookup("ibase/WMS3PLDashboard/remote");
			jsonObjData = (JSONObject) wms3PLDashboardRemote.getOrderStatusDueDateWiseSummary(siteCode, dataSourceName);
			outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			/*String jsonObjData= "{'0':{'product_category':'Over Due','category_value':{'Jan':'91030265.756'},'date':'1'}, '1':{'product_category':'Outstanding','category_value':{'Jan':'2100'},'date':'2'},'2':{'product_category':'Pending Order','category_value':{'Jan':'60415938.593'},'date':'3'},'3':{'product_category':'Credit Limit','category_value':{'Jan':'900000'},'date':'0'},'4':{'product_category':'Balance','category_value':{'Jan':'100105'},'date':'4'}}" ;
			outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().replace('\'', '"').getBytes());
			outputStream.flush();
			outputStream.close();*/
			System.out.println(" Final data set for getOrderStatusDueDateWiseSummary  build the Graph is === "+ jsonObjData);
            
		    }
		    catch (Exception e)
		    {
			System.out.println("Exception : OrderStatusDueDateWiseSummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
