package ibase.dashboard.mfg.servlet;

import ibase.dashboard.mfg.ejb.SampleRCpDtlRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class SampleRcpDtlServlet extends HttpServlet
{
	// private static final long serialVersionUID = 1L;

	/**
     * 
     */
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		SampleRCpDtlRemote sampleRCpDtlRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String lastMonth = "";
		try
		{
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			dataSourceName = request.getParameter("dataSourceName");
			lastMonth = request.getParameter("lastMonth");
			context = new InitialContext(appConnectParm.getProperty());
			sampleRCpDtlRemote = (SampleRCpDtlRemote) context.lookup("ibase/SampleRCpDtl/remote");
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			sampleRCpDtlRemote.setUserInfo(userInfo);
			JSONObject jsonObjData = (JSONObject) sampleRCpDtlRemote.getSampleRCPDtlData(dataSourceName,lastMonth);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for SampleRcpDtlServlet  build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : SampleRcpDtlServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}