package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import ibase.system.config.ConnDriver;
import ibase.utility.GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class StdPayStru
 */
@Stateless
public class StdPayStru extends ValidatorEJB implements StdPayStruRemote, StdPayStruLocal 
{

	public String itemChanged() throws RemoteException, ITMException 
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1,
			String xmlString2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException,
			ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";

		try 
		{
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) 
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : StdPayStru : [itemChanged(String, xmlString)] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2,
			String objContext, String currentColumn, String editFlag,
			String xtraParams) throws RemoteException, ITMException 
	{
		GenericUtility genericUtility = null;

		Connection conn = null;
		int currentFormNo = 0;

		ResultSet rs = null;
		String payTable = "", ptDescr = "";
		String grade = "", gradeDescr = "";
		String adCode = "", adCodeDescr = "";
		String mTakeHome = "", mGross = "", paGross = "";
		String payable = "";
		String amtType = "", frequency = "", payMethod = "", updPayStru = "", applMode = "", canModify = "";
		String query = "";
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString;
		try 
		{
			valueXmlString = new StringBuffer();
			genericUtility = GenericUtility.getInstance();
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			valueXmlString = new StringBuffer(
					"<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			switch (currentFormNo) 
			{
				case 1:
					valueXmlString.append("<Detail1>");
					if (currentColumn.trim().equalsIgnoreCase("itm_default")) 
					{
						amtType = "F";
						frequency = "2";
						payMethod = "S";
						updPayStru = "Y";
						applMode = "3";
						mTakeHome = "A";
						canModify = "N";
						mGross = "A";
						paGross = "A";
						valueXmlString.append("<amount_type>").append("<![CDATA[" + amtType + "]]>").append("</amount_type>");
						valueXmlString.append("<frequency>").append("<![CDATA[" + frequency + "]]>").append("</frequency>");
						valueXmlString.append("<pay_method>").append("<![CDATA[" + payMethod + "]]>").append("</pay_method>");
						valueXmlString.append("<upd_paystru>").append("<![CDATA[" + updPayStru + "]]>").append("</upd_paystru>");
						valueXmlString.append("<appl_mode>").append("<![CDATA[" + applMode + "]]>").append("</appl_mode>");
						valueXmlString.append("<mtakehome_mode>").append("<![CDATA[" + mTakeHome + "]]>").append("</mtakehome_mode>");
						valueXmlString.append("<can_modify>").append("<![CDATA[" + canModify + "]]>").append("</can_modify>");
						valueXmlString.append("<mgross_mode>").append("<![CDATA[" + mGross + "]]>").append("</mgross_mode>");
						valueXmlString.append("<pagross_mode>").append("<![CDATA[" + paGross + "]]>").append("</pagross_mode>");
						System.out.println("valueXmlString :: " + currentColumn + " " + valueXmlString);
					}
					else if(currentColumn.trim().equalsIgnoreCase("pay_table"))
					{
						payTable = checkNull(genericUtility.getColumnValue("pay_table", dom));
						query = " select descr from paytable where pay_table = ? ";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1, payTable);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							ptDescr = rs.getString("descr") == null ? "" : rs.getString("descr");
						}
						if (rs != null) 
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<paytable_descr>").append("<![CDATA[" + ptDescr + "]]>").append("</paytable_descr>");
					}
					else if(currentColumn.trim().equalsIgnoreCase("grade"))
					{
						grade = checkNull(genericUtility.getColumnValue("grade", dom));
						query = " select descr from grade where grade_code = ? ";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1, grade);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							gradeDescr = rs.getString("descr") == null ? "" : rs.getString("descr");
						}
						if (rs != null) 
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<grade_descr>").append("<![CDATA[" + gradeDescr + "]]>").append("</grade_descr>");
					}
					else if(currentColumn.trim().equalsIgnoreCase("ad_code"))
					{
						adCode = checkNull(genericUtility.getColumnValue("ad_code", dom));
						query = " select descr, payable from allwdedn where ad_code = ? ";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1, adCode);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							adCodeDescr = rs.getString("descr") == null ? "" : rs.getString("descr");
							payable = rs.getString("payable") == null ? "" : rs.getString("payable");
						}
						if (rs != null) 
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<allwdedn_descr>").append("<![CDATA[" + adCodeDescr + "]]>").append("</allwdedn_descr>");
						if(payable.equalsIgnoreCase("A"))
						{
							mTakeHome = "A";
							valueXmlString.append("<mtakehome_mode>").append("<![CDATA[" + mTakeHome + "]]>").append("</mtakehome_mode>");
						}
						else if(payable.equalsIgnoreCase("D"))
						{
							mTakeHome = "D";
							valueXmlString.append("<mtakehome_mode>").append("<![CDATA[" + mTakeHome + "]]>").append("</mtakehome_mode>");
						}
						else
						{
							mTakeHome = "N";
							valueXmlString.append("<mtakehome_mode>").append("<![CDATA[" + mTakeHome + "]]>").append("</mtakehome_mode>");
						}
						if(mTakeHome.equalsIgnoreCase("A"))
						{
							mGross = "A";
							paGross = "A";
							valueXmlString.append("<mgross_mode protect=\"1\">").append("<![CDATA[" + mGross + "]]>").append("</mgross_mode>");
							valueXmlString.append("<pagross_mode protect=\"1\">").append("<![CDATA[" + paGross + "]]>").append("</pagross_mode>");
						}
						else
						{
							mGross = "N";
							paGross = "N";
							valueXmlString.append("<mgross_mode protect=\"0\">").append("<![CDATA[" + mGross + "]]>").append("</mgross_mode>");
							valueXmlString.append("<pagross_mode protect=\"0\">").append("<![CDATA[" + paGross + "]]>").append("</pagross_mode>");
						}
						System.out.println("valueXmlString :: " + currentColumn + " " + valueXmlString);
					}
					else if(currentColumn.trim().equalsIgnoreCase("mtakehome_mode"))
					{
						mTakeHome = checkNull(genericUtility.getColumnValue("mtakehome_mode", dom));
						if(mTakeHome.equalsIgnoreCase("A"))
						{
							mGross = "A";
							paGross = "A";
							valueXmlString.append("<mgross_mode protect=\"1\">").append("<![CDATA[" + mGross + "]]>").append("</mgross_mode>");
							valueXmlString.append("<pagross_mode protect=\"1\">").append("<![CDATA[" + paGross + "]]>").append("</pagross_mode>");
						}
						else
						{
							mGross = "N";
							paGross = "N";
							valueXmlString.append("<mgross_mode protect=\"0\">").append("<![CDATA[" + mGross + "]]>").append("</mgross_mode>");
							valueXmlString.append("<pagross_mode protect=\"0\">").append("<![CDATA[" + paGross + "]]>").append("</pagross_mode>");
						}
						System.out.println("valueXmlString :: " + currentColumn + " " + valueXmlString);
					}
					else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit")) 
					{
						mTakeHome = checkNull(genericUtility.getColumnValue("mtakehome_mode", dom));
						mGross = checkNull(genericUtility.getColumnValue("mgross_mode", dom));
						paGross = checkNull(genericUtility.getColumnValue("pagross_mode", dom));
						if(mTakeHome.equalsIgnoreCase("A"))
						{
							//mGross = "A";
							//paGross = "A";
							if (mTakeHome.equalsIgnoreCase(mGross))
							{
								valueXmlString.append("<mgross_mode protect=\"1\">").append("<![CDATA[" + mGross + "]]>").append("</mgross_mode>");
							}
							if (mTakeHome.equalsIgnoreCase(paGross))
							{
								valueXmlString.append("<pagross_mode protect=\"1\">").append("<![CDATA[" + paGross + "]]>").append("</pagross_mode>");
							}
						}
						/*
						else
						{
							mGross = "N";
							paGross = "N";
							valueXmlString.append("<mgross_mode protect=\"0\">").append("<![CDATA[" + mGross + "]]>").append("</mgross_mode>");
							valueXmlString.append("<pagross_mode protect=\"0\">").append("<![CDATA[" + paGross + "]]>").append("</pagross_mode>");
						}
						*/
						System.out.println("valueXmlString :: " + currentColumn + " " + valueXmlString);
					}
					valueXmlString.append("</Detail1>");

					break;
				}
				valueXmlString.append("</Root>");
			} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} 
		finally 
		{
			try 
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			} catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		System.out.println("valueXmlString:::::" + valueXmlString.toString());
		return valueXmlString.toString();
	}

	public String wfValData() throws RemoteException, ITMException 
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,
			String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try 
		{
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) 
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : StdPayStru : wfValData(String xmlString) : ==>" + e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2,
			String objContext, String editFlag, String xtraParams)
			throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0, childNodeListLength = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		SimpleDateFormat simpleDateFormat = null;

		String msgType = "";

		GenericUtility genericUtility = null;

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);		
			
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for (int ctr = 0; ctr < childNodeListLength; ctr++) 
					{
						childNode = childNodeList.item(ctr);
						if (childNode.getNodeType() != Node.ELEMENT_NODE) 
						{
							continue;
						}
						childNodeName = childNode.getNodeName();

						System.out.println("childNodeName.editFlag." + childNodeName + ".." + editFlag);

						if (childNodeName.equalsIgnoreCase("pay_table")) 
						{
							String payTable = checkNull(genericUtility.getColumnValue("pay_table", dom));
							
							if (payTable.length() == 0) 
							{

								System.out.println("PAY TABLE is null");

								errList.add("VMSTDPAY01");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMSTDPAY01");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}

							else 
							{
								int cnt = 0;

								System.out.println("PAY TABLE invalid");

								String sql = " select count(1) as RowCount from paytable where pay_table = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, payTable);
								rs = pstmt.executeQuery();
								
								System.out.println(" SQL :: " + sql);

								if (rs.next()) 
								{
									cnt = rs.getInt("RowCount");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (cnt < 1) 
								{
									System.out.println("PAY_TABLE error message");

									errList.add("VMSTDPAY02");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMSTDPAY02");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
						} 
						else if (childNodeName.equalsIgnoreCase("grade")) 
						{
							String grade = checkNull(genericUtility.getColumnValue("grade", dom));
							
							if (grade.length() == 0) 
							{

								System.out.println("GRADE is null");

								errList.add("VMSTDPAY03");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMSTDPAY03");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}

							else 
							{
								int cnt = 0;

								System.out.println("GRADE invalid");

								String sql = " select count(1) as RowCount from grade where grade_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, grade);
								rs = pstmt.executeQuery();
								
								System.out.println(" SQL :: " + sql);

								if (rs.next()) 
								{
									cnt = rs.getInt("RowCount");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (cnt < 1) 
								{
									System.out.println("GRADE error message");

									errList.add("VMSTDPAY04");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMSTDPAY04");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("ad_code")) 
						{
							String adCode = checkNull(genericUtility.getColumnValue("ad_code", dom));
							
							if (adCode.length() == 0) 
							{

								System.out.println("AD CODE is null");

								errList.add("VMSTDPAY05");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMSTDPAY05");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}

							else 
							{
								int cnt = 0;

								System.out.println("AD Code invalid");

								String sql = " select count(1) as RowCount from allwdedn where ad_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, adCode);
								rs = pstmt.executeQuery();
								
								System.out.println(" SQL :: " + sql);

								if (rs.next()) 
								{
									cnt = rs.getInt("RowCount");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (cnt < 1) 
								{
									System.out.println("AD CODE error message");

									errList.add("VMSTDPAY06");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMSTDPAY06");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
						} 
						else if (childNodeName.equalsIgnoreCase("eff_date")) 
						{
							String effDate = checkNull(genericUtility.getColumnValue("eff_date", dom));
							
							if (effDate.length() == 0) 
							{
								errList.add("VMSTDPAY07");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMSTDPAY07");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
						}

						else if (childNodeName.equalsIgnoreCase("valid_upto")) 
						{
							String validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom));
							String effDate = checkNull(genericUtility.getColumnValue("eff_date", dom));

							if (validUpto.length() == 0) 
							{
								errList.add("VMSTDPAY08");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMSTDPAY08");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
							
							else if (simpleDateFormat.parse(effDate).compareTo(simpleDateFormat.parse(validUpto)) >= 0) 
							{
								errList.add("VMSTDPAY09");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMSTDPAY09");
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							
							else if (editFlag.equalsIgnoreCase("A"))
							{
								int cnt = 0;
								Timestamp effDateDB = null;
								Timestamp validUptoDB = null;
								try
								{
									effDateDB = Timestamp.valueOf(genericUtility.getValidDateTimeString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
								}
								catch(Exception e)
								{
									errList.add("VMSTDPAY07");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMSTDPAY07");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
								try
								{
									validUptoDB = Timestamp.valueOf(genericUtility.getValidDateTimeString(validUpto, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
								}
								catch(Exception e)
								{
									errList.add("VMSTDPAY08");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMSTDPAY08");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
								// Modified by Piyush on 29/09/2016 [To validate with all primary key fields].Start
								/*
								String sql = " select count(1) as RowCount from std_paystru where eff_date > ? and eff_date <= ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setTimestamp(1, effDateDB);
								pstmt.setTimestamp(2, validUptoDB);
								*/

								String payTable = checkNull(genericUtility.getColumnValue("pay_table", dom));
								String grade = checkNull(genericUtility.getColumnValue("grade", dom));
								String adCode = checkNull(genericUtility.getColumnValue("ad_code", dom));
								String sql = "select count(1) as RowCount from std_paystru where eff_date > ? and eff_date <= ?  and pay_table = ? and grade = ? and ad_code = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setTimestamp(1, effDateDB);
								pstmt.setTimestamp(2, validUptoDB);
								pstmt.setString(3, payTable);
								pstmt.setString(4, grade);
								pstmt.setString(5, adCode);
								// Modified by Piyush on 29/09/2016 [To validate with all primary key fields].End
								rs = pstmt.executeQuery();
								
								System.out.println(" SQL :: " + sql);

								if (rs.next()) 
								{
									cnt = rs.getInt("RowCount");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (cnt > 0) 
								{
									errList.add("VMSTDPAY13");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMSTDPAY13");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("amount"))
						{
							String amt = checkNull(genericUtility.getColumnValue("amount", dom));
							Double a = 0.0;
							if (amt.length() == 0) 
							{
								errList.add("VMSTDPAY10");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMSTDPAY10");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
							else
							{
								try
								{
									a = Double.parseDouble(amt);
									if (a < 0)
									{
										errList.add("VMSTDPAY12");
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, "VMSTDPAY12");
										if (msgType.equalsIgnoreCase("E")) 
										{
											break;
										}
									}
								}
								catch(Exception e)
								{
									errList.add("VMSTDPAY10");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMSTDPAY10");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
						}
					}
					break;
				}

				int errListSize = errList.size();
				StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");

				//ERRORLIST
				if (errList != null && errListSize > 0) 
				{
					for (int cnt = 0; cnt < errListSize; cnt++) 
					{
						String errCode = (String) errList.get(cnt);
						String errFldName = (String) errFields.get(cnt);
						System.out.println("errCode .........." + errCode);

						errString = getErrorString(errFldName, errCode, userId);
						System.out.println("errString is : ::::>>>> " + errString);
						msgType = errorType(conn, errCode);
						if (errString.length() > 0)
						{
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........." + errStringXml);
							errString = "";
						}
						if (msgType.equalsIgnoreCase("E")) 
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;

					errStringXml.append("</Errors></Root>\r\n");
				} 
				else 
				{
					errStringXml = new StringBuffer("");
				}
				errString = errStringXml.toString();
			} 
			
			catch (Exception e) 
			{
				System.out.println("Exception ::" + e);
				e.printStackTrace();
				errString = e.getMessage();
			} 
			finally 
			{
				try 
				{
					if (conn != null) 
					{
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						conn.close();
					}
					conn = null;
				} 
				catch (Exception d) 
				{
					d.printStackTrace();
				}
			}
			System.out.println("ErrString ::" + errString);
			return errString;
	}
	
	private String errorType(Connection conn, String errorCode) throws ITMException 
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				msgType = rs.getString("MSG_TYPE");
			}
		} 
		catch (Exception ex) 
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		} 
		else 
		{
			input = input.trim();
		}
		return input;
	}
	
}
