<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">


<html>
<head>
<meta charset="utf-8" />
</head>
<script type="text/javascript" src="/ibase/webitm/js/prodWiz_Edit.js" charset="utf-8"></script>

<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>

<script type="text/javascript" src="/ibase/webitm/js/sortable_table.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/fixed_table_rc.js"></script>

<!-- <link href="/ibase/webitm/css/DD/ProductWizard.css" rel="stylesheet"/> -->
<link href="/ibase/webitm/css/DD/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>

<link href="/ibase/webitm/css/DD/fixed_table_rc.css" rel="stylesheet"/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/htmlWizard.css"/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/productWiz.css"/>

<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/jquery.datetimepicker.css"/> 

<script>
<![CDATA[

	$(document).ready(function() {
	
	    $('#SKUItemId').fxdHdrCol({
			fixedCols:  0,
			width:     "100%",
			height:    "95%",
			colModal: [
				   { width: 100, align: 'center' },
				   { width: 300, align: 'left' },
				   { width: 300, align: 'left' },
				   { width: 90, align: 'center' },
				   { width: 90, align: 'center' },
				   { width: 90, align: 'center' },
				   { width: 110, align: 'left' },
				   { width: 150, align: 'left' },
				   { width: 150, align: 'left' },
				   { width: 250, align: 'left' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },/* Changed by sneha on 27-09-2016 for trade mark*/
				   { width: 120, align: 'center' },/* Changed by wasim on 02-08-2016 for tax chapter*/
				   { width: 80, align: 'center' },
				   { width: 80, align: 'center' },
				   { width: 80, align: 'center' },
				   { width: 80, align: 'center' },
				   { width: 80, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 150, align: 'center' },
				   { width: 150, align: 'center' },
				   { width: 150, align: 'center' },
			],
			sort: true
		});
	});
	
	/*getAppDateFormat();*/ /* Comment added by parikshit kumbhar on 09/07/15 */
	
	function setActionVal( value )
	{
	   var maxId = $('#SKUItemId tbody tr').length;
		
		for( dbID = 1; dbID <= maxId; dbID++)
		{
	   		document.getElementById("Detail3."+dbID+".item_barcode").value = "";		
	    }
	    document.getElementById(value).style.pointerEvents = 'none';
	    document.getElementById("action").value = value;
	    
	   document.getElementById(value).style.display = "none";
	   document.getElementById("finish").style.display = "none";
	   document.getElementById("add").style.display = "none";
	   document.getElementById("delete").style.display = "none";
	   
	   document.getElementById("buttonreplacement").style.display = "";
	   document.getElementById("errorActivityTable").style.display = "none";
	}
	
]]>
</script>

<!-- Changed by Sneha on 30-03-2016, to capture maximum rows added [Start] 
<body onload="setItemDescrOnload()">
 Changed by Sneha on 30-03-2016, to capture maximum rows added [End] -->
 
<body onload="getAppDateFormat(); setCustItemRef(); defaultBarcodeFlag();">
<form name="prodWizEditFormIII" id="prodWizEditFormIII" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet"> <!--  -->

<TABLE border="0" width="99%" height="2%" class="header_td header_table" cellpadding="0" cellspacing="0" >
	<TR>
		<div class='contentHeaderLbl'>
		<img src="/ibase/images/menuImages/web/Dailyactivityreport.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px;margin-top:9px; height: 20px; width: 20px;"/>
			<TD class="header_main header_td1" nowrap="true" valign="middle" > 
			      Product Wizard Edit
			</TD>
		</div>
	</TR>
</TABLE>	

<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:99%">
	<table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 0px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
			<xsl:for-each select="//error">
				<xsl:if test="position() = 1">
					<tr>	
						<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
							Message :
						</td> 
						<td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
							Description :
						</td>
						<td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
							<a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
						</td>
					</tr>
				</xsl:if>
				<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
				<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
				<tr style="background: rgba(255, 204, 0, 0.66);">
					 <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
						<xsl:value-of select="message"/>
					</td> 
					
					<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
						<xsl:value-of select="description"/>
					</td>
					
					<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
					</td>
				</tr>
			</xsl:for-each>
			
			<xsl:for-each select="//error">
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:if test="position() = 1">
					<xsl:if test="$type = 'W'">
						<tr style="background: rgba(255, 204, 0, 0.66);">
							<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
								<input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
							</td>
							<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
						</tr>
					</xsl:if>
				</xsl:if>	
			</xsl:for-each>
	</table>
</div>
	
<!-- Changed by Sneha on 30-03-2016, to capture maximum rows added [Start] -->
<input type="hidden" id="rowId" /> 
<input type="hidden" id="maxRowId" />
<!-- Changed by Sneha on 30-03-2016, to capture maximum rows added [End] -->
			
<!-- 	<div class="mainPage-Container" style="height: 100%;">
		<div style="width: 99%; margin-top: 5px;"> -->
		
	<div class="pageContentWrapper" style="height:72%;">
		<div id="headerDiv" >			
			<strong>Product Description : </strong>
		
			<xsl:for-each select="//Detail3">
				<xsl:variable name="login_code"><xsl:value-of select="login_code"/></xsl:variable>
				<xsl:variable name="supp_code"><xsl:value-of select="supp_code"/></xsl:variable>
				<xsl:variable name="supp_descr"><xsl:value-of select="supp_descr"/></xsl:variable>
				<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
		        <xsl:variable name="site_descr"><xsl:value-of select="site_descr"/></xsl:variable>
		        <xsl:variable name="date_format"><xsl:value-of select="date_format"/></xsl:variable><!-- Added by parikshit kumbhar on 08/07/15 [to set date format]-->
		        <xsl:variable name="item_parent"><xsl:value-of select="item_parent"/></xsl:variable> <!-- Changed by Sneha on 28-10-2016, for item parent -->
		        <xsl:variable name="phy_attrib_4"><xsl:value-of select="phy_attrib_4"/></xsl:variable> 
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
	
				<xsl:if test="$dbID = '0'">
					<input type="hidden" name="Detail3.{normalize-space($dbID)}.login_code" id ="Detail3.{normalize-space($dbID)}.login_code" value="{$login_code}" ISCHANGED="false"/>
					<input type="hidden" value="{$supp_code}" name="Detail3.{normalize-space($dbID)}.supp_code" id="Detail3.{normalize-space($dbID)}.supp_code" /> 
					<input type="hidden" value="{$supp_descr}" name="Detail3.{normalize-space($dbID)}.supp_descr" id="Detail3.{normalize-space($dbID)}.supp_descr" />
					<input type="hidden" value="{$site_code}" name="Detail3.{normalize-space($dbID)}.site_code" id="Detail3.{normalize-space($dbID)}.site_code" />
					<input type="hidden" value="{$site_descr}" name="Detail3.{normalize-space($dbID)}.site_descr" id="Detail3.{normalize-space($dbID)}.site_descr" />
					<!-- Added by parikshit kumbhar on 08/07/15 [to set date format] start -->
					<input type="hidden" value="{$date_format}" name="Detail3.{normalize-space($dbID)}.date_format" id="date_format" />
	                <!-- Added by parikshit kumbhar on 08/07/15 [to set date format] end-->
	                
	                <input type="hidden" value="{$item_parent}" name="Detail3.{normalize-space($dbID)}.item_parent" id="Detail3.{normalize-space($dbID)}.item_parent" ISCHANGED="false" readOnly = "1" onkeypress="return disableEnter()" /> <!-- Changed by Sneha on 28-10-2016, for item parent -->
	                <input type="hidden" name="cust_item_ref_status" id="cust_item_ref_status" ISCHANGED="false" readOnly = "1" onkeypress="return disableEnter()"/> <!-- Changed by Sneha on 28-10-2016, for cust_item_ref_status -->
					<input type="hidden" value="{$phy_attrib_4}" name="Detail3.{normalize-space($dbID)}.phy_attrib_4" id="Detail3.{normalize-space($dbID)}.phy_attrib_4" ISCHANGED="false" readOnly = "1" onkeypress="return disableEnter()" /> <!-- Changed by Sneha on 28-10-2016, for item parent --> 
				</xsl:if>
			</xsl:for-each>
 		</div> 
 		
		<!-- <div style="height: 78%; overflow: auto; margin-top: 8px;" id="detail">
		<table id="SKUItemId" cellspacing="0" width="100%"> -->
		
<div  id="detailDiv" style='height:75%; margin-top: 8px;'>
	<div id="detail" >
		<table id="SKUItemId" class="headertableClass" style="border-top-style: none;" width="100%">
		<thead>
			<tr>
				<!-- <th><input type='checkbox' id='Detail3.0.selectbox' onclick='checkAllSKUItem(this)' checked='1'/></th> -->
				<th class = "tHeader">Item&#160;Code</th>
				<!-- <th>Edit&#160;Description</th>	 Changed by Sneha on 01-07-2016, to edit the item description -->
				<th class = "tHeader">Item&#160;Description</th>
				<th class = "tHeader">Customer&#160;Item&#160;Refernces</th>	<!-- Added by Sneha on 24-10-2016 -->
				<th class = "tHeader">Active</th>	<!-- Added by Sneha on 28-10-2016 -->
				<th class = "tHeader">Limited&#160;Edi.</th>
				<th class = "tHeader">Stop&#160;buy</th>
				<th class = "tHeader">Size</th>
				<th class = "tHeader">Colour</th>
				
				<!-- Changed by Sneha on 23-06-2016, for display of Dimension instead of Fitting [Start]  -->
				<!--  <th>Fitting</th> -->
				<th class = "tHeader">Dimension</th> 
				<!-- Changed by Sneha on 23-06-2016, for display of Dimension instead of Fitting [End]  -->
				
				<th class = "tHeader">Category</th>
				<th class = "tHeader">Trade&#160;Mark</th> <!-- Added by Sneha on 26-09-2016 -->
				<th class = "tHeader">Sales&#160;Tax</th>
				<th class = "tHeader">Purchase&#160;Tax</th>
				<th class = "tHeader">Length</th>
				<th class = "tHeader">Width</th>
				<th class = "tHeader">Height</th>
				<th class = "tHeader">Gross&#160;Wt</th>
				<th class = "tHeader">Barcode</th>
				<th class = "tHeader">Commodity&#160;No</th>
				<th class = "tHeader">Location</th>
				<th class = "tHeader">Pack&#160;List</th>
				<th class = "tHeader">Price&#160;List</th>
				<th class = "tHeader">Supplier&#160;Details</th>
				<th class = "tHeader">Language&#160;Details</th>
			</tr>
		</thead>
		
		<tbody class='table-body fadeInDown'>
			<xsl:for-each select="//Detail3">
				<xsl:variable name="item_code"><xsl:value-of select="item_code"/></xsl:variable>
				<xsl:variable name="descr"><xsl:value-of select="descr"/></xsl:variable>
				<!--	<xsl:variable name="editDescr"><xsl:value-of select="editDescr"/></xsl:variable>	 Changed by Sneha on 01-07-2016, to edit the item description -->
				<xsl:variable name="attr_value"><xsl:value-of select="attr_value"/></xsl:variable>
				<xsl:variable name="phy_attrib_1"><xsl:value-of select="phy_attrib_1"/></xsl:variable>
				<xsl:variable name="phy_attrib_2"><xsl:value-of select="phy_attrib_2"/></xsl:variable>
				<xsl:variable name="phy_attrib_3"><xsl:value-of select="phy_attrib_3"/></xsl:variable>
				
				<xsl:variable name="size_code_descr"><xsl:value-of select="size_code_descr"/></xsl:variable>
				<xsl:variable name="color_code_descr"><xsl:value-of select="color_code_descr"/></xsl:variable>
				<xsl:variable name="dimension_code_descr"><xsl:value-of select="dimension_code_descr"/></xsl:variable>
				
				<xsl:variable name="item_category"><xsl:value-of select="item_category"/></xsl:variable>
				<xsl:variable name="item_category_descr"><xsl:value-of select="item_category_descr"/></xsl:variable>
				<xsl:variable name="length"><xsl:value-of select="length"/></xsl:variable>
				<xsl:variable name="width"><xsl:value-of select="width"/></xsl:variable>
				<xsl:variable name="height"><xsl:value-of select="height"/></xsl:variable>
				<xsl:variable name="gross_weight"><xsl:value-of select="gross_weight"/></xsl:variable>
				<xsl:variable name="item_barcode"><xsl:value-of select="item_barcode"/></xsl:variable>
				<xsl:variable name="item_commodity"><xsl:value-of select="item_commodity"/></xsl:variable>
				<xsl:variable name="price_list_dtl"><xsl:value-of select="price_list_dtl"/></xsl:variable>
				<xsl:variable name="supp_item_dtl"><xsl:value-of select="supp_item_dtl"/></xsl:variable>
				<xsl:variable name="loc_code"><xsl:value-of select="loc_code"/></xsl:variable>
				<xsl:variable name="loc_type"><xsl:value-of select="loc_type"/></xsl:variable>
				
				<xsl:variable name="dbIDs"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
				<xsl:variable name="language_dtl"><xsl:value-of select="language_dtl"/></xsl:variable>	
				<xsl:variable name="pack_size_descr"><xsl:value-of select="pack_size_descr"/></xsl:variable>
           		<xsl:variable name="shipper_size"><xsl:value-of select="shipper_size"/></xsl:variable>
		        <xsl:variable name="case_length"><xsl:value-of select="case_length"/></xsl:variable>
				<xsl:variable name="case_width"><xsl:value-of select="case_width"/></xsl:variable>
				<xsl:variable name="size_height"><xsl:value-of select="size_height"/></xsl:variable>
				<xsl:variable name="case_gross_weight"><xsl:value-of select="case_gross_weight"/></xsl:variable>
				<xsl:variable name="case_net_weight"><xsl:value-of select="case_net_weight"/></xsl:variable>
				<xsl:variable name="tax"><xsl:value-of select="tax"/></xsl:variable>
				<xsl:variable name="tax_descr"><xsl:value-of select="tax_descr"/></xsl:variable>
				<xsl:variable name="language"><xsl:value-of select="language"/></xsl:variable>
				<xsl:variable name="language_desc"><xsl:value-of select="language_desc"/></xsl:variable>
				<xsl:variable name="language_dtl"><xsl:value-of select="language_dtl"/></xsl:variable>
				
				<!--added by samadhan on 23/12/2015 for brand,limited edition and stop purchase start-->
				<xsl:variable name="usage_type"><xsl:value-of select="usage_type"/></xsl:variable> <!--limited edition-->
				<xsl:variable name="catalog_no"><xsl:value-of select="catalog_no"/></xsl:variable> <!--Stop purchase-->
				<!--added by samadhan on 23/12/2015 for brand,limited edition and stop purchase end-->
				
				<!--Changed by wasim on 02-08-2016 for tax chapter [START]-->
				<xsl:variable name="tax_chap"><xsl:value-of select="tax_chap"/></xsl:variable>
				<!--Changed by wasim on 02-08-2016 for tax chapter [END]-->
				
				<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [Start] -->
				<xsl:variable name="trade_mark"><xsl:value-of select="trade_mark"/></xsl:variable>
				<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [End] -->
				
				<xsl:variable name="phy_attrib_4"><xsl:value-of select="phy_attrib_4"/></xsl:variable><!-- Changed by Sneha on 28-10-2016, to add new cust item ref -->
				<xsl:variable name="active"><xsl:value-of select="active"/></xsl:variable><!-- Changed by Sneha on 28-10-2016, to add new cust item ref -->
			
				<xsl:if test="$dbIDs > '0'">
				
				<!-- Changed by Sneha on 30-03-2016, maximum no of rows [Start] -->
				<SCRIPT>
					<![CDATA[ var qtyR; qtyR ="]]>	<xsl:value-of select="$dbIDs"/>
					<![CDATA[";maxId= qtyR; ]]>
				</SCRIPT>
				<!-- Changed by Sneha on 30-03-2016, maximum no of rows [End] -->
				
				<tr>
					<td class = "td_leftAlign">
						<xsl:choose>
							<xsl:when test="$chkbox ='Y'">
								<input type="checkbox" name="Detail3.{normalize-space($dbIDs)}.selectbox" id="Detail3.{normalize-space($dbIDs)}.selectbox" 
										checked='true' value="true" onClick="setChecked(this)" style="visibility: hidden; width: 0px;"/>
							</xsl:when>	
							<xsl:otherwise>
								<input type="checkbox" name="Detail3.{normalize-space($dbIDs)}.selectbox" id="Detail3.{normalize-space($dbIDs)}.selectbox" 
										value="false" onClick="setChecked(this)" style="visibility: hidden; width: 0px;"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:value-of select="item_code"/>
					</td>
					
					<!-- Changed by Sneha on 01-07-2016, to edit the item description [Start] 
					<td>
							<div id="Detail3.{normalize-space($dbIDs)}.editDescr"></div>
					</td>
					 Changed by Sneha on 01-07-2016, to edit the item description [End] -->
					<td class = "td_leftAlign">
						<input type="text" class="input_editable" value="{$descr}" name="Detail3.{normalize-space($dbIDs)}.descr" 
							id="Detail3.{normalize-space($dbIDs)}.descr" maxlength="90" style="width: 100%;"  ISCHANGED='false' readOnly = '1' 
							onkeypress="return disableEnter()"/>
							
							<!-- <xsl:value-of select="descr"/> -->
						<input type="hidden" class="input_editable" value="{$item_code}" name="Detail3.{normalize-space($dbIDs)}.item_code" 
							id="Detail3.{normalize-space($dbIDs)}.item_code" maxlength="10" style="width: 100%"/>
							
						<input type="hidden" class="input_editable" value="{$attr_value}" name="Detail3.{normalize-space($dbIDs)}.attr_value" 
							id="Detail3.{normalize-space($dbIDs)}.attr_value" maxlength="90" style="width: 100%;"  ISCHANGED='false' readOnly = '1' />
					</td>
					
					<td>
						<input type="text" class="input_editable" value="{$phy_attrib_4}" name="Detail3.{normalize-space($dbIDs)}.phy_attrib_4" 
							id="Detail3.{normalize-space($dbIDs)}.phy_attrib_4" maxlength="30" style="width: 100%;"  onkeypress="return disableEnter()"/>
					</td>
					
					<!-- Changed by Sneha on 28-10-2016, for item active and in-active [Start] -->
					<td>
						<select name="Detail3.{normalize-space($dbIDs)}.active" id="active">
							<xsl:choose>
								<xsl:when test="$active ='Y'">
									<option value="Y" selected="selected" >Yes</option>
								</xsl:when>	
								<xsl:otherwise>
									<option value="Y" >Yes</option>
								</xsl:otherwise>
							</xsl:choose>	
							<xsl:choose>
								<xsl:when test="$active ='N'">
									<option value="N" selected="selected" >No</option>
								</xsl:when>	
								<xsl:otherwise>
									<option value="N" >No</option>
								</xsl:otherwise>
							</xsl:choose>	
						</select>
					</td>	
					<!-- Changed by Sneha on 28-10-2016, for item active and in-active [End] -->
					
					
					<!-- Added By Samadhan on 21/12/2015 for Limited Edition Start -->
					<td>
						<select name="Detail3.{normalize-space($dbIDs)}.usage_type" id="usage_type"    >
			
							<xsl:choose>
								<xsl:when test="$usage_type ='N'">
									<option value="N" selected="selected" >No    </option>
								</xsl:when>	
								<xsl:otherwise>
									<option value="N" >No   </option>
								</xsl:otherwise>
							</xsl:choose>	
							<xsl:choose>
								<xsl:when test="$usage_type ='Y'">
									<option value="Y" selected="selected" >Yes    </option>
								</xsl:when>	
								<xsl:otherwise>
									<option value="Y" >Yes    </option>
								</xsl:otherwise>
							</xsl:choose>	
					
						</select>
					</td>	
					
					<td>
						<select name="Detail3.{normalize-space($dbIDs)}.catalog_no" id="catalog_no">
							<xsl:choose>
								<xsl:when test="$catalog_no ='N'">
									<option value="N" selected="selected" >No   </option>
								</xsl:when>	
								<xsl:otherwise>
									<option value="N" >No  </option>
								</xsl:otherwise>
							</xsl:choose>	
							<xsl:choose>
								<xsl:when test="$catalog_no ='Y'">
									<option value="Y" selected="selected" >Yes    </option>
								</xsl:when>	
								<xsl:otherwise>
									<option value="Y" >Yes  </option>
								</xsl:otherwise>
							</xsl:choose>	
					
						</select>
					</td>	
				<!-- Added By Samadhan on 21/12/2015 for Limited Edition End -->
					<td>
						<input type="hidden" class="input_editable" value="{$phy_attrib_1}" name="Detail3.{normalize-space($dbIDs)}.phy_attrib_1" 
							id="Detail3.{normalize-space($dbIDs)}.phy_attrib_1" maxlength="10"/>
							
							<!--Added by Parikshit Kumbhar on 19/05/2015 [to set hidden field]  -->
						<input type="hidden" class="input_editable" value="{$size_code_descr}" name="Detail3.{normalize-space($dbIDs)}.size_code_descr" 
							id="Detail3.{normalize-space($dbIDs)}.size_code_descr" maxlength="10"/>

						<xsl:value-of select="size_code_descr"/>
					</td>
					
					<td>
						<input type="hidden" class="input_editable" value="{$phy_attrib_2}" name="Detail3.{normalize-space($dbIDs)}.phy_attrib_2" 
							id="Detail3.{normalize-space($dbIDs)}.phy_attrib_2" maxlength="10"/>
							
						<input type="hidden" class="input_editable" value="{$color_code_descr}" name="Detail3.{normalize-space($dbIDs)}.color_code_descr" 
							id="Detail3.{normalize-space($dbIDs)}.color_code_descr" maxlength="10"/>
						
						<xsl:value-of select="color_code_descr"/>
					</td>
					
					<td>
						<input type="hidden" class="input_editable" value="{$phy_attrib_3}" name="Detail3.{normalize-space($dbIDs)}.phy_attrib_3" 
							id="Detail3.{normalize-space($dbIDs)}.phy_attrib_3" maxlength="10"/>
							
						<input type="hidden" class="input_editable" value="{$dimension_code_descr}" name="Detail3.{normalize-space($dbIDs)}.dimension_code_descr" 
							id="Detail3.{normalize-space($dbIDs)}.dimension_code_descr" maxlength="10"/>
							
						<xsl:value-of select="dimension_code_descr"/>
					</td>
					
					<td>
						<input type="hidden" value="{$item_category}" name="Detail3.{normalize-space($dbIDs)}.item_category" 
							id="Detail3.{normalize-space($dbIDs)}.item_category" maxlength="10"/>
							
						<input type="hidden" value="{$item_category_descr}" name="Detail3.{normalize-space($dbIDs)}.item_category_descr" 
							id="Detail3.{normalize-space($dbIDs)}.item_category_descr" maxlength="10"/>
						  
						<div style="float:left;" id="item_category.{normalize-space($dbIDs)}" contenteditable="true" onkeypress="return false;"
						 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','item_categoryII', 'Category', '{normalize-space($dbIDs)}');">
							<xsl:value-of select="item_category"/>
						</div>
						
						<div class = "imgClass2">
							<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','item_categoryII', 'Category', '{normalize-space($dbIDs)}');" >
								<img src="/ibase/webitm/images/pophelp.png"   title="Select Product Category" />
							</a>
						</div>
					</td>

					<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [Start] -->
					<td>							
						<input type="hidden" value="{$trade_mark}" name="Detail3.{normalize-space($dbIDs)}.trade_mark" id="Detail3.{normalize-space($dbIDs)}.trade_mark" maxlength="25"/>
							
						<div style="float:left;" id="trade_mark.{normalize-space($dbIDs)}"  onkeypress="return false;"
						 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','trade_mark', 'Trade Mark', '{normalize-space($dbIDs)}');">
							<xsl:value-of select="trade_mark"/>
						</div>
						
						<div class = "imgClass2">
							<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','trade_mark', 'Trade Mark', '{normalize-space($dbIDs)}');" 
								id="Detail3.{normalize-space($dbIDs)}.trade_mark_pophelp" >
								<img src="/ibase/webitm/images/pophelp.png"  title="Select Trade Mark" />
							</a>
						</div>
					</td>
					<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [End] -->
					
					<td>
						<input type="hidden" value="{$tax}" name="Detail3.{normalize-space($dbIDs)}.tax" id="Detail3.{normalize-space($dbIDs)}.tax"/>
						<input type="hidden" value="{$tax_descr}" name="Detail3.{normalize-space($dbIDs)}.tax_descr" id="Detail3.{normalize-space($dbIDs)}.tax_descr" maxlength="10"/>	.
							
						<div style="float:left;" id="tax.{normalize-space($dbIDs)}" contenteditable="true" onkeypress="return false;"
						 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','tax_desc', 'Sales Tax', '{normalize-space($dbIDs)}');">
							<xsl:value-of select="tax_descr"/>
						</div>

						<div class = "imgClass2">
							<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','tax_desc', 'Sales Tax', '{normalize-space($dbIDs)}');">
								<img src="/ibase/webitm/images/pophelp.png"   title="Select Sales Tax" />
							</a>
						</div>
					</td>
					
					<!-- Changed by wasim on 02-08-2016 for tax chapter [START] -->
					<td>
						<input type="hidden" value="{$tax_chap}" name="Detail3.{normalize-space($dbIDs)}.tax_chap" id="Detail3.{normalize-space($dbIDs)}.tax_chap" maxlength="10"/>
							
						<div style="float:left;" id="tax_chap.{normalize-space($dbIDs)}" contenteditable="true" onkeypress="return false;"
						 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','tax_chapII', 'Purchase Tax', '{normalize-space($dbIDs)}');">
							<xsl:value-of select="tax_chap"/>
						</div>
						
						<div class = "imgClass2">
							<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','tax_chapII', 'Purchase Tax', '{normalize-space($dbIDs)}');" 
							 id="Detail3.{normalize-space($dbIDs)}.tax_chap_pophelp" >
								<img src="/ibase/webitm/images/pophelp.png"  style="margin-left: -5px;" title="Select Purchase Tax" />
							</a>
						</div>
					</td>
					<!-- Changed by wasim on 02-08-2016 for tax chapter [START] -->
					
					<td >
						<input type="text" class="editInputClass" value="{$length}" name="Detail3.{normalize-space($dbIDs)}.length" 
							id="Detail3.{normalize-space($dbIDs)}.length" maxlength="11" style='text-align: right; width: 100%' 
							onchange='return isNumeric(this)' onkeypress="return disableEnter()"/>
					</td>
					<td >
						<input type="text" class="editInputClass" value="{$width}" name="Detail3.{normalize-space($dbIDs)}.width" 
							id="Detail3.{normalize-space($dbIDs)}.width" maxlength="11" style='text-align: right; width: 100%' 
							onchange='return isNumeric(this)' onkeypress="return disableEnter()"/>
					</td>
					<td >
						<input type="text" class="editInputClass" value="{$height}" name="Detail3.{normalize-space($dbIDs)}.height" 
							id="Detail3.{normalize-space($dbIDs)}.height" maxlength="11" style='text-align: right; width: 100%' 
							onchange='return isNumeric(this)' onkeypress="return disableEnter()"/>
					</td>
					<td >
						<input type="text" class="editInputClass" value="{$gross_weight}" name="Detail3.{normalize-space($dbIDs)}.gross_weight" 
							id="Detail3.{normalize-space($dbIDs)}.gross_weight" maxlength="11" style='text-align: right; width: 100%' 
							onchange='return isNumeric(this)' onkeypress="return disableEnter()"/>
					</td>
					<td >
						<input type="text" class="editInputClass" size="13" value="{$item_barcode}" name="Detail3.{normalize-space($dbIDs)}.item_barcode" 
							id="Detail3.{normalize-space($dbIDs)}.item_barcode" maxlength="20" style='width: 100%' onkeypress="return disableEnter()" 
							onkeyup = "return specialCharValidate(this.id);" />
					</td>
					
					<td >
						<input type="text" class="editInputClass" size="13" value="{$item_commodity}" name="Detail3.{normalize-space($dbIDs)}.item_commodity" 
							id="Detail3.{normalize-space($dbIDs)}.item_commodity" maxlength="20" style='width: 100%' onkeypress="return disableEnter()" 
							onkeyup = "return specialCharValidate(this.id);" />
					</td>
					
					<td>
						<input type="hidden" value="{$loc_code}" name="Detail3.{normalize-space($dbIDs)}.loc_code" 
							id="Detail3.{normalize-space($dbIDs)}.loc_code" maxlength="10"/>
							
						<input type="hidden" value="{$loc_type}" name="Detail3.{normalize-space($dbIDs)}.loc_type" 
							id="Detail3.{normalize-space($dbIDs)}.loc_type" maxlength="10"/>
								
						<div style="float:left;" id="loc_code.{normalize-space($dbIDs)}" contenteditable="true" onkeypress="return false;"
						 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','loc_codeII', 'Location Code', '{normalize-space($dbIDs)}');">
							<xsl:value-of select="loc_code"/>
						</div>
						
						<div class = "imgClass2">
							<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','loc_codeII', 'Location Code', '{normalize-space($dbIDs)}');" >
								<img src="/ibase/webitm/images/pophelp.png"   title="Select Location Code" />
							</a>
						</div>
					</td>

					<td class = "td_leftAlign">
						<input type="hidden" class="input_editable" value="{$pack_size_descr}" name="Detail3.{normalize-space($dbIDs)}.pack_size_descr" 
							id="Detail3.{normalize-space($dbIDs)}.pack_size_descr" />
						
						<a href="#" id="Detail3.{normalize-space($dbIDs)}.packListLink" onclick="openPopup(event, this.id, 'pack');" style="color: black">Click&#160;for&#160;Pack&#160;Details</a>
					</td>
					
					<td class = "td_leftAlign">
						<input type="hidden" class="input_editable" value="{$price_list_dtl}" name="Detail3.{normalize-space($dbIDs)}.price_list_dtl" 
							id="Detail3.{normalize-space($dbIDs)}.price_list_dtl" />
						
						<a href="#" id="Detail3.{normalize-space($dbIDs)}.prodPriceLink" onclick="openPopup(event, this.id, 'price');" style="color: black">Click&#160;for&#160;PriceList</a>
					</td>
					
					<td class = "td_leftAlign">
						<input type="hidden" class="input_editable" value="{$supp_item_dtl}" name="Detail3.{normalize-space($dbIDs)}.supp_item_dtl" 
							id="Detail3.{normalize-space($dbIDs)}.supp_item_dtl" />
						
						<a href="#" id="Detail3.{normalize-space($dbIDs)}.suppListLink" onclick="openPopup(event, this.id, 'supp');" style="color: black">Click&#160;for&#160;Supplier&#160;Details</a>
					</td>
					
					<td class = "td_leftAlign">
						<input type="hidden" class="input_editable" value="{$language_dtl}" name="Detail3.{normalize-space($dbIDs)}.language_dtl" 
							id="Detail3.{normalize-space($dbIDs)}.language_dtl" />
						
						<a href="#" id="Detail3.{normalize-space($dbIDs)}.language_dtl" onclick="openPopup(event, this.id, 'lang');" style="color: black">Click&#160;for&#160;Language&#160;Details</a>
						
						<input type="hidden" class="input_editable" value="{$language}" name="Detail3.{normalize-space($dbIDs)}.language" 
							id="Detail3.{normalize-space($dbIDs)}.language" />
													
						<input type="hidden" class="input_editable" value="{$language_desc}" name="Detail3.{normalize-space($dbIDs)}.language_desc" 
							id="Detail3.{normalize-space($dbIDs)}.language_desc" />
					</td>
				</tr>
				</xsl:if>
			</xsl:for-each>
		</tbody>
		</table>
	</div>
	
<!-- 	<div style="overflow: auto; height: 260px;"> 
	<table id="SKUPackListId" style="text-align: center; width: 550px; margin: 0 auto;">
		<caption id="SKUPackListCaption" class="captionClass">Pack Size Details</caption>
		-->
	<div id="packListDiv" class = "hidden body_table_div"> 
		<table id="SKUPackListId" class="headertableClass">
		<caption id="SKUPackListCaption" style = "margin-bottom:5px;">Pack Size Details</caption>
			<tbody>
			<tr>
			    <td class="td_leftAlign">Shipper/pack size:</td>
			    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="s_size" value ="" maxlength="11" /></td>	
			   
			    <td class="td_leftAlign">Case Length :</td>
			    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_length" value ="" maxlength="11" /></td>	
			</tr>
			    
			<tr>
			    <td class="td_leftAlign">Case Width:</td>
			    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_width" value ="" maxlength="11" /></td>	
			   
			    <td class="td_leftAlign">Case Height :</td>
			    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_height" value ="" maxlength="11" /></td>
			</tr>
			
			<tr>
			    <td class="td_leftAlign">Case Gross Weight:</td>
			    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_g_weight" value ="" maxlength="11" /></td>	
			    
			    <td class="td_leftAlign">Case Net Weight:</td>
			    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_n_weight" value ="" maxlength="11" /></td>
			</tr>
			</tbody>
		</table>
		<br/><input type="hidden" id="idNumPack"/>
	
		<div align = "right">
			<input type="button" style="cursor:hand" class="button" value="Ok" title='Ok' onclick="javascript:setPackDtls()"/>
			<input type="submit" style="cursor:hand" class="button" value="Cancel" title='Cancel' onclick="javascript:closePopup()"/>
		</div><br/>
	</div>


	
<!-- 	<div id="priceListDiv">
		<div style="overflow: auto; height: 260px;">
		<table class='tableClass' id="SKUPriceListId" style="text-align: center; width: 550px; margin: 0 auto;"> -->
		
	<div id="priceListDiv" class = "hidden body_table_div" >
		<table id="SKUPriceListId" class="headertableClass" style = "width:700px;">
			<caption id="SKUPriceListCaption" style = "margin-bottom:5px;">table</caption>
			<thead>
				<tr class='thClass'>
					<th class = "tHeader"  width='10px;'><input type="checkbox" id="chkAllPrices" name="chkAllPrices" onclick="checkAll(this)" /></th>
					<th class = "tHeader"  width='150px;'>Sites</th>
					<th class = "tHeader" width='150px;'>PriceList</th>
					<th class = "tHeader" width='50px;'>Currency</th>
					<th class = "tHeader" width='70px;'>Special&#160;Rate</th>
					<!-- <th width='50px;'>Cost</th> -->
					<th class = "tHeader" width='100px;'>Date&#160;From</th>
					<th class = "tHeader" width='100px;'>Date&#160;To</th>
				</tr>
			</thead>
			<tbody class='table-body'></tbody>
		</table>
		
		<br/><input type="hidden" id="idNumP"/>
		<div align = "right">
			<input type="button" style="cursor:hand" class="button" value="Ok" title='' onclick="javascript:setPrice()"/>
			<input type="submit" style="cursor:hand" class="button" value="Cancel" title='' onclick="javascript:closePopup()"/>
		</div><br/>
	</div>

	<!-- <div id="suppListDiv">
		<div style="overflow: auto; height: 260px;">
		<table class='tableClass' id="SKUSuppListId" style="text-align: center; width: 550px; margin: 0 auto;"> -->
		
	<div id="suppListDiv" class = "hidden body_table_div">
		<table id="SKUSuppListId" class="headertableClass"  style = "width:750px;">
			<caption id="SKUSuppListCaption" style = "margin-bottom:5px;">table</caption>
			<thead>
				<tr class='thClass'>
					<th class = "tHeader" width='10px;'><input type="checkbox" id="chkAllSupplier" disabled = 'true' name="chkAllSupplier" onclick="checkAll(this)" /></th>
					<th class = "tHeader" width='200px;'>Supplier</th>
					<th class = "tHeader" width='150px;'>PriceList</th>
					<th class = "tHeader" width='50px;'>Currency</th>
					<th class = "tHeader" width='50px;'>Cost</th>
					<th class = "tHeader" width='100px;'>Date&#160;From</th>
					<th class = "tHeader" width='100px;'>Date&#160;To</th>
				</tr>
			</thead>
			<tbody class='table-body'></tbody>
		</table>
		
		<br/><input type="hidden" id="idNumS"/>
		
		<div align = "right">
			<input type="button" style="cursor:hand" class="button" value="Ok" title='Ok' onclick="javascript:setSuppDtls()"/>
			<input type="submit" style="cursor:hand" class="button" value="Cancel" title='Cancel' onclick="javascript:closePopup()"/>
		</div><br/>
	</div>

	<!-- <div id="langListDiv">
		<div style="overflow: auto; height: 260px;">
		<table class='tableClass' id="SKULangListId" style="text-align: center; width: 550px; margin: 0 auto;">
			<caption id="SKULangListCaption" class="captionClass">Language Detail</caption> -->
			
	<div id="langListDiv" class = "hidden body_table_div">
		<table id="SKULangListId" class="headertableClass" style = "width:550px;">
			<caption id="SKULangListCaption" style = "margin-bottom:5px;">Language Detail</caption>
			<thead>
				<tr class='thClass'>
					<th class = "tHeader" width='100px'>Language&#160;Code</th>
					<th class = "tHeader" width='400px'>Item&#160;Descr</th>
				</tr>
			</thead>
			<tbody class='table-body'></tbody>
		</table>
				
		<input type="hidden" id="idNumL"/>
		
		<div align = "right" style="margin-top:10px;">
			<input type="button" style="cursor:hand" class="button" value="Ok" title='Ok' onclick="javascript:setLangDtls()"/>
			<input type="submit" style="cursor:hand" class="button" value="Cancel" title='Cancel' onclick="javascript:closePopup()"/>
		</div><br/>
	</div>
	
	<table width="100%">
		<tr>
			<td colspan="2">
				<input type="hidden" value="3" name="FORM_NO" ID="FORM_NO" />
				<input type="hidden"  value="dd_productWizEdit" name="OBJ_NAME" />
				<input type="hidden"  value="" name="action" id="action" />
				<input type="hidden" value="2:MP" name="formType" id="formType" />
				<input type="hidden" value="" name="PRE_FORM_VAL" ID="PRE_FORM_VAL" />
				
				<div id="buttonreplacement" align="center" style="display:none;">
					<img src="/ibase/images/preload.gif" alt="Please wait work in progress" >
						 Please wait......
					</img>	
				</div>
	
				<input type="submit" style="cursor:hand" class="button" value="Previous" title='Previous' id="previous" onclick="javascript:setActionVal('previous');"/>
				<!-- <input type="submit" style="cursor:hand" class="button" value="Previous" title='Previous' onclick="javascript:setActionVal('previous');"/> -->
				<input type="submit" style="cursor:hand" class="button" value="Finish" title='Finish' id="finish" onclick="javascript:return checkSKUValidation('finish');"/> 
				
				<!-- Changed by Sneha on 30-03-2016, to add new row and delete the row [Start] -->
				<input type="button" style="cursor:hand; float:right; margin-right: 15px;" class="button" value="Delete" title='Delete' id="delete" onclick="javascript:deleteItem(maxRowId)"/>
				<input type="button" style="cursor:hand; float:right;" class="button" value="Add" title='Add' id="add" onclick="javascript:return checkSKUValidation('add');"/>
				<!-- Changed by Sneha on 30-03-2016, to add new row and delete the row [End] javascript:addItem()-->	
			</td>
        </tr>
	</table>
		
	</div>
</div>

</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>
