/**
 *  Purpose:Create new   master SUPPLY SITES PREF for Dadra 2 , Request ID:  W15FSUN007
 *  Author: Jagruti Shinde
 *  Date: 23-09-2015
 */


package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class ReplsiteprefIC extends ValidatorEJB implements ReplsiteprefICLocal, ReplsiteprefICRemote 
{
	/**
	 * The method is defined without any parameter and returns blank string
	 */	
	@Override

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, xtraParams,editFlag);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String xtraParams,String editFlag) throws RemoteException, ITMException
	{   				

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "", docLocCode = "" ,statusPkord= "", locCode = "";
		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String>errFields = new ArrayList <String> ();
		E12GenericUtility genericUtility;
		String transTran = "",type = "", tranType = "",remarks="",addUser="",addTerm="",addDate="",chgUser="",chgTerm="",chgDate="",prefOrder="",descr="";
		HashMap itmVolumeMap = new HashMap();
		ResultSet rs= null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		String siteCode = "",userId = "",childNodeName = "",errString = "",siteCodeSupp = "";

		int ctr = 0, currentFormNo = 0, childNodeListLength = 0, siteCount = 0, siteSuppCount = 0, cnt = 0;
		double quantity = 0;
		try
		{	
			genericUtility = new E12GenericUtility();			
			System.out.println("xtraParam----->>["+xtraParams+"]");
			System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
			System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
			System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	

			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[ENd]
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}	


			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
				System.out.println("------in detail1 validation----------------");
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName11------->>["+childNodeName+"]");

					if("site_code".equalsIgnoreCase(childNodeName))
					{

						siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code",dom));						
						System.out.println("siteCode ---------->>["+siteCode+"]");	
						if(siteCode.length() == 0)
						{
							errCode = "VMSITECNUL";//Site code cannot be blank
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							if(! "E".equalsIgnoreCase(editFlag))
							{
								siteCount = getDBRowCount(conn, "site", "site_code", siteCode);

								if(siteCount == 0)
								{
									errCode = "VMSITESEXT";//Entered site code not present in site master.
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
								}
							}	
						}					

					}
					if("site_code__supp".equalsIgnoreCase(childNodeName))
					{

						siteCodeSupp = checkNullAndTrim(genericUtility.getColumnValue("site_code__supp",dom));
						System.out.println("siteCodeSupp ---------->>["+siteCodeSupp+"]");	

						if(siteCodeSupp.length() == 0)
						{
							errCode = "VMSITESNUL";//Please enter site code supp
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else 
						{
							if(! "E".equalsIgnoreCase(editFlag))
							{
								siteSuppCount = getDBRowCount(conn, "site", "site_code", siteCodeSupp);

								if(siteSuppCount == 0)
								{
									errCode = "VMSITECEXT";//Entered site code supp. not present in site master.
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
								}
								else
								{
									siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code",dom));
									siteCodeSupp = checkNullAndTrim(genericUtility.getColumnValue("site_code__supp",dom));
									String sql = "SELECT COUNT(*) AS COUNT FROM SITE_REPL_PREF WHERE SITE_CODE = ? AND SITE_CODE__SUPP = ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, siteCode);
									pstmt.setString(2, siteCodeSupp);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										cnt = rs.getInt("COUNT");
									}							
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									if(cnt != 0)
									{
										errList.add( "VMPRIMAREX" );//Entered site code and site_code_supp are present in site_repl_pref.
										errFields.add( childNodeName.toLowerCase() );
									}	
								}
							}
						}	

					}
					if("trans_tran".equalsIgnoreCase(childNodeName))
					{

						transTran = checkNullAndTrim(genericUtility.getColumnValue("trans_tran",dom));
						System.out.println("TRANS_TRAN ---------->>["+transTran+"]");	

						if(transTran.length() == 0)
						{
							errCode = "VMTRANTYNL";//Please enter trans tran
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							transTran = checkNullAndTrim(genericUtility.getColumnValue("trans_tran",dom));
							if(! ("P".equalsIgnoreCase(transTran)))
							{
								if(! ("D".equalsIgnoreCase(transTran)))
								{
									errCode = "VMTRANSTRN";//Please enter trans tran 
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
								}
							}

						}


					}
					if("tran_type".equalsIgnoreCase(childNodeName))
					{
						tranType = checkNullAndTrim(genericUtility.getColumnValue("tran_type",dom));
						transTran = checkNullAndTrim(genericUtility.getColumnValue("trans_tran",dom));

						System.out.println("transTran@@[" + transTran+"]" );
						System.out.println("tranType@@[" + tranType+"]" );

						if("tran_type".equalsIgnoreCase(childNodeName))
						{
							if(tranType.length()==0)
							{
								errCode = "VMTRANTPNL";//tran_type cannot be blank
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );

							}

							else
							{
								int trantCount = getDBRowCount(conn, "sordertype", "order_type", tranType);
								int transCount = getDBRowCount(conn, "distorder_type", "tran_type", tranType);
								
							if(trantCount==0 && transCount==0)
							{
								errCode = "VMTRANTYPD";//tran_type cannot be blank
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );

							}
								
								




							}
						}
					}
					if(childNodeName.equalsIgnoreCase("pref_order") )
					{
						prefOrder = checkNull(genericUtility.getColumnValue("pref_order",dom));
						System.out.println("Supplysites_codechildNodeName.pref_Order." + prefOrder + "");
						if (prefOrder.length() == 0 )
						{
							errCode = "VMPREORNUL";	//Preference Order cannot be blank
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );

						}
					}
				}
				break;		
			}//End of switch statement
			int errListSize = errList.size();
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);

					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );

					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: ReplsiteprefIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			//throw new ITMException(e);
			e.printStackTrace();			
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : ReplsiteprefIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}


	/**
	 * The public method is defined without any parameters and returns blank string
	 */
	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(dom)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :ReplsiteprefIC :itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from ReplsiteprefIC itemChanged \n[" + errString + "]" );

		return errString;
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 */
	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		Connection conn = null;

		StringBuffer valueXmlString;		
		String loginSite = "",loginEmpCode = "",chgUser = "" , chgTerm = "",siteDescr = "", siteCodeSupp = "" ,tranDate = "";
		String siteCode = "";
		int currentFormNo = 0;
		System.out.println("xtraParams=["+xtraParams+"]");
		E12GenericUtility genericUtility = new E12GenericUtility();		

		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );

		try
		{			
			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));			
			loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));	
			chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));

			System.out.println("loginEmpCode---->>["+loginEmpCode+"] chgUser---->>["+chgUser+"]");	
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormatObj.format(currentDate.getTime());
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB( "DriverITM" );	
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString.append("</editFlag>\r\n</Header>\r\n");
			switch ( currentFormNo )  
			{
			case 1:
			{
				valueXmlString.append( "<Detail1>\r\n" );
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("loginSite : ["+loginSite+"]");
					siteDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "site", "site_code", loginSite));
					valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
					valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );					
				}
				else if( currentColumn.trim().equalsIgnoreCase( "site_code" ) )
				{
					siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code",currFormDataDom));
					System.out.println("siteCode : ["+siteCode+"]");
					if(siteCode.length()  > 0)
					{
						siteDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "site", "site_code", siteCode));												
						valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
					}
					else
					{												
						valueXmlString.append( "<site_descr><![CDATA[" ).append( "" ).append( "]]></site_descr>\r\n" );
					}

				}
				else if( currentColumn.trim().equalsIgnoreCase( "site_code__supp" ) )
				{
					siteCodeSupp = checkNullAndTrim(genericUtility.getColumnValue("site_code__supp",currFormDataDom));	
					System.out.println("siteCodeSupp : ["+siteCodeSupp+"]");
					if(siteCodeSupp.length()  > 0)
					{
						siteDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "site", "site_code", siteCodeSupp));
						valueXmlString.append( "<descr_1><![CDATA[" ).append( siteDescr ).append( "]]></descr_1>\r\n" );
					}
					else
					{
						valueXmlString.append( "<descr_1><![CDATA[" ).append( "" ).append( "]]></descr_1>\r\n" );	
					}
				}
				valueXmlString.append( "<add_date><![CDATA[" ).append( tranDate ).append( "]]></add_date>\r\n" );
				valueXmlString.append( "<add_user><![CDATA[" ).append( chgUser ).append( "]]></add_user>\r\n" );
				valueXmlString.append( "<add_term><![CDATA[" ).append( chgTerm ).append( "]]></add_term>\r\n" );

				valueXmlString.append("</Detail1>\r\n");
			} //Case 1. End
			break;



			}//End of switch block
			valueXmlString.append( "</Root>\r\n" );	 
		}
		catch (Exception e)
		{				
			e.printStackTrace();			

		}
		finally
		{	
			try
			{				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string.  
	 * @param input
	 */
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}


	private int getDBRowCount(Connection conn, String table_name, String whrCondCol, String whrCondVal)
	{
		int count=0;				
		ResultSet rs=null;
		PreparedStatement pstmt = null;

		String sql="select count(*) from "+table_name+" where "+whrCondCol+" = ?";
		System.out.println("SQL in getDBRowCount method : "+sql);
		try
		{
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,whrCondVal);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
		}

		catch(Exception ex){
			System.out.println("Exception In getDBRowCount method of ReplsiteprefIC Class : "+ex.getMessage());
			ex.printStackTrace();
		}
		System.out.println("Return count from getDBRowCount ----->>["+count+"]");					
		return count;
	}

	private String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) throws Exception
	{

		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in getColumnDescr ");
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;

	}




}
