package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.GSTR3B;

public class GSTR3BSerailizer extends JsonSerializer<GSTR3B> 
{
    @Override
    public void serialize(GSTR3B gstr3b, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
    {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("gstin", gstr3b.gstin);
        jsonGenerator.writeStringField("fp", gstr3b.financialPeriod);
        if(gstr3b.supplyDetails != null)
        {
        	jsonGenerator.writeObjectField("sup_details", gstr3b.supplyDetails);
        } 
        if(gstr3b.interStateSupplies != null)
        {
        	jsonGenerator.writeObjectField("inter_sup", gstr3b.interStateSupplies);
        }
        if(gstr3b.itcEligibility != null)
        {
        	jsonGenerator.writeObjectField("itc_elg", gstr3b.itcEligibility);
        }
        if(gstr3b.inwardSupplies != null)
        {
        	jsonGenerator.writeObjectField("inward_sup", gstr3b.inwardSupplies);
        }
        if(gstr3b.interestLateFeeData != null)
        {
        	jsonGenerator.writeObjectField("intr_ltfee", gstr3b.interestLateFeeData);
        }
        jsonGenerator.writeEndObject();
    }
}
