package ibase.dashboard.scm.servlet;
import ibase.dashboard.scm.ejb.CustomerInfoRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class OrderHistoryServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData =null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}
  
	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		CustomerInfoRemote custInfoRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String custCode       = "";
		String prdCode        = "";
		String reportName     = "";
		try
		{
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			dataSourceName  =request.getParameter("dataSourceName"); 
			custCode        =request.getParameter("custCode");
			prdCode        	=request.getParameter("prdCode");
			reportName    	  = request.getParameter("reportName"); 
			session.setAttribute("reportName", reportName);
			System.out.println("reportName is =" + reportName );
			System.out.println("in doPost" + "custCode is =" + custCode );
			System.out.println( "prdCode is =" + prdCode );
			context = new InitialContext(appConnectParm.getProperty());
			custInfoRemote = (CustomerInfoRemote)context.lookup("ibase/CustomerInfoEJB/remote");
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			custInfoRemote.setUserInfo(userInfo);
			JSONObject jsonObjData      = (JSONObject)custInfoRemote.getOrderHistory(custCode,prdCode,dataSourceName);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for OrderHistoryServlet build the Graph is===" + jsonObjData);	

		} catch (Exception e)
		{
			System.out.println("Exception : OrderHistoryServlet :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
		
	}
}