package ibase.webitm.bean.adm;

import ibase.utility.UserInfoBean;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;

import java.text.SimpleDateFormat;
import java.util.*;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.servlet.http.HttpSession;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PerkProcessWizardBean 
{
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	private int domID = 0;

	public PerkProcessWizardBean( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			//Changed by Pramod on 08-01-11[WS01SUN030 ||Generating country wise, language wise xsl and reading the same.Getting user language and country]starts
			this.user_lang = this.userInfo.getUserLanguage();
			this.user_country = this.userInfo.getUserCountry();
		   //Changed by Pramod on 08-01-11[WS01SUN030 ||Generating country wise, language wise xsl and reading the same.Getting user language and country]Ends
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}		
	}

	public PerkProcessWizardBean() throws ITMException
	{
		System.out.println(":PerkProcessWizardBean Called................:");
	}

	public String getDataForRefNo( String RefNo,String lineNo, String tranId, String selectedData , String det2DbId) throws ITMException
	{
		System.out.println("In PerkProcessWizardBean.java ----->getDataForRefNo() Method");
		System.out.println("RefNo---->["+RefNo+"]");
		System.out.println("lineNo---->["+lineNo+"]");
		System.out.println("tranId---->["+tranId+"]");
		System.out.println("selectedData---->["+selectedData+"]");
		System.out.println("det2DbId---->["+det2DbId+"]");
		
		RefNo =  checkNull(RefNo);
		lineNo  =  checkNull(lineNo);
		tranId   = checkNull(tranId);
		det2DbId = checkNull(det2DbId);
		
		
		int num = 1;
		String itemData = "";

		StringBuffer valueXmlString = new StringBuffer();
		String sql = "";
		
		String empName = "";
		String linNo = "";
		
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Document dom2 = null;
		String currentFormNo = "3";
		String preFormDet ="";
		String xmlName ="";
		String xslFileName ="";

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
		
			xmlName = "perk_claim_process3_wiz";
			System.out.println("xmlName..["+xmlName+"]");

			if (selectedData != null && selectedData.trim().length() > 0)
			{
				
				xslFileName = getXSLFileName(xmlName + "_" +this.user_lang + "_" + this.user_country + ".xsl",xmlName+ "_" + "en" + "_" + "US" +"_"+"A"+ ".xsl" );
				
				
				itemData = (new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, "<Root>"+selectedData+"</Root>", CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
		else 
			{
				System.out.println("xmlName..["+xmlName+"]");

				xslFileName = getXSLFileName(xmlName + "_" +this.user_lang + "_" + this.user_country + ".xsl",xmlName+ "_" + "en" + "_" + "US" +"_"+"A"+ ".xsl" );
				
				if (selectedData == null)
				{
					selectedData = "";
				}
				itemData = (new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, "<Root>"+selectedData+"</Root>", CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
			/* else
			{
				GenericUtility genericUtility = GenericUtility.getInstance();
				
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				
				valueXmlString.append("<Root>\r\n" );	
				
				sql =   " SELECT * FROM  EMP_ITDECL_PROOF WHERE   TRAN_ID = ?  AND  AD_CODE = ?  ORDER BY LINE_NO  ";

				pstmt = conn.prepareStatement(sql);							
				pstmt.setString(1, tranId);
				pstmt.setString(2, adCode);
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					linNo =      checkNull(rs.getString("LINE_NO"));
					
					udfStr1 = 	 checkNull(rs.getString("UDF_STR_1"));
					udfStr2 = 	 checkNull(rs.getString("UDF_STR_2"));
					udfStr3 =    checkNull(rs.getString("UDF_STR_3"));
					
					
					 udfStr4 = 	  checkNull(rs.getString("UDF_STR_4"));
					 udfStr5 =    checkNull(rs.getString("UDF_STR_5")); 
					
					 city = 	  checkNull(rs.getString("CITY"));
					 pin =        checkNull(rs.getString("PIN")); 
					 stateCode =  checkNull(rs.getString("STATE_CODE"));
					 countCode =  checkNull(rs.getString("COUNT_CODE")); 
					 
					 proofAmount =  checkNull(rs.getString("PROOF_AMOUNT"));
					
					udfDateOne =   rs.getDate("UDF_DATE_1");
					udfDateTwo =   rs.getDate("UDF_DATE_2");
					udfDateThree = rs.getDate("UDF_DATE_3");
					udfNumVal1 = checkNull(rs.getString("UDF_NUM_VAL1"));
					udfNumVal2 = checkNull(rs.getString("UDF_NUM_VAL2"));
					udfNumVal3 = checkNull(rs.getString("UDF_NUM_VAL3"));

					if (udfDateOne != null)
					{
						udfDate1 = sdf.format(udfDateOne);
					}

					if (udfDateTwo != null)
					{
						udfDate2 = sdf.format(udfDateTwo);
					}

					if (udfDateThree != null)
					{
						udfDate3 = sdf.format(udfDateThree);
					}	
					
					valueXmlString.append("<Detail3 domID='"+linNo+"' selected = 'Y'>\r\n" );
					
					valueXmlString.append("<tran_id><![CDATA[").append(tranId).append("]]></tran_id>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append(linNo).append("]]></line_no>\r\n");
					valueXmlString.append("<emp_code><![CDATA[").append(empCode).append("]]></emp_code>\r\n");
					valueXmlString.append("<emp_name><![CDATA[").append(empName).append("]]></emp_name>\r\n");
					valueXmlString.append( "<ad_code><![CDATA[").append(adCode).append( "]]></ad_code>\r\n" );	
					valueXmlString.append( "<acctYear><![CDATA[").append(acctYear).append( "]]></acctYear>\r\n" );		

					valueXmlString.append("<udf_str_1><![CDATA[").append(udfStr1).append("]]></udf_str_1>\r\n");			
					valueXmlString.append( "<udf_str_2><![CDATA[").append(udfStr2).append( "]]></udf_str_2>\r\n" );
					valueXmlString.append( "<udf_str_3><![CDATA[").append(udfStr3).append( "]]></udf_str_3>\r\n" );
					
					valueXmlString.append( "<udf_str_4><![CDATA[").append(udfStr4).append( "]]></udf_str_4>\r\n" );
					valueXmlString.append( "<udf_str_5><![CDATA[").append(udfStr5).append( "]]></udf_str_5>\r\n" );

					valueXmlString.append( "<udf_date_1><![CDATA[").append(udfDate1).append( "]]></udf_date_1>\r\n" );
					valueXmlString.append( "<udf_date_2><![CDATA[").append(udfDate2).append( "]]></udf_date_2>\r\n" );
					valueXmlString.append( "<udf_date_3><![CDATA[").append(udfDate3).append( "]]></udf_date_3>\r\n" );

					valueXmlString.append( "<udf_num_val1><![CDATA[").append(udfNumVal1).append( "]]></udf_num_val1>\r\n" );
					valueXmlString.append( "<udf_num_val2><![CDATA[").append(udfNumVal2).append( "]]></udf_num_val2>\r\n" );
					valueXmlString.append( "<udf_num_val3><![CDATA[").append(udfNumVal3).append( "]]></udf_num_val3>\r\n" );
					
					valueXmlString.append( "<city><![CDATA[").append(city).append( "]]></city>\r\n" );
					valueXmlString.append( "<pin><![CDATA[").append(pin).append( "]]></pin>\r\n" );
					valueXmlString.append( "<state_code><![CDATA[").append(stateCode).append( "]]></state_code>\r\n" );
					valueXmlString.append( "<count_code><![CDATA[").append(countCode).append( "]]></count_code>\r\n" );
					
					valueXmlString.append( "<proof_amount><![CDATA[").append(proofAmount).append( "]]></proof_amount>\r\n" );
					valueXmlString.append( "<state_descr><![CDATA[").append(getStateDescr(stateCode,conn)).append( "]]></state_descr>\r\n" );
					
					valueXmlString.append( "</Detail3>\r\n" );
					
				}
				if (rs != null)
				{
					rs.close(); 
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close(); 
					pstmt = null;
				}
				
				
				valueXmlString.append( "</Root>\r\n" );
				
				itemData = valueXmlString.toString();
				System.out.println( "itemData["+itemData+"]");
			

				xslFileName = getXSLFileName(xmlName + "_" +this.user_lang + "_" + this.user_country + ".xsl",xmlName+ "_" + "en" + "_" + "US" + ".xsl" );

				itemData = (new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}*/
			System.out.println( "itemData["+itemData+"]");
		}
		catch(Exception e)
		{			
			System.out.println( "Exception :ITWizardBean :getItemList(String) :==>\n"+e.getMessage());
			throw new ITMException(e);
		}		
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITWizardBean :getItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println( "itemData["+itemData+"]");
		return itemData;	
	}
	
	
	private String getXSLFileName( String xslFileName,String xslFileName1 )throws ITMException 
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				//Changed By Yogesh on 22/03/2011-[WS01SUN063| to return another file in case if required file does not exists].start
				//throw new ITMException( new Exception("Wizard XSL file Not Found") );	
				File xslFile1 = new File(xslPath , xslFileName1);
				retFileName = xslFile1.getAbsolutePath();
				
				if(!xslFile1.exists())
				{
					throw new ITMException( new Exception("Wizard XSL file Not Found" + " at Location [" + retFileName + "]") );
				}
				//Changed By Yogesh on 22/03/2011-[WS01SUN063| to return another file in case if required file does not exists].end
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}	
	


	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

 /* public String getStateDescr(String stateCode, Connection conn) throws ITMException
 {
	PreparedStatement pstmt = null;
	ResultSet rs = null;

	String stateDescr = "";
	String sql = "";
	try
	{		
		
		sql = "select * from state WHERE STATE_CODE =? ";
		
		pstmt =  conn.prepareStatement( sql );

		pstmt.setString(1, checkNull(stateCode) );
		rs = pstmt.executeQuery();

		System.out.println(" select emp_code sql ["+sql+"]");

		if(rs.next()) 
		{
			stateDescr = checkNull(rs.getString("DESCR"));
			
		}
		if (rs != null)
		{
			rs.close();
			rs = null;
		}
		if (pstmt != null)
		{
			pstmt.close();
			pstmt = null;
		}
	}
	catch (Exception e)
	{
		e.printStackTrace();
		System.out.println( "Exception :GetDataForAccntPerson :getEmpCodeListForAccntPers():" + e.getMessage());
	}
	finally
	{
		try
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
		}
		catch(Exception e)
		{
			System.out.println( "Exception :GetDataForAccntPerson :getEmpCodeListForAccntPers() while closing database connection :==>"+e.getMessage());
			throw new ITMException(e);
		}
	}
	System.out.println("stateDescr..["+stateDescr+"]");

	return stateDescr;
}
	
//Modified by Abhishek on [31/12/2014][Start]

 public ArrayList<String> getValidCity() 
	{
	
		Connection conn = null;
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;  
		String query = "";
		String statnCode = "";
		String statnDescr= "";
		
		ArrayList<String> citygMap = new ArrayList<String>();
		
		try{
		
		conn = connDriver.getConnectDB("DriverITM");
		
		query = "SELECT STAN_CODE , DESCR FROM STATION ";
			
		pstmt = conn.prepareStatement(query);
		rs = pstmt.executeQuery();
		while(rs.next())
		{
			statnCode =  rs.getString("STAN_CODE");
			statnDescr = rs.getString("DESCR");
			
			citygMap.add(checkNull(statnDescr));
		}
		if(rs != null) 
		{
			rs.close();
			rs = null;
		}
		if(pstmt != null) 
		{
			pstmt.close();
			pstmt = null;

		}
		System.out.println(" At msgStringMap  ....."+citygMap);
		}
		catch (Exception E)
		{
			 E.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;

				}
				if(conn != null)
				{					
					conn.close();
					conn = null;	
				}
				
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}		
		}
			return citygMap;
	}
	
	public int  getAttachVar(String empCode , String adCode , String prdCode ,String objName)
	{

		Connection conn = null;
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;  
		String query = "";
		String refID = "";
		String windowName ="w_"+checkNull(objName);
		int attach =  0 ;
		System.out.println(" empCode ....."+empCode);
		System.out.println(" adCode ....."+adCode);
		System.out.println(" prdCode  ....."+prdCode);
		System.out.println(" prdCode  ....."+windowName);
		try{
		
		//refID = checkNull(prdCode)+":"+checkNull(empCode)+":"+checkNull(adCode); 
		refID = checkNull(prdCode)+"~"+checkNull(empCode)+"~"+checkNull(adCode); 
		System.out.println(" refID  ....."+refID);
		conn = connDriver.getConnectDB("DriverITM");
		
		//query = "SELECT COUNT(*)  AS ATTACHCOUNT FROM DOC_TRANSACTION_LINK WHERE REF_ID = ?  AND  REF_SER = ? ";
		query = "SELECT COUNT(*)  AS ATTACHCOUNT FROM DOC_TRANSACTION_LINK WHERE REF_ID = ?  AND  REF_SER = (SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?) ";
			
		pstmt = conn.prepareStatement(query);
		pstmt.setString(1, refID);
		pstmt.setString(2, windowName);
		rs = pstmt.executeQuery();
		if(rs.next())
		{
			
			attach = rs.getInt("ATTACHCOUNT") ;
		}
		if(rs != null) 
		{
			rs.close();
			rs = null;
		}
		if(pstmt != null) 
		{
			pstmt.close();
			pstmt = null;

		}
		System.out.println(" is Attachment Necessary  .....");
		}
		catch (Exception E)
		{
			 E.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;

				}
				if(conn != null)
				{		
					conn.close();
					conn = null;	
				}
				
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}		
		}
		
		return attach ;
	}*/

//Modified by Abhishek on [31/12/2014][End]
	

}