<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body onload="formatDate();">
<script type="text/javascript" src="/ibase/webitm/js/WavegenWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<script language="Javascript" src="/ibase/webitm/js/date.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.core.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.position.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.menu.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.autocomplete.js"></script>
		
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/WavegenWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="wavegenWizForm1" id="wavegenWizForm1" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:100%;padding:12px; background-color:white;top:0px;">
		&#160;&#160;<img src="/ibase/images/menuImages/web/wavegeneration.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px; height: 20px; width: 20px;"/>
		&#160;Wave Generation
	</div><br></br><br></br>
	<!-- Changed by Santosh on 31/03/2017 to remove horizontal scroll bar -->
	<!-- <div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:100%;position:absolute;"> -->
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:98%;position:absolute;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
                    </td>
                </tr>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<!-- Added by Santosh on 10/03/2017 to display sort order options Start -->
	<div id="sortOrderOpt" class="sortOrderContainer">
		<div class="closeDiv" onclick="hideSortOrdDiv();">
			X
		</div>
		<div class="sortOrderWrapper">
			<div class="sortOrderRow">
				<div class="sortOrdChkB"><input type="checkbox" name="sortOrdChkB" id="sortOrdChkB1" onclick="generateSortOrderSeq('1');" /></div><div class="leftAlign" id="sortOrdDescr1" >Customer Rank</div><div class="rightAlign" name="sortOrdVal" id="sortOrdVal1">0</div>
			</div>
			<div class="sortOrderRow">
				<div class="sortOrdChkB"><input type="checkbox" name="sortOrdChkB" id="sortOrdChkB2" onclick="generateSortOrderSeq('2');" /></div><div class="leftAlign" id="sortOrdDescr2" >Credit Term Rank</div><div class="rightAlign" name="sortOrdVal" id="sortOrdVal2">0</div>
			</div>
			<div class="sortOrderRow">
				<div class="sortOrdChkB"><input type="checkbox" name="sortOrdChkB" id="sortOrdChkB3" onclick="generateSortOrderSeq('3');" /></div><div class="leftAlign" id="sortOrdDescr3" >Pending Payments</div><div class="rightAlign" name="sortOrdVal" id="sortOrdVal3">0</div>
			</div>
			<div class="sortOrderRow">
				<div class="sortOrdChkB"><input type="checkbox" name="sortOrdChkB" id="sortOrdChkB4" onclick="generateSortOrderSeq('4');" /></div><div class="leftAlign" id="sortOrdDescr4" >Cancellation Date</div><div class="rightAlign" name="sortOrdVal" id="sortOrdVal4">0</div>
			</div>
			<div class="sortOrderRow">
				<div class="leftAlign" style="float:left;width:22%;"><input type="button" value="Reset" class="button" onclick="resetSortOrd();" /></div><div class="leftAlign" style="float:left;width:30%;"><input type="button" value="Set Sort Order" class="button" onclick="setSortOrdSeq();" /></div>
			</div>
		</div>
	</div>
	<!-- Added by Santosh on 10/03/2017 to display sort order options End -->
	<div id="mainPageHeaderContatiner">
		<div id="mainPage-input-Container">
			<xsl:for-each select="//Detail1">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
				<xsl:variable name="sort_order"><xsl:value-of select="sort_order"/></xsl:variable>
				<xsl:variable name="item_ser__from"><xsl:value-of select="item_ser__from"/></xsl:variable>
				<xsl:variable name="item_ser__to"><xsl:value-of select="item_ser__to"/></xsl:variable>
				<xsl:variable name="product_style__from"><xsl:value-of select="product_style__from"/></xsl:variable>
				<xsl:variable name="product_style__to"><xsl:value-of select="product_style__to"/></xsl:variable>
				<xsl:variable name="item_code__from"><xsl:value-of select="item_code__from"/></xsl:variable>
				<xsl:variable name="item_code__to"><xsl:value-of select="item_code__to"/></xsl:variable>
				<xsl:variable name="cust_code__from"><xsl:value-of select="cust_code__from"/></xsl:variable>
				<xsl:variable name="cust_code__to"><xsl:value-of select="cust_code__to"/></xsl:variable>
				<xsl:variable name="due_date__from"><xsl:value-of select="due_date__from"/></xsl:variable>
				<xsl:variable name="due_date__to"><xsl:value-of select="due_date__to"/></xsl:variable>
				<xsl:variable name="sale_order__from"><xsl:value-of select="sale_order__from"/></xsl:variable>
				<xsl:variable name="sale_order__to"><xsl:value-of select="sale_order__to"/></xsl:variable>
				<xsl:variable name="cust_code__dlv__from"><xsl:value-of select="cust_code__dlv__from"/></xsl:variable>
				<xsl:variable name="cust_code__dlv__to"><xsl:value-of select="cust_code__dlv__to"/></xsl:variable>
				<xsl:variable name="credit_term__from"><xsl:value-of select="credit_term__from"/></xsl:variable>
				<xsl:variable name="credit_term__to"><xsl:value-of select="credit_term__to"/></xsl:variable>
				<xsl:variable name="carrier_code"><xsl:value-of select="carrier_code"/></xsl:variable>				
				<xsl:variable name="carrier_name"><xsl:value-of select="carrier_name"/></xsl:variable>
				<xsl:variable name="default_qty_flag"><xsl:value-of select="default_qty_flag"/></xsl:variable>
				<xsl:variable name="wave_mode"><xsl:value-of select="wave_mode"/></xsl:variable>
				<xsl:variable name="order_type"><xsl:value-of select="order_type"/></xsl:variable>
				<xsl:variable name="loc_type_parent"><xsl:value-of select="loc_type_parent"/></xsl:variable>
				<xsl:variable name="tran_code"><xsl:value-of select="tran_code"/></xsl:variable>
				<xsl:variable name="tran_name"><xsl:value-of select="tran_name"/></xsl:variable>
				<xsl:variable name="remarks"><xsl:value-of select="remarks"/></xsl:variable>
				<xsl:variable name="active_pick_allow"><xsl:value-of select="active_pick_allow"/></xsl:variable>
				<xsl:variable name="master_pack_allow"><xsl:value-of select="master_pack_allow"/></xsl:variable>
				<xsl:variable name="parcelpack_allow"><xsl:value-of select="parcelpack_allow"/></xsl:variable>
				<xsl:variable name="stock_to_dock_allow"><xsl:value-of select="stock_to_dock_allow"/></xsl:variable>
				<xsl:variable name="single_lot"><xsl:value-of select="single_lot"/></xsl:variable>
				<xsl:variable name="ship_type"><xsl:value-of select="ship_type"/></xsl:variable>
				<xsl:variable name="pallet_no"><xsl:value-of select="pallet_no"/></xsl:variable>
				<xsl:variable name="direct_pick_loc"><xsl:value-of select="direct_pick_loc"/></xsl:variable>
				<xsl:variable name="print_label"><xsl:value-of select="print_label"/></xsl:variable>
				<xsl:variable name="printer_name"><xsl:value-of select="printer_name"/></xsl:variable>
				<xsl:variable name="date_format"><xsl:value-of select="date_format"/></xsl:variable>
				<xsl:variable name="app_context"><xsl:value-of select="app_context"/></xsl:variable>
				<input type="hidden" id="date_format" value="{$date_format}" /> 
				<input type="hidden" id="app_context" value="{$app_context}" /> 
				<table id="activityTable" border="0" cellSpacing="1" cellPadding="0" style="margin-bottom:25px;">
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Site Code :
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$site_code}" name="Detail1.{normalize-space($dbID)}.site_code" id="Detail1.{normalize-space($dbID)}.site_code" tabIndex="10"/>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle">Sort Order:</td>
						<td class="td_leftAlign">
							<input type="text" class="input_editable" value="{$sort_order}" name="Detail1.{normalize-space($dbID)}.sort_order" id="Detail1.{normalize-space($dbID)}.sort_order" tabIndex="15" onfocus="displayPopUpIcon('popUpIcon0');" />
							<!-- Changed by Santosh on 10/03/2017 to change sort_order logic -->
							<!-- <a href="javascript:getListOfValues('SORT_ORDER','Detail1.{normalize-space($dbID)}.sort_order','{$site_code}');" id="popUpIcon0"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png"/></a> -->
							<a href="#" onclick="openSortOrdPopUp(event);" id="popUpIcon0"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png"/></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle">
							Item Series From:
						</td>
						<td class="td_leftAlign">
							<input type="text" class="input_editable" value="{$item_ser__from}" name="Detail1.{normalize-space($dbID)}.item_ser__from" id="Detail1.{normalize-space($dbID)}.item_ser__from" tabIndex="20" popupFldName="ITEM_SER" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon1');" />
							<a href="javascript:getListOfValues('ITEM_SER','Detail1.{normalize-space($dbID)}.item_ser__from','{$site_code}');" id="popUpIcon1"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png"/></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle">
							Item Series To:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$item_ser__to}" name="Detail1.{normalize-space($dbID)}.item_ser__to" id="Detail1.{normalize-space($dbID)}.item_ser__to"  tabIndex="30" popupFldName="ITEM_SER" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon2');"/>
							<a href="javascript:getListOfValues('ITEM_SER','Detail1.{normalize-space($dbID)}.item_ser__to','{$site_code}');" id="popUpIcon2" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Product(Style) From:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$product_style__from}" name="Detail1.{normalize-space($dbID)}.product_style__from" id="Detail1.{normalize-space($dbID)}.product_style__from" popupFldName="ITEM_PARNT" tabIndex="40" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon3');" />
							<a href="javascript:getListOfValues('ITEM_PARNT','Detail1.{normalize-space($dbID)}.product_style__from','{$site_code}');" id="popUpIcon3" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Product(Style) To:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$product_style__to}" name="Detail1.{normalize-space($dbID)}.product_style__to" id="Detail1.{normalize-space($dbID)}.product_style__to" tabIndex="50" popupFldName="ITEM_PARNT" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon4');" />
							<a href="javascript:getListOfValues('ITEM_PARNT','Detail1.{normalize-space($dbID)}.product_style__to','{$site_code}');" id="popUpIcon4"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Item Code From:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$item_code__from}" name="Detail1.{normalize-space($dbID)}.item_code__from" id="Detail1.{normalize-space($dbID)}.item_code__from" tabIndex="60" popupFldName="ITEM_CODE" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon5');" />
							<a href="javascript:getListOfValues('ITEM_CODE','Detail1.{normalize-space($dbID)}.item_code__from','{$site_code}');" id="popUpIcon5" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Item Code To:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$item_code__to}" name="Detail1.{normalize-space($dbID)}.item_code__to" id="Detail1.{normalize-space($dbID)}.item_code__to" tabIndex="70" popupFldName="ITEM_CODE" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon6');" />
							<a href="javascript:getListOfValues('ITEM_CODE','Detail1.{normalize-space($dbID)}.item_code__to','{$site_code}');" id="popUpIcon6"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Sales Order From:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$sale_order__from}" name="Detail1.{normalize-space($dbID)}.sale_order__from" id="Detail1.{normalize-space($dbID)}.sale_order__from" onblur="callItemChange('sale_order__from');" popupFldName="SALE_ORDER" onkeyup="getAutoPopupData(this);" tabIndex="80" onfocus="displayPopUpIcon('popUpIcon7');" />
							<a href="javascript:getListOfValues('SALE_ORDER','Detail1.{normalize-space($dbID)}.sale_order__from','{$site_code}');" id="popUpIcon7"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Sales Order  To:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$sale_order__to}" name="Detail1.{normalize-space($dbID)}.sale_order__to" id="Detail1.{normalize-space($dbID)}.sale_order__to" onblur="callItemChange('sale_order__to');" popupFldName="SALE_ORDER" onkeyup="getAutoPopupData(this);" tabIndex="90" onfocus="displayPopUpIcon('popUpIcon8');" />
							<a href="javascript:getListOfValues('SALE_ORDER','Detail1.{normalize-space($dbID)}.sale_order__to','{$site_code}');" id="popUpIcon8"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Customer Code From:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$cust_code__from}" name="Detail1.{normalize-space($dbID)}.cust_code__from" id="Detail1.{normalize-space($dbID)}.cust_code__from" onchange="callItemChange('cust_code__from');" popupFldName="CUST_CODE" onkeyup="getAutoPopupData(this);" tabIndex="100" onfocus="displayPopUpIcon('popUpIcon9');" />
							<a href="javascript:getListOfValues('CUST_CODE','Detail1.{normalize-space($dbID)}.cust_code__from','{$site_code}');" id="popUpIcon9" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Customer Code To :
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$cust_code__to}" name="Detail1.{normalize-space($dbID)}.cust_code__to" id="Detail1.{normalize-space($dbID)}.cust_code__to" onchange="callItemChange('cust_code__to');" popupFldName="CUST_CODE" onkeyup="getAutoPopupData(this);" tabIndex="110" onfocus="displayPopUpIcon('popUpIcon10');" />
							<a href="javascript:getListOfValues('CUST_CODE','Detail1.{normalize-space($dbID)}.cust_code__to','{$site_code}');" id="popUpIcon10"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Due Date From:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$due_date__from}" name="Detail1.{normalize-space($dbID)}.due_date__from" id="due_date__from" tabIndex="120"  onfocus="displayPopUpIcon('popUpIcon11');" />
							<a href="javascript:setDate('due_date__from');" id="popUpIcon11"   tabIndex="-1"><img src="/ibase/webitm/images/calender.png" /></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Due Date To:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$due_date__to}" name="Detail1.{normalize-space($dbID)}.due_date__to" id="due_date__to" tabIndex="130"  onfocus="displayPopUpIcon('popUpIcon12');" />
							<a href="javascript:setDate('due_date__to');" id="popUpIcon12"  tabIndex="-1"><img src="/ibase/webitm/images/calender.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Customer Code Dlv From:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$cust_code__dlv__from}" name="Detail1.{normalize-space($dbID)}.cust_code__dlv__from" id="Detail1.{normalize-space($dbID)}.cust_code__dlv__from" tabIndex="140" popupFldName="CUST_CODE" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon13');" />
							<a href="javascript:getListOfValues('CUST_CODE','Detail1.{normalize-space($dbID)}.cust_code__dlv__from','{$site_code}');" id="popUpIcon13" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Customer Code Dlv To:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$cust_code__dlv__to}" name="Detail1.{normalize-space($dbID)}.cust_code__dlv__to" id="Detail1.{normalize-space($dbID)}.cust_code__dlv__to" tabIndex="142" popupFldName="CUST_CODE" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon14');" />
							<a href="javascript:getListOfValues('CUST_CODE','Detail1.{normalize-space($dbID)}.cust_code__dlv__to','{$site_code}');" id="popUpIcon14" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Credit Term From:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$credit_term__from}" name="Detail1.{normalize-space($dbID)}.credit_term__from" id="Detail1.{normalize-space($dbID)}.credit_term__from" tabIndex="144" popupFldName="CREDIT_TERM__FROM" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon15');" />
							<a href="javascript:getListOfValues('CREDIT_TERM__FROM','Detail1.{normalize-space($dbID)}.credit_term__from','{$site_code}');" id="popUpIcon15" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Credit Term To:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$credit_term__to}" name="Detail1.{normalize-space($dbID)}.credit_term__to" id="Detail1.{normalize-space($dbID)}.credit_term__to" tabIndex="146" popupFldName="CREDIT_TERM__TO" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon16');" />
							<a href="javascript:getListOfValues('CREDIT_TERM__TO','Detail1.{normalize-space($dbID)}.credit_term__to','{$site_code}');" id="popUpIcon16" tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle" >
							Carrier Code:
						</td>
						<td class="td_leftAlign" colspan="3">
							<div id="inputDiv">
								<input type="text" class="input_editable" value="{$carrier_code}" name="Detail1.{normalize-space($dbID)}.carrier_code" id="Detail1.{normalize-space($dbID)}.carrier_code" onchange="callItemChange('carrier_code');" tabIndex="160" style="width:21%; margin-right:5px;" />
								<input type="text" class="editDisplayClass" value="{$carrier_name}" name="Detail1.{normalize-space($dbID)}.carrier_name" id="Detail1.{normalize-space($dbID)}.carrier_name" tabIndex="-1" style="width:64%;" readOnly="true"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Default Quantity Automatic:
						</td>
						<td class="td_leftAlign" >
							<SELECT id='Detail1.{normalize-space($dbID)}.default_qty_flag' NAME="Detail1.{normalize-space($dbID)}.default_qty_flag" align="LEFT" TABINDEX="170" class="input_editable">
								<OPTION value="Y"><xsl:choose><xsl:when test="$default_qty_flag='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
								<OPTION value="N"><xsl:choose><xsl:when test="$default_qty_flag='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
							</SELECT>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle" >
							Wave Mode:
						</td>
						<td class="td_leftAlign" >
							<SELECT id='Detail1.{normalize-space($dbID)}.wave_mode' NAME="Detail1.{normalize-space($dbID)}.wave_mode" onchange="callItemChange('wave_mode');" align="LEFT" TABINDEX="180" class="input_editable" style="width:60%;">
								<OPTION value="P"><xsl:choose><xsl:when test="$wave_mode='P'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Process]]></OPTION>
								<OPTION value="R"><xsl:choose><xsl:when test="$wave_mode='R'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Preview]]></OPTION>
							</SELECT>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Sales Order Type:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$order_type}" name="Detail1.{normalize-space($dbID)}.order_type" id="Detail1.{normalize-space($dbID)}.order_type" TABINDEX="190" />
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle" >
							Location Type Parent:
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$loc_type_parent}" name="Detail1.{normalize-space($dbID)}.loc_type_parent" id="Detail1.{normalize-space($dbID)}.loc_type_parent" TABINDEX="200" />
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Transporter Code:
						</td>
						<td class="td_leftAlign" colspan="3">
							<div id="inputDiv">
								<input type="text" class="editDisplayClass" value="{$tran_code}" name="Detail1.{normalize-space($dbID)}.tran_code" id="Detail1.{normalize-space($dbID)}.tran_code" onchange="callItemChange('tran_code');" TABINDEX="-1" style="width:16%; margin-right:5px;" readOnly="true"/>
								<input type="text" class="editDisplayClass" value="{$tran_name}" name="Detail1.{normalize-space($dbID)}.tran_name" id="Detail1.{normalize-space($dbID)}.tran_name" TABINDEX="-1" style="width:69%;" readOnly="true"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle">
							Remarks:
						</td>
						<td class="td_leftAlign"  colspan="3">
							<input type="text" class="input_editable" value="{$remarks}" name="Detail1.{normalize-space($dbID)}.remarks" id="Detail1.{normalize-space($dbID)}.remarks" TABINDEX="210" style="width:86%;"/>
						</td>
					</tr>
				</table>
				<table id="shipmentTable" cellSpacing="1" border="0" style="margin-left:75px;">
					<tr>
						<td colspan="6">
							<table style="width:100%">
								<tr>
									<td class="td_rightAlign" nowrap="true" valign="middle">Active Allow:</td>
									<td>
										<SELECT id='Detail1.{normalize-space($dbID)}.active_pick_allow' NAME="Detail1.{normalize-space($dbID)}.active_pick_allow" align="LEFT" TABINDEX="220" class="input_editable">
											<OPTION value="Y"><xsl:choose><xsl:when test="$active_pick_allow='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
											<OPTION value="N"><xsl:choose><xsl:when test="$active_pick_allow='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
										</SELECT>
									</td>
									<td class="td_rightAlign" nowrap="true" valign="middle">Master Allow:</td>
									<td>
										<SELECT id='Detail1.{normalize-space($dbID)}.master_pack_allow' NAME="Detail1.{normalize-space($dbID)}.master_pack_allow" align="LEFT" TABINDEX="230" TABORDER="210" class="input_editable">
											<OPTION value="Y"><xsl:choose><xsl:when test="$master_pack_allow='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
											<OPTION value="N"><xsl:choose><xsl:when test="$master_pack_allow='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
										</SELECT>
									</td>
									<td class="td_rightAlign" nowrap="true" valign="middle">Parcel Allow:</td>
									<td>
										<SELECT id='Detail1.{normalize-space($dbID)}.parcelpack_allow' NAME="Detail1.{normalize-space($dbID)}.parcelpack_allow" align="LEFT" TABINDEX="240" class="input_editable">
											<OPTION value="Y"><xsl:choose><xsl:when test="$parcelpack_allow='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
											<OPTION value="N"><xsl:choose><xsl:when test="$parcelpack_allow='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
										</SELECT>
									</td>
								</tr>
								<tr>
									<td class="td_rightAlign" nowrap="true" valign="middle">Stock To Dock:</td>
									<td>
										<SELECT id='Detail1.{normalize-space($dbID)}.stock_to_dock_allow' NAME="Detail1.{normalize-space($dbID)}.stock_to_dock_allow" align="LEFT" TABINDEX="250" class="input_editable">
											<OPTION value="Y"><xsl:choose><xsl:when test="$stock_to_dock_allow='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
											<OPTION value="N"><xsl:choose><xsl:when test="$stock_to_dock_allow='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
										</SELECT>
									</td>
									<td class="td_rightAlign" nowrap="true" valign="middle">Single Lot:</td>
									<td>
										<SELECT id='Detail1.{normalize-space($dbID)}.single_lot' NAME="Detail1.{normalize-space($dbID)}.single_lot" align="LEFT" TABINDEX="260" class="input_editable">
											<OPTION value="Y"><xsl:choose><xsl:when test="$single_lot='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
											<OPTION value="N"><xsl:choose><xsl:when test="$single_lot='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
										</SELECT>
									</td>
									<td class="td_rightAlign" nowrap="true" valign="middle">Shipment Type:</td>
									<td>
										<SELECT id='Detail1.{normalize-space($dbID)}.ship_type' NAME="Detail1.{normalize-space($dbID)}.ship_type" align="LEFT" TABINDEX="270" class="input_editable">
											<OPTION value="A"><xsl:choose><xsl:when test="ship_type='A'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[As per Routing]]></OPTION>
											<OPTION value="L"><xsl:choose><xsl:when test="ship_type='L'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[LTL]]></OPTION>
											<OPTION value="M"><xsl:choose><xsl:when test="ship_type='M'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Master Pack]]></OPTION>
											<OPTION value="P"><xsl:choose><xsl:when test="ship_type='P'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Parcel Pack]]></OPTION>
										</SELECT>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle">Pallet No:</td>
						<td colspan="2">
							<input type="text" class="input_editable" value="{$pallet_no}" name="Detail1.{normalize-space($dbID)}.pallet_no" id="Detail1.{normalize-space($dbID)}.pallet_no" TABINDEX="280" style="width:85%;"/>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle" colspan="2">Direct Pick Location:</td>
						<td>
							<input type="text" class="input_editable" value="{$direct_pick_loc}" name="Detail1.{normalize-space($dbID)}.direct_pick_loc" id="Detail1.{normalize-space($dbID)}.direct_pick_loc" TABINDEX="290" style="width:90%;"/>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle">Print Label:</td>
						<td>
							<SELECT id='Detail1.{normalize-space($dbID)}.print_label' NAME="Detail1.{normalize-space($dbID)}.print_label" onchange="callItemChange('print_label');" align="LEFT" TABINDEX="300" class="input_editable">
								<OPTION value="Y"><xsl:choose><xsl:when test="$print_label='Y'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Yes]]></OPTION>
								<OPTION value="N"><xsl:choose><xsl:when test="$print_label='N'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[No]]></OPTION>
							</SELECT>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle">Printer For Label:</td>
						<td colspan="2">
							<input type="text" class="input_editable" value="{$printer_name}" name="Detail1.{normalize-space($dbID)}.printer_name" id="Detail1.{normalize-space($dbID)}.printer_name" TABINDEX="310" style="width:192%" onfocus="displayPopUpIcon('popUpIcon17');" />
						</td>
						<td>
							<a href="javascript:getListOfValues('PRINTER_NAME','Detail1.{normalize-space($dbID)}.printer_name','{$site_code}');" id="popUpIcon17"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png" /></a>
						</td>
					</tr>
				</table>
			</xsl:for-each>
		</div>
		<div id="btnDiv">
			<input type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden" value="wavegen_wiz" name="OBJ_NAME" />
			<input type="hidden" value="" name="action" id="action" />
			<!-- Added by Santosh on 31/03/2017 for Reset button  -->
			<input type="submit" style="cursor:hand;margin-left:2px;" value="Reset" onclick="setActionVal('reset');"  class="button" title='Reset' id="reset"/>
			<input type="submit" style="cursor:hand;margin-left:2px;" value="Next" onclick="setActionVal('next');return displayWaitImg();" class="button" title='Next' id="next"/>
		</div>
	</div>
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
