/**
 *  Purpose: Dashboard for Task Details, Reuest ID: W15CSUN005  
 *  Author: Sneha Mestry
 *  Date: 23-06-2015
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;


import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class TaskDetails extends ValidatorEJB implements TaskDetailsRemote, TaskDetailsLocal
{
		
	public TaskDetails()
	{}
	E12GenericUtility genericUtility = new E12GenericUtility();
	//1.This is the main method to show the parent graph 
	@SuppressWarnings("unchecked")	
	
	public JSONObject getTaskDetails(String dataSourceName, String siteCode) throws RemoteException, ITMException
	{
		
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();	
		
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB(dataSourceName);
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			int count = 0;
			int replCreatecount = 0, replVerifycount = 0, replPendingcount = 0, activereplCreatecount = 0, 
				activereplVerifycount = 0, activereplPendingcount = 0, pickCreatecount = 0, pickPendingcount = 0,
				pickVerifycount = 0, activeCreatecount = 0, activePendingcount = 0, activeVerifycount = 0, 
				mpackCreatecount = 0, mpackPendingcount = 0, mpackVerifycount = 0, hazmetCreateCount = 0,
				hazmetPendingCount = 0, hazmetVerifyCount = 0;
			String assignTask = "";
			
			System.out.println(" ************** Replenishments ****************** ");
			// Replenishments Created Count
			sql = "  SELECT COUNT(DISTINCT RH.REPL_ORDER) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, REPL_ORD_HDR RH,  REPL_ORD_DET RT  "    //created
				+ " WHERE W.WAVE_ID = WT.WAVE_ID AND WT.REF_ID = RH.REPL_ORDER AND WT.WAVE_STATUS ='C' AND WT.STATUS ='N' AND RH.REPL_ORDER = RT.REPL_ORDER " 
				+ " AND RH.REPL_ORDER = RT.REPL_ORDER AND W.CANCEL ='N' AND (RT.CANCEL_MODE ='N' OR RT.CANCEL_MODE IS NULL) AND RH.ORDER_TYPE NOT IN " 
				+ " ('E','Q','T','P','I','V') ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				replCreatecount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Replenishments Pending Count
			sql = " SELECT COUNT (DISTINCT RH.REPL_ORDER) AS COUNT FROM REPL_ORD_HDR RH, WAVE_TASK W, WAVE_TASK_DET WT, REPL_ORD_DET RT" 
		      	+ " WHERE W.WAVE_ID = WT.WAVE_ID AND RH.REPL_ORDER = WT.REF_ID AND WT.STATUS = 'N' "
			    + " AND WT.WAVE_STATUS = 'W' AND RT.REPL_ORDER = RH.REPL_ORDER AND W.CANCEL = 'N' AND (RT.CANCEL_MODE ='N' OR RT.CANCEL_MODE IS NULL) " 
			    + " AND RH.ORDER_TYPE NOT IN ('E','Q','T','P','I','V') " ;
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				replPendingcount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			//  Replenishments Verfied Count
			sql = " SELECT COUNT (DISTINCT RH.REPL_ORDER) AS COUNT FROM REPL_ORD_HDR RH, REPL_ORD_DET RT, WAVE_TASK W, WAVE_TASK_DET WT, "   //verified
				+ " REPL_ISS_HDR RIH, REPL_ISS_DET RIT WHERE RH.REPL_ORDER = RT.REPL_ORDER AND W.WAVE_ID = WT.WAVE_ID AND RH.REPL_ORDER = RIT.REPL_ORDER "
				+ " AND RH.REPL_ORDER = RIH.REPL_ORDER AND RH.REPL_ORDER = WT.REF_ID AND RIH.CONFIRMED ='Y' AND WT.WAVE_STATUS ='V' " 
				+ " AND W.CANCEL ='N' AND (RT.CANCEL_MODE ='N' OR RT.CANCEL_MODE IS NULL) AND RH.ORDER_TYPE NOT IN " 
				+ " ('E','Q','T','P','I','V') ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				replVerifycount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			int totalRepltasks = replCreatecount + replVerifycount + replPendingcount ;
			rowData = new JSONObject();
			assignTask = "Replenishments";
			rowData.put("assignTask", assignTask);
			rowData.put("created", replCreatecount);
			rowData.put("pending", replPendingcount);
			rowData.put("verified", replVerifycount);
			rowData.put("totalTask", totalRepltasks);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("rowData for Replenishments :::::::::: " + rowData);
			System.out.println("rawDataJson  for Replenishments :::::::::: " + rawDataJson);
			
			
			System.out.println(" ************** Active Replenishments ****************** ");
			// Active Repl Created Count
			sql = " SELECT COUNT( DISTINCT RH.REPL_ORDER) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, REPL_ORD_HDR RH, REPL_ORD_DET RT "    //created
				+ " WHERE W.WAVE_ID = WT.WAVE_ID AND WT.REF_ID = RH.REPL_ORDER AND RH.REPL_ORDER = RT.REPL_ORDER AND ( RT.CANCEL_MODE = 'N' OR RT.CANCEL_MODE IS NULL ) " 
				+ " AND W.CANCEL ='N' AND WT.STATUS ='N' AND WT.WAVE_STATUS ='C' AND RH.ORDER_TYPE IN " 
				+ " ('E','Q','T','P','I','V') ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				activereplCreatecount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Active Replenishments Pending Count
			sql = " SELECT COUNT ( DISTINCT RH.REPL_ORDER) AS COUNT FROM REPL_ORD_HDR RH, WAVE_TASK W, WAVE_TASK_DET WT, REPL_ORD_DET RT" 
			  	+ " WHERE W.WAVE_ID = WT.WAVE_ID AND RH.REPL_ORDER = WT.REF_ID AND RH.REPL_ORDER = RT.REPL_ORDER AND WT.STATUS = 'N' " 
			  	+ " AND (RT.CANCEL_MODE ='N' OR RT.CANCEL_MODE IS NULL) AND W.CANCEL ='N' AND WT.WAVE_STATUS = 'W' AND" 
			  	+ " RH.ORDER_TYPE IN ('E','Q','T','P','I','V') " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				activereplPendingcount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Active Replenishments Verified Count
			sql = " SELECT COUNT ( DISTINCT RH.REPL_ORDER) AS COUNT FROM REPL_ORD_HDR RH, REPL_ORD_DET RT, WAVE_TASK W, WAVE_TASK_DET WT, "   //verified
				+ " REPL_ISS_HDR RIH, REPL_ISS_DET RIT WHERE RH.REPL_ORDER = RT.REPL_ORDER AND W.WAVE_ID = WT.WAVE_ID AND RH.REPL_ORDER = RIT.REPL_ORDER "
				+ " AND RH.REPL_ORDER = RIH.REPL_ORDER AND RH.REPL_ORDER = WT.REF_ID AND RIH.CONFIRMED ='Y' AND WT.WAVE_STATUS ='V' " 
				+ " AND (RT.CANCEL_MODE ='N' OR RT.CANCEL_MODE IS NULL) AND W.CANCEL ='N' AND RH.ORDER_TYPE IN " 
				+ " ('E','Q','T','P','I','V') ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				activereplVerifycount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			int totalactiverepltasks = activereplCreatecount + activereplVerifycount + activereplPendingcount ;
			rowData = new JSONObject();
			assignTask = "Active Replenishments";
			rowData.put("assignTask", assignTask);
			rowData.put("created", activereplCreatecount);
			rowData.put("pending", activereplPendingcount);
			rowData.put("verified", activereplVerifycount);
			rowData.put("totalTask", totalactiverepltasks);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("rowData for Active Replenishments :::::::::: " + rowData);
			System.out.println("rawDataJson for Active Replenishments :::::::::: " + rawDataJson);
			
			System.out.println(" ************** Picking ****************** ");
			// Picking Created Count
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, PICK_ORD_HDR PH, PICK_ORD_DET PT, ITEM I WHERE W.WAVE_ID = WT.WAVE_ID "
				+ " AND WT.REF_ID = PH.PICK_ORDER AND PT.ITEM_CODE = I.ITEM_CODE AND PT.PICK_ORDER = WT.REF_ID AND WT.SALE_ORDER = PT.SALE_ORDER AND (I.HAZARDOUS ='N' OR I.HAZARDOUS IS NULL )  AND WT.WAVE_STATUS ='C' AND WT.STATUS ='N' " 
				+ " AND W.CANCEL ='N' AND WT.REF_SER IN('C-PICK','M-PICK','P-PICK') ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				pickCreatecount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Picking Pending Count
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM PICK_ORD_HDR PH, PICK_ORD_DET PT, WAVE_TASK W, WAVE_TASK_DET WT, ITEM I WHERE W.WAVE_ID = WT.WAVE_ID " 
			   	+ " AND PH.PICK_ORDER = WT.REF_ID AND PT.ITEM_CODE = I.ITEM_CODE AND PT.PICK_ORDER = WT.REF_ID AND WT.SALE_ORDER = PT.SALE_ORDER AND (I.HAZARDOUS ='N' OR I.HAZARDOUS IS NULL) AND WT.STATUS = 'N' AND W.CANCEL ='N' " 
			    + " AND WT.WAVE_STATUS = 'W' AND WT.REF_SER IN('C-PICK','M-PICK','P-PICK') ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				pickPendingcount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Picking Verified Count
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM  PICK_ORD_HDR PH, PICK_ORD_DET PT, WAVE_TASK W, WAVE_TASK_DET WT, PICK_ISS_HDR PIH, PICK_ISS_DET PIT, ITEM I " 
				+ " WHERE W.WAVE_ID = WT.WAVE_ID AND PH.PICK_ORDER = PIT.PICK_ORDER AND PH.PICK_ORDER = PIH.PICK_ORDER AND PH.PICK_ORDER = WT.REF_ID " 
				+ " AND PT.ITEM_CODE = I.ITEM_CODE AND WT.SALE_ORDER = PT.SALE_ORDER AND (I.HAZARDOUS ='N' OR I.HAZARDOUS IS NULL) AND PIH.CONFIRMED ='Y' AND W.CANCEL ='N' AND WT.REF_SER IN('C-PICK','M-PICK','P-PICK') AND WT.WAVE_STATUS = 'V' " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				pickVerifycount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			int totalpicktasks = pickCreatecount + pickVerifycount + pickPendingcount ;
			rowData = new JSONObject();
			assignTask = "Picking";
			rowData.put("assignTask", assignTask);
			rowData.put("created", pickCreatecount);
			rowData.put("pending", pickPendingcount);
			rowData.put("verified", pickVerifycount);
			rowData.put("totalTask", totalpicktasks);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("rowData for Picking :::::::::: " + rowData);
			System.out.println("rawDataJson for Picking :::::::::: " + rawDataJson);
			
			System.out.println(" ************** Active Pick ****************** ");
			//Active Pick Create Count 
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, PICK_ORD_HDR PH, PICK_ORD_DET PT WHERE W.WAVE_ID = WT.WAVE_ID "
				+ " AND WT.REF_ID = PH.PICK_ORDER AND PH.PICK_ORDER = PT.PICK_ORDER AND W.CANCEL ='N' AND WT.STATUS ='N' AND WT.WAVE_STATUS ='C' AND WT.REF_SER IN('A-PICK') ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				activeCreatecount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Active Pick Pending Count 
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM PICK_ORD_HDR PH, WAVE_TASK W, WAVE_TASK_DET WT,PICK_ORD_DET PT WHERE W.WAVE_ID = WT.WAVE_ID AND PH.PICK_ORDER = WT.REF_ID " 
			   	+ " AND PH.PICK_ORDER = PT.PICK_ORDER AND W.CANCEL ='N' AND WT.STATUS = 'N' AND WT.WAVE_STATUS = 'W' AND WT.REF_SER IN ('A-PICK') " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				activePendingcount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Active Pick Verified Count 
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM PICK_ORD_HDR PH, PICK_ORD_DET PT, WAVE_TASK W, WAVE_TASK_DET WT, PICK_ISS_HDR PIH, PICK_ISS_DET PIT " 
				+ " WHERE PH.PICK_ORDER = PT.PICK_ORDER AND W.WAVE_ID = WT.WAVE_ID AND PH.PICK_ORDER = PIT.PICK_ORDER AND PH.PICK_ORDER = PIH.PICK_ORDER AND PH.PICK_ORDER = WT.REF_ID " 
				+ " AND W.CANCEL ='N' AND PIH.CONFIRMED ='Y' AND WT.REF_SER IN ('A-PICK') AND WT.WAVE_STATUS = 'V' " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				activeVerifycount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			int totalactiveTasks = activeCreatecount + activeVerifycount + activePendingcount ; 
			rowData = new JSONObject();
			assignTask = "Active Pick";
			rowData.put("assignTask", assignTask);
			rowData.put("created", activeCreatecount);
			rowData.put("pending", activePendingcount);
			rowData.put("verified", activeVerifycount);
			rowData.put("totalTask", totalactiveTasks);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("rowData for Active Pick :::::::::: " + rowData);
			System.out.println("rawDataJson for Active Pick :::::::::: " + rawDataJson);
			
			System.out.println(" ************** Master Pack ****************** ");
			//Master Pack Create Count.
			sql = " SELECT COUNT (DISTINCT PH.TRAN_ID) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, PACK_HDR PH WHERE W.WAVE_ID = WT.WAVE_ID AND WT.REF_ID = PH.TRAN_ID  " 
			    + " AND WT.STATUS ='N' AND W.CANCEL ='N' AND WT.REF_SER IN ('M-PACK') AND WT.WAVE_STATUS ='C' " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				mpackCreatecount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Master Pack Pending Count.
			sql = " SELECT COUNT(DISTINCT WT.REF_ID) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, PACK_HDR PH WHERE W.WAVE_ID = WT.WAVE_ID AND WT.REF_ID = PH.TRAN_ID " 
			  	+ " AND WT.REF_SER IN ('M-PACK') AND WT.STATUS ='N' AND W.CANCEL ='N' AND WT.WAVE_STATUS ='W' " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				mpackPendingcount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Master Pack Verify Count.
			sql = " SELECT COUNT(DISTINCT WT.REF_ID) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, PACK_HDR PH WHERE W.WAVE_ID = WT.WAVE_ID AND WT.REF_ID = PH.TRAN_ID " 
			  	+ " AND WT.REF_SER IN ('M-PACK') AND WT.STATUS ='Y' AND W.CANCEL ='N' AND WT.WAVE_STATUS ='V' " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				mpackVerifycount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			int totalmpacktasks = mpackCreatecount + mpackVerifycount + mpackPendingcount ;
			rowData = new JSONObject();
			assignTask = "Master pack";
			rowData.put("assignTask", assignTask);
			rowData.put("created", mpackCreatecount);
			rowData.put("pending", mpackPendingcount);
			rowData.put("verified", mpackVerifycount);
			rowData.put("totalTask", totalmpacktasks);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("rowData for Master pack :::::::::: " + rowData);
			System.out.println("rawDataJson for Master pack :::::::::: " + rawDataJson);
			
			System.out.println(" ************** Hazmet Case Pick ****************** ");
			// Hazmet Case Pick Create Count
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, PICK_ORD_HDR PH,ITEM I,PICK_ORD_DET PT WHERE W.WAVE_ID = WT.WAVE_ID " 
				+ " AND WT.REF_ID = PH.PICK_ORDER AND PH.PICK_ORDER = PT.PICK_ORDER AND PT.ITEM_CODE = I.ITEM_CODE AND I.HAZARDOUS ='Y' AND WT.WAVE_STATUS ='C' " 
				+ " AND WT.STATUS = 'N' AND WT.REF_SER IN('C-PICK') " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				hazmetCreateCount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Hazmet Case Pick Pending Count
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, PICK_ORD_HDR PH,ITEM I,PICK_ORD_DET PT WHERE W.WAVE_ID = WT.WAVE_ID " 
				+ " AND WT.REF_ID = PH.PICK_ORDER AND PH.PICK_ORDER = PT.PICK_ORDER AND PT.ITEM_CODE = I.ITEM_CODE AND I.HAZARDOUS ='Y' AND WT.WAVE_STATUS ='W' " 
				+ " AND WT.STATUS ='N' AND WT.REF_SER IN('C-PICK') " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				hazmetPendingCount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Hazmet Case Pick Verify Count
			sql = " SELECT COUNT ( DISTINCT PH.PICK_ORDER) AS COUNT FROM WAVE_TASK W, WAVE_TASK_DET WT, PICK_ORD_HDR PH,ITEM I,PICK_ORD_DET PT WHERE W.WAVE_ID = WT.WAVE_ID " 
				+ " AND WT.REF_ID = PH.PICK_ORDER AND PH.PICK_ORDER = PT.PICK_ORDER AND PT.ITEM_CODE = I.ITEM_CODE AND I.HAZARDOUS ='Y' AND WT.WAVE_STATUS ='V' " 
				+ " AND WT.REF_SER IN('C-PICK') " ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				hazmetVerifyCount = rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			int totalhazmetcasepicks = hazmetCreateCount + hazmetVerifyCount + hazmetPendingCount ;
			rowData = new JSONObject();
			assignTask = "Hazmat Case Pick"; 
			rowData.put("assignTask", assignTask);
			rowData.put("created", hazmetCreateCount);
			rowData.put("pending", hazmetPendingCount);
			rowData.put("verified", hazmetVerifyCount);
			rowData.put("totalTask", totalhazmetcasepicks);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("rowData for Hazmet Case Pick :::::::::: " + rowData);
			System.out.println("rawDataJson for Hazmet Case Pick :::::::::: " + rawDataJson);	
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}				
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ReplTask.getReplTaskDetails(String dataSourceName, String siteCode):" + d.getMessage());
				throw new ITMException(d);
			}
		}
	
		return rawDataJson;
	}
/*
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "0";
		}
		else
		{
			return str.trim();
		}

	}
*/
	
}

