/**
 *  PURPOSE  : DefaultItemChanged for Item Attribute Values master
 *  AUTHOR   : Samadhan On 21/04/2015  
 *  Obj_name : itm_attrib_val  
 *  Request Id:  D15AKAT013
 */


package ibase.webitm.ejb.wms;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class ItmAttribValIC extends ValidatorEJB implements ItmAttribValICRemote, ItmAttribValICLocal{

	/**
	 * The method defined with no parameter and returns nothing
	 */
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			if (currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr); 
			}
			if (hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr); 
			}
			if (allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr); 
			}
			System.out.println("Current Dom:{"+currXmlDataStr+"}");
			System.out.println("Header Dom:{"+hdrXmlDataStr+"}");
			System.out.println("All Dom:{"+allXmlDataStr+"}");

			errString = defaultItemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "Return String :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :Item Attribute val :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from Item Attribute Val itemChanged" );
		return errString;
	}


	public String defaultItemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		String siteCode = "";
		String errString = "";
		String chgUser="";
		String chgTerm="";
		int currentFormNo = 0;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String query="";
		StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n" );
		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver(); 
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			System.out.println("site code ->["+siteCode+"]");
			System.out.println("Current Column> > > > ->["+currentColumn+"]");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");

			valueXmlString.append("</Header>\r\n" );

			switch ( currentFormNo )
			{
			case 1:
			{
				if(currentColumn.trim()!=null)
				{
					if ( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						System.out.println("--------------item default --------------");
						valueXmlString.append( "<Detail1>\r\n" );
						if(editFlag.equalsIgnoreCase("A"))
						{
							valueXmlString.append( "<chg_user><![CDATA[" ).append( chgUser ).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );	
							valueXmlString.append( "<active_yn><![CDATA[" ).append("Y").append( "]]></active_yn>\r\n" );
						}

						valueXmlString.append( "</Detail1>\r\n" );

					}
					/*	if ( currentColumn.trim().equalsIgnoreCase( "itm_defaultedit" ))
					{
						System.out.println("Edit item default flag --------------"+editFlag);
						String descr = checkNull(genericUtility.getColumnValue("descr", currDom));
						System.out.println("Descr in item_defaultedit :-------------"+descr);
						valueXmlString.append( "<Detail1>\r\n" );
						if(editFlag.trim().equalsIgnoreCase("E"))
						{
							valueXmlString.append("<descr protect = '1'> <![CDATA[").append(descr).append("]]></descr>\r\n");	
						}

						valueXmlString.append( "</Detail1>\r\n" );
					}*/
					if ( currentColumn.trim().equalsIgnoreCase( "attrib_code" ))
					{
						String itemCode = checkNull(genericUtility.getColumnValue("attrib_code", currDom));
						System.out.println("item change itemCode := "+itemCode);
						if(itemCode != null)
						{
							query =" SELECT descr FROM item_attribute WHERE attrib_code=? " ;	
							pstmt = conn.prepareStatement(query);
							pstmt.setString(1, itemCode);
							rs = pstmt.executeQuery();
							valueXmlString.append( "<Detail1>\r\n" );
							if(rs.next())
							{
								valueXmlString.append("<item_attribute_descr>").append("<![CDATA[" + rs.getString(1) + "]]>").append("</item_attribute_descr>");
							}
							else
							{
								valueXmlString.append("<item_attribute_descr>").append("<![CDATA[]]>").append("</item_attribute_descr>");
							}
							valueXmlString.append( "</Detail1>\r\n" );
						}
					}
					if ( currentColumn.trim().equalsIgnoreCase( "attrib_id" ))
					{
						String attribCode = checkNull(genericUtility.getColumnValue("attrib_code", currDom));
						String attribId = checkNull(genericUtility.getColumnValue("attrib_id", currDom));
						System.out.println("item change attribId := "+attribCode);
						if(attribCode != null)
						{
							query = "select attrib_id from itm_attrib_val where attrib_id = ? and attrib_code='SIZE_TYPE'  ";
							pstmt= conn.prepareStatement(query);
							pstmt.setString(1, attribCode);
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								query ="select descr,sh_descr,udf__str1 from itm_attrib_val where attrib_id = ? and attrib_code='SIZE'" ;	
								pstmt1 = conn.prepareStatement(query);
								pstmt1.setString(1, attribId);
								rs1 = pstmt1.executeQuery();
								valueXmlString.append( "<Detail1>\r\n" );
								if(rs1.next())
								{
									valueXmlString.append("<descr>").append("<![CDATA[" + checkNull(rs1.getString(1)) + "]]>").append("</descr>");
									valueXmlString.append("<sh_descr>").append("<![CDATA[" + checkNull(rs1.getString(2)) + "]]>").append("</sh_descr>");
									valueXmlString.append("<udf__str1>").append("<![CDATA[" + checkNull(rs1.getString(3)) + "]]>").append("</udf__str1>");
								}
								else
								{
									valueXmlString.append("<descr>").append("<![CDATA[]]>").append("</descr>");
									valueXmlString.append("<sh_descr>").append("<![CDATA[]]>").append("</sh_descr>");
									valueXmlString.append("<udf__str1>").append("<![CDATA[]]>").append("</udf__str1>");
								}
								valueXmlString.append( "</Detail1>\r\n" );
								pstmt1.close();
								rs1.close();
							}
							pstmt.close();
							rs.close();			

						}
					}
				}
			}
			break;
			}
			valueXmlString.append( "</Root>\r\n" );
		}
		catch(Exception e)
		{
			System.out.println("Exception: FrightUpdIC: defaultItemChanged(Document dom): " + e.getMessage() + ":");
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);		
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;								
				}
				if( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;								
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception es)
			{
				es.printStackTrace();
				errString = genericUtility.createErrorString(es);
			}
		}
		System.out.println("ErrString ::"+errString);
		return valueXmlString.toString();		
	}

	private String checkNull( String input )
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}  

	@Override
	public String wfValData(Document dom, Document dom1, Document dom2,	String objContext, String editFlag, String xtraParams)
	throws RemoteException, ITMException {

		System.out.println("Samadhan wfValData.....called..");
		System.out.println("samadhan"+dom);
		System.out.println("samadhan"+dom);
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String attribCode ="";
		String attribId = "",shortDescr="",descr="";
		String query = "",shdescrSQL="";
		int ctr=0,currentFormNo =0,childNodeListLength =0;
		String userId="";
		String childNodeName = null,childNodeValue = null;
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		try
		{	 //Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn =  connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			E12GenericUtility genericUtility = new E12GenericUtility(); 
			descr = checkNull(genericUtility.getColumnValue("descr", dom));     // Sneha 
			//Changed by Jagruti on 24/12/2015 for short descr[Start].
			shortDescr = checkNull(genericUtility.getColumnValue("sh_descr", dom));
			//Changed by Jagruti on 24/12/2015 for short descr[End].
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{	
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					System.out.println("Node Name:="+childNodeName);

					if(childNodeName.equalsIgnoreCase("attrib_code") )
					{
						System.out.println("inside first child node Val:"+childNodeValue);

						if (childNode.getFirstChild() == null)
						{
							errString = getErrorString("attrib_code","VTFLDNVL",userId);
							break ;
						}
						else
						{
							//String itemCode = checkNull(genericUtility.getColumnValue("attrib_code", dom));
							String itemCode = checkNullAndTrim(genericUtility.getColumnValue("attrib_code", dom)); // Changed by Sneha on 09-08-2016
							//System.out.println("itemCode===>>["+itemCode+"]");
							
							query =" SELECT count(1) FROM item_attribute WHERE attrib_code=? " ;	
							pstmt = conn.prepareStatement(query);
							pstmt.setString(1, itemCode);
							rs = pstmt.executeQuery();
							int count=0;
							if(rs.next())
							{
								count = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							if(count == 0 )
							{	 
								errString = getErrorString("attrib_code","VTFLDNVL",userId);
								break ;
							}	
						}
					}
					else if(childNodeName.equalsIgnoreCase("attrib_id"))
					{
						if (childNode.getFirstChild() == null)
						{
							errString = getErrorString("attrib_id","VTATRIDNVL",userId);
							break ;
						}
						else
						{
							// Changed by Sneha on 09-08-2016, to trim the value [Start]
							//attribCode = checkNull(genericUtility.getColumnValue("attrib_code", dom));
							//attribId = checkNull(genericUtility.getColumnValue("attrib_id", dom));
							attribCode = checkNullAndTrim(genericUtility.getColumnValue("attrib_code", dom));
							attribId = checkNullAndTrim(genericUtility.getColumnValue("attrib_id", dom));
							//System.out.println("attribCode inside attrib_id ===>["+attribCode+"] attribId===>>"+attribId+"]");
							// Changed by Sneha on 09-08-2016, to trim the value [End]
							
							query = "select attrib_id from itm_attrib_val where attrib_id = ? and attrib_code='SIZE_TYPE'  ";
							pstmt= conn.prepareStatement(query);
							pstmt.setString(1, attribCode);
							rs=pstmt.executeQuery();
							if(rs.next())
							{	
								System.out.println("attrib_id" +attribCode);
								//Change by Jagruti for descr/short descr lenght[Start]
								if((descr.trim()).length()>15)
								{
									System.out.println("if  size greater for descr");
									errString = getErrorString("descr","VTSDESCLIM",userId);
								//Description/Short Descr should not be greater than 15 character for SIZE attribute
								}
								if((shortDescr.trim()).length()>15)
								{
									System.out.println("if  size greater for shortdescr");
									errString = getErrorString("sh_descr","VTSDESCLIM",userId);
									//Description/Short Descr should not be greater than 15 character for SIZE attribute
								}
								//Change by Jagruti for descr/short descr lenght[End]

								query ="select * from itm_attrib_val where attrib_id = ? and attrib_code='SIZE'" ;	
								pstmt1= conn.prepareStatement(query);
								pstmt1.setString(1, attribId);
								rs1 = pstmt1.executeQuery();
								if(!rs1.next())
								{
									errString = getErrorString("attrib_id","VTATRIDNIM",userId);
									pstmt1.close();
									rs1.close();
									break ;
								}

							}
							pstmt.close();
							rs.close();
						}
					}

					else if(childNodeName.equalsIgnoreCase("descr"))
					{
						if (childNode.getFirstChild() == null)
						{
							System.out.println(" descr null"+descr);
							errString = getErrorString("descr","VTDESCNVL",userId);
							break ;
						}
					}
					//Change by Jagruti on 25/12/2015 for Short Description[Start]
					else if(childNodeName.equalsIgnoreCase("sh_descr"))
					{
						if (childNode.getFirstChild() == null)
						{
							System.out.println("Short descr null"+shortDescr);
							errString = getErrorString("sh_descr","VTDESCNVL",userId);
							break ;
						}
					}
					//Change by Jagruti on 25/12/2015 for Short Description[End]

				}
				break;
			}
			
			// Changed by Sneha on 09-08-2016, to trim the value [Start]
			//attribCode = checkNull(genericUtility.getColumnValue("attrib_code", dom));
			//attribId = checkNull(genericUtility.getColumnValue("attrib_id", dom));
			attribCode = checkNullAndTrim(genericUtility.getColumnValue("attrib_code", dom));
			attribId = checkNullAndTrim(genericUtility.getColumnValue("attrib_id", dom));
			//System.out.println("attribCode outside ===>["+attribCode+"] attribId===>>"+attribId+"]");
			// Changed by Sneha on 09-08-2016, to trim the value [End]
			
			if(editFlag.equalsIgnoreCase("A"))
			{
				query =" SELECT count(1) FROM itm_attrib_val WHERE attrib_code=? and attrib_id=? " ;	
				pstmt = conn.prepareStatement(query);
				pstmt.setString(1, attribCode);
				pstmt.setString(2, attribId);
				rs = pstmt.executeQuery();
				int count=0;
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				pstmt.close();
				rs.close();
				if(count != 0 )
				{	 
					errString = getErrorString("attrib_id","VTDUPENTRY",userId);
					return errString;
				}	
			}

			if(attribCode.equalsIgnoreCase("COLOR"))
			{
				if((descr.trim()).length()>20)
				{
					errString = getErrorString("descr","VTDESCLIMT",userId);
				}
			}
			//Changed by Jagruti on 24/12/2015 for size length validation [Start]
			if(attribCode.equalsIgnoreCase("SIZE"))
			{
				System.out.println("if for size");
				if((descr.trim()).length()>15)
				{
					System.out.println("if  size greater than15 for descr");
					errString = getErrorString("descr","VTSDESCLIM",userId);
				}
				if((shortDescr.trim()).length()>15)
				{
					System.out.println("if  size greater than15 for shortdescr");
					errString = getErrorString("sh_descr","VTSDESCLIM",userId);
				}
			}
			//Changed by Jagruti on 24/12/2015 for size length validation [End]


			if(editFlag.equalsIgnoreCase("E"))
			{
				//Change by Jagruti on 24/12/2015  for edit mode[Start]
				//query =" SELECT DISTINCT DESCR FROM itm_attrib_val WHERE attrib_code=? and attrib_id=? " ;
				query =" SELECT DISTINCT DESCR ,SH_DESCR FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE=? AND ATTRIB_ID=? " ;
				//Change by Jagruti on 24/12/2015 for edit mode[End]
				pstmt = conn.prepareStatement(query);
				pstmt.setString(1, attribCode);
				pstmt.setString(2, attribId);
				rs = pstmt.executeQuery();
				String descrSQL="";
				if(rs.next())
				{
					descrSQL = rs.getString("DESCR");
					shdescrSQL=rs.getString("SH_DESCR");
				}
				pstmt.close();
				rs.close();
				if(!descrSQL.equalsIgnoreCase(descr) )
				{	System.out.println("in descr"+descr); 
				errString = getErrorString("descr","VTINTGMAGN",userId);
				return errString;
				}	
				//Change by Jagruti on 25/12/2015 for short descr in edit[Start]
				else if(!shdescrSQL.equalsIgnoreCase(shortDescr))
				{
					System.out.println("in short descr"+shortDescr);
					errString = getErrorString("sh_descr","VTINTGMAGN",userId);
					return errString;
				}
				//Change by Jagruti on 25/12/2015 for short descr in edit mode[End]
			}

		}catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
		}
		finally
		{
			try
			{

				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;								
				}	
				if( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;								
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}

			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}

	@Override
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;	
		String errString = "";
		try
		{
			System.out.println("xmlString:::"+xmlString);
			if (xmlString.trim().length() > 0 )
			{
				dom = parseString("<Root>" + xmlString+ "</Root>");
			}
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : Cpp : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}


	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom,
			Document allFormDataDom, String objContext, String xtraParams)
	throws RemoteException, ITMException {

		return null;
	}
	
	// Changed by Sneha on 09-08-2016 [Start]
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	// Changed by Sneha on 09-08-2016 [End]

}
