

package ibase.webitm.ejb.wms;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;

import javax.imageio.ImageIO;
import javax.naming.InitialContext;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import sun.misc.BASE64Decoder;

import com.adsionline.ADSIShippingWS.ADSIShippingLocator;
import com.adsionline.ADSIShippingWS.ADSIShippingSoap;
import com.adsionline.ADSIShippingWS.Address;
import com.adsionline.ADSIShippingWS.Carrier;
import com.adsionline.ADSIShippingWS.CommodityInfo;
import com.adsionline.ADSIShippingWS.Country;
import com.adsionline.ADSIShippingWS.EnumManifestAction;
import com.adsionline.ADSIShippingWS.EnumPackageType;
import com.adsionline.ADSIShippingWS.EnumTerms;
import com.adsionline.ADSIShippingWS.EnumTimeInTransit;
import com.adsionline.ADSIShippingWS.EnumUnitOfMeasure;
import com.adsionline.ADSIShippingWS.ImageRotation;
import com.adsionline.ADSIShippingWS.NameValuePair;
import com.adsionline.ADSIShippingWS.Package2;
import com.adsionline.ADSIShippingWS.PackageResult2;
import com.adsionline.ADSIShippingWS.ShipWithLabelType;
import com.adsionline.ADSIShippingWS.Shipment2;
import com.adsionline.ADSIShippingWS.ShipmentResult2;
import com.adsionline.ADSIShippingWS.ShipmentResultReturn2;
import com.adsionline.ADSIShippingWS.StringReturn;
@javax.ejb.Stateless
public class GeneShipLabelsPrc extends ProcessEJB implements GeneShipLabelsPrcLocal,GeneShipLabelsPrcRemote //SessionBean
{

	DistCommon discommon = new DistCommon();
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	String chgUser = null;

	ADSIShippingSoap  soap = null;

	public String process() throws RemoteException,ITMException
	{
		return "";
	}


	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("below genericUtility--------------->>>>>>>>>");
		try
		{	
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 
				System.out.println("headerDom" + headerDom);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 
				System.out.println("detailDom" + detailDom);
			}

			long startTime22 = System.currentTimeMillis();
			retStr = process(headerDom, detailDom, windowName, xtraParams);
			long endTime22 = System.currentTimeMillis();
			System.out.println("DIFFERANCE IN TIME FOR TOTAL PROCESS IN SECONDS:::["+(endTime22-startTime22)/1000+"]"); 
		}
		catch (Exception e)
		{
			System.out.println("Exception :StockAllocationPrcEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			retStr = e.getMessage();
			throw new ITMException(e);
		}
		return retStr;	
	}
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("detailDom------------------->"+detailDom);
		String childNodeName = "", siteCode = "";
		String errCode = "";		
		String errString = "";	
		String ptcn = "", tranCode = "", packCode = "";
		String sql = "",upddCartonsql = "" ,sqlChgStatus = "",sqlPrintStatus = "",
		sqlMaster = "",sqlCrtnChg = "",sqlGetTrack = "";
		String printStatus = "";
		String confirmed = "";
		String adsiShippingURL = "",imagePath = "";
		String masterCarton = "",itemCode = "",trackingNo = "",parcelCartonNo = "",
		cartonStatus = "",chgStatus = "";

		String tempItemCode = "";
		String value = "",outerCartonNo = "",trackNo = "",pckgId = "";
		long msnNo = 0;
		String packTranId = "",serviceCode = "",saleOrder = "", waveId = "";
		String printer = "";
		long oldMsnNo = 0;
		String oldCarrierSymbol = "",carrierSymbol ="";
		String oldCarrierFriendlyName = "",carrierFriendlyName = "";
		String response = "",refType = "",frtTerm = "",sSQL = "";
		Connection conn = null;		

		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		int count = 0,noArt = 0;
		int package2ArrSize = 0;

		double packSize = 0.0;
		double weight = 0.0,actWeight = 0.0,itemWeght = 0.0,shipQty = 0.0 ;	
		String packlength = "", packwidth = "", packheight = "";
		double totalFrtAmt = 0.0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;

		PreparedStatement pstmt = null,pstmt1 = null,ptcnPSTMT = null,
		pstmtUpdCarton = null,pstmtChg = null, pstmtPrintStatus = null,
		pstmtMaster = null,pstmtCrtnChg = null,pstmtGetTrack = null,pstmtDesp = null;	
		ResultSet rs = null,rs1 = null,ptcnRS = null ,rsPrintStatus = null,
		rsMaster = null,rsGetTrack = null;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		ADSIShippingLocator locator = null;

		List arryOuterCartonNo = new ArrayList();
		LinkedHashMap linkedMap = new LinkedHashMap();
		ArrayList ptcnList = new ArrayList();
		int pUpd = 0;
		String glblPTCN = "";
		String  siteCodeShip = "",stateCodeDlv = "",defPh="",quantity ="",itemCodeInput = "",cartonNo = "",pickOrder = "",lineNo = "",
		custName="",custShName = "",shipCity="",shipCountry = "",shipAdd1 = "",shipAdd2 = "",custCodeDlv = "",archivePath ="",shipArchive = "",
		shipAdd3 = "",shipPh="",shipFax ="",shipMailId = "",custPord = "",harmonizCode = "",harmonizDescr="",originCountry ="",
		pin ="",shipmentType = "",addName = "",addValue = "";
		double unitValue = 0.0 ,itemheight= 0.0,itemWidth =0.0 ,itemLength = 0.0;
		String shipAdd4 = "",shipAdd5 = "",shipAdd6 = "",tempShipAdd="";
		DistCommon distCommon = new DistCommon();
		String projectName = "";


		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//connDriver = null;	
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			/*chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");*/

			parentNodeList = headerDom.getElementsByTagName("Detail1");
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for(int ctr = 0; ctr < childNodeListLength; ctr++)
			{	
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();
				System.out.println("childNodeName.editFlag." + childNodeName+".."+childNode.getFirstChild());
			}

			siteCode = genericUtility.getColumnValue("site_code",headerDom);
			ptcn = genericUtility.getColumnValue("ptcn",headerDom);
			packCode = genericUtility.getColumnValue("pack_code",headerDom);
			tranCode = genericUtility.getColumnValue("tran_code",headerDom);
			printer = genericUtility.getColumnValue("printer_name",headerDom);	
			itemCodeInput = genericUtility.getColumnValue("item_code",headerDom);	
			quantity = genericUtility.getColumnValue("quantity",headerDom);	
			System.out.println("ptcn: "+ptcn);
			System.out.println("packCode: "+packCode);
			System.out.println("tranCode: "+tranCode);
			System.out.println("printer: "+printer);
			System.out.println("itemCode: "+itemCodeInput);
			System.out.println("quantity: "+quantity);

			upddCartonsql = "UPDATE CARTON_MASTER SET PACK_CODE = ?,TRACKING_NO = ?,MSN_NO = ? ,CARRIER_SYMBOL = ?,CARRIER_FRIENDLYNAME = ? WHERE CARTON_NO = ?";
			pstmtUpdCarton = conn.prepareStatement(upddCartonsql);


			sqlChgStatus = "UPDATE WAVE_STATUS_ORG SET PRINT_STATUS = ?,TRAN_CODE__NEW =(SELECT TRAN_CODE FROM DESPATCH WHERE PTCN =?) WHERE PTCN = ?";
			pstmtChg = conn.prepareStatement(sqlChgStatus);

			sqlPrintStatus = "SELECT DISTINCT PRINT_STATUS FROM WAVE_STATUS_ORG WHERE PTCN = ?";
			pstmtPrintStatus = conn.prepareStatement(sqlPrintStatus);


			sqlMaster = "SELECT MASTER_CARTON,TRACKING_NO,CARTON_NO,STATUS,CHANGE_STATUS,MSN_NO,CARRIER_SYMBOL,CARRIER_FRIENDLYNAME,CARTON_TYPE " +
			" ,FILLER_WEIGHT,TARE_WEIGHT " + 
			" FROM CARTON_MASTER WHERE PTCN = ? AND CARTON_TYPE <> ? ORDER BY CARTON_NO,MASTER_CARTON";
			pstmtMaster = conn.prepareStatement(sqlMaster);

			sqlCrtnChg = "UPDATE CARTON_MASTER SET CHANGE_STATUS = ? WHERE PTCN = ?";
			pstmtCrtnChg = conn.prepareStatement(sqlCrtnChg);

			sqlGetTrack = 	" SELECT TRACKING_NO,MSN_NO,CARRIER_SYMBOL , CARRIER_FRIENDLYNAME FROM CARTON_MASTER WHERE CARTON_NO = ?";
			pstmtGetTrack = conn.prepareStatement(sqlGetTrack);

			long timeBefore = System.currentTimeMillis();
			adsiShippingURL = discommon.getDisparams("999999","WMS_ADSI_SOAP_URL",conn);
			imagePath = discommon.getDisparams("999999","SHIP_WITH_PATH",conn);
			//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
			projectName = distCommon.getDisparams("999999","PROJECT",conn);
			//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]
			System.out.println("adsiShippingURL -->"+adsiShippingURL);
			System.out.println("imagePath -->"+imagePath);
			locator = new ADSIShippingLocator();
			System.out.println(" Connecting ADSI server ................");
			soap = locator.getADSIShippingSoap(new URL(adsiShippingURL));
			long timeAfter = System.currentTimeMillis();
			System.out.println(" is server active ["+soap.testADSIServer()+"]");    			    		
			if(!soap.testADSIServer())
			{
				errString = itmDBAccessEJB.getErrorString("","ADSISRVERR","","",conn);
				return errString;
			}   

			if( ptcn.trim().length() > 0 && packCode == null)
			{
				sql = "SELECT DISTINCT(S.PACK_CODE) FROM  WAVE_TASK_DET W, SORDDET S WHERE W.SALE_ORDER = S.SALE_ORDER AND W.PTCN = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ptcn);
				rs = pstmt.executeQuery();
				if( rs.next())
				{
					packCode = rs.getString(1);
				}
				rs.close(); rs = null;
				pstmt.close(); pstmt = null;
				System.out.println("old packCode : "+packCode);
			}

			if( ptcn.trim().length() > 0 && tranCode == null)
			{
				sql = "SELECT DISTINCT(S.TRAN_CODE) FROM  WAVE_TASK_DET W, SORDER S WHERE W.SALE_ORDER = S.SALE_ORDER AND W.PTCN = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ptcn);
				rs = pstmt.executeQuery();
				if( rs.next())
				{
					tranCode = rs.getString(1);
				}
				rs.close(); rs = null;
				pstmt.close(); pstmt = null;
				System.out.println("old tranCode: "+tranCode);
			}

			if(( packCode.trim().length() > 0 && ptcn.trim().length() > 0 ) || ( tranCode.trim().length() > 0 && ptcn.trim().length() > 0 ))
			{
				sql = " SELECT DISTINCT PTCN,SALE_ORDER,REF_TYPE FROM WAVE_TASK_DET WHERE  PTCN = ? AND REF_TYPE IN (?,?,?) ";
				ptcnPSTMT = conn.prepareStatement(sql);
				ptcnPSTMT.setString(1, ptcn);
				ptcnPSTMT.setString(2, "M");
				ptcnPSTMT.setString(3, "P");
				ptcnPSTMT.setString(4, "A");
				ptcnRS = ptcnPSTMT.executeQuery();
			}

			while(ptcnRS.next())
			{
				saleOrder = ptcnRS.getString("SALE_ORDER");
				ptcn = ptcnRS.getString("PTCN");
				refType = ptcnRS.getString("REF_TYPE");

				if(ptcnList.contains(ptcn))
				{
					continue;
				}
				else
				{
					ptcnList.add(ptcn);
				}

				pstmtPrintStatus.setString(1, ptcn);
				rsPrintStatus = pstmtPrintStatus.executeQuery();
				if(rsPrintStatus.next())
				{
					printStatus = rsPrintStatus.getString("PRINT_STATUS");
				}

				sql = "SELECT SERVICE_CODE,SHIPMENT_TYPE FROM TRANSPORTER WHERE TRAN_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranCode);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					serviceCode = rs.getString(1);
					shipmentType = rs.getString(2);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = "SELECT DISTINCT(WAVE_ID) FROM WAVE_TASK_DET WHERE PTCN = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ptcn);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					waveId = rs.getString(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("wave id is ---["+waveId+"]");

				System.out.println("printStatus ["+printStatus+"] serviceCode ["+serviceCode+"]");			
				if( "Y".equalsIgnoreCase(printStatus) && "NO".equalsIgnoreCase(serviceCode))
				{
					/*errString = itmDBAccessEJB.getErrorString("","ALLREPRINT","","",conn);
							return errString;*/
					continue;
				}			


				File file = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+"Ship"+".ser" );
				System.out.println("file IS ["+file+"]");
				if(!file.exists())
				{

					HashMap sordMap = getSordInfo(saleOrder,conn);

					//	sql = "SELECT POD.PICK_ORDER,POD.LINE_NO FROM PICK_ORD_DET POD, PICK_ISS_HDR PIH WHERE POD.PICK_ORDER = PIH.PICK_ORDER AND PIH.PTCN = ? AND POD.ITEM_CODE = ? ";
					sql = "SELECT PICK_ORDER,LINE_NO FROM PICK_ORD_DET  WHERE PICK_ORDER IN ( SELECT REF_ID FROM WAVE_TASK_DET  " +
					"WHERE REF_SER = 'A-PICK' AND PTCN = ? AND ROWNUM = 1) AND ITEM_CODE =   ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, ptcn);
					pstmt.setString(2, itemCodeInput);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						pickOrder = rs.getString(1);
						lineNo = rs.getString(2);
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					HashMap itmVolumeMap = getItemVolumeMap(itemCodeInput, "", conn);
					harmonizDescr = (String)itmVolumeMap.get("HARMONIZATION_DESCR");
					harmonizCode = (String)itmVolumeMap.get("HARMONIZATION_NO");
					itemWeght = (Double)itmVolumeMap.get("ITEM_WEIGHT");
					itemheight = (Double)itmVolumeMap.get("ITEM_HEIGHT");
					itemWidth = (Double)itmVolumeMap.get("ITEM_WID");
					itemLength = (Double)itmVolumeMap.get("ITEM_LEN");

					originCountry = (String)itmVolumeMap.get("ORIGIN_COUNTRY");

					double volume = itemheight * itemWidth * itemLength;

					/*errString = itmDBAccessEJB.getErrorString("","FILENFOUND","");
					return errString;*/
					sql = 	"SELECT CARTON_NO FROM CARTON_MASTER  WHERE PTCN= ?  AND PICK_ORDER = ? AND LINE_NO__PICK = ?" ;
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, ptcn);
					pstmt1.setString(2, pickOrder);
					pstmt1.setString(3, lineNo);

					rs1 = pstmt1.executeQuery();

					if( rs1.next())
					{
						cartonNo = rs1.getString(1);;
					}
					else
					{


						//(String pickOrder,int lineNo,Double noArt,String ptcn,String refSeries,String xtraParams,Connection conn,double weight,double volume, String packType,String itemCode,String facilityCode,String locTypeParent,String packCode)throws Exception
						cartonNo = updateCartonMaster(pickOrder, Integer.parseInt(lineNo), 1.0, ptcn, "A-PICK", xtraParams, conn, itemWeght, volume, "A", itemCodeInput, "", "N",packCode);

					}

					rs1.close(); rs1 = null;
					pstmt1.close(); pstmt1 = null;


					Shipment2 shipment2 = new Shipment2();	
					Address recipient = new Address();//To set the Address
					custName = (String)sordMap.get("CUST_NAME");
					custShName = (String)sordMap.get("SH_NAME");

					shipAdd1 = checkNull((String)sordMap.get("ADDR1")).trim();
					shipAdd2 = checkNull((String)sordMap.get("ADDR2")).trim();
					shipAdd3 = checkNull((String)sordMap.get("ADDR3")).trim();

					shipCity = (String)sordMap.get("CITY");
					stateCodeDlv = (String)sordMap.get("STATE_DLV");
					shipCountry = (String)sordMap.get("COUNT_CODE");	
					shipPh = (String)sordMap.get("PHONE");	
					shipMailId = (String)sordMap.get("EMAIL_ID");	
					shipFax = (String)sordMap.get("FAX");	
					custPord = (String)sordMap.get("CUST_PORD");	
					//serviceCode = (String)sordMap.get("SERVICE_CODE");
					pin = (String)sordMap.get("DLV_PIN");
					//shipmentType =  (String)sordMap.get("SHIPMENT_TYPE");

					shipAdd4 = checkNull((String)sordMap.get("ADDR4")).trim();
					shipAdd5 = checkNull((String)sordMap.get("ADDR5")).trim();
					shipAdd6 = checkNull((String)sordMap.get("ADDR6")).trim();

					projectName = distCommon.getDisparams("999999","PROJECT",conn);

					//Changed by Jagruti Shinde  as per WaveGenerationPrc[Start]
					/*if("DDUK".equalsIgnoreCase(projectName))
					{ 
						tempShipAdd = shipAdd3;
						shipAdd3 = shipAdd1+" "+shipAdd2;
						shipAdd2 = tempShipAdd+" "+shipAdd4;
						shipAdd1 = shipAdd5;
						stateCodeDlv = shipAdd6;
					}*/
					if("DDUK".equalsIgnoreCase(projectName))
					{ 
						tempShipAdd = shipAdd3;
						/*shipAdd3 = shipAdd1+" "+shipAdd2;
						shipAdd2 = tempShipAdd+" "+shipAdd4;
						shipAdd1 = shipAdd5;*/
						shipAdd3 = shipAdd1;
						shipAdd2 = shipAdd2;
						shipAdd1 = tempShipAdd;
						stateCodeDlv = shipAdd6;
					}
					//Changed by Jagruti Shinde as per WaveGenerationPrc[End]

					shipment2.setID(waveId);
					recipient.setID(custCodeDlv);//Customer Code
					recipient.setContact(custName);//Customer Name

					recipient.setCompany("");//Customer Company Name

					if(!"".equalsIgnoreCase(shipAdd3) && shipAdd3.length() > 0)
					{
						recipient.setAddress1(shipAdd3);//Customer Adress1
						recipient.setAddress2(shipAdd2);//Customer Adress2
						recipient.setAddress3(shipAdd1);//Customer Adress3
					}
					else if(!"".equalsIgnoreCase(shipAdd2) && shipAdd2.length() > 0)
					{
						recipient.setAddress1(shipAdd2);//Customer Adress1
						recipient.setAddress2(shipAdd1);//Customer Adress2
						recipient.setAddress3("");
					}
					else
					{
						recipient.setAddress1(shipAdd1);//Customer Adress1
						recipient.setAddress2("");//Customer Adress2
						recipient.setAddress3("");
					}
					//Chnaged by Rohan on 21-08-13 for shipAddrs 3 is blank then set address 2.end
					recipient.setCity(shipCity);//Customer Adress City
					recipient.setState(stateCodeDlv);//Customer Adress State
					//Changed By Pragyan to overcome from postal code error
					shipCountry = shipCountry!=null?shipCountry.trim():"";
					Country country = soap.getCountry("ISO3", shipCountry).getResponseCountry();
					recipient.setCountry(country);//Customer Adress Country

					defPh = discommon.getDisparams("999999","SHIPPER_DEFAULT_PH",conn);
					if(shipPh == null || shipPh.trim().length()== 0)
					{
						recipient.setPhone(defPh);
					}
					else
					{
						recipient.setPhone(shipPh);
					}

					System.out.println("phone no is: "+recipient.getPhone());
					recipient.setEMail(shipMailId);
					recipient.setFax(shipFax);
					recipient.setPostalCode(pin);
					System.out.println("pin code is :"+recipient.getPostalCode());
					shipment2.setRecipient(recipient);
					System.out.println("service code "+serviceCode);
					//HardCoded valus needs to be change later.
					com.adsionline.ADSIShippingWS.Service service = new com.adsionline.ADSIShippingWS.Service();
					//service.setFriendlyName(serviceCode);
					service.setFriendlyName(serviceCode);

					//service.setSymbol(serviceCode);	
					//System.out.println("Service symbol  is :"+service.getSymbol());
					shipment2.setService(service);
					System.out.println("Service name is :"+shipment2.getService());
					System.out.println("Service code is :"+serviceCode);

					shipment2.setTerms(EnumTerms.trmSHIPPER);
					shipment2.setSignatureReleaseFlag(false);//false  As per Taro
					shipment2.setSignatureRequiredFlag(false);//true Required As per Taro
					shipment2.setSaturdayDeliveryFlag(false);// Taro Need To clerify "what is based on service level?"

					java.util.Date date = new java.util.Date();
					Calendar calendar = Calendar.getInstance();
					calendar.setTime(date);
					shipment2.setShipDate(calendar);

					shipment2.setConsigneeAccount("");//Not Required As per Taro
					shipment2.setThirdPartyBillingFlag(false);//Not Required As per Taro
					shipment2.setThirdPartyBillingAccount("");//Not Required As per Taro
					Address addrs = new Address();//Need to capture if required
					shipment2.setThirdPartyBillingAddress(addrs);//Not Required As per Taro

					shipment2.setHALFlag(false);//Need clarification from Taro
					shipment2.setHALAddress(addrs);//Need clarification from Taro

					shipment2.setManifestAction(EnumManifestAction.maRELEASE);//As per taro by default its maRELEASE


					shipment2.setConsigneeBillingFlag(false);//As per Taro Not Required
					shipment2.setConsigneeBillingFlag(false);//As per Taro Not Required
					shipment2.setShipperReference(ptcn);//As per Taro use PTCN(Pick Ticket Control No)
					shipment2.setConsigneeReference(custPord);//As per Taro it is sorder.cust_pord

					if(shipmentType != null && shipmentType.trim().length() > 0)
					{
						shipment2.setShipperName(shipmentType);
					}
					else
					{
						shipment2.setShipperName("Taro Commercial");//Needs to change after clarity
					}

					shipment2.setTimeInTransit(EnumTimeInTransit.tntFOREVER);
					shipment2.setSaturdayDeliveryFlag(false);



					//

					NameValuePair[] additionalFields = new NameValuePair[1];
					additionalFields[0] = new NameValuePair("carton_no", cartonNo);

					Package2[] packgeList = new Package2[1];
					CommodityInfo[] infoCom = null;
					String nafFlag = discommon.getDisparams("999999","NAFTA_FLAG_COUNT",conn);
					String carrPackDescr = discommon.getDisparams("999999","CARR_PKG_DESC",conn);
					String sqlQuery = "",sqlSize = "";
					Package2 pkg2 = null;					
					pkg2 =  new Package2();
					pkg2.setID(cartonNo);
					sqlSize = "SELECT C.PACK_CODE,C.TARE_WEIGHT,C.FILLER_WEIGHT, P.LENGTH , P.WIDTH , P.HEIGHT " 
						+" FROM CARTON_MASTER C,PACKING P WHERE C.PACK_CODE = P.PACK_CODE AND C.CARTON_NO  = ? ";
					pstmt1 = conn.prepareStatement(sqlSize);

					pstmt1.setString(1, cartonNo);
					rs1 = pstmt1.executeQuery();

					double slength = 0.0, width = 0.0, height = 0.0, tareWt = 0.0, fillerWt = 0.0;
					if(rs1.next())
					{
						slength =rs1.getDouble("LENGTH");																					
						width = rs1.getDouble("WIDTH");
						height =rs1.getDouble("HEIGHT");
						tareWt  = rs1.getDouble("TARE_WEIGHT");
						fillerWt  = rs1.getDouble("FILLER_WEIGHT");
					}						

					/*String strlen = ""+itemLength;
					String widthStr = ""+itemWidth;
					String heightStr = ""+itemheight;*/
					String strlen = ""+slength;
					String widthStr = ""+width;
					String heightStr = ""+height;
					System.out.println("strlen = ["+slength+"]");
					System.out.println("widthStr = ["+width+"]");
					System.out.println("heightStr = ["+height+"]");
					pkg2.setDimension(strlen+"x"+widthStr+"x"+heightStr);	
					pkg2.setDescription(carrPackDescr); 
					pkg2.setOversizeFlag(false);//As per Taro 
					pkg2.setDeclaredValueFlag(false);//As per Taro 
					pkg2.setDeclaredValueAmount(0.0);//As per Taro not required
					pkg2.setDeclaredValueCustoms(0.0);//As per Taro not required
					pkg2.setBillOfLadingComment("");//As per Taro not required
					pkg2.setAdditionalHandlingFlag(false);//As per Taro false
					pkg2.setPackaging(EnumPackageType.pkgCUSTOM);//As per Taro default pkgCUSTOM
					pkg2.setCODFlag(false);//As per Taro false
					pkg2.setCODAmount(0.0);//As per Taro not required 
					pkg2.setCODPaymentType(0);//As per Taro not required 
					Address addr = new Address();
					pkg2.setCODReturnAddress(addr);//As per Taro not required 
					pkg2.setAdditionalFields(additionalFields);


					pkg2.setHazmatFlag(false);


					double qty = Double.parseDouble(quantity);	
					actWeight = actWeight + itemWeght * qty;
					System.out.println("WEIGHT IS"+actWeight);
					pkg2.setWeight(actWeight);
					linkedMap.put(itemCodeInput, qty);
					CommodityInfo[] comInfo = new CommodityInfo[linkedMap.size()];
					comInfo = setCommodityInfos(linkedMap, masterCarton, saleOrder, soap,refType, conn);
					pkg2.setCommodityInfos(infoCom);
					packgeList[0] = pkg2;	
					shipment2.setPackages2(packgeList);

					errString =  updateTRackingNo(saleOrder,ptcn,waveId,tranCode, sordMap,shipment2 ,conn);

					if(errString != null && errString.indexOf("Errors") != -1)
					{
						return errString;
					}
					//


				}
				else
				{
					FileInputStream fis = new FileInputStream(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+"Ship"+".ser" );
					ObjectInputStream ois = new ObjectInputStream(fis);
					System.out.println(" file loaded ");
					Shipment2 shipment2 = (Shipment2) ois.readObject();   	    
					System.out.println("objReturn2 ["+shipment2.getPackages2().length+"]" );

					package2ArrSize = shipment2.getPackages2().length;
					System.out.println("package2ArrSize ["+package2ArrSize+"]");			
					Package2[] packages2 = new Package2[package2ArrSize];
					packages2 = shipment2.getPackages2();

					com.adsionline.ADSIShippingWS.Service service = new com.adsionline.ADSIShippingWS.Service();
					service = shipment2.getService();				
					System.out.println("Retriving the Package For update ["+packages2.toString()+"]");

					if( !"NO".equalsIgnoreCase(serviceCode))
					{
						System.out.println(" old service code ["+service.getFriendlyName()+"]");
						System.out.println(" new service code ["+serviceCode+"]");
						service.setFriendlyName(serviceCode);
					}


					if( "N".equalsIgnoreCase(printStatus) || !"NO".equalsIgnoreCase(serviceCode) )
					{

						pstmtMaster.setString(1, ptcn);
						pstmtMaster.setString(2, "C");
						rsMaster = pstmtMaster.executeQuery();

						double fillerWt=0.0;
						double tareWt=0.0;

						while(rsMaster.next())
						{
							fillerWt=0.0;
							tareWt=0.0; 

							linkedMap.clear();
							masterCarton = rsMaster.getString("MASTER_CARTON");
							System.out.println("masterCarton ["+masterCarton+"]");
							parcelCartonNo  = rsMaster.getString("CARTON_NO");
							cartonStatus = rsMaster.getString("STATUS");
							chgStatus = rsMaster.getString("CHANGE_STATUS");
							oldMsnNo =  rsMaster.getLong("MSN_NO");
							oldCarrierSymbol =  rsMaster.getString("CARRIER_SYMBOL");
							refType =  rsMaster.getString("CARTON_TYPE");

							System.out.println("parcelCartonNo ["+parcelCartonNo+"]CARRIER_SYMBOL["+oldCarrierSymbol+"]["+oldMsnNo+"]Change Status["+chgStatus+"]");

							if("M".equalsIgnoreCase(refType))
							{
								boolean isExist = false;
								tempItemCode = "";
								int itemCount = 0;

								sql = 	" SELECT CM.ITEM_CODE,WOD.WEIGHT FROM CARTON_MASTER CM, WAVE_STATUS_ORG_DET WOD WHERE CM.PTCN = WOD.PTCN " +
								" AND CM.CARTON_NO = WOD.CARTON_NO AND CM.MASTER_CARTON = ? AND CM.CARTON_TYPE = ? AND CM.STATUS <> ? " +
								" ORDER BY CM.ITEM_CODE";
								pstmt1 = conn.prepareStatement(sql);
								pstmt1.setString(1, masterCarton);
								pstmt1.setString(2, "C");
								pstmt1.setString(3, "R");

								rs1 = pstmt1.executeQuery();

								while( rs1.next())
								{
									isExist = true;							
									packSize = rs1.getDouble("WEIGHT");
									itemCode = rs1.getString("ITEM_CODE");

									weight = weight + packSize;
									linkedMap.put(itemCode, weight);
								}
								System.out.println("Map data  ["+linkedMap.toString()+"]");
								rs1.close(); rs1 = null;
								pstmt1.close(); pstmt1 = null;

								if("R".equalsIgnoreCase(cartonStatus))
								{						

									if(packages2[count] != null)
									{

										System.out.println("UPDATING For MSN NO R ["+packages2[count].getTrackingNumber()+"]");
										System.out.println("UPDATING For MSN NO R ["+packages2[count].getWeight()+"]");
									}
									packages2[count] = null;

									System.out.println("CHANGES NOT EXIST[" +count+"]Master Carton ["+masterCarton+"]chgStatus["+chgStatus+"]");

									if("Y".equalsIgnoreCase(chgStatus))
									{
										StringReturn testReturn = soap.voidPackage(oldCarrierSymbol,oldMsnNo);
										response =  testReturn.getResponse();
										System.out.println("response  Master Carton void----["+response+"] for master carton["+masterCarton+"]");	
									}

									count++;

									continue;
								}
								else
								{

									if( weight > 0.0)
									{
										if(packages2[count] != null)
										{
											System.out.println("UPDATING For MSN NO weight ["+packages2[count].getTrackingNumber()+"]");
											System.out.println("UPDATING For MSN NO weight ["+packages2[count].getWeight()+"]");
										}

										arryOuterCartonNo.add(masterCarton);
										CommodityInfo[] comInfo = new CommodityInfo[linkedMap.size()];
										comInfo = setCommodityInfos(linkedMap, masterCarton, saleOrder, soap,refType, conn);				
										System.out.println("old weight ["+packages2[count].getWeight()+"]");
										System.out.println("new weight ["+weight+"]"); 

										System.out.println("weight afer add f and t wt ====>[[[[ "+weight);

										fillerWt=rsMaster.getDouble("FILLER_WEIGHT");
										tareWt=rsMaster.getDouble("TARE_WEIGHT");

										System.out.println("FILLER_WEIGHT====>[[[[ "+fillerWt);
										System.out.println("TARE_WEIGHT====>[[[[ "+tareWt);

										weight = weight + fillerWt + tareWt;
										System.out.println("weight + TARE_WEIGHT + tareWt ====>[[[[ "+weight);

										packages2[count].setWeight(weight);
										System.out.println("old comodity info length ["+packages2[count].getCommodityInfos().length+"]");
										System.out.println("new comodity info length ["+comInfo.length+"]");
										packages2[count].setCommodityInfos(comInfo);
									}
									else
									{


										if(packages2[count] != null)
										{
											System.out.println("UPDATING For MSN NO void ["+packages2[count].getTrackingNumber()+"]");
											System.out.println("UPDATING For MSN NO void ["+packages2[count].getWeight()+"]");
										}
										System.out.println("In case of weight zero ["+weight+"]");
										packages2[count] = null;

										System.out.println("ON ELSE BLOCK CHANGES NOT EXIST[" +count+"]Master Carton ["+masterCarton+"]chgStatus["+chgStatus+"]");

										if("Y".equalsIgnoreCase(chgStatus))
										{
											StringReturn testReturn = soap.voidPackage(oldCarrierSymbol,oldMsnNo);
											response =  testReturn.getResponse();
											System.out.println("on else response  Master Carton void----["+response+"] for master carton["+masterCarton+"]");	
										}

									}
									count++;
								}
								weight = 0;

								System.out.println(" arryOuterCartonNo.size ["+arryOuterCartonNo.size()+"]");

							}
							else
							{
								if("R".equalsIgnoreCase(cartonStatus))
								{
									packages2[count] = null;
									StringReturn testReturn = soap.voidPackage(oldCarrierSymbol,oldMsnNo);
									response =  testReturn.getResponse();
									System.out.println("response  Parcel void----["+response+"]");		
								}
								else
								{
									arryOuterCartonNo.add(parcelCartonNo);
									System.out.println("for ref typ["+refType+"]");	

									if("A".equalsIgnoreCase(refType) )
									{

										sql = 	"SELECT ITEM_CODE,SUM(QUANTITY - CASE WHEN DEALLOC_QTY IS NULL THEN 0 ELSE CASE WHEN DEALLOC_QTY IS NULL"
											+" THEN 0 ELSE DEALLOC_QTY END END) AS QTY FROM PICK_ORD_DET WHERE CARTON_NO = ? GROUP BY ITEM_CODE";
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1, parcelCartonNo);
										rs1 = pstmt1.executeQuery();

										while( rs1.next())
										{

											itemCode = rs1.getString("ITEM_CODE");	
											shipQty = rs1.getDouble("QTY");	
											HashMap itmVolumeMap = getItemVolumeMap(itemCode, "", conn);
											itemWeght = (Double)itmVolumeMap.get("ITEM_WEIGHT");
											weight = weight + itemWeght * shipQty;
											linkedMap.put(itemCode, shipQty);
										}

										rs1.close(); rs1 = null;
										pstmt1.close(); pstmt1 = null;

										System.out.println("Map data A ["+linkedMap.toString()+"]");

										CommodityInfo[] comInfo = new CommodityInfo[linkedMap.size()];
										comInfo = setCommodityInfos(linkedMap, masterCarton, saleOrder, soap,refType, conn);				
										System.out.println("old weight ["+packages2[count].getWeight()+"]");
										System.out.println("new weight ["+weight+"]");

										System.out.println("weight afer add f and t wt ====>[[[[ "+weight);

										fillerWt=rsMaster.getDouble("FILLER_WEIGHT");
										tareWt=rsMaster.getDouble("TARE_WEIGHT");

										System.out.println("FILLER_WEIGHT====>[[[[ "+fillerWt);
										System.out.println("TARE_WEIGHT====>[[[[ "+tareWt);

										weight = weight + fillerWt + tareWt;
										System.out.println("weight + TARE_WEIGHT + tareWt ====>[[[[ "+weight);

										sql = 	" SELECT LENGTH,WIDTH,HEIGHT FROM PACKING WHERE PACK_CODE = ? ";
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1, packCode);
										rs1 = pstmt1.executeQuery();

										if( rs1.next())
										{
											packlength = rs1.getString(1);
											packwidth = rs1.getString(2);
											packheight = rs1.getString(3);
										}
										rs1.close(); rs1 = null;
										pstmt1.close(); pstmt1 = null;

										packages2[count].setWeight(weight);									
										packages2[count].setDimension(packlength+"x"+packwidth+"x"+packheight);
										System.out.println("old comodity info length ["+packages2[count].getCommodityInfos().length+"]");
										System.out.println("new comodity info length ["+comInfo.length+"]");
										packages2[count].setCommodityInfos(comInfo);
									}
								}

								oldMsnNo = 0;oldCarrierSymbol = "";
								oldCarrierFriendlyName = "";
								count++;
							}

						}
						pstmtMaster.clearParameters();
						if( rsMaster != null)
						{
							rsMaster.close(); 
							rsMaster = null;
						}


					}

					if( arryOuterCartonNo.size() == 0)
					{

						pstmtCrtnChg.setString(1, "N");
						pstmtCrtnChg.setString(2, ptcn);
						pstmtCrtnChg.executeUpdate();
						pstmtChg.setString(1, "Y");
						pstmtChg.setString(2, ptcn);
						pstmtChg.setString(3, ptcn);
						int test = pstmtChg.executeUpdate();

						errString = itmDBAccessEJB.getErrorString("Void Records Successfully","NOTHING2PR","");
						System.out.println("Only Voiding the Error ["+errString+"]");
						errString = "";

					}
					else
					{
						System.out.println("arryOuterCartonNo ["+arryOuterCartonNo.toString()+"]");

						System.out.println("actual package size ["+packages2.length+"]");
						Collections.sort(arryOuterCartonNo);
						shipment2.setPackages2(packages2); 

						java.util.Date date = new java.util.Date();
						Calendar calendar = Calendar.getInstance();
						calendar.setTime(date);
						shipment2.setShipDate(calendar);

						System.out.println("Generating Label for the date ["+calendar.getTime().getTime()+"]");

						ShipmentResultReturn2 objReturn2=soap.shipWithLabel(shipment2, ShipWithLabelType.PNG, ImageRotation.Rotation_Default);
						System.out.println("Is successfully Executed ["+objReturn2.isSuccess()+"]");
						System.out.println("Return Messages ["+objReturn2.getMessage()+"]");
						if(!objReturn2.isSuccess())
						{
							errString = getError(objReturn2.getMessage(),"SOAPURLUAL", conn);
							return errString;
						}
						else
						{
							ShipmentResult2 objShipResult = objReturn2.getShipmentResultResponse2();
							int  lenPacakges =  objShipResult.getPackageResults2().length;		

							carrierSymbol= objShipResult.getServiceSymbol();
							System.out.println("serviceSymbol["+carrierSymbol+"]");
							carrierSymbol = carrierSymbol.substring(0,carrierSymbol.lastIndexOf(".") );
							System.out.println("Carrier Symbol ["+carrierSymbol+"]");

							Carrier[] carr = soap.getCarriers().getCarrierList();
							for(int j = 0;j<carr.length;j++)
							{
								Carrier carr1 = carr[j];
								System.out.println("Carrier Symbol["+carr1.getSymbol());
								System.out.println("Friendly Name["+carr1.getFriendlyName());
								System.out.println("Short Name["+carr1.getShortName());

								if(carr1.getSymbol().equalsIgnoreCase(carrierSymbol))
								{
									carrierFriendlyName = carr1.getFriendlyName();
									break;
								}


							}
							System.out.println("lenPacakges"+lenPacakges);
							for(int pCtr=0;pCtr < lenPacakges;pCtr++)
							{
								PackageResult2 pkg2frm =  (PackageResult2)objShipResult.getPackageResults2()[pCtr];	
								value = pkg2frm.getBase64Label();
								pckgId = pkg2frm.getPackageID();

								pkg2frm.getAdditionalFields();
								trackNo = pkg2frm.getTrackingNumber();
								msnNo =  pkg2frm.getMSN();
								for(int Cadd=0;Cadd<pkg2frm.getAdditionalFields().length;Cadd++)
								{
									System.out.println("additional fields are Name:"+pkg2frm.getAdditionalFields()[Cadd].getName());
									System.out.println("additional fields are Value:"+pkg2frm.getAdditionalFields()[Cadd].getValue());
								}

								String cnumber = arryOuterCartonNo.get(pCtr).toString();
								System.out.println("cnumber is :"+cnumber);
								System.out.println("Package ID["+pckgId+"]");
								System.out.println("New Tracking No --------------["+pkg2frm.getTrackingNumber()+"]");
								System.out.println("NeW MSN No -------------------["+msnNo+"]");
								System.out.println("BASE64lABEL Length["+value.length()+"]");
								BASE64Decoder decoder = new BASE64Decoder(); 
								System.out.println("Package id for carton no is :[" +decoder.decodeBuffer(pckgId) +"]");
								//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
								System.out.println("getAdditionalFields:::::"+pkg2frm.getAdditionalFields().length);
								for(int Cadd=0;Cadd<pkg2frm.getAdditionalFields().length;Cadd++)
								{
									addName = pkg2frm.getAdditionalFields()[Cadd].getName();
									addValue = pkg2frm.getAdditionalFields()[Cadd].getValue();
									
									if("Base64ArchiveDoc".equalsIgnoreCase(addName.trim()))
									{
										shipArchive = addValue;
										System.out.println("additional fields are Name for Base64ArchiveDoc:"+addName);
										System.out.println("additional fields are Value for Base64ArchiveDoc:"+addValue);
										byte[] imgBytes = decoder.decodeBuffer(addValue);    
										System.out.println("IMAGE Byte Length for Base64ArchiveDoc:["+imgBytes.length+"]");
										BufferedImage bufImg = ImageIO.read(new ByteArrayInputStream(imgBytes)); 						
										File imgOutFile = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+cnumber +"_Archive" +".png");
										File file2 = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+cnumber +"_Archive" +".png");

										if(!file2.exists())
										{
											archivePath = imgOutFile.getPath();
											System.out.println("Get Path for file not exist ArchiveDoc["+archivePath+"]");
											File createFolder = new File(archivePath);

											if(!createFolder.exists())
											{
												createFolder.mkdirs();
											}
											imgOutFile.createNewFile();
											ImageIO.write(bufImg, "png", imgOutFile);
											System.out.println("Write File Complete for Base64ArchiveDoc----");
										}
										else
										{
											File oldFile = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+cnumber +"_Archive"+"_old.png");
											if(!oldFile.exists())
											{
												file2.renameTo(oldFile);
											}
											archivePath = imgOutFile.getPath();
											System.out.println("Get Path for file exist Base64ArchiveDoc["+archivePath+"]");
											File createFolder = new File(archivePath);

											if(!createFolder.exists())
											{
												createFolder.mkdirs();
											}
											imgOutFile.createNewFile();
											ImageIO.write(bufImg, "png", imgOutFile);
											System.out.println("Write File Complete for new Base64ArchiveDoc----");
										}
									}
								}

								//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]

								byte[] imgBytes = decoder.decodeBuffer(value);    
								System.out.println("IMAGE Byte Length ["+imgBytes.length+"]");
								BufferedImage bufImg = ImageIO.read(new ByteArrayInputStream(imgBytes)); 						
								File imgOutFile = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+cnumber +".png");
								File file1 = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+cnumber +".png");

								if(!file1.exists())
								{
									//errString = itmDBAccessEJB.getErrorString("","FILENFOUND","");
									//return errString;
								}
								else
								{
									File oldFile = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+cnumber +"_old.png");
									if(!oldFile.exists())
									{
										file1.renameTo(oldFile);
									}
								}
								String path = imgOutFile.getPath();
								System.out.println("Get Path ["+path+"]");
								path = path.substring(0,path.lastIndexOf(File.separator));
								System.out.println("after Path ["+path+"]");
								File createFolder = new File(path);
								if(!createFolder.exists())
								{
									createFolder.mkdirs();
								}

								pstmtGetTrack.setString(1, cnumber);
								rsGetTrack = pstmtGetTrack.executeQuery();

								if( rsGetTrack.next() )
								{
									oldMsnNo = rsGetTrack.getLong("MSN_NO");
									oldCarrierSymbol = rsGetTrack.getString("CARRIER_SYMBOL");
									oldCarrierFriendlyName = rsGetTrack.getString("CARRIER_FRIENDLYNAME");

									if(oldMsnNo != 0 && oldMsnNo != msnNo)
									{
										StringReturn testReturn = soap.voidPackage(oldCarrierSymbol,oldMsnNo);
										response =  testReturn.getResponse();
										System.out.println("response delete not old msn as new msn["+response+"]");

										if(!response.contains("No Error"))
										{
											//errString = itmDBAccessEJB.getErrorString(response,"NTVOIDPKGS","");
											//errString =  getError(response, "NTVOIDPKGS", conn);
											//return errString;

										}
									}
								}

								pstmtGetTrack.clearParameters();

								pstmtUpdCarton.setString(1, packCode);		
								pstmtUpdCarton.setString(2, trackNo);		
								pstmtUpdCarton.setLong(3, msnNo);		
								pstmtUpdCarton.setString(4, carrierSymbol);
								pstmtUpdCarton.setString(5, carrierFriendlyName);
								pstmtUpdCarton.setString(6, cnumber);
								int test = pstmtUpdCarton.executeUpdate();
								System.out.println("update statement is :"+test);
								if(test==1)
								{
									System.out.println("updated");						
								}
								else
								{
									System.out.println("not updated");
								}								


								imgOutFile.createNewFile();
								ImageIO.write(bufImg, "png", imgOutFile);
								System.out.println("Write File Complete----");				

							}



							pstmtChg.setString(1, "Y");
							pstmtChg.setString(2, ptcn);		
							pstmtChg.setString(3, ptcn);		
							int test = pstmtChg.executeUpdate();
							if( test > 0)
							{
								System.out.println(" WAVE_STATUS_ORG table updated ");

								int wavOrgUpdCount = reUpdateWaveOrgMasterCartonNo(ptcn, conn);
								System.out.println(" WAVE_STATUS_ORG_DET table updated ["+wavOrgUpdCount+"]");
							}
							else
							{				
								throw new Exception("WAVE_STATUS_ORG table table updated");					
							}


							pstmtCrtnChg.setString(1, "N");
							pstmtCrtnChg.setString(2, ptcn);

							test = pstmtCrtnChg.executeUpdate();

							if( test > 0)
							{
								System.out.println("Carton Master table updated ");
							}
							else
							{				
								throw new Exception("Carton Master  updated");					
							}

							HashMap sordMap = getSordInfo(saleOrder,conn);
							frtTerm = (String)sordMap.get("FRT_TERM");
							totalFrtAmt = objShipResult.getTotal();
							System.out.println("Update in desp update freight Amt totalFrtAmt ["+totalFrtAmt+"] For frtTerm["+frtTerm+"]saleOrder["+saleOrder+"]");

							if("B".equalsIgnoreCase(frtTerm))
							{
								sSQL = "UPDATE DESPATCH SET FREIGHT_AMT_ADD = ? WHERE PTCN = ?";
								pstmtDesp = conn.prepareStatement(sSQL);
								pstmtDesp.setDouble(1, totalFrtAmt);
								pstmtDesp.setString(2, ptcn);
								pUpd = pstmtDesp.executeUpdate();

								System.out.println("Update in desp update freight Amt upd ["+pUpd+"] For");    					

								if(pstmtDesp != null)
								{
									pstmtDesp.close();
									pstmtDesp = null;


								}

								sSQL = "UPDATE SHIP_DOCS SET FREIGHT_AMT_ADD = ? WHERE PTCN = ?";
								pstmtDesp = conn.prepareStatement(sSQL);
								pstmtDesp.setDouble(1, totalFrtAmt);
								pstmtDesp.setString(2, ptcn);	    					
								pUpd = pstmtDesp.executeUpdate();

								System.out.println("Update in Ship Docs update freight Amt upd ["+pUpd+"] For");

								if(pstmtDesp != null)
								{
									pstmtDesp.close();
									pstmtDesp = null;

								}
							}

						}

					}
				}

			}//while(ptcnRS.next())

			if(ptcnRS != null)
			{
				ptcnRS.close();
				ptcnRS = null;
			}

			if(ptcnPSTMT != null)
			{
				ptcnPSTMT.close();
				ptcnPSTMT = null;
			}

			if(pstmtUpdCarton != null)
			{
				pstmtUpdCarton.close();
				pstmtUpdCarton = null;
			}

			if(pstmtChg != null)
			{
				pstmtChg.close();
				pstmtChg = null;
			}

			if(rsPrintStatus != null)
			{
				rsPrintStatus.close();
				rsPrintStatus = null;
			}

			if(pstmtPrintStatus != null)
			{
				pstmtPrintStatus.close();
				pstmtPrintStatus = null;
			}

			if( rsMaster != null)
			{
				rsMaster.close(); 
				rsMaster = null;
			}

			if(pstmtCrtnChg != null)
			{
				pstmtCrtnChg.close(); 
				pstmtCrtnChg = null;
			}

			if(pstmtMaster != null)
			{
				pstmtMaster.close();
				pstmtMaster = null;
			}

			if(pstmtGetTrack != null)
			{
				pstmtGetTrack.close();
				pstmtGetTrack = null;
			}

			if(rsGetTrack != null)
			{
				rsGetTrack.close();
				rsGetTrack = null;
			}

			/*if(printer != null && printer.trim().length()>0)
			{
				errString =	generatedLabelPrint(waveId,glblPTCN, printer, conn);
			}*/

		}	
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch(Exception es)
			{
				es.printStackTrace();
				errString = es.getMessage();			
				throw new ITMException(es);
			}
			e.printStackTrace();
			System.out.println("Exception :GenerateLabels :process(String xmlString2, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			errString = e.getMessage();			
			throw new ITMException(e);
		}
		finally
		{
			//System.out.println("Closing Connection....");
			try
			{				
				if(rs1 != null)
				{
					rs1.close(); rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close(); pstmt1 = null;
				}

				if( rs != null)
				{
					rs.close(); rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close(); pstmt = null;
				}


				if(ptcnRS != null)
				{
					ptcnRS.close();
					ptcnRS = null;
				}

				if(ptcnPSTMT != null)
				{
					ptcnPSTMT.close();
					ptcnPSTMT = null;
				}

				if(pstmtUpdCarton != null)
				{
					pstmtUpdCarton.close();
					pstmtUpdCarton = null;
				}

				if(pstmtChg != null)
				{
					pstmtChg.close();
					pstmtChg = null;
				}

				if(rsPrintStatus != null)
				{
					rsPrintStatus.close();
					rsPrintStatus = null;
				}

				if(pstmtPrintStatus != null)
				{
					pstmtPrintStatus.close();
					pstmtPrintStatus = null;
				}

				if( rsMaster != null)
				{
					rsMaster.close(); 
					rsMaster = null;
				}

				if(pstmtCrtnChg != null)
				{
					pstmtCrtnChg.close(); 
					pstmtCrtnChg = null;
				}

				if(pstmtMaster != null)
				{
					pstmtMaster.close();
					pstmtMaster = null;
				}


				if (errString != null && errString.trim().length() > 0)
				{
					conn.rollback();
					System.out.println("errString ::::::::::::::::::::"+errString);
					return errString;
				}			
				else
				{
					conn.commit();				
				}

				if( errString.trim().length() == 0 )
				{
					errString="VTCOMPL";
					errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
				}

				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				throw new ITMException(e);			
			}
			finally
			{
				/*if( errString.trim().length() == 0 )
				{
					errString="VTCOMPL";
					errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
				}*/
				//return errString;
			}

		}
		return errString;

		/*catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch(Exception es)
			{
				es.printStackTrace();
				errString = es.getMessage();			
				throw new ITMException(es);
			}
			e.printStackTrace();
			System.out.println("Exception :GenerateLabels :process(String xmlString2, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			errString = e.getMessage();			
			throw new ITMException(e);
		}
			//=========================
		return errString;*/
	}
	public String isTranCodeChanged(String ptcn, Connection conn) throws ITMException
	{
		String sql = "";		
		String shipTranCode = "",cartonMasterTranCode = "";	
		String errString = "";
		String serviceCode = "";

		PreparedStatement pstmt = null;
		ResultSet rs = null;

		String siteCodeShip= "";
		try
		{
			sql = "SELECT TRAN_CODE FROM WAVE_STATUS_ORG WHERE PTCN = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, ptcn);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cartonMasterTranCode = rs.getString("TRAN_CODE");
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;

			sql = " SELECT DISTINCT S.SITE_CODE__SHIP FROM SORDER S, WAVE_TASK W, WAVE_TASK_DET WT " +
			" WHERE W.WAVE_ID = WT.WAVE_ID AND S.SALE_ORDER = WT.SALE_ORDER AND WT.PTCN = ? ";
			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, ptcn );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				siteCodeShip = checkNull(rs.getString("SITE_CODE__SHIP"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;		

			sql = "SELECT ST.TRAN_CODE, ST.SERVICE_CODE FROM SHIPMENT S, SHIP_DOCS SD, SITE_TRANSPORTER ST WHERE SD.PTCN = ? " +
			" AND S.SHIPMENT_ID = SD.SHIPMENT_ID AND S.TRAN_CODE = ST.TRAN_CODE AND ST.SITE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, ptcn);
			pstmt.setString(2, siteCodeShip);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				System.out.println("from site_transporter");
				shipTranCode = rs.getString("TRAN_CODE");
				serviceCode = rs.getString("SERVICE_CODE");
			}
			else
			{
				System.out.println("from transporter");
				sql =  " SELECT S.TRAN_CODE,T.SERVICE_CODE FROM SHIPMENT S , SHIP_DOCS SD, TRANSPORTER T WHERE SD.PTCN = ? " +
				" AND S.SHIPMENT_ID = SD.SHIPMENT_ID AND S.TRAN_CODE = T.TRAN_CODE ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ptcn);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					shipTranCode = rs.getString("TRAN_CODE");
					serviceCode = rs.getString("SERVICE_CODE");
				}
				else
				{
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;

					sql = "SELECT ST.TRAN_CODE,ST.SERVICE_CODE FROM DESPATCH D,WAVE_TASK_DET W, SITE_TRANSPORTER ST "
						+" WHERE D.DESP_ID = W.REF_ID AND W.REF_SER='S-DSP'" 
						+" AND ST.TRAN_CODE = D.TRAN_CODE AND W.PTCN = ? AND ST.SITE_CODE = ? ";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, ptcn);
					pstmt.setString(2, siteCodeShip);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						shipTranCode = rs.getString("TRAN_CODE");
						serviceCode = rs.getString("SERVICE_CODE");
					}
					else
					{
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						sql = "SELECT T.TRAN_CODE,T.SERVICE_CODE FROM DESPATCH D,WAVE_TASK_DET W,TRANSPORTER T "
							+" WHERE D.DESP_ID = W.REF_ID AND W.REF_SER='S-DSP'" 
							+" AND T.TRAN_CODE = D.TRAN_CODE AND W.PTCN = ?";

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, ptcn);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							shipTranCode = rs.getString("TRAN_CODE");
							serviceCode = rs.getString("SERVICE_CODE");
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;					
					}
				}
			}


			if( cartonMasterTranCode.equalsIgnoreCase(shipTranCode))
			{
				return "NO";				
			}
			else
			{
				return serviceCode;
			}

		}
		catch(Exception e)
		{
			errString = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null )
				{
					rs.close(); rs = null;
				}
				if(pstmt != null )
				{
					pstmt.close(); pstmt = null;
				}				
			}
			catch(Exception e)
			{

				e.printStackTrace();
				throw new ITMException(e);
			}
		}

	}

	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}
	private CommodityInfo[] setCommodityInfos(LinkedHashMap linkMap,String masterCarton,String saleOrder,ADSIShippingSoap  soap,String cartonType ,Connection conn) throws ITMException
	{
		String itemCode = "";
		String harmonizDescr = "";
		String harmonizCode = "";
		String originCountry = "";
		String nafFlag = "";
		String shipCountry = "";

		double unitValue = 0,caseWeight = 0,itemWeight = 0;
		double packSizeCase = 0,noArt =0;
		CommodityInfo[] commoList;
		int cCtr = 0;
		try
		{

			System.out.println("GenerateLabelsPrc.setCommodityInfos()");
			System.out.println("list.size ["+linkMap.size()+"]");
			commoList = new CommodityInfo[linkMap.size()];
			nafFlag = discommon.getDisparams("999999","NAFTA_FLAG_COUNT",conn);
			CommodityInfo comInfo = new CommodityInfo();
			Iterator it = linkMap.keySet().iterator();

			while(it.hasNext())
			{
				itemCode = (String)it.next();
				comInfo = new CommodityInfo();
				System.out.println(" item_code ["+itemCode+"]");

				if(!"A".equalsIgnoreCase(cartonType))
				{
					HashMap itmVolumeMap = getItemVolumeMap(itemCode, "", conn);
					harmonizDescr = (String)itmVolumeMap.get("HARMONIZATION_DESCR");
					harmonizCode = (String)itmVolumeMap.get("HARMONIZATION_NO");
					caseWeight = (Double)itmVolumeMap.get("PACK_WEIGHT");
					originCountry = (String)itmVolumeMap.get("ORIGIN_COUNTRY");
					packSizeCase = (Double)itmVolumeMap.get("PACK_SIZE");
					noArt = getItemCount(masterCarton, itemCode, conn);
					comInfo.setQuantity(noArt * packSizeCase);
				}
				else
				{
					HashMap itmVolumeMap = getItemVolumeMap(itemCode, "", conn);
					harmonizDescr = (String)itmVolumeMap.get("HARMONIZATION_DESCR");
					harmonizCode = (String)itmVolumeMap.get("HARMONIZATION_NO");
					caseWeight = (Double)itmVolumeMap.get("ITEM_WEIGHT");
					originCountry = (String)itmVolumeMap.get("ORIGIN_COUNTRY");
					packSizeCase = (Double)itmVolumeMap.get("PACK_SIZE");

					noArt = (Double)linkMap.get(itemCode);
					comInfo.setQuantity(noArt);
				}

				unitValue = getRateStdoum(saleOrder, itemCode, conn);				
				comInfo.setDescription(harmonizDescr);//As per taro Harmonization description

				comInfo.setHarmonizedCode(harmonizCode);//As per Taro Haromonization code
				comInfo.setUnitValue(unitValue);
				comInfo.setUnitWeight(caseWeight);
				Country originCountryMfg = soap.getCountry("ISO3", originCountry).getResponseCountry();
				comInfo.setOriginCountry(originCountryMfg);
				HashMap sordMap = getSordInfo(saleOrder,conn);
				shipCountry = sordMap.get("COUNT_CODE").toString();
				System.out.println(" shipCountry  ["+shipCountry+"]harmonizDescr["+harmonizDescr);
				if(nafFlag.indexOf(shipCountry) != -1)
				{
					comInfo.setNaftaFlag(true);
					System.out.println("available in disparm");
				}
				else
				{
					System.out.println("not in disparm");
					comInfo.setNaftaFlag(false);
				}

				Calendar calendar = Calendar.getInstance();
				comInfo.setExportNumberExpireDate(calendar);
				comInfo.setUnitOfMeasure(EnumUnitOfMeasure.uomPCS);
				commoList[cCtr] = comInfo;
				cCtr++;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}

		return commoList;
	}
	private HashMap getSordInfo(String saleOrder,Connection conn) throws ITMException
	{
		String sql = "";
		ResultSet rs = null;

		PreparedStatement pstmt = null;
		HashMap sordInfoMap = new HashMap();
		String custCode = "",stanCode = "",siteCodeShip = "",stateCodeDlv = "",shipConsGrp = ""
			,custName="",custShName = "",shipCity="",shipCountry = "",shipAdd1 = "",shipAdd2 = "",shipAdd3 = "",shipAdd4 = "",
			shipAdd5 = "",shipAdd6 = "",licenceNo = "",tranCode = "",transMod ="",
			shipPh="",shipFax ="",shipMailId = "",custPord = "",frtTerm="",dlvPin ="";
		java.sql.Date lincenceUpto = null;
		String projectName = "";
		try
		{
			//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]	
			/*sql = "SELECT C.CUST_CODE AS CUST_CODE," 
				+" C.STAN_CODE AS STAN_CODE," 
				+" S.SITE_CODE__SHIP AS SHIP_CODE," 
				+" S.CUST_PORD AS CUST_PORD," 
				+" C.STATE_CODE AS STATE_DLV," 
				+" C.SHIP_CONS_GRP AS  SHIP_CONS_GRP," 
				+" C.CUST_NAME AS  CUST_NAME,"
				+" C.SH_NAME AS  SH_NAME,"
				+" C.ADDR1 AS  ADDR1,"
				+" C.ADDR2 AS  ADDR2,"
				+" C.ADDR3 AS  ADDR3,"
				+" C.CITY AS  CITY,"
				+" C.COUNT_CODE AS  COUNT_CODE,"
				+" C.TELE1 AS  PHONE,"
				+" C.FAX AS  FAX,"
				+" C.EMAIL_ADDR AS  EMAIL_ID,"
				//changed by Pragyan on 23/12/13 for getting FRT TERM.
				+" S.FRT_TERM AS  FRT_TERM,S.DLV_PIN AS DLV_PIN"
				+" FROM SORDER S,CUSTOMER C "
				+ " WHERE S.CUST_CODE__DLV = C.CUST_CODE "
				+ " AND S.SALE_ORDER = ? ";
			 */

			sql = " SELECT S.CUST_CODE__DLV AS CUST_CODE,"
				+" S.STAN_CODE AS STAN_CODE,"
				+" S.SITE_CODE__SHIP AS SHIP_CODE,"
				+" S.CUST_PORD AS CUST_PORD,"
				+" S.STATE_CODE__DLV AS STATE_DLV,"
				+" C.SHIP_CONS_GRP AS  SHIP_CONS_GRP,"
				+" S.DLV_TO AS  CUST_NAME,"
				+" C.SH_NAME AS  SH_NAME,"
				+" S.DLV_ADD1 AS  ADDR1,"
				+" S.DLV_ADD2 AS  ADDR2,"
				+" S.DLV_ADD3 AS  ADDR3,"
				+" S.NOTIFY_ADD1 AS  ADDR4," 
				+" S.NOTIFY_ADD2 AS  ADDR5,"
				+" S.NOTIFY_ADD3 AS  ADDR6,"
				+" S.DLV_CITY AS  CITY,"
				+" S.COUNT_CODE__DLV AS  COUNT_CODE,"
				+" S.TEL1__DLV AS  PHONE,"
				+" S.FAX__DLV AS  FAX,"
				+" C.EMAIL_ADDR AS  EMAIL_ID,"
				+" C.DRUG_LIC_NO_1 AS  DRUG_LIC_NO_1,"
				+" C.DRUG_LICNO1_UPTO AS  DRUG_LICNO1_UPTO, "
				+" S.DLV_PIN AS  DLV_PIN, "
				+" S.FRT_TERM AS  FRT_TERM";

			if("DDUK".equalsIgnoreCase(projectName))
			{
				sql = sql +", S.TRAN_CODE AS  TRAN_CODE," 
				+" S.TRANS_MODE AS  TRANS_MODE";
			}
			sql = sql+" FROM SORDER S,CUSTOMER C"
			+" WHERE S.CUST_CODE__DLV = C.CUST_CODE "
			+" AND S.SALE_ORDER = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,saleOrder);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				custCode = rs.getString("CUST_CODE");
				stanCode = rs.getString("STAN_CODE");
				siteCodeShip = rs.getString("SHIP_CODE");
				stateCodeDlv = rs.getString("STATE_DLV");
				shipConsGrp = rs.getString("SHIP_CONS_GRP");
				custName = rs.getString("CUST_NAME");
				custShName = rs.getString("SH_NAME");
				shipCity = rs.getString("CITY");
				shipAdd1 = rs.getString("ADDR1");
				shipAdd2 = rs.getString("ADDR2");
				shipAdd3 = rs.getString("ADDR3");
				shipAdd4 = rs.getString("ADDR4");
				shipAdd5 = rs.getString("ADDR5");
				shipAdd6 = rs.getString("ADDR6");
				shipCountry = rs.getString("COUNT_CODE");
				shipPh = rs.getString("PHONE");
				shipMailId = rs.getString("EMAIL_ID");
				shipFax = rs.getString("FAX");
				custPord = rs.getString("CUST_PORD");
				frtTerm = rs.getString("FRT_TERM");
				dlvPin = rs.getString("DLV_PIN");
				licenceNo =  rs.getString("DRUG_LIC_NO_1");
				lincenceUpto =  rs.getDate("DRUG_LICNO1_UPTO");
				frtTerm =  rs.getString("FRT_TERM");
				if("DDUK".equalsIgnoreCase(projectName))
				{
					tranCode = rs.getString("TRAN_CODE");				
					transMod = rs.getString("TRANS_MODE");
				}
			}

			sordInfoMap.put("CUST_CODE", custCode);
			sordInfoMap.put("STAN_CODE", stanCode);
			sordInfoMap.put("SHIP_CODE", siteCodeShip);
			sordInfoMap.put("STATE_DLV", stateCodeDlv);
			sordInfoMap.put("CUST_NAME", custName);
			sordInfoMap.put("SH_NAME", custShName);
			sordInfoMap.put("CITY", shipCity);
			sordInfoMap.put("ADDR1", shipAdd1);
			sordInfoMap.put("ADDR2", shipAdd2);
			sordInfoMap.put("ADDR3", shipAdd3);
			sordInfoMap.put("ADDR4", shipAdd4);
			sordInfoMap.put("ADDR5", shipAdd5);
			sordInfoMap.put("ADDR6", shipAdd6);
			sordInfoMap.put("COUNT_CODE", shipCountry);
			sordInfoMap.put("PHONE", shipPh);
			sordInfoMap.put("EMAIL_ID", shipMailId);
			sordInfoMap.put("FAX", shipFax);
			sordInfoMap.put("CUST_PORD", custPord);
			//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]

			if(shipConsGrp != null && shipConsGrp.length() > 0 )
			{
				sordInfoMap.put("SHIP_CONS_GRP", shipConsGrp);
			}
			else
			{
				sordInfoMap.put("SHIP_CONS_GRP", custCode);
			}
			sordInfoMap.put("FRT_TERM", frtTerm);
			sordInfoMap.put("DLV_PIN", dlvPin);

			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			System.out.println("Exception in  == >"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1)
			{
				throw new ITMException(e1);
			}
		}
		return sordInfoMap;	
	}
	private HashMap getItemVolumeMap(String itemCode,String lotNo,Connection con)throws Exception
	{
		double packSize = 0,itemSize = 0,lotSize = 0;
		PreparedStatement pstmt = null;		
		String sql="",hazardous = "";		
		String harmonizCode = "",harmonizDescr = "",originCountry = "";
		ResultSet rs = null;
		double itmLen = 0,itmWidth = 0,itmHeight = 0,itemWeight = 0,lotLen = 0 ,lotHeight = 0,lotWidth = 0,lotWeight = 0;
		HashMap dataVolumeMap = new HashMap();

		try {			

			sql = "SELECT I.LENGTH ITEM_LEN,I.WIDTH ITEM_WID,I.HEIGHT ITEM_HEIGHT,I.GROSS_WEIGHT ITEM_WEIGHT,I.HAZARDOUS HAZARD, " 
				+" I.HARMONIZATION_NO HARMONIZATION_NO,I.HARMONIZATION_DESCR HARMONIZATION_DESCR,I.COUNT_CODE__MFG ORIGIN_COUNTRY,"
				+" L.LENGTH LITEM_LEN,L.WIDTH LITEM_WID,L.HEIGHT LITEM_HEIGHT,L.SHIPPER_SIZE SHIPSIZE,L.GROSS_WEIGHT LOT_WEIGHT FROM"
				+" ITEM I,ITEM_LOT_PACKSIZE L"
				+" WHERE I.ITEM_CODE = L.ITEM_CODE"
				+" AND L.LOT_NO__FROM <= ? AND L.LOT_NO__TO >= ?"
				+" AND  I.ITEM_CODE = ?";				  

			pstmt = con.prepareStatement(sql);
			if(lotNo != null && lotNo.length() > 0)
			{
				pstmt.setString(1, lotNo);
				pstmt.setString(2, lotNo);
			}
			else
			{
				pstmt.setString(1, "00");
				pstmt.setString(2, "ZZ");
			}
			pstmt.setString(3, itemCode);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				itmLen = rs.getDouble("ITEM_LEN");
				itmWidth = rs.getDouble("ITEM_WID");
				itmHeight = rs.getDouble("ITEM_HEIGHT");
				itemWeight = rs.getDouble("ITEM_WEIGHT");
				hazardous = rs.getString("HAZARD");
				lotLen = rs.getDouble("LITEM_LEN");
				lotWidth = rs.getDouble("LITEM_WID");
				lotHeight = rs.getDouble("LITEM_HEIGHT");				
				packSize = rs.getDouble("SHIPSIZE");				
				lotWeight = rs.getDouble("LOT_WEIGHT");
				harmonizCode = rs.getString("HARMONIZATION_NO");
				harmonizDescr = rs.getString("HARMONIZATION_DESCR");
				originCountry = rs.getString("ORIGIN_COUNTRY");
			}

			//packSize = (lotHeight * lotWidth * lotLen)/(itmLen * itmWidth * itmHeight);
			/*itemSize = Math.floor(itmLen * itmWidth * itmHeight);
			lotSize = Math.floor((lotHeight * lotWidth * lotLen));*/
			itemSize = itmLen * itmWidth * itmHeight;
			lotSize = lotHeight * lotWidth * lotLen;

			dataVolumeMap.put("PACK_SIZE", packSize);
			dataVolumeMap.put("ITEM_SIZE", itemSize);
			dataVolumeMap.put("LOT_SIZE", lotSize);
			dataVolumeMap.put("HAZARDOUS", hazardous);
			dataVolumeMap.put("ITEM_WEIGHT", itemWeight);
			dataVolumeMap.put("PACK_WEIGHT", lotWeight);
			dataVolumeMap.put("HARMONIZATION_NO", harmonizCode);
			dataVolumeMap.put("HARMONIZATION_DESCR", harmonizDescr);
			dataVolumeMap.put("ORIGIN_COUNTRY", originCountry);
			dataVolumeMap.put("ITEM_LEN", itmLen);
			dataVolumeMap.put("ITEM_WID", itmWidth);
			dataVolumeMap.put("ITEM_HEIGHT", itmHeight);
			dataVolumeMap.put("LITEM_LEN", lotLen);
			dataVolumeMap.put("LITEM_WID", lotWidth);
			dataVolumeMap.put("LITEM_HEIGHT", lotHeight);

			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;

			}
			if(rs != null)
			{
				rs.close();
				rs = null;

			}



		} catch (Exception e) {

			throw e;
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
				if(rs != null)
				{
					rs.close();
					rs = null;

				}
			}
			catch(Exception e)
			{
				throw e;
			}
		}

		return dataVolumeMap;
	}
	private double getRateStdoum(String saleOrder,String itemCode,Connection conn) throws ITMException
	{
		String sql = "";
		double rateStdOum = 0.0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{

			sql =   " SELECT RATE__STDUOM FROM SORDDET WHERE  SALE_ORDER = ? AND ITEM_CODE = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, saleOrder);
			pstmt.setString(2, itemCode);


			rs = pstmt.executeQuery();
			if( rs.next())
			{
				rateStdOum = rs.getDouble(1);

			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;	 

		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		return rateStdOum;
	}

	private double getItemCount(String masterCarton,String itemCode, Connection conn) throws ITMException
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		double count = 0;

		try
		{
			sql = "SELECT COUNT(*) FROM CARTON_MASTER WHERE MASTER_CARTON = ? AND CARTON_TYPE = ? AND ITEM_CODE = ? AND STATUS <> ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, masterCarton);
			pstmt.setString(2, "C");
			pstmt.setString(3, itemCode);
			pstmt.setString(4, "R");
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				count = rs.getDouble(1);
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
			System.out.println(" item count ["+count+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null)
				{
					rs.close(); rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close(); pstmt = null;
				}
			}
			catch(Exception es)
			{
				es.printStackTrace();
				throw new ITMException(es);
			}
		}

		return count;
	}
	private String generatedLabelPrint(String waveId, String ptcn, String printer, Connection conn) throws ITMException
	{

		String errString ="";
		String printMode = "";
		String outputFilename = "";
		TreeMap argMap = null;
		String isReplenishment = "N";
		String saleOrder = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{    		

			String reportObjName = discommon.getDisparams("999999","WAVE_LABEL_OBJ_NAME",conn);			
			System.out.println("Printer *->["+printer.trim()+"]  report_obj_name ["+reportObjName+"] waveId ->["+waveId+"]");		
			ibase.webitm.reports.utility.JasperReportGenerator jrGenerator = new ibase.webitm.reports.utility.JasperReportGenerator();
			String xsdString ="<Arguments>" +
			"<Argument id=\"WAVE_ID\" name=\"WAVE_ID\">" +
			"<argType>java.lang.String</argType>" +								
			"<value>"+waveId+"</value>" +
			"</Argument>";

			if(ptcn != null && ptcn.length() > 0)
			{
				xsdString = xsdString +
				"<Argument id=\"PTCN\" name=\"PTCN\">" +
				"<argType>java.lang.String</argType>" +								
				"<value>"+ptcn+"</value>" +
				"</Argument>";
			}

			xsdString = xsdString +  
			"<Argument id=\"PRINTVAL\" name=\"PRINTVAL\">" +
			"<argType>java.lang.String</argType>" +
			//"<value>"+ptcnList.get(i)+"</value>" +
			"<value>"+isReplenishment+"</value>" +
			"</Argument>" +
			"<Argument id=\"x_path\" name=\"x_path\">" +
			"<argType>java.lang.String</argType>" +
			"<value>/DocumentRoot/pick_label</value>" +
			"</Argument>" +
			"<Argument id=\"design_source\" name=\"design_source\">" +
			"<argType>java.lang.String</argType>" +
			"<value>pick_label.jrxml</value>" +
			"</Argument>" +
			"<Argument id=\"data_source\" name=\"data_source\">" +
			"<argType>java.lang.String</argType>" +
			"<value>SQL</value>" +
			"</Argument>" +
			"<Argument id=\"bind_type\" name=\"bind_type\">" +
			"<argType>java.lang.Integer</argType>" +
			"<value>0</value>" +
			"</Argument>" +
			"<Argument id=\"report_type\" name=\"report_type\">" +
			"<argType>java.lang.String</argType>" +
			"<value>JASPER</value>" +
			"</Argument>" +
			"<Argument id=\"report_save_type\" name=\"report_save_type\">" +
			"<argType>java.lang.String</argType>" +									
			"<value>NATIVE</value>" +									
			"</Argument>" +
			"</Arguments>";
			System.out.println(" XSD parser **->["+xsdString+"]");		
			//changed by sankara on 24/06/14 call report from remote
			//changed by sankara on 22/07/14 not require as per pragyan sir start.
			/*if(isRemotePrintSrvCofigured("IS_REMOTE_PRNTSRV_CONFIGRD",conn))
				{				
					errString = jrGenerator.callRemotePrintServlet(reportObjName, xsdString, chgUser, printer.trim(), 1, conn);
				}
				else
				{
					errString = jrGenerator.printReport(reportObjName, xsdString, chgUser, printer.trim(), 1, conn);		
				}*/
			errString = jrGenerator.callRemotePrintServlet(reportObjName, xsdString, chgUser, printer.trim(), 1, conn);
			//changed by sankara on 22/07/14 not require as per pragyan sir ned.
			//errString = jrGenerator.printReport(reportObjName, xsdString, chgUser, printer.trim(), 1, conn);		
			System.out.println(" PRINTING task completed--------**------->");		

			//}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}

	private boolean isRemotePrintSrvCofigured(String propertyName , Connection conn) throws ITMException
	{
		String sql = "";
		String flagRemoteRptSrvltCofigured = "N";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isConfigured = false;
		DistCommon discommon = new DistCommon();	
		try
		{
			flagRemoteRptSrvltCofigured  = discommon.getDisparams("999999",propertyName,conn);       

			if("Y".equalsIgnoreCase(flagRemoteRptSrvltCofigured))
			{
				return isConfigured = true;
			}
			else
			{
				return isConfigured;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{	
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
				throw new ITMException(ex);
			}
		}
	}
	//changed by pragyan on 28/08/14 for update wave_status_org_det start.
	private int reUpdateWaveOrgMasterCartonNo(String PTCN,Connection conn) throws ITMException
	{

		String sql = "";
		String cartonNo = "";
		String orgMasterCarton = "";
		String newMasterCarton = "";
		int update = 0;
		PreparedStatement pstmt = null;

		try
		{  
			sql = "UPDATE WAVE_STATUS_ORG_DET W SET (MASTER_CARTON,TRACKING_NO,SHIP_LABEL) = "
				+ "( SELECT MASTER_CARTON,TRACKING_NO,SHIP_LABEL FROM CARTON_MASTER B WHERE " 
				+ " W.PTCN = B.PTCN AND W.CARTON_NO = B.CARTON_NO AND B.PTCN = ?)  WHERE W.PTCN = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, PTCN);
			pstmt.setString(2, PTCN);
			update = pstmt.executeUpdate();
			if( update > 0 )
			{
				System.out.println("update successfully in WAVE_STATUS_ORG DET ["+update+"]");
			}
			pstmt.close(); pstmt = null;

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null )
				{
					pstmt.close(); pstmt = null;
				}


			}
			catch(Exception es)
			{
				es.printStackTrace();
				throw new ITMException(es);
			}
		}
		return 0;		
	}
	private  String getError(String saleOrder,String Code,Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Invalid Data"+"</message><description>";
			mainStr= mainStr+"Sale Order ="+saleOrder+""+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}

	private String updateCartonMaster(String pickOrder,int lineNo,Double noArt,String ptcn,String refSeries,String xtraParams,Connection conn,double weight,double volume, String packType,String itemCode,String facilityCode,String locTypeParent,String packCode)throws Exception
	{
		String errString = "";		
		String sql = "",sqlInsert = "";
		//Changed by Pragyan on 19-SEP-14   [W14FSUN003]	
		//PreparedStatement pstmt = null,pstmtInsert = null,pstmtPacking = null;
		PreparedStatement pstmt = null,pstmtInsert = null,pstmtPacking = null,pstmtPackingFacility = null,pstmtPackingFiller = null;
		//ResultSet rs = null;
		ResultSet rs = null,rsFacility = null, rsFiller = null;
		String chgUser="",chgTerm="",windowName="",keyString="",tranIDCol="",refSer="";
		String xmlString="",tranIDSer="";
		int updCnt[] = null;
		String crtnType = "";
		double volumeItem=0.0;
		double weightItem=0.0;
		double tareWeight = 0.0; //add on 19-SEP-14 (Pragyan)   [W14FSUN003]	
		double fillerWeight = 0.0;//add on 19-SEP-14 (Pragyan)   [W14FSUN003]	
		//String packCode="";
		String cartonNumber="";


		try
		{
			System.out.println("***********************Ameya:Inside updateCartonMaster method****************************");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			System.out.println("Displaying input parameters::"+pickOrder+"::"+lineNo+"::"+noArt+"::");
			Timestamp currDate = new Timestamp(System.currentTimeMillis());

			windowName = "w_carton_no_gen";	
			xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
			"\r\n</header><Detail1>"+
			"\r\n<carton_no></carton_no>"+
			"</Detail1></Root>";
			System.out.println("xmlString : : : : :"+xmlString);
			TransIDGenerator tg = new TransIDGenerator(xmlString,"BASE",CommonConstants.DB_NAME);


			if(packCode == null && packCode.length() <= 0)
			{
				//Start Changed by Pragyan on 19-SEP-14	   [W14FSUN003]	
				sql =  "SELECT PACK_CODE,GROSS_WEIGHT,LENGTH*WIDTH*HEIGHT,TARE_WEIGHT "
					+" FROM PACKING_FACILITY WHERE " 
					+" FACILITY_CODE = ? AND LENGTH*WIDTH*HEIGHT> = ? and "
					+" GROSS_WEIGHT = ( SELECT MIN(GROSS_WEIGHT) " 
					+" FROM PACKING_FACILITY WHERE " 
					+" FACILITY_CODE = ? AND LENGTH*WIDTH*HEIGHT = (SELECT MIN(LENGTH*WIDTH*HEIGHT) "
					+" VOLUME FROM PACKING_FACILITY WHERE " 
					+" FACILITY_CODE = ? AND GROSS_WEIGHT >= ? AND LENGTH*WIDTH*HEIGHT >= ? AND PACK_TYPE IN(?,'B') ) AND PACK_TYPE IN(?,'B')  ) AND PACK_TYPE IN(?,'B') "
					+" ORDER BY LENGTH*WIDTH*HEIGHT";




				pstmtPacking = conn.prepareStatement(sql);
				pstmtPacking.setString(1, facilityCode);
				pstmtPacking.setDouble(2, volume);
				pstmtPacking.setString(3, facilityCode);
				pstmtPacking.setString(4, facilityCode);
				pstmtPacking.setDouble(5, weight);
				pstmtPacking.setDouble(6, volume);
				pstmtPacking.setString(7, packType);
				pstmtPacking.setString(8, packType);
				pstmtPacking.setString(9, packType);

				rs = pstmtPacking.executeQuery();

				if(rs.next())
				{
					packCode = rs.getString(1);
					weightItem = rs.getDouble(2);
					volumeItem = rs.getDouble(3);
					tareWeight = rs.getDouble(4);
				}
				else
				{

					if(pstmtPacking != null)
					{
						pstmtPacking.close();
						pstmtPacking =null;
					}

					if(rs != null)
					{
						rs.close();
						rs = null;
					}




					sql = "SELECT PACK_CODE,GROSS_WEIGHT,LENGTH*WIDTH*HEIGHT,TARE_WEIGHT,TARE_WEIGHT "+
					"FROM PACKING WHERE " +
					"LENGTH*WIDTH*HEIGHT>=? and "+
					"GROSS_WEIGHT= ( SELECT MIN(GROSS_WEIGHT) " +
					"FROM PACKING WHERE " +
					"LENGTH*WIDTH*HEIGHT =(SELECT MIN(LENGTH*WIDTH*HEIGHT) "+ 
					"VOLUME FROM PACKING WHERE " +
					"GROSS_WEIGHT>=? AND LENGTH*WIDTH*HEIGHT>=? AND PACK_TYPE IN(?,'B') ) AND PACK_TYPE IN(?,'B')  ) AND PACK_TYPE IN(?,'B') "+
					"ORDER BY LENGTH*WIDTH*HEIGHT";

					pstmtPacking = conn.prepareStatement(sql);

					pstmtPacking.setDouble(1, volume);
					pstmtPacking.setDouble(2, weight);
					pstmtPacking.setDouble(3, volume);
					pstmtPacking.setString(4, packType);
					pstmtPacking.setString(5, packType);
					pstmtPacking.setString(6, packType);

					//Changed by Ameya on 14/08/2012 updateCartonMaster for changing the query [END]

					rs = pstmtPacking.executeQuery();
					if(rs.next())
					{
						packCode = rs.getString(1);
						weightItem = rs.getDouble(2);
						volumeItem = rs.getDouble(3);
						tareWeight = rs.getDouble(4);
					}

					System.out.println("packCode="+packCode);
					System.out.println("weightItem="+weightItem);
					System.out.println("volumeItem="+volumeItem);	 		

				}

				System.out.println("packCode="+packCode);
				System.out.println("weightItem="+weightItem);
				System.out.println("volumeItem="+volumeItem);

				if(pstmtPacking != null)
				{
					pstmtPacking.close();
					pstmtPacking =null;
				}

				if(rs != null)
				{
					rs.close();
					rs = null;
				}

			}

			sql = "SELECT KEY_STRING, TRAN_ID_COL,REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				keyString = rs.getString( "KEY_STRING" );
				tranIDCol = rs.getString("TRAN_ID_COL");
				refSer = rs.getString("REF_SER");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt =null;
			}

			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			keyString = keyString.substring(keyString.indexOf(","));

			sqlInsert = "INSERT INTO CARTON_MASTER (CARTON_NO, STATUS, CHG_DATE, CHG_USER, CHG_TERM, " 
				+"PICK_ORDER, LINE_NO__PICK ,PTCN,REF_SER,CARTON_TYPE,PACK_CODE,MASTER_CARTON,ITEM_CODE,TARE_WEIGHT,FILLER_WEIGHT) " 
				+" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";

			pstmtInsert = conn.prepareStatement(sqlInsert);
			if(refSeries.startsWith("C"))
			{

				crtnType = "C";
			}
			else if(refSeries.startsWith("A"))
			{
				crtnType = "A";
			}
			else if(refSeries.startsWith("M-PICK"))
			{
				crtnType = "C";
			}
			else if(refSeries.startsWith("M-PACK"))
			{
				crtnType = "M";
			}
			else if(refSeries.startsWith("S-DOC"))
			{
				crtnType = "S";
			}

			for(int i=1; i<= noArt ;i++)
			{
				System.out.println("inside the for loopppp::::::::::");

				tranIDSer = tg.generateTranSeqID(refSer, tranIDCol, keyString, conn);
				System.out.println("tranIDSer="+tranIDSer);
				cartonNumber = getSSCC("", Integer.parseInt(tranIDSer), conn);
				System.out.println("Generated Key :: "+tranIDSer);
				if (tranIDSer.indexOf("ERROR") > -1 )
				{
					errString = itmDBAccessEJB.getErrorString("","VTTRANID","","",conn);
				}

				System.out.println(tranIDSer);
				//Changed by Ameya on 11/08/2012 for M-PACK Start.
				System.out.println(cartonNumber);
				pstmtInsert.setString(1,cartonNumber);
				//pstmtInsert.setString(1,tranIDSer);
				//Changed by Ameya on 11/08/2012 for M-PACK End.
				pstmtInsert.setString(2,"A");
				pstmtInsert.setTimestamp(3,currDate);
				pstmtInsert.setString(4,chgUser);
				pstmtInsert.setString(5,chgTerm);
				pstmtInsert.setString(6,pickOrder);
				pstmtInsert.setInt(7,lineNo);
				pstmtInsert.setString(8,ptcn);
				pstmtInsert.setString(9,refSeries);
				pstmtInsert.setString(10,crtnType);
				pstmtInsert.setString(11,packCode);
				//Changed by Pragyan on 19-SEP-14   [W14FSUN003]	
				if(packCode != null && packCode.length() > 0)
				{
					fillerWeight = getFillerWeight(packCode,locTypeParent,tareWeight,volumeItem,conn);
					if((refSeries.startsWith("M-PACK")))
					{
						updatePacketWeigfhts(pickOrder,packCode,tareWeight,fillerWeight,weight,cartonNumber,conn);
					}

				}

				if((refSeries.startsWith("M-PACK")))
				{
					pstmtInsert.setString(12,cartonNumber);
				}
				else
				{
					pstmtInsert.setString(12,"");
				}

				pstmtInsert.setString(13,itemCode);  
				pstmtInsert.setDouble(14,tareWeight);     //Add on  19-SEP-14   [W14FSUN003]		
				pstmtInsert.setDouble(15,fillerWeight);   //Add on  19-SEP-14   [W14FSUN003]	 

				pstmtInsert.addBatch();
				pstmtInsert.clearParameters();

				System.out.println("packCode="+packCode);
				System.out.println("weightItem="+weightItem);
				System.out.println("volumeItem="+volumeItem);

			}// end of for loop

			updCnt = pstmtInsert.executeBatch();
			pstmtInsert.clearBatch();
			System.out.println(":ROWS INSERTED:["+updCnt.length+"]");

			if(pstmtInsert != null)
			{
				pstmtInsert.close();
				pstmtInsert = null;
			}

			if(errString == "" && errString.length() <= 0)
			{
				errString = cartonNumber;

				if("A".equalsIgnoreCase(crtnType))
				{
					updateActivePackingCarton(pickOrder, lineNo, cartonNumber, packCode, conn);
				}
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{			
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInsert != null)
				{
					pstmtInsert.close();
					pstmtInsert = null;
				}
				if(pstmtPacking != null)
				{
					pstmtPacking.close();
					pstmtPacking =null;
				}

				if(errString != null && errString.indexOf("ERROR") != -1)
				{

					throw new Exception();		
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new Exception();		
			}
		}

		return errString;
	}

	private String getSSCC(String mfgCode, int runNumber, Connection conn) throws Exception 
	{
		boolean isOdd = false;
		int sumOdd = 0, sumEven = 0;
		String inputStr = "", sscc18 = "",  runNumberStr =""; //mfgCode = "0351672",
		//ibase.utility.E12GenericUtility genUtility = ibase.utility.new E12GenericUtility();
		int ctr, curDigit = 0, chkDigit = 0, padLen = 0; // runNumber = 4967235
		try
		{
			if (mfgCode == null || mfgCode.length() <= 0) 
			{
				mfgCode = "04";
			}
			sumOdd = 0;
			sumEven = 0;
			padLen = 16 - mfgCode.length(); // total length should be 16 excluding extension digit and check digit

			runNumberStr = "0000000000000000" + String.valueOf(runNumber);

			runNumberStr = runNumberStr.substring(runNumberStr.length() - padLen ,runNumberStr.length()); 
			inputStr = mfgCode + runNumberStr;

			System.out.println(  " inputStr [" + inputStr + "] inputStr.length() [" +  inputStr.length() + "]" );
			for (int pos = inputStr.length() - 1; pos >= 0 ; pos--)
			{

				curDigit = Integer.parseInt(inputStr.substring(pos,pos+1));
				System.out.println(  " pos [" + pos +"] curDigit [" + curDigit + "]" );
				if  ( (pos % 2) == 0)
				{
					sumEven +=  curDigit;
				}
				else
				{
					sumOdd += curDigit;
				}

			}
			// step 1  - multiple odd sum with 3
			sumOdd = sumOdd * 3;
			chkDigit =  10 - ((sumEven + sumOdd) % 10) ;

			if(chkDigit > 9)
			{
				chkDigit = 0;
			}
			//System.out.println(  " Integer(chkDigit).toString() [" + String.valueOf(chkDigit) +"]" );
			//sscc18 = 
			sscc18 ="0" + inputStr + String.valueOf(chkDigit);
			System.out.println(" chkDigit [" + chkDigit + "] sumOdd [" + sumOdd + "] sumEven [" + sumEven + "] inputStr [" + inputStr + "] sscc18 [" + sscc18 +"]" );


		}
		catch(Exception e){
			throw e;
		}
		return sscc18;
	}
	private double getFillerWeight(String packCode,String locTypeParent,double weight,double volume, Connection conn) throws ITMException
	{
		String sql = "";
		double fillerWeight = 0.0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{

			sql =   " SELECT FILLER_WEIGHT FROM PACKING_FILLER WHERE  PACK_CODE = ? AND LOC_TYPE__PARENT = ? AND " 
				+" (? BETWEEN MIN_WEIGHT AND MAX_WEIGHT) AND (? BETWEEN MIN_VOLUME AND MAX_VOLUME) ORDER BY FILLER_WEIGHT ASC";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, packCode);
			pstmt.setString(2, locTypeParent);
			pstmt.setDouble(3, weight);
			pstmt.setDouble(4, volume);

			rs = pstmt.executeQuery();
			if( rs.next())
			{
				fillerWeight = rs.getDouble(1);

			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;	 

		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		return fillerWeight;
	}

	private void updatePacketWeigfhts(String masterPackTranId ,String packCode,double tareWeight,double fillerweight,double caseWeight,String masterCartonNo, Connection conn) throws ITMException
	{
		String sql = "";
		int  updateCount = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{

			sql =   " UPDATE  PACK_HDR SET TARE_WEIGHT = ?,FILLER_WEIGHT = ? WHERE TRAN_ID = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1, tareWeight);
			pstmt.setDouble(2, fillerweight);
			pstmt.setString(3, masterPackTranId);

			updateCount = pstmt.executeUpdate();

			if(updateCount > 0)
			{
				System.out.println("	Update Count for master pack weight update "+updateCount);
			}

			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1)
			{
				throw new ITMException(e1);
			}
		}

	}

	private void updateActivePackingCarton(String pickOrder ,int pickLineNo,String activeCartonNo,String packCode, Connection conn) throws ITMException
	{
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int maxLineNo = 1;
		int updLineCtr = 0; 

		try
		{
			//System.out.println(" -- saleOrder ["+saleOrder+"] lineNo ["+lineNo+"] itemCode ["+itemCode+"] ");
			sql =   "SELECT MIN(LINE_NO) FROM PICK_ORD_DET WHERE PICK_ORDER = ? AND PACK_CODE IS NULL";
			sql1 =   "UPDATE PICK_ORD_DET SET CARTON_NO = ?,PACK_CODE = ? WHERE PICK_ORDER = ? AND LINE_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, pickOrder);

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				maxLineNo = rs.getInt(1);
			}
			pstmt.close(); pstmt = null;	 
			rs.close(); rs = null;	 
			pstmt = conn.prepareStatement(sql1);

			while(maxLineNo <= pickLineNo)
			{
				pstmt.setString(1,activeCartonNo);
				pstmt.setString(2,packCode);
				pstmt.setString(3,pickOrder);
				pstmt.setInt(4,maxLineNo);
				updLineCtr =  pstmt.executeUpdate();
				if(updLineCtr > 0)
				{
					System.out.println("Updating Carton / Pack Code  ["+updLineCtr+"] For Lin No["+maxLineNo+"]Carton No["+activeCartonNo+"]Pack Code["+packCode+"]");
				}
				pstmt.clearParameters();
				maxLineNo++;
			}
			pstmt.close(); pstmt = null;	 

		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}

	}

	private String updateTRackingNo(String saleOrder,String ptcn,String waveID,String tranCode,HashMap sordMap,Shipment2 shipment2 ,Connection conn)throws Exception
	{

		String errString = "";
		String imagePath = "";
		String tranId="";
		String sqlInsertDt = null;
		int lineNo = 1;
		String cartonNo = "";
		String pickOrder = "";
		String refSer = "";
		String refId = "";
		String cartonType = "";
		String packCode = "";
		String masterCarton = "";
		String itmCode = "";
		String weight = "";
		String trackingNo = ""; 
		String shipLabel = "";
		String lineNoPick = "";
		String new_trackingNo = "";
		String  new_shipLabel = "";
		String cnumber = "";
		String addName = "";
		String addValue = "";
		String serviceSymbol = "";
		String carrierSymbol = "";
		String carrierFriendlyName = "";
		String sqlInsertData ="",sqlInsertData1 ="",sql ="";

		String value = "";
		String pckgId = "";
		String trackNo="",shipArchive = "";
		String frtTerm = "",sSQL = "";
		//Added by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
		String archivePath = "";
		String  new_shipLabelArchive = "";
		//Added by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]
		double msnNo=0.0;
		double itemWeight = 0.0,caseWeight = 0.0;
		double totalFrtAmt = 0.0;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtCart = null;
		PreparedStatement pstmtInsertData = null;
		PreparedStatement pstmtInsertData1 = null;
		PreparedStatement pstmtInsertTran = null;
		PreparedStatement pstmtDt = null;
		PreparedStatement pstmtDesp = null;
		ResultSet rsD = null;
		ResultSet rs = null ;

		HashMap itmVolumeMap = null;

		try
		{


			Timestamp currDate = new Timestamp(System.currentTimeMillis());
			tranId = getTranId("w_wave_stat_org", conn);

			sqlInsertData = "INSERT INTO WAVE_STATUS_ORG (TRAN_ID, WAVE_ID,TRAN_CODE,PTCN,CHG_USER,CHG_DATE,CHG_TERM,PRINT_STATUS,CARRIER_SYMBOL,CARRIER_FRIENDLYNAME,TRAN_CODE__NEW)"+						
			" VALUES (?,?,?,?,?,?,?,?,?,?,?)";
			pstmtInsertData = conn.prepareStatement(sqlInsertData);

			pstmtInsertData.setString(1,tranId);
			pstmtInsertData.setString(2,waveID);
			pstmtInsertData.setString(3,tranCode);
			pstmtInsertData.setString(4,ptcn);
			pstmtInsertData.setString(5,chgUser);
			pstmtInsertData.setTimestamp(6,currDate);
			pstmtInsertData.setString(7,"base");
			pstmtInsertData.setString(8,"Y");
			pstmtInsertData.setString(9,carrierSymbol);
			pstmtInsertData.setString(10,carrierFriendlyName);
			pstmtInsertData.setString(11,tranCode);
			//Chnaged by sumit on 03/04/12


			pstmtInsertData.addBatch();				
			pstmtInsertData.executeBatch();


			imagePath = discommon.getDisparams("999999","SHIP_WITH_PATH",conn);
			BASE64Decoder decoder = new BASE64Decoder();
			//Timestamp currDate = new Timestamp(System.currentTimeMillis());
			ShipmentResultReturn2 objReturn2 = soap.shipWithLabel(shipment2, ShipWithLabelType.PNG, ImageRotation.Rotation_Default);
			ShipmentResult2 objShipResult = objReturn2.getShipmentResultResponse2();
			System.out.println("Is successfully Executed ["+objReturn2.isSuccess()+"]");
			System.out.println("Message String ["+objReturn2.getMessage()+"]");


			if(!objReturn2.isSuccess())
			{
				//Changed by samadhan on 04/12/2015 for handling special characters
				//errString = getError(saleOrder + "[" + objReturn2.getMessage() +"]", "ADSISRVERR", conn);
				errString = getError("["+ saleOrder + "] " + objReturn2.getMessage() +" ", "ADSISRVERR", conn);
				return errString;
			}
			else
			{
				frtTerm = (String)sordMap.get("FRT_TERM");
				totalFrtAmt = objShipResult.getTotal();
				System.out.println("Update in desp update freight Amt totalFrtAmt ["+totalFrtAmt+"] For frtTerm["+frtTerm+"]");

				if("B".equalsIgnoreCase(frtTerm))
				{
					sSQL = "UPDATE DESPATCH SET FREIGHT_AMT_ADD = ? WHERE PTCN = ?";
					pstmtDesp = conn.prepareStatement(sSQL);
					pstmtDesp.setDouble(1, totalFrtAmt);
					pstmtDesp.setString(2, ptcn);
					int pUpd = pstmtDesp.executeUpdate();

					System.out.println("Update in desp update freight Amt upd ["+pUpd+"] For");
				}


				System.out.println("Total Amount Of  ["+totalFrtAmt+"]");
				int  lenPacakges =  objShipResult.getPackageResults2().length;
				serviceSymbol = objShipResult.getServiceSymbol();
				System.out.println("serviceSymbol["+serviceSymbol+"]");
				carrierSymbol = serviceSymbol.substring(0,serviceSymbol.lastIndexOf(".") );
				System.out.println("Carrier Symbol ["+carrierSymbol+"]");
				Carrier[] carr = soap.getCarriers().getCarrierList();

				for(int j = 0;j<carr.length;j++)
				{
					Carrier carr1 = carr[j];
					System.out.println("Carrier Symbol["+carr1.getSymbol());
					System.out.println("Friendly Name["+carr1.getFriendlyName());
					System.out.println("Short Name["+carr1.getShortName());

					if(carr1.getSymbol().equalsIgnoreCase(carrierSymbol))
					{
						carrierFriendlyName = carr1.getFriendlyName();
						break;
					}


				}
				System.out.println("Carrier Symbol ["+carrierFriendlyName+"]");

				for(int pCtr=0;pCtr < lenPacakges;pCtr++)
				{
					PackageResult2 pkg2frm =  (PackageResult2)objShipResult.getPackageResults2()[pCtr];	
					value = pkg2frm.getBase64Label();
					pckgId = pkg2frm.getPackageID();
					//change by rekha on 23-05-13.start
					pkg2frm.getAdditionalFields();
					trackNo = pkg2frm.getTrackingNumber();			
					cnumber = "";
					System.out.println("getAdditionalFields"+pkg2frm.getAdditionalFields().length);
					for(int Cadd=0;Cadd<pkg2frm.getAdditionalFields().length;Cadd++)
					{
						addName = pkg2frm.getAdditionalFields()[Cadd].getName();
						addValue = pkg2frm.getAdditionalFields()[Cadd].getValue();
						System.out.println("additional fields are Name:["+addName+"]");
						System.out.println("additional fields are Value:["+addValue+"]");

						if(addName.equalsIgnoreCase("carton_no"))
						{
							cnumber = addValue;
							System.out.println("additional fields are Name for cartoon number:"+addName);
							System.out.println("additional fields are Value for cartoon number:"+addValue);
						}
					}


					System.out.println("cnumber is :"+cnumber);
					System.out.println("Package ID["+pckgId+"]");
					System.out.println("Tracking No ["+pkg2frm.getTrackingNumber()+"]");
					System.out.println("BASE64lABEL Length["+value.length()+"]");

					System.out.println("Package id for carton no is :[" +decoder.decodeBuffer(pckgId) +"]");
					msnNo = pkg2frm.getMSN();
					//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
					if("Base64ArchiveDoc".equalsIgnoreCase(addName.trim()))
					{
						shipArchive = addValue;
						byte[] imgBytes = decoder.decodeBuffer(addValue);    
						System.out.println("IMAGE Byte Length for Base64ArchiveDoc ["+imgBytes.length+"]");
						BufferedImage bufImg = ImageIO.read(new ByteArrayInputStream(imgBytes));  

						File imgOutFile = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+cnumber +"_Archive" +".png");
						archivePath = imgOutFile.getPath();
						System.out.println("Get Path for Base64ArchiveDoc["+archivePath+"]");
						File createFolder = new File(archivePath);

						if(!createFolder.exists())
						{
							createFolder.mkdirs();
						}
						imgOutFile.createNewFile();
						ImageIO.write(bufImg, "png", imgOutFile);
						System.out.println("Write File Complete for Base64ArchiveDoc----");
					}
					//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]
					System.out.println("MSN NO IN EACH PACKAGE IS :" +msnNo);
					byte[] imgBytes = decoder.decodeBuffer(value);    
					System.out.println("IMAGE Byte Length ["+imgBytes.length+"]");
					BufferedImage bufImg = ImageIO.read(new ByteArrayInputStream(imgBytes));  

					File imgOutFile = new File(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+cnumber +".png");
					String path = imgOutFile.getPath();
					System.out.println("Get Path ["+path+"]");
					File createFolder = new File(path);

					if(!createFolder.exists())
					{
						createFolder.mkdirs();
					}

					//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
					/*sql = "UPDATE CARTON_MASTER SET TRACKING_NO = ?  , SHIP_LABEL= ? , MSN_NO =?,CARRIER_SYMBOL = ? , CARRIER_FRIENDLYNAME = ?"
							+ " WHERE CARTON_NO = ?";	*/	
					sql = "UPDATE CARTON_MASTER SET TRACKING_NO = ?  , SHIP_LABEL= ? ,SHIP_LABEL_ARCHIVE= ?, MSN_NO =?,CARRIER_SYMBOL = ? , CARRIER_FRIENDLYNAME = ?"
						+ " WHERE CARTON_NO = ?";	
					pstmtCart = conn.prepareStatement(sql);
					pstmtCart.setString(1, trackNo);
					pstmtCart.setString(2, path );
					pstmtCart.setString(3, archivePath);
					pstmtCart.setDouble(4, msnNo);
					pstmtCart.setString(5, carrierSymbol);
					pstmtCart.setString(6, carrierFriendlyName);
					pstmtCart.setString(7, cnumber);
					//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]
					System.out.println("carton number in for loop: "+cnumber);
					System.out.println("msn no for pkg result is :" +msnNo);
					int test = pstmtCart.executeUpdate();
					System.out.println("update statement is :"+test);
					if(test==1)
					{
						System.out.println("updated");

					}
					else    
					{
						System.out.println("not updated");
					}

					imgOutFile.createNewFile();
					ImageIO.write(bufImg, "png", imgOutFile);
					System.out.println("Write File Complete----");

				}

				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				OutputStream file = new FileOutputStream(imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+"Ship"+".ser" );
				OutputStream buffer = new BufferedOutputStream( file );
				ObjectOutput output = new ObjectOutputStream( buffer );
				output.writeObject(shipment2);
				output.flush();
				output.close();  
				file = new FileOutputStream( imagePath+ File.separator+"Ship_Label"+File.separator+ ptcn + File.separator + ptcn+"_"+"ShipRslt"+".ser" );
				buffer = new BufferedOutputStream( file );
				output = new ObjectOutputStream( buffer );
				output.writeObject(objReturn2);
				output.flush();
				output.close();  


				//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
				//sqlInsertDt = "SELECT CARTON_NO,PICK_ORDER,LINE_NO__PICK,CARTON_TYPE,PACK_CODE,MASTER_CARTON,ITEM_CODE,TRACKING_NO,SHIP_LABEL  FROM CARTON_MASTER WHERE PTCN = ?  ORDER BY ITEM_CODE";
				sqlInsertDt = "SELECT CARTON_NO,PICK_ORDER,LINE_NO__PICK,CARTON_TYPE,PACK_CODE,MASTER_CARTON,ITEM_CODE,TRACKING_NO,SHIP_LABEL ,SHIP_LABEL_ARCHIVE  FROM CARTON_MASTER WHERE PTCN = ?  ORDER BY ITEM_CODE";
				//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]

				//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
				/*sqlInsertData1 = "INSERT INTO WAVE_STATUS_ORG_DET (TRAN_ID, LINE_NO,PTCN,CARTON_NO," +
					" PICK_ORDER,	LINE_NO__PICK	,REF_SER,	REF_ID,	" +
					"	CARTON_TYPE,PACK_CODE,MASTER_CARTON,ITEM_CODE, " +
					"WEIGHT,TRACKING_NO,	SHIP_LABEL	)"+				
					" VALUES (?,?,	?,?,	?,?,	?,?,	?,?,	?,?	,	?,?,	?)";*/
				sqlInsertData1 = "INSERT INTO WAVE_STATUS_ORG_DET (TRAN_ID, LINE_NO,PTCN,CARTON_NO," +
				" PICK_ORDER,	LINE_NO__PICK	,REF_SER,	REF_ID,	" +
				"	CARTON_TYPE,PACK_CODE,MASTER_CARTON,ITEM_CODE, " +
				"WEIGHT,TRACKING_NO,	SHIP_LABEL	,SHIP_LABEL_ARCHIVE)"+				
				" VALUES (?,?,	?,?,	?,?,	?,?,	?,?,	?,?	,	?,?,	?,?)";
				//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]
				pstmtInsertData1 = conn.prepareStatement(sqlInsertData1);

				pstmtDt = conn.prepareStatement(sqlInsertDt);

				pstmtDt.setString(1, ptcn);
				rsD = pstmtDt.executeQuery();
				ArrayList test = new ArrayList();
				String tempItem = "";
				while(rsD.next())
				{


					cartonNo = rsD.getString("CARTON_NO");
					pickOrder = rsD.getString("PICK_ORDER");
					lineNoPick = rsD.getString("LINE_NO__PICK");
					cartonType = rsD.getString("CARTON_TYPE");
					packCode = rsD.getString("PACK_CODE");
					masterCarton = rsD.getString("MASTER_CARTON");
					itmCode = rsD.getString("ITEM_CODE");
					new_trackingNo = rsD.getString("TRACKING_NO");

					if(itmCode != null && !tempItem.equalsIgnoreCase(itmCode))
					{
						tempItem = itmCode;
						itmVolumeMap = getItemVolumeMap(itmCode,"",conn);
						caseWeight = (Double)itmVolumeMap.get("PACK_WEIGHT");
						itemWeight = (Double)itmVolumeMap.get("ITEM_WEIGHT");
					}

					new_shipLabel = rsD.getString("SHIP_LABEL");
					//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
					new_shipLabelArchive = rsD.getString("SHIP_LABEL_ARCHIVE");
					System.out.println("ship_label_archive in while loop  :" +new_shipLabelArchive);
					//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]
					System.out.println("carton no in while loop :" +cartonNo);
					System.out.println("tracking no in while loop :"+new_trackingNo);
					System.out.println("ship_label in while loop :"+new_shipLabel);															 
					pstmtInsertData1.setString(1,tranId);
					pstmtInsertData1.setInt(2,lineNo);
					pstmtInsertData1.setString(3,ptcn);
					pstmtInsertData1.setString(4,cartonNo);
					pstmtInsertData1.setString(5,pickOrder);
					pstmtInsertData1.setString(6,lineNoPick);
					pstmtInsertData1.setString(7,refSer);
					pstmtInsertData1.setString(8,refId);
					pstmtInsertData1.setString(9,cartonType);
					pstmtInsertData1.setString(10,packCode);
					pstmtInsertData1.setString(11,masterCarton);
					pstmtInsertData1.setString(12,itmCode);							

					if(new_trackingNo == null || new_trackingNo.trim().length()==0)
					{
						pstmtInsertData1.setDouble(13,caseWeight);
						pstmtInsertData1.setString(14,"");
						pstmtInsertData1.setString(15,"");
						//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
						pstmtInsertData1.setString(16,"");
						//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]
					}
					else
					{
						pstmtInsertData1.setDouble(13,0.0);
						pstmtInsertData1.setString(14,new_trackingNo);
						pstmtInsertData1.setString(15,new_shipLabel);
						//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[Start]
						pstmtInsertData1.setString(16,new_shipLabelArchive);
						//Changed by Jagruti Shinde Request ID:[W15LKAT002] for Implementing and printing DHL Archive label.[End]
					}

					pstmtInsertData1.addBatch();
					lineNo++;

				}



				//pstmtInsertData.executeBatch();
				pstmtInsertData1.executeBatch();
				pstmtInsertData.clearParameters();
				pstmtInsertData1.clearParameters();

				/*if( pstmtInsertData != null)
					{
						pstmtInsertData.close();
						pstmtInsertData = null;
					}*/

				if( pstmtInsertData1 != null)
				{
					pstmtInsertData1.close();
					pstmtInsertData1 = null;
				} 
			}
			//}
			if( pstmtInsertData != null)
			{
				pstmtInsertData.close();
				pstmtInsertData = null;
			}


		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if( pstmtInsertData != null)
				{
					pstmtInsertData.close();
					pstmtInsertData = null;
				}

				if( pstmtInsertData1 != null)
				{
					pstmtInsertData1.close();
					pstmtInsertData1 = null;
				} 
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw e;
			}

		}

		return errString;
	}

	private String getTranId(String windowName, Connection conn) throws ITMException
	{
		String keyStringQuery = "";
		String xmlValues = "";
		String tranId = "";	
		ResultSet rSet = null ;
		PreparedStatement pstmt = null;
		CommonConstants commonConstants = new CommonConstants();

		java.sql.Timestamp currDate = null;

		try
		{

			keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			System.out.println("keyStringQuery--------->>"+keyStringQuery);

			pstmt = conn.prepareStatement(keyStringQuery);
			pstmt.setString(1,windowName);
			rSet = pstmt.executeQuery();	    	
			String tranSer1 = "";
			String keyString = "";
			String keyCol = "";
			if (rSet.next())
			{
				keyString = rSet.getString("KEY_STRING");
				keyCol = rSet.getString("TRAN_ID_COL");
				tranSer1 = rSet.getString("REF_SER");
			}
			// Changed by Sneha on 21-07-2016, for Closing the Open Cursor [Start]
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}
			// Changed by Sneha on 21-07-2016, for Closing the Open Cursor [End]
			
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			String currDateStr = sdfAppl.format(currDate);
			//End Changes by Gulzar on 5/12/2012

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + "" + "</site_code>";
			xmlValues = xmlValues +		"<desp_date>" + currDateStr + "</desp_date>"; 
			xmlValues = xmlValues +		"<tran_date>" + currDateStr + "</tran_date>"; 
			xmlValues = xmlValues +		"<order_date>" + currDateStr + "</order_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			// Creating wave_id 
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			if(rSet != null)
			{
				rSet.close();
				rSet=null;
			}	
			if(pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{	
				if(rSet != null)
				{
					rSet.close();
					rSet=null;
				}	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}				
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return checkNull( tranId);
	}	



}