package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.LiveEventMgrWiseDetailsRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

@SuppressWarnings("serial")
public class ProductMgrWiseDetailServlet extends HttpServlet
{
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		LiveEventMgrWiseDetailsRemote liveEventDetailsRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = null;
		String dataSourceName  = "";
		String personName      = "";
		String productName     = "";
		String uniqueCode      = "";
		String eventCode       = "";
		String loginId         = "";
		String newTranId	   = "";
		HttpSession session    = null;
		UserInfoBean userInfo  = null;
		
		try
		{
			response.setContentType("application/xml");
			session 	   = request.getSession(true);
			userInfo 	   = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId 	   = userInfo.getLoginCode();
			appConnectParm = new AppConnectParm();
			dataSourceName = request.getParameter("dataSourceName");
			personName     = request.getParameter("personName");
			productName    = request.getParameter("productName");
			uniqueCode     = request.getParameter("code");
			eventCode      = request.getParameter("eventCode");
			newTranId	   = request.getParameter("newTranId");
			System.out.println(" ProductMgrWiseDetailServlet uniqueCode ="+uniqueCode+"=== personName =" + personName + "===== dataSourceName :"+dataSourceName);		
			context        = new InitialContext(appConnectParm.getProperty());
			liveEventDetailsRemote = (LiveEventMgrWiseDetailsRemote) context.lookup("ibase/LiveEventMgrWiseDetails/remote");
			JSONObject jsonObjData = (JSONObject) liveEventDetailsRemote.getProductDetail(dataSourceName,personName,productName,uniqueCode,eventCode,loginId,newTranId);
			OutputStream outputStream   = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
		    outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for ProductMgrWiseDetailServlet==" + jsonObjData);		

		} catch (Exception e)
		{
			System.out.println("Exception : ProductMgrWiseDetailServlet :doPost() :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}