package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.AttendanceComplianceRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

public class AttendanceComplianceServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		AttendanceComplianceRemote gardeniaRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginId = "";
		HttpSession session = null;
		JSONObject jsonObjData = null;
		OutputStream outputStream = null;
		UserInfoBean userInfo = null;
		try
		{
			
			response.setContentType("application/xml");
			session = request.getSession(true);
			userInfo = (UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();
			dataSourceName = request.getParameter("dataSourceName");

			System.out.println("loginId is =" + loginId);
			
			context = new InitialContext(appConnectParm.getProperty());
			gardeniaRemote = (AttendanceComplianceRemote) context.lookup("ibase/AttendanceCompliance/remote");
			jsonObjData = (JSONObject) gardeniaRemote.getAttendance(dataSourceName,loginId);
			outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for AttendanceComplianceServlet  build the Graph is==="+ jsonObjData);

		}
		catch (Exception e)
		{
			System.out
					.println("Exception : AttendanceComplianceServlet :doPost(HttpServletRequest request, HttpServletResponse response) :"
							+ e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
