SET DEFINE OFF

CREATE TABLE FINENT_ACCTPRD
(
	FIN_ENTITY CHAR(10) NOT NULL,
	ACCT_PRD CHAR(6) NOT NULL,
	DESCR VARCHAR2(30) NOT NULL,
	FR_DATE DATE NOT NULL,
	TO_DATE DATE NOT NULL,
	IT_FR_DATE DATE,
	IT_TO_DATE DATE,
	CHG_DATE DATE NOT NULL,
	CHG_USER VARCHAR2(10) NOT NULL,
	CHG_TERM VARCHAR2(15) NOT NULL
);

ALTER TABLE FINENT_ACCTPRD ADD ( CONSTRAINT FINENT_ACCTPRD_X PRIMARY KEY (FIN_ENTITY,ACCT_PRD) );
ALTER TABLE FINENT_ACCTPRD ADD ( CONSTRAINT FK_FINENT_ACCTPRD_FENT FOREIGN KEY (FIN_ENTITY) REFERENCES FINENT ) ;
ALTER TABLE FINENT_ACCTPRD ADD ( CONSTRAINT FK_FINENT_ACCTPRD_APRD FOREIGN KEY (ACCT_PRD) REFERENCES ACCTPRD ) ;

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VTITXPRC01',
	'Financial entity null!',
	'Financial entity is not specified, please specify financial entity',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);

COMMIT;

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VTITXPRC02',
	'Invalid financial entity!',
	'Entered financial entity does not exist in system, please specify financial entity existing in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);

COMMIT;
INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VTITXPRC03',
	'Account Period Blank!',
	'Accounting period is not specified, please specify accounting period',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);

COMMIT;

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VTITXPRC04',
	'Invalid accounting period!',
	'Entered accounting period does not exist in system, please specify accounting period existing in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);

COMMIT;

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
VALUES 
('itax_proc','1','fin_entity','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
VALUES 
('itax_proc1','1','fin_entity','Y');

COMMIT;

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
VALUES 
('itax_proc','1','itm_default','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
VALUES 
('itax_proc','1','fin_entity','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
VALUES 
('itax_proc1','1','itm_default','Y');


INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
VALUES 
('itax_proc1','1','fin_entity','Y');

COMMIT;


INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) 
VALUES 
('fullfinal',10,null,'Income Tax','prcm_itax_proc','a','I','Income Tax','1','2',null,'U',null,null,null,null,null,null,null);

COMMIT;

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_NAME,COMP_TYPE,COMM_FORMAT) 
VALUES 
('fullfinal','prcm_itax_proc','1','prcm_adm_default_1',null,'0',FN_SYSDATE(),'BASE','BASE','2','nvo_business_object_ffs_itax_proc','WSR',null);

COMMIT;

