package ibase.dashboard.scm.servlet;
import ibase.dashboard.scm.ejb.SalesPerformanceTwoRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class CNSDivisionBrandServlet extends HttpServlet
{
	//private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		SalesPerformanceTwoRemote salesPerformanceTwo = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String topNos = "", month = "";
		try
		{
			response.setContentType("application/xml");
			dataSourceName    = request.getParameter("dataSourceName"); 
			topNos = (request.getParameter("topNos"));
			month = (request.getParameter("month"));
			System.out.println("in doPost" + "month is =" + month + "topNos is =" + topNos);
			
			context = new InitialContext(appConnectParm.getProperty());
			salesPerformanceTwo = (SalesPerformanceTwoRemote) context.lookup("ibase/SalesPerformanceTwo/remote");
			JSONObject jsonObjData      = (JSONObject)salesPerformanceTwo.getCNSDivisionBrandData(dataSourceName,month,topNos);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for DivisionWiseBrandServlet build the Graph is===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception : DivisionWiseBrandServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}