/**
* PURPOSE : Validation and Item Change implementation for Stock Transfer component .
* AUTHOR  : Gulzar
* Date    : 24/10/11
* 
*/

package ibase.webitm.ejb.wms;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.BaseLogger;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.InputSource;
import java.net.InetAddress;

@javax.ejb.Stateless
public class StockTransferGrlIC extends ValidatorEJB implements StockTransferGrlICRemote, StockTransferGrlICLocal  
{
	// Validation Code. Start	
	/**
	* The method is defined without any parameter and returns blank string
	*/
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(DOM)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param currFrmXmlStr contains the current form data in XML format
	* @param hdrFrmXmlStr contains all the header information in the XML format
	* @param allFrmXmlStr contains the data of all the forms in XML format
	* @param objContext represents the form number
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/	
	public String wfValData(String currFrmXmlStr, String hdrFrmXmlStr,String allFrmXmlStr, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = "";
		
		try
		{
			System.out.println("currFrmXmlStr ::"+currFrmXmlStr);
			System.out.println("hdrFrmXmlStr ::"+hdrFrmXmlStr);
			System.out.println("allFrmXmlStr ::"+allFrmXmlStr);
			if(currFrmXmlStr != null && currFrmXmlStr.trim().length()!=0)
			{
				currDom = parseString(currFrmXmlStr); 
			}
			if(hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length()!=0)
			{
				hdrDom = parseString(hdrFrmXmlStr); 
			}
			if(allFrmXmlStr != null && allFrmXmlStr.trim().length()!=0)
			{
				allDom = parseString(allFrmXmlStr);
			}
			errString = wfValData(currDom,hdrDom,allDom,objContext,editFlag,xtraParams);
		}//end of try
		catch(Exception e)
		{
			System.out.println("Exception : [StockTransferGrlIC][wfValData(String currFrmXmlStr)] : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of specified fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	 public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 	
	 {
		String errString = "";
		String columnValue = "";
		String sql = "";	
		String refSer = "";
		String locCodeTo = "", locCode = "";;
		String tranDate = "";
		String singleLotSl = "";
		String itemLotOpt = "";
		String rowCountStr = "";
		String itemCode = "";
		String siteCode = "";
		String lotNo = "";
		String lpnNo = "";
		String invStat = "";
		String locCodeSys = "";//Changes by chaitali 18/11/11
		String childNodeName = "";
        
		//Changed by Rohan on 21/07/12 
		String grlLoc = "";
		int noOfChilds = 0;
		int noOfParent = 0;
		int count = 0;

		double quantity = 0d;
		double holdQty = 0;

		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		
        GenericUtility genericUtility = GenericUtility.getInstance();
        //Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.start
        ibase.webitm.utility.wms.CommonWmsUtil commonWmsUtility =ibase.webitm.utility.wms.CommonWmsUtil.getInstance();

		DistCommon distCommon = new DistCommon();
		int currentFormNo = 0, cnt = 0,recCnt = 0;		
		Node childNode =null;
        String userId = "";
		NodeList parentList = null;
		NodeList childList = null;	
		String resrvLocInvstat = "";
		String casePickInvstat = "",deepStoreLoc = "";
		java.util.Date tranDateDt = null;
		String prdCode = "";
		
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		ArrayList<String> invStatList = new ArrayList<String>();
		//Changed by Rohan on 21/07/12
		DistCommon discommon = new DistCommon();
		String partialGrlLoc ="" ;//Added By Ashish on 23/Aug/12 for partial Grl Location.[WM2ESUN009] 
		String  partialResrvLoc ="";//Added By Ashish on 23/Aug/12 for partial Grl Location. [WM2ESUN009]
		PreparedStatement pstmtPgrl=null; //Added By Ashish on 23/Aug/12 for partial Grl Location. [WM2ESUN009]
		ResultSet rsPgrl =null; //Added By Ashish on 23/Aug/12 for partial Grl Location.[WM2ESUN009]
		String lpnNoto=""; //Added By Ashish on 24/Aug/12 for partial Grl Location. [WM2ESUN009]
		PreparedStatement pstmtQtyVal =null; //Added By Ashish on 01/Sep/12 for partial Grl Location. [WM2ESUN009]
		ResultSet rsQtyVal = null; //Added By Ashish on 01/Sep/12 for partial Grl Location. [WM2ESUN009]
		
		try
		{
					
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
			childList = null;	
			noOfParent = parentList.getLength();

			switch(currentFormNo)
			{
				case 1 :
				{
					System.out.println("Enter in 1st form VALIDATION*****************************************************");
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();						
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if ( "tran_date".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLTRANDT" );
								errFields.add( childNodeName.toLowerCase() ); 
							}
						}
						else if ( "ref_ser".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLREFSER" );
								errFields.add( childNodeName.toLowerCase() );
							}
							refSer = genericUtility.getColumnValue( "ref_ser", currDom );
							
							sql = "SELECT COUNT(*) AS COUNT FROM REFSER WHERE REF_SER = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("COUNT");
							}							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						
							if(cnt == 0)
							{
								errList.add( "VTREFSER1" );
								errFields.add( childNodeName.toLowerCase() );
							}						
						}
						else if ( "site_code".equalsIgnoreCase( childNodeName ) )
						{							
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLSITE" );
								errFields.add( childNodeName.toLowerCase() );
							}
							siteCode = genericUtility.getColumnValue( "site_code", currDom );
							
							sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("COUNT");
							}							
							rs.close();
							rs = null;							
							pstmt.close();
							pstmt = null;
							
							if(cnt == 0)
							{
								errList.add( "INVSITECD" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else //added by kunal on 15-feb-14 for period code
							{
								
								siteCode = genericUtility.getColumnValue("site_code", currDom);
								cnt = 0; 
								System.out.println("364 site code ="+siteCode);
								if (genericUtility.getColumnValue("tran_date", currDom) != null)
								{
									tranDateDt = sdf1.parse(genericUtility.getColumnValue("tran_date", currDom));
									sql = "select code from period where ?  between fr_date and to_date";
									pstmt = conn.prepareStatement(sql);
									pstmt.setDate(1, new java.sql.Date(tranDateDt.getTime()));
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										prdCode = rs.getString(1);

									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									sql = "select count(*) from period_stat where site_code = ? and prd_code = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, siteCode);
									pstmt.setString(2, prdCode);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										cnt = rs.getInt(1);

									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									if (cnt == 0)
									{
										errList.add( "VTSITEPD" );
										errFields.add( childNodeName.toLowerCase() );
										break;
									}
									// nvo_functions_adv.nf_check_period('SAL',mdate1,msite_code)
									errCode = nfCheckPeriod("IC", tranDateDt, siteCode);
									System.out.println("425 Error Code = " + errCode);
									if (errCode != null && errCode.trim().length() > 0)
									{
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
									}
								} 							 
							}//end 
						}
						else if ( "reas_code".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLREASON" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}// for loop end
				}//case 1 end
				break;
				case 2 :
				{
					System.out.println("Enter in 2nd case form VALIDATION*****************************************************");
					grlLoc  = discommon.getDisparams("999999","GRL_INVSTAT",conn);
					/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][START]*/
					partialGrlLoc = discommon.getDisparams("999999","PGRL_INVSTAT",conn);
					/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009] [END]*/
					System.out.println("General location code"+grlLoc);
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for ( int ctr = 0; ctr < noOfChilds; ctr++ )  //Loop for each node of current detail
					{	
						childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if( "lpn_no".equalsIgnoreCase( childNodeName ) )
						{
							lpnNo = genericUtility.getColumnValue("lpn_no", allDom, "2" );
							System.out.println("LPN Number=====>"+lpnNo);
							// added by cpatil on 14-08-12  start
							if(lpnNo == null || lpnNo.trim().length() == 0)
							{
								errList.add( "NULLLPNNO" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
							// added by cpatil on 14-08-12 end
							
							/*//Chnaged by Rohan on 10-02-12 allow lpn no start with NJ & CN & allow only 10 Character.start
							if(!lpnNo.startsWith("NJ") && !lpnNo.startsWith("CN") && !lpnNo.startsWith("DM") && !lpnNo.startsWith("EX"))
							{
								errList.add( "VTINVLPN" );
								errFields.add( childNodeName.toLowerCase());
							}
							
							if(lpnNo.length() != 10)
							{
								errList.add( "VTINVLEN" );
								errFields.add( childNodeName.toLowerCase());
							}
							//Chnaged by Rohan on 10-02-12 allow lpn no start with NJ & CN & allow only 10 Character.end
							 */
							siteCode = genericUtility.getColumnValue("site_code", hdrDom );
							System.out.println("siteCode Number=====>"+siteCode);
							//Changed by Rohan on 21/07/12 for check stock that present only on grl location
							//sql = "SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ?  AND LOT_SL = ? ";
							sql = "SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ?  AND LOT_SL = ? AND LOC_CODE in (select loc_code from location where inv_stat = ? ) and quantity > 0";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, siteCode );
							pstmt.setString( 2, lpnNo );
							//Changed by Rohan on 21/07/12 for check stock that present only on grl location
							pstmt.setString(3, grlLoc );
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								quantity = rs.getDouble(1);
							}
							else
							{
								//Changed by Rohan on 21/07/12 to change messages type
								//errList.add( "VTSTK2" );
								/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][START]*/
								String sqlPartial ="SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ?  AND LOT_SL = ? AND LOC_CODE in (select loc_code from location where inv_stat = ? ) and quantity > 0";
								pstmtPgrl = conn.prepareStatement( sqlPartial );
								pstmtPgrl.setString( 1, siteCode );
								pstmtPgrl.setString( 2, lpnNo );
								pstmtPgrl.setString(3, partialGrlLoc);
								rsPgrl = pstmtPgrl.executeQuery();
								
								if(rsPgrl.next())
								{
									quantity = rsPgrl.getDouble(1);
								}
								else
								{	
									errList.add( "VTLPNNTVAL" );
									errFields.add( childNodeName.toLowerCase() );
								}
								rsPgrl.close(); rsPgrl = null;
								pstmtPgrl.close(); pstmtPgrl = null;
								/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][END]*/
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							
	
							if( quantity == 0 )
							{
								errList.add( "VTSTK2" );
								errFields.add( childNodeName.toLowerCase() );
							}
							//End changed by Gulzar on 5/12/2012
						  }// end of else
						}//End of case "LPN_NO"
					}//End of for loop
				}//case 2 end
				break;
				case 3 :
				{
					System.out.println("Enter in 3nd case form VALIDATION*****************************************************");
					String isPartial="";
					String scannedQuantity="";
					double scannedQuantityD= 0.0;
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for ( int ctr = 0; ctr < noOfChilds; ctr++ )  //Loop for each node of current detail
					{	
						childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if( "loc_code__to".equalsIgnoreCase( childNodeName ) )
						{
							resrvLocInvstat = distCommon.getDisparams("999999","RESERV_LOCATION",conn);
							
							//Added By Mahesh Patidar on 23/06/12
							casePickInvstat = distCommon.getDisparams("999999","CASE_PICK_INVSTAT",conn);
							deepStoreLoc = distCommon.getDisparams("999999","DEEP_STORE_INVSTAT",conn);
							
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][START]*/
							partialGrlLoc = discommon.getDisparams("999999","PGRL_INVSTAT",conn);
							partialResrvLoc = discommon.getDisparams("999999","PRSRV_INVSTAT",conn);
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][END]*/
							
							itemCode = genericUtility.getColumnValue("item_code", allDom, "3" );
							locCode = genericUtility.getColumnValue("loc_code__fr", allDom, "3" );
							siteCode = genericUtility.getColumnValue("site_code", hdrDom );
							locCodeTo = genericUtility.getColumnValue("loc_code__to", allDom, "3" );
							lotNo = genericUtility.getColumnValue("lot_no__fr", allDom, "3" );
							lpnNo = genericUtility.getColumnValue("lot_sl__fr", allDom, "3" );
							lpnNoto=genericUtility.getColumnValue("lot_sl__to", allDom, "3" ); //added by Ashish Sonawane on 24/Aug/12 [WM2ESUN009]
							
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][START]*/
							isPartial =	genericUtility.getColumnValue("ispartial", allDom, "3" );
							scannedQuantity= genericUtility.getColumnValue("quantity", allDom, "3" );
							if(scannedQuantity != null && scannedQuantity.trim().length() > 0)
							{	
								scannedQuantityD = Double.parseDouble(scannedQuantity);
							}
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][END]*/
							
							//Changed by Ameya on 07/09/2012 check locType of item & location is equal or not Start
							String locTypeItem = "";
							String locTypeLocation = "";
							sql = "SELECT LOC_TYPE FROM ITEM WHERE ITEM_CODE = ? ";								  
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, itemCode );
							rs = pstmt.executeQuery();	
							if( rs.next() )
							{
								locTypeItem = rs.getString(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							
							sql = "SELECT LOC_TYPE FROM LOCATION WHERE LOC_CODE = ? ";								  
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, locCodeTo );
							rs = pstmt.executeQuery();	
							if( rs.next() )
							{
								locTypeLocation = rs.getString(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							
							if( !locTypeLocation.equalsIgnoreCase(locTypeItem) )
							{
								errList.add( "VMLOCTYP1" );
								errFields.add( childNodeName.toLowerCase() );
								//errString = getErrorString("loc_code__to","INVLOCCODE",userId);
								break;
							}
							//Changed by Ameya on 07/09/2012 check locType of item & location is equal or not End
							
							//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.start			
							if(!commonWmsUtility.isValFacLocation(locCodeTo, siteCode, conn))
							{
								errList.add( "VMFACI2" ); // 'Diffrent Loc Code from location and site' (set same error Code @base)
								errFields.add( childNodeName.toLowerCase() );
								break;
							}
							//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.end
							
							sql = "SELECT HOLD_QTY FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ?"
									  + " AND LOC_CODE = ? AND lOT_NO = ? AND LOT_SL = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, itemCode );
							pstmt.setString( 2, siteCode );
							pstmt.setString( 3, locCode );
							pstmt.setString( 4, lotNo );
							pstmt.setString( 5, lpnNo );
							rs = pstmt.executeQuery();	
							if( rs.next() )
							{
								holdQty = rs.getDouble("HOLD_QTY");
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;

							if(holdQty == 0)
							{
								invStatList.add(casePickInvstat);
							}
							invStatList.add(resrvLocInvstat);
							invStatList.add(deepStoreLoc);
							//Ended By Mahesh Patidar
							
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][START]*/
							if("Y".equalsIgnoreCase(isPartial))
							{
								invStatList.add(partialGrlLoc);
							}
							if(locCode.trim().equalsIgnoreCase(partialGrlLoc.trim()))
							{
								invStatList.add(partialResrvLoc);
							}	
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][END]*/

							sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT, INV_STAT FROM LOCATION WHERE LOC_CODE = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, locCodeTo );
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
								itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
								invStat = checkNull(rs.getString("INV_STAT"));
							}
							else
							{
								errList.add( "INVLOCCODE" );
								errFields.add( childNodeName.toLowerCase() );
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;

//							if ( !invStat.trim().equalsIgnoreCase(resrvLocInvstat.trim()) )
							if(!(invStatList.contains(invStat.trim())))//Changed By Mahesh Patidar on 23/06/12
							{
								errList.add( "VTLOCCODE8" );
								errFields.add( childNodeName.toLowerCase() );
							}
							//Added By Mahesh Patidar on 29/06/12
							System.out.println("casepickinvstat["+casePickInvstat+"] inv stat["+invStat+"]");
							if(casePickInvstat.trim().equals(invStat.trim()) && holdQty > 0)
							{
								System.out.println("Case Pick Inv stat is equal to inv stat");
								errList.add( "VTLOCCOD10" );
								errFields.add( childNodeName.toLowerCase() );
							}
							//Ended By Mahesh Patidar
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][START]*/
							if("Y".equalsIgnoreCase(isPartial))
							{
								System.out.println("@@@@isPartial:["+isPartial+"]");
								if(!(partialGrlLoc.trim().equals(invStat.trim())))
								{
									System.out.println("@@@@partialGrlLoc: ["+partialGrlLoc+"] invStat: ["+invStat+"]");
									errList.add( "VTLOCCOD11" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][END]*/
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial reserve location [WM2ESUN009][END]*/
							if(locCode.trim().equalsIgnoreCase(partialGrlLoc.trim()))
							{
								if(!(partialResrvLoc.trim().equals(invStat.trim())))
								{
									System.out.println("@@@@partialGrlLoc: ["+partialResrvLoc+"] invStat: ["+invStat+"]");
									errList.add( "VTLOCCOD12" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
							/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial reserve location [WM2ESUN009][END]*/
							/*Added by Ashish Sonawane on 24/Aug/12 for  validating scanned lpn number for partial quantity [WM2ESUN009][START]*/
							if("Y".equalsIgnoreCase(isPartial))
							{
								if(lpnNoto == null ||  lpnNoto.trim().length()==0)
								{
									errList.add("NULLLPNNO");
									errFields.add( childNodeName.toLowerCase() );
								}
								else if(lpnNo.trim().equalsIgnoreCase(lpnNoto.trim()))
								{
									errList.add( "DUPLPNNO" );
									errFields.add( childNodeName.toLowerCase() );
								}
								
								String sqlQtyVal = "SELECT A.QUANTITY, A.ITEM_CODE, A.LOT_NO " +
										" FROM STOCK A, INVSTAT B, ITEM C, LOCATION D "+
										" WHERE A.LOC_CODE = D.LOC_CODE AND D.INV_STAT = B.INV_STAT "+
										" AND A.ITEM_CODE = C.ITEM_CODE AND B.AVAILABLE = 'Y' "+
										" AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " +
										" AND ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) > 0 "+//Changed by gulzar on 1/12/2012
										" AND A.lot_sl = ? "; 
								
								pstmtQtyVal =  conn.prepareStatement(sqlQtyVal);
								pstmtQtyVal.setString(1, lpnNo);//grlInvstat);
								rsQtyVal = pstmtQtyVal.executeQuery();
								if(rsQtyVal.next())
								{
									quantity = rsQtyVal.getDouble("QUANTITY");
									itemCode = rsQtyVal.getString("ITEM_CODE");
									lotNo = rsQtyVal.getString("LOT_NO");
									double packSize = getPackSize(itemCode,lotNo,conn);
									if(packSize != 0.0)
									{	
										if(( quantity % packSize ) != scannedQuantityD )
										{
											System.out.println("@@@@ Error Partial quantity : ["+( quantity % packSize )+" and scanned quantity : ["+scannedQuantityD+"]");
											errList.add( "QTYMSMTCH" );
											errFields.add( childNodeName.toLowerCase() );
										}
										else
										{
											System.out.println("@@@@ partial quantity:["+( quantity % packSize )+"] and scanned quantity : ["+scannedQuantityD+"]");
										}
									}
								}
								else
								{
									System.out.println("What is this??......No record for LPN in stock");
								}
								rsQtyVal.close(); rsQtyVal = null;
								pstmtQtyVal.close(); pstmtQtyVal = null;
								
							}
							/*Added by Ashish Sonawane on 24/Aug/12 for  validating scanned lpn number for partial quantity [WM2ESUN009][END]*/
							if( singleLotSl.trim().equalsIgnoreCase("Y") )
							{
								//Change by Rohan on 19/07/12 for bug Fixing
								/*
								 sql = "SELECT QUANTITY FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ?"
										  + " AND LOC_CODE = ? AND lOT_NO = ? AND LOT_SL = ?";
								*/
								//sql = "SELECT QUANTITY FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ?"
								//	  + " AND LOC_CODE = ? AND lOT_NO = ? AND LOT_SL = ?";
								
								sql = "SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ?"
									  + " AND LOC_CODE = ? ORDER BY QUANTITY DESC";
								
								pstmt = conn.prepareStatement( sql );
								//Change by Rohan on 19/07/12 for bug Fixing.start
								/*
								pstmt.setString( 1, itemCode );
								pstmt.setString( 2, siteCode );
								pstmt.setString( 3, locCodeTo );
								pstmt.setString( 4, lotNo );
								pstmt.setString( 5, lpnNo );
								*/
								pstmt.setString( 1, siteCode );
								pstmt.setString( 2, locCodeTo );
								//Change by Rohan on 19/07/12 for bug Fixing.end
								
								rs = pstmt.executeQuery();	
								if( rs.next() )
								{
									quantity = rs.getDouble("QUANTITY");
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if( quantity != 0 )
								{
									errList.add( "VTLOCCODE1" );
									errFields.add( childNodeName.toLowerCase() );
								}
								//Changed by Gulzar on 5/12/2012
								String locCodeExist = "";
								NodeList locCodeNodeList = null;
								ArrayList dupLocCodeList = new ArrayList();

								int noOfLocCode = 0;
								int listLen = 0;
								recCnt = 0;
								int locCodeCntDb = 0;

								locCodeNodeList = allDom.getElementsByTagName("loc_code__to");
								noOfLocCode = locCodeNodeList.getLength();
								
								for( int idx = 0; idx < noOfLocCode; idx++ )
								{
									if ( locCodeNodeList.item( idx ).getFirstChild() != null )
									{
										dupLocCodeList.add((String)( locCodeNodeList.item( idx ).getFirstChild() ).getNodeValue());
									}
								}
								listLen = dupLocCodeList.size();
								if ( listLen > 0 )
								{
									recCnt = 1;
									for( int i = 0; i < listLen - 1; i++ )
									{
										for ( int j = i+1; j < listLen; j++ )
										{
											if ( ((String)dupLocCodeList.get(i)).equalsIgnoreCase((String)dupLocCodeList.get(j)) )
											{
												recCnt++;
												break;
											}
										}
										if( recCnt > 1 )
										{
											break;
										}
									}
								}
								System.out.println("recCnt = ["+recCnt+"]");
	
								if( recCnt > 1 )
								{
									errList.add( "DUPLOCCODE" );
									errFields.add( childNodeName.toLowerCase() );
								}
								//End changed by Gulzar on 5/12/2012
							}
							else
							{
								if( itemLotOpt.trim().equals("0") )  // Validation for single item_code and single lot_no
								{
									/*--Commented by gulzar as it is not valid for single item and single lot
									sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, itemCode );
									pstmt.setString( 2, siteCode );
									pstmt.setString( 3, locCodeTo );
									pstmt.setString( 4, lotNo );
									rs = pstmt.executeQuery();
									if( rs.next() )
									{
										count = rs.getInt("COUNT");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									if( count > 0 )
									{
										errList.add( "VTLOCCODE3" );
										errFields.add( childNodeName.toLowerCase() );
									}
									*/
                                    //Chnaged by Rohan on 21/07/12 for bug fixing
									//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
									sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, itemCode );
									pstmt.setString( 2, siteCode );
									pstmt.setString( 3, locCodeTo );
									pstmt.setString( 4, lotNo );
									rs = pstmt.executeQuery();
									if( rs.next() )
									{
										count = rs.getInt("COUNT");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									if( count > 0 )
									{
										errList.add( "VTLOCCODE2" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code and multiple lot_no
								{
									sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, itemCode );
									pstmt.setString( 2, siteCode );
									pstmt.setString( 3, locCodeTo );
									pstmt.setString( 4, lotNo );
									rs = pstmt.executeQuery();
									if( rs.next() )
									{
										count = rs.getInt("COUNT");
									}
									rs.close(); rs = null;
									pstmt.close(); pstmt = null;

									if( count > 0 )
									{
										errList.add( "VTLOCCODE4" );
										errFields.add( childNodeName.toLowerCase() );
									}	
								}//end of itemLotOpt == "1"
							}//else of singleLotSl =="Y"
						}//End of case "loc_code__to"
					}//End of for loop
				}//case 2 end
				break;
			} //switch end
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}//try block end
		catch(Exception e)
		{
			System.out.println("Exception in StockTransferGrlIC  == >");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StockTransferGrlIC:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
	}

	private String errorType( Connection conn , String errorCode ) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}
	// Item Change Functionality. Start from here....		
	/**
	* The public method is defined without any parameters and returns blank string
	*/
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(dom)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param currFrmXmlStr contains the current form data in XML format
	* @param hdrFrmXmlStr contains all the header information in the XML format
	* @param allFrmXmlStr contains the data of all the forms in XML format
	* @param objContext represents the form number
	* @param currentColumn represents the value of current field.
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/
	public String itemChanged(String currFrmXmlStr, String hdrFrmXmlStr, String allFrmXmlStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		
		String errString = null;
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		try
		{
			System.out.println ( "currFrmXmlStr [" + currFrmXmlStr + "]");
			System.out.println ( "currFrmXmlStr [" + hdrFrmXmlStr + "]");
			System.out.println ( "currFrmXmlStr [" + allFrmXmlStr + "]");
			if (currFrmXmlStr != null && currFrmXmlStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currFrmXmlStr); 
			}
			if (hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrFrmXmlStr); 
			}
			if (allFrmXmlStr != null && allFrmXmlStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allFrmXmlStr); 
			}
			errString = itemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception : StockTransferGrlIC:defaul_ItemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		System.out.println ( "returning from StockTransferGrlIC default_Itemchanged" );
		return errString;
	}	
	
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 * 
	 */
	public String itemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String sql = "";
		String itemCode = "";
		String itemDescr = "";
		String tranId = "";		
		String tranDate = "";				
		String columnValue = "";		
		String refSerFor = "";
		String reasCode = "";
		String confirmed = "";
		String confDate = "";
		String siteCode = "";	
		String siteDescr = "";	
		String empCodeAprv = "";
		String fullName = "";
		String lpnNo = "";
		String lotSl = "";
		String noArt = "";
		String locDescr = "";
		String acctCode = "";
		String cctrCode = "";
		String lotNo = "";
		String locCode = "";
		String unit = "";
		//Changed by Ameya on 06/09/2012 for declare locType & locCode for Reserve location Start 
		String locType = "";
		String locCodeNew = ""; 
		int locPrveZone = 0;
		//Changed by Ameya on 06/09/2012 for declare locType & locCode for Reserve location End
		//ArrayList reservLocList = null;
		String grlInvstat = "";
		String resrvLocInvstat = "";
		String resvLocCode = "";
		String stockSql = "",deepStoreLoc = "",	casePickInvstat ="";
		String partialGrlLoc="",partialResrvLoc="";//Added by Ashish Sonawane on 23/Aug/12 [WM2ESUN009]		
		int currentFormNo = 0;
		int domID = 0;	
		int locListSize = 0;
		int count = 0;
		
		double quantity = 0d; 
			
		ResultSet rs = null;
		ResultSet rsStock = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtStock = null;

		StringBuffer valueXmlString = new StringBuffer();		
		GenericUtility genericUtility = GenericUtility.getInstance();

		java.util.Date currDate = null;
		SimpleDateFormat sdf = null;
		String currDateStr = null;
		String defReasCode = null;
		String loginCode = "";
		String chgTerm = "";
		ArrayList<String> invStatList = new ArrayList<String>();
		try
		{
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			
			columnValue = genericUtility.getColumnValue( currentColumn, currDom );
			
			DateFormat dateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");

			DistCommon distCommon = new DistCommon();
			
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
            valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
            valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );

			switch ( currentFormNo )
			{
			  	case 1:
				{
					valueXmlString.append( "<Detail1 domID='1'>\r\n" );
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
					{	
						currDate = new java.util.Date();
						sdf = new SimpleDateFormat(applDateFormat);
						currDateStr = sdf.format(currDate);

						defReasCode = distCommon.getDisparams("999999","DEFAULT_REAS_CODE",conn);
						
						loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
						chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" ));
						siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
						if ( siteCode.trim().length() == 0 || "INVALID_SITE".equalsIgnoreCase(siteCode.trim()) )
						{
							siteCode = getSiteCode( xtraParams, conn );
						}
						System.out.println("siteCode = ["+siteCode+"]");

						valueXmlString.append( "<tran_id/>" );
						valueXmlString.append( "<tran_date><![CDATA[" ).append( currDateStr ).append( "]]></tran_date>\r\n" );
						valueXmlString.append( "<ref_ser__for><![CDATA[" ).append( "XFRX" ).append( "]]></ref_ser__for>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append(  checkNull ( siteCode)).append( "]]></site_code>\r\n" );
						
						sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, siteCode );						
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							siteDescr = rs.getString("DESCR");
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;

						valueXmlString.append( "<site_descr><![CDATA[" ).append( checkNull( siteDescr )).append( "]]></site_descr>\r\n" );
						valueXmlString.append( "<reas_code><![CDATA[" ).append(  checkNull ( defReasCode)).append( "]]></reas_code>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append( loginCode ).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append( currDateStr ).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
					}
					valueXmlString.append("</Detail1>\r\n");
				}//case 1 end here
				break;
			  	case 2:
			  	{
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
					{
					//	reservLocList = new ArrayList(); //Commented By Mahesh Patidar on 23/06/12
						grlInvstat = distCommon.getDisparams("999999","GRL_INVSTAT",conn);
						resrvLocInvstat = distCommon.getDisparams("999999","RESERV_LOCATION",conn);
						//changed by sankara on 10/09/2012 to assign deep storage,case pick location [Start]
						deepStoreLoc = distCommon.getDisparams("999999","DEEP_STORE_INVSTAT",conn);
						casePickInvstat = distCommon.getDisparams("999999","CASE_PICK_INVSTAT",conn);
						//Changed by Ameya on 14/09/2012
						//invStatList.add(casePickInvstat);	
						invStatList.add(resrvLocInvstat);
						invStatList.add(deepStoreLoc);
						//changed by sankara on 10/09/2012 to assign deep storage,case pick location [End]
						//changed by sankara on 05/04/14 passed login site code
						siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
						System.out.println("in case 2:::::"+siteCode);
						//Commented and changes below by gulzar on 12/23/2011
						/*
						sql = "SELECT A.LOC_CODE FROM STOCK A , INVSTAT B, LOCATION C "
							+ " WHERE A.LOC_CODE = C.LOC_CODE AND C.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
							+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " 
							+ " AND A.QUANTITY = 0 AND C.INV_STAT = ?  ORDER BY LOC_CODE ";
						
						*/
						//Changed by Ameya on 06/09/2012 using method getLocCode Start
						/*
						sql = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
							+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
							+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
							+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";
					
						double stockQty = 0d;
						stockSql = "SELECT SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY "
								+  " FROM STOCK WHERE LOC_CODE = ? ";
						
						pstmtStock =  conn.prepareStatement(stockSql);

						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1, resrvLocInvstat);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							resvLocCode = checkNull(rs.getString("LOC_CODE") );
							pstmtStock.setString( 1, resvLocCode );
							rsStock = pstmtStock.executeQuery();
							if ( rsStock.next() )
							{
								stockQty = rsStock.getDouble("STOCK_QTY");
								//Commented By Mahesh Patidar on 23/06/12
//								if ( stockQty == 0 )
//								{
//									reservLocList.add(resvLocCode);
//								}
//							}
//							else
//							{
//								reservLocList.add(resvLocCode);
								//Ended By Mahesh Patidar
							}
							pstmtStock.clearParameters();
							rsStock.close(); rsStock = null;
						}
						rs.close(); rs = null;						
						pstmt.close(); pstmt = null;
						pstmtStock.close(); pstmtStock = null;
						//Added By Mahesh Patidar on 23/06/12
						if(stockQty != 0)
						{
							resvLocCode = "";
						}
						//Ended By Mahesh Patidar
						//End changes by gulzar on 12/23/2011

						//Commented By Mahesh Patidar on 23/06/12
						//System.out.println("reservLocList...>>>> "+reservLocList);
						//locListSize = reservLocList.size();
						//System.out.println("locListSize...>>>> "+locListSize);
						//Ended By Mahesh Patidar
						*/
						//Changed by Ameya on 06/09/2012 using method getLocCode End
						
						count = 0;

						sql = "SELECT A.ITEM_CODE, A.SITE_CODE, A.LOC_CODE, A.LOT_NO, A.LOT_SL," +
								"C.ITEM_SER, C.DESCR ITEM_DESCR, A.QUANTITY, A.UNIT, A.GRADE, A.EXP_DATE, A.LTRAN_DATE,"+
								"A.REMARKS, D.INV_STAT, D.DESCR LOC_DESCR, A.PACK_CODE, A.ALLOC_QTY, A.MFG_DATE, A.NO_ART, " +
								"A.SITE_CODE__MFG, A.POTENCY_PERC, A.RATE, A.GROSS_RATE, A.RETEST_DATE,"+
								"A.CONV__QTY_STDUOM, A.UNIT__ALT, A.BATCH_NO, A.ACCT_CODE__INV,A.CCTR_CODE__INV "+
								//Changed by Ameya on 06/09/2012 to check LOC_TYPE & LOC_ZONE__PREF of ITEM
								", C.LOC_TYPE, C.LOC_ZONE__PREF "+	
								"FROM STOCK A, INVSTAT B, ITEM C, LOCATION D "+
								"WHERE A.LOC_CODE = D.LOC_CODE AND D.INV_STAT = B.INV_STAT "+
								//changed by sankara on 05/04/14 value passed through prepare state ment
								//"AND A.ITEM_CODE = C.ITEM_CODE AND B.AVAILABLE = 'Y' "+
								"AND A.ITEM_CODE = C.ITEM_CODE AND B.AVAILABLE = ? "+
								//changed by sankara on 05/04/14 value passed through prepare state ment
								//"AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " +
								"AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> ? " +
								//"AND (A.QUANTITY - A.ALLOC_QTY - CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END) > 0 "+//Commented by gulzar on 1/12/2012
								"AND ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) > 0 "+//Changed by gulzar on 1/12/2012
								//changed by sankara on 05/04/14 added login site code
								//"AND D.INV_STAT = ? ";
								" AND D.INV_STAT = ? AND A.SITE_CODE = ? ";

						pstmt =  conn.prepareStatement(sql);
						//changed by sankara on 05/04/14 added login site code and using preparestatement statrt.
						//pstmt.setString(1, grlInvstat);						
						pstmt.setString(1, "Y");
						pstmt.setString(2, "S");
						pstmt.setString(3, grlInvstat);
						pstmt.setString(4, siteCode);
						//changed by sankara on 05/04/14 added login site code and using preparestatement end.
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							itemCode = rs.getString("ITEM_CODE");
							locCode = rs.getString("LOC_CODE");
							lotNo = rs.getString("LOT_NO");
							lotSl = rs.getString("LOT_SL");
							quantity = rs.getDouble("QUANTITY");
							unit = rs.getString("UNIT");
							noArt = rs.getString("NO_ART");
							itemDescr = rs.getString("ITEM_DESCR");
							locDescr = rs.getString("LOC_DESCR");
							acctCode = rs.getString("ACCT_CODE__INV");
							cctrCode = rs.getString("CCTR_CODE__INV");
							//Changed by Ameya on 07/09/2012 set locType & locPrveZone Start
							locType = rs.getString("LOC_TYPE");
							locPrveZone = rs.getInt("LOC_ZONE__PREF");
							//Changed by Ameya on 07/09/2012 set locType & locPrveZone End
							//Changed by Ameya on 06/09/2012 setting resrvLoc
							//Changed by sumit on 28/09/12 modified method parameter 
							//locCodeNew = getLocCode( invStatList,  locType, locPrveZone, conn); 
							//locCodeNew = getLocCode("", invStatList,  locType, locPrveZone, conn);
							domID++;

							valueXmlString.append( "<Detail2 domID='"+ domID +"' selected=\"N\">\r\n" );
							valueXmlString.append("<tran_id/>\r\n");
							valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
							valueXmlString.append("<item_code><![CDATA[").append(checkNull(itemCode)).append("]]></item_code>\r\n");
							valueXmlString.append("<item_descr><![CDATA[").append(checkNull(itemDescr)).append("]]></item_descr>\r\n");
							valueXmlString.append("<loc_code__fr><![CDATA[").append(checkNull(locCode)).append("]]></loc_code__fr>\r\n");
							valueXmlString.append("<loc_descr__fr><![CDATA[").append(checkNull(locDescr)).append("]]></loc_descr__fr>\r\n");
							//commented and changed by chaitali 18/11/11 to set the available grl location to system suggested location 	
							//valueXmlString.append("<loc_code__to><![CDATA[").append( reservLocList.get(count) ).append("]]></loc_code__to>\r\n");
							//Commented By Mahesh Patidar on 23/06/12
							//if ( locListSize > 0 && count < locListSize )
							//{
							//Changed by Ameya on 07/09/2012 setting resvLocCode
							//valueXmlString.append("<loc_code__sys><![CDATA[").append(resvLocCode).append("]]></loc_code__sys>\r\n");
							valueXmlString.append("<loc_code__sys><![CDATA[").append(locCodeNew).append("]]></loc_code__sys>\r\n");
								//count++;
							//}
								//Ended By Mahesh Patidar 
							//End changes by chaitali on 18/11/11
							valueXmlString.append("<loc_code__to><![CDATA[").append( "" ).append("]]></loc_code__to>\r\n");
							valueXmlString.append("<lot_no__fr><![CDATA[").append(checkNull(lotNo)).append("]]></lot_no__fr>\r\n");
							valueXmlString.append("<lot_no__to><![CDATA[").append(checkNull(lotNo)).append("]]></lot_no__to>\r\n");								
							valueXmlString.append("<lot_sl__fr><![CDATA[").append(checkNullAndTrim(lotSl)).append("]]></lot_sl__fr>\r\n");
							valueXmlString.append("<lot_sl__to><![CDATA[").append(checkNullAndTrim(lotSl)).append("]]></lot_sl__to>\r\n");
							valueXmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
							valueXmlString.append("<unit><![CDATA[").append(unit).append("]]></unit>\r\n");
							valueXmlString.append("<no_art><![CDATA[").append(noArt).append("]]></no_art>\r\n");
							valueXmlString.append("<acct_code__cr><![CDATA[").append(checkNull(acctCode)).append("]]></acct_code__cr>\r\n");
							valueXmlString.append("<cctr_code__cr><![CDATA[").append(checkNull(cctrCode)).append("]]></cctr_code__cr>\r\n");
							valueXmlString.append("<acct_code__dr><![CDATA[").append(checkNull(acctCode)).append("]]></acct_code__dr>\r\n");
							valueXmlString.append("<cctr_code__dr><![CDATA[").append(checkNull(cctrCode)).append("]]></cctr_code__dr>\r\n");
							valueXmlString.append("<remarks/>\r\n");
							valueXmlString.append("</Detail2>\r\n");
						}
						rs.close(); rs = null;						
						pstmt.close(); pstmt = null;

						///////////
						String updatedDetailDomStr = addSelectedRecToDom( allDom, valueXmlString.toString() );

						valueXmlString = null;
						valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
						valueXmlString.append("</editFlag>\r\n</Header>\r\n");
						updatedDetailDomStr = updatedDetailDomStr.substring(updatedDetailDomStr.indexOf("<Root>") + "<Root>".length(), updatedDetailDomStr.indexOf("</Root>") );
						valueXmlString.append(updatedDetailDomStr);
						
						System.out.println("\n**************************\n");
						System.out.println("updatedDetailDomStr[1]:>>>>>>>>>>> "+updatedDetailDomStr);

						///////////

					}//outer if
					break;				  		
			  	}// case 2
			  	case 3:
			  	{
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
					{
					//	reservLocList = new ArrayList(); //Commented By Mahesh Patidar on 23/06/12
						grlInvstat = distCommon.getDisparams("999999","GRL_INVSTAT",conn);
						resrvLocInvstat = distCommon.getDisparams("999999","RESERV_LOCATION",conn);
						deepStoreLoc = distCommon.getDisparams("999999","DEEP_STORE_INVSTAT",conn);
						casePickInvstat = distCommon.getDisparams("999999","CASE_PICK_INVSTAT",conn);
						/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][START]*/
						partialGrlLoc = distCommon.getDisparams("999999","PGRL_INVSTAT",conn);
						partialResrvLoc = distCommon.getDisparams("999999","PRSRV_INVSTAT",conn);
						/*Added by Ashish Sonawane on 23/Aug/12 for  allowing partial grl location [WM2ESUN009][END]*/
						lotSl = checkNull(genericUtility.getColumnValue("lpn_no", allDom, "2" ));
                          
						//invStatList.add(casePickInvstat); // 13/09/12 manoharan
						invStatList.add(resrvLocInvstat);
						invStatList.add(deepStoreLoc);

						System.out.println("manohar 24/06/12 LPN No [ "+lotSl + "]");
						//Commented and changes below by gulzar on 12/23/2011
						/*
						sql = "SELECT A.LOC_CODE FROM STOCK A , INVSTAT B, LOCATION C "
							+ " WHERE A.LOC_CODE = C.LOC_CODE AND C.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
							+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " 
							+ " AND A.QUANTITY = 0 AND C.INV_STAT = ?  ORDER BY LOC_CODE ";
						
						*/
						//Changed by Ameya on 06/09/2012 using method getLocCode Start
						/*
						sql = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
							+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
							+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
							+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";
					
						double stockQty = 0d;
						stockSql = "SELECT SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY "
								+  " FROM STOCK WHERE LOC_CODE = ? ";
						
						pstmtStock =  conn.prepareStatement(stockSql);

						pstmt =  conn.prepareStatement(sql);
						//pstmt.setString(1, resrvLocInvstat); //Commented By Ashish Sonawane on 23/Aug/12 [WM2ESUN009] 
						/*Added by Ashish Sonawane on 23/Aug/12 for partial reserve location [WM2ESUN009][START] */ 
						/*if(locCode.trim().equalsIgnoreCase(partialGrlLoc.trim()))
						{
							pstmt.setString(1, partialResrvLoc);
						}
						else
						{
							pstmt.setString(1, resrvLocInvstat);
						}
						/*Added by Ashish Sonawane on 23/Aug/12 for partial reserve location [WM2ESUN009][END] */
						/*rs = pstmt.executeQuery();
						while (rs.next())
						{
							resvLocCode = checkNull(rs.getString("LOC_CODE") );
							pstmtStock.setString( 1, resvLocCode );
							rsStock = pstmtStock.executeQuery();
							if ( rsStock.next() )
							{
								stockQty = rsStock.getDouble("STOCK_QTY");
								//Commented By Mahesh Patidar on 23/06/12
								if ( stockQty == 0 )
								{
									//reservLocList.add(resvLocCode);
									break;
								}
							}
							else
							{
								//reservLocList.add(resvLocCode);
								resvLocCode = "";
								//Ended By Mahesh Patidar
							}
							pstmtStock.clearParameters();
							rsStock.close(); rsStock = null;
						}
						rs.close(); rs = null;						
						pstmt.close(); pstmt = null;
						pstmtStock.close(); pstmtStock = null;
						//Added By Mahesh Patidar on 23/06/12
						//if(stockQty != 0)
						//{
						//	resvLocCode = "";
						//}
						//Ended By Mahesh Patidar
						//End changes by gulzar on 12/23/2011

						//Commented By Mahesh Patidar on 23/06/12
						//System.out.println("reservLocList...>>>> "+reservLocList);
						//locListSize = reservLocList.size();
						//System.out.println("locListSize...>>>> "+locListSize);
						//Ended By Mahesh Patidar
						 */
						//Changed by Ameya on 06/09/2012 using method getLocCode End
						count = 0;

						/* 24/06/12 manoharan commented to get stock info for lot_sl entered
						sql = "SELECT A.ITEM_CODE, A.SITE_CODE, A.LOC_CODE, A.LOT_NO, A.LOT_SL," +
								"C.ITEM_SER, C.DESCR ITEM_DESCR, A.QUANTITY, A.UNIT, A.GRADE, A.EXP_DATE, A.LTRAN_DATE,"+
								"A.REMARKS, D.INV_STAT, D.DESCR LOC_DESCR, A.PACK_CODE, A.ALLOC_QTY, A.MFG_DATE, A.NO_ART, " +
								"A.SITE_CODE__MFG, A.POTENCY_PERC, A.RATE, A.GROSS_RATE, A.RETEST_DATE,"+
								"A.CONV__QTY_STDUOM, A.UNIT__ALT, A.BATCH_NO, A.ACCT_CODE__INV,A.CCTR_CODE__INV "+
								"FROM STOCK A, INVSTAT B, ITEM C, LOCATION D "+
								"WHERE A.LOC_CODE = D.LOC_CODE AND D.INV_STAT = B.INV_STAT "+
								"AND A.ITEM_CODE = C.ITEM_CODE AND B.AVAILABLE = 'Y' "+
								"AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " +
								//"AND (A.QUANTITY - A.ALLOC_QTY - CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END) > 0 "+//Commented by gulzar on 1/12/2012
								"AND ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) > 0 "+//Changed by gulzar on 1/12/2012
								"AND D.INV_STAT = ? ";
						*/
						sql = "SELECT A.ITEM_CODE, A.SITE_CODE, A.LOC_CODE, A.LOT_NO, A.LOT_SL," +
								"C.ITEM_SER, C.DESCR ITEM_DESCR, A.QUANTITY, A.UNIT, A.GRADE, A.EXP_DATE, A.LTRAN_DATE,"+
								"A.REMARKS, D.INV_STAT, D.DESCR LOC_DESCR, A.PACK_CODE, A.ALLOC_QTY, A.MFG_DATE, A.NO_ART, " +
								"A.SITE_CODE__MFG, A.POTENCY_PERC, A.RATE, A.GROSS_RATE, A.RETEST_DATE,"+
								"A.CONV__QTY_STDUOM, A.UNIT__ALT, A.BATCH_NO, A.ACCT_CODE__INV,A.CCTR_CODE__INV "+
								//Changed by Ameya on 06/09/2012 to check LOC_TYPE & LOC_ZONE__PREF of ITEM
								",C.LOC_TYPE, C.LOC_ZONE__PREF, D.INV_STAT "+	
								"FROM STOCK A, INVSTAT B, ITEM C, LOCATION D "+
								"WHERE A.LOC_CODE = D.LOC_CODE AND D.INV_STAT = B.INV_STAT "+
								"AND A.ITEM_CODE = C.ITEM_CODE AND B.AVAILABLE = 'Y' "+
								"AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " +
								//"AND (A.QUANTITY - A.ALLOC_QTY - CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END) > 0 "+//Commented by gulzar on 1/12/2012
								"AND ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) > 0 "+//Changed by gulzar on 1/12/2012
								"AND A.lot_sl = ? ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1, lotSl);//grlInvstat);
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							itemCode = rs.getString("ITEM_CODE");
							siteCode = rs.getString("SITE_CODE");
							locCode = rs.getString("LOC_CODE");
							lotNo = rs.getString("LOT_NO");
							lotSl = rs.getString("LOT_SL");
							quantity = rs.getDouble("QUANTITY");
							unit = rs.getString("UNIT");
							noArt = rs.getString("NO_ART");
							itemDescr = rs.getString("ITEM_DESCR");
							locDescr = rs.getString("LOC_DESCR");
							acctCode = rs.getString("ACCT_CODE__INV");
							cctrCode = rs.getString("CCTR_CODE__INV");
							//Changed by Ameya on 07/09/2012 set locType & locPrveZone Start
							locType = rs.getString("LOC_TYPE");	
							locPrveZone = rs.getInt("LOC_ZONE__PREF");
							String locInvStat = rs.getString("INV_STAT");	
							//Changed by Ameya on 07/09/2012 set locType & locPrveZone End
							
							/*Added by Ashish Sonawane on 23/Aug/12 for checking partial quantity [WM2ESUN009][START] */
							String isPartial = "";
							System.out.println("@@@@locCode:["+locCode+"] partialGrlLoc:["+partialGrlLoc+"] , loc");
							//if(!(locCode.trim().equalsIgnoreCase(partialGrlLoc.trim())))
							if(!(locInvStat.trim().equalsIgnoreCase(partialGrlLoc.trim())))
							{	
								double packSize = getPackSize(itemCode,lotNo,conn);
								if(packSize != 0.0)
								{	
									if((quantity % packSize ) == 0.0 )
									{
										System.out.println("@@@@exact quantity:["+quantity+"]");
										isPartial ="N";
									}
									else
									{
										quantity= (quantity % packSize );
										System.out.println("@@@@partial quantity:["+quantity+"]");
										isPartial="Y";
										invStatList = null;
										invStatList = new ArrayList();
										invStatList.add(partialResrvLoc);
									}
								}
							}
							else
							{
								isPartial="N";
							}
							/*Added by Ashish Sonawane on 23/Aug/12 for checking partial quantity [WM2ESUN009][END] */
							
							//Changed by Ameya on 06/09/2012 setting resrvLoc
							//Changed by sankara on 10/09/2012 to pass invStatList 
							//locCodeNew = getLocCode( resrvLocInvstat,  locType, locPrveZone, conn);
							//Changed by sumit on 28/09/12 suggested location as per inv_stat.
							//locCodeNew = getLocCode( invStatList,  locType, locPrveZone, conn)
							//locCodeNew = getLocCode(locInvStat, invStatList,  locType, locPrveZone, conn);
							locCodeNew = getLocCode(locInvStat, invStatList,  locType, locPrveZone,siteCode, conn);
							domID++;

							valueXmlString.append( "<Detail3 domID='"+ domID +"' selected=\"N\">\r\n" );
							valueXmlString.append("<tran_id/>\r\n");
							valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
							valueXmlString.append("<item_code><![CDATA[").append(checkNull(itemCode)).append("]]></item_code>\r\n");
							valueXmlString.append("<item_descr><![CDATA[").append(checkNull(itemDescr)).append("]]></item_descr>\r\n");
							valueXmlString.append("<loc_code__fr><![CDATA[").append(checkNull(locCode)).append("]]></loc_code__fr>\r\n");
							valueXmlString.append("<loc_descr__fr><![CDATA[").append(checkNull(locDescr)).append("]]></loc_descr__fr>\r\n");
							//commented and changed by chaitali 18/11/11 to set the available grl location to system suggested location 	
							//valueXmlString.append("<loc_code__to><![CDATA[").append( reservLocList.get(count) ).append("]]></loc_code__to>\r\n");
							//Commented By Mahesh Patidar on 23/06/12
							//if ( locListSize > 0 && count < locListSize )
							//{
							//valueXmlString.append("<loc_code__sys><![CDATA[").append(resvLocCode).append("]]></loc_code__sys>\r\n"); //Commented By Ashish Sonawane on 23/Aug/12 for partial GRL [WM2ESUN009]  
							//count++;
							 /* Added by Ashish Sonawane on 23/Aug/12 for partial GRL location ,suggesting partial GRL location [WM2ESUN009][START]*/ 
							   // if("Y".equalsIgnoreCase(isPartial))
							    //{
							    	//valueXmlString.append("<loc_code__sys><![CDATA[").append(partialGrlLoc).append("]]></loc_code__sys>\r\n");
							    //}
							    //else
							    //{	
							    	//Changed by Ameya on 07/09/2012 setting resvLocCode
							    	//valueXmlString.append("<loc_code__sys><![CDATA[").append(resvLocCode).append("]]></loc_code__sys>\r\n");
							    	valueXmlString.append("<loc_code__sys><![CDATA[").append(locCodeNew).append("]]></loc_code__sys>\r\n");
							   // }
							  /* Added by Ashish Sonawane on 23/Aug/12 for partial GRL location ,suggesting partial GRL location [WM2ESUN009][END]*/
							//}
								//Ended By Mahesh Patidar 
							//End changes by chaitali on 18/11/11
							valueXmlString.append("<loc_code__to><![CDATA[").append( "" ).append("]]></loc_code__to>\r\n");
							valueXmlString.append("<lot_no__fr><![CDATA[").append(checkNull(lotNo)).append("]]></lot_no__fr>\r\n");
							valueXmlString.append("<lot_no__to><![CDATA[").append(checkNull(lotNo)).append("]]></lot_no__to>\r\n");								
							valueXmlString.append("<lot_sl__fr><![CDATA[").append(checkNullAndTrim(lotSl)).append("]]></lot_sl__fr>\r\n");
							valueXmlString.append("<lot_sl__to><![CDATA[").append(checkNullAndTrim(lotSl)).append("]]></lot_sl__to>\r\n");
							valueXmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
							valueXmlString.append("<unit><![CDATA[").append(unit).append("]]></unit>\r\n");
							/* Added by Ashish Sonawane on 07-sep-12 as per Manoharan Sir in case of partial GRL no_art to be set as quantity [START] */ 
							if("Y".equalsIgnoreCase(isPartial))
							{
								valueXmlString.append("<no_art><![CDATA[").append(quantity).append("]]></no_art>\r\n");
							}
							else
							{	
								valueXmlString.append("<no_art><![CDATA[").append(noArt).append("]]></no_art>\r\n");
							}
							/* Added by Ashish Sonawane on 07-sep-12 as per Manoharan Sir in case of partial GRL no_art to be set as quantity [END] */
							valueXmlString.append("<acct_code__cr><![CDATA[").append(checkNull(acctCode)).append("]]></acct_code__cr>\r\n");
							valueXmlString.append("<cctr_code__cr><![CDATA[").append(checkNull(cctrCode)).append("]]></cctr_code__cr>\r\n");
							valueXmlString.append("<acct_code__dr><![CDATA[").append(checkNull(acctCode)).append("]]></acct_code__dr>\r\n");
							valueXmlString.append("<cctr_code__dr><![CDATA[").append(checkNull(cctrCode)).append("]]></cctr_code__dr>\r\n");
							valueXmlString.append("<remarks/>\r\n");
							valueXmlString.append("<ispartial><![CDATA[").append(isPartial).append("]]></ispartial>\r\n");
							valueXmlString.append("</Detail3>\r\n");
						}
						rs.close(); rs = null;						
						pstmt.close(); pstmt = null;

						///////////
						String updatedDetailDomStr = addSelectedRecToDom( allDom, valueXmlString.toString() );

						valueXmlString = null;
						valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
						valueXmlString.append("</editFlag>\r\n</Header>\r\n");
						updatedDetailDomStr = updatedDetailDomStr.substring(updatedDetailDomStr.indexOf("<Root>") + "<Root>".length(), updatedDetailDomStr.indexOf("</Root>") );
						valueXmlString.append(updatedDetailDomStr);
						
						System.out.println("\n**************************\n");
						System.out.println("updatedDetailDomStr[1]:>>>>>>>>>>> "+updatedDetailDomStr);

						///////////

					}//outer if
					break;	
				}
			}//switch  end
		}//try block end
		catch(Exception e)
		{
			System.out.println( "Exception :StockTransferGrlIC :default_ItemChanged(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StockTransferGrlIC:default_ItemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );	
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	private String getSiteCode( String xtraParams, Connection connObject ) throws ITMException
	{
		String defaultSite = "";
		String empSite = "";
		String workSite = "";
		String sql = "";
		String loginCode = "";
	
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));

			sql = "SELECT USERS.EMP_CODE, USERS.ENTITY_CODE, USERS.SITE_CODE__DEF, EMP.EMP_SITE, EMP.WORK_SITE "+
					"FROM USERS USERS, EMPLOYEE EMP WHERE USERS.EMP_CODE = EMP.EMP_CODE AND USERS.CODE = ? ";
			pstmt = connObject.prepareStatement( sql );
			pstmt.setString( 1, loginCode );						
			rs = pstmt.executeQuery();	
			if( rs.next() )
			{
				defaultSite = checkNull(rs.getString("SITE_CODE__DEF"));
				empSite = checkNull(rs.getString("EMP_SITE"));
				workSite = checkNull(rs.getString("WORK_SITE"));
			}
			if ( defaultSite.trim().length() == 0 && empSite.trim().length() > 0 )
			{
				defaultSite = empSite;
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
		}
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{	
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("defaultSite = ["+defaultSite+"]");
		return defaultSite;
	}
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	private String addSelectedRecToDom( Document allFormDataDom, String detailString ) throws Exception
	{
		ArrayList selectedList = new ArrayList();
		NodeList detailList = null;
		Node currDetail = null;
		NodeList currDetailList = null;
		String selectedVal = "", nodeName = "", updateStatus = "";
		String domIDVal = "";
		String updatedDetailDomStr = "";
		String attributeVal = "";
		String locCodeTo = "";
		String columnValue = "";

		HashMap toUpdateMap = new HashMap();

		Node elementName = null;

		int currDetailListLength = 0;
		int	detailListLength = 0;

		int selectedValCnt = 0;
		
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			detailList = allFormDataDom.getElementsByTagName("Detail2");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();
				
				attributeVal = "";
				columnValue = "";

				ArrayList toUpdNodeList = new ArrayList();
				HashMap dataMap = new HashMap();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					nodeName = childNode.getNodeName();
					if (nodeName.equalsIgnoreCase("Attribute"))
					{
						attributeVal = checkNull(currDetailList.item(i).getAttributes().getNamedItem("selected").getNodeValue());
						System.out.println("attributeVal =["+attributeVal+"]");
					}//if (nodeName = Attribute
					else if (nodeName.equalsIgnoreCase("loc_code__to"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							locCodeTo = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 1, childNode );
							dataMap.put("loc_code__to", childNode);
						}
					}
				}//End of inner for loop
				if ( "Y".equalsIgnoreCase(attributeVal.trim()) )
				{
					if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
					{
						domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
						System.out.println("domIDVal =["+domIDVal+"]");
					}
					toUpdateMap.put( domIDVal, dataMap );
				}
			}//End of for loop
			
			System.out.println("toUpdateMap:>>>>>>>>>>>: "+toUpdateMap);

			detailList = null;
			
			detailString = detailString + "</Root>\r\n" ;	
			System.out.println("detailString:>>>>>>>>>>> "+detailString);
			Document detailDom = genericUtility.parseString(detailString); 

			Element elementAttr = null;

			detailList = detailDom.getElementsByTagName("Detail2");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);

				if ( currDetail.getAttributes().getNamedItem( "selected" ) != null )
				{
					selectedVal = checkNull(currDetail.getAttributes().getNamedItem( "selected" ).getNodeValue());
					System.out.println("selectedVal =["+selectedVal+"]");
					if ( "N".equalsIgnoreCase(selectedVal.trim()) )
					{
						if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
						{
							//ArrayList aList = null;

							HashMap dataMap = new HashMap();

							domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
							System.out.println("domIDVal =["+domIDVal+"]");
							System.out.println("toUpdateMap.containsKey(domIDVal) =["+toUpdateMap.containsKey(domIDVal)+"]");
							if ( toUpdateMap.containsKey(domIDVal) )
							{
								elementAttr = (Element)currDetail;
								elementAttr.setAttribute( "selected" , "Y" );
								
								Node locCodeToNode = null;

								dataMap = (HashMap)toUpdateMap.get(domIDVal);

								if ( dataMap.get("loc_code__to") != null )
								{
									locCodeToNode = (Node)dataMap.get("loc_code__to");
								}
								
								Node updatedNode = null;

								currDetailList = currDetail.getChildNodes();
								currDetailListLength = currDetailList.getLength();
								
								for ( int i = 0; i < currDetailListLength; i++ )
								{
									elementName = currDetailList.item(i);
									nodeName = elementName.getNodeName();
									if( elementName.getNodeType() != Node.ELEMENT_NODE || nodeName.equalsIgnoreCase("#text") )
									{
										continue;
									}
									System.out.println("nodeName =["+nodeName+"]");
									if ( nodeName.equalsIgnoreCase("loc_code__to") )
									{
										//System.out.println("LocCodeToNode =["+genericUtility.serializeDom( LocCodeToNode )+"]");
										updatedNode = detailDom.importNode(locCodeToNode, true);
										//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
										(detailDom.getElementsByTagName("Detail2").item(ctr)).replaceChild(updatedNode, elementName );
									}
								}//inner for loop
							}//if ( toUpdateMap.containsKey(domIDVal) )
						}//if ( currDetail.getAttributes().getNamedItem( "domID" )
					}//if ( "N".equalsIgnoreCase(selectedVal.trim()) )
				}//if ( currDetail.getAttributes().getNamedItem( "selected" )
			}//outer for loop
			updatedDetailDomStr = genericUtility.serializeDom( detailDom );
			System.out.println("updatedDetailDomStr:>>>>>>>>>>> "+updatedDetailDomStr);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return updatedDetailDomStr;
	}
	
	private double getPackSize(String itemCode, String lotNo, Connection conn) throws ITMException
	{
		PreparedStatement pstmtPackSize=null;
        ResultSet rsPackSize = null;
        double partialQty=0.0;
        double packSize=0.0;
        
		try {
			String sqlPackSize ="SELECT SHIPPER_SIZE FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE =?  AND LOT_NO__FROM <= ? AND LOT_NO__TO >= ?";
			pstmtPackSize =conn.prepareStatement(sqlPackSize);
			pstmtPackSize.setString(1, itemCode);
			pstmtPackSize.setString(2, lotNo);
			pstmtPackSize.setString(3, lotNo);
			rsPackSize = pstmtPackSize.executeQuery();
			
			if(rsPackSize.next())
			{
				packSize=Double.parseDouble((rsPackSize.getString("SHIPPER_SIZE")==null?"0":rsPackSize.getString("SHIPPER_SIZE")));
			}
			
			//partialQty= (quantity % packSize ) == 0.0 ? quantity : (quantity % packSize );
			
			pstmtPackSize.close();
			pstmtPackSize=null;
			rsPackSize.close();
			rsPackSize=null;
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			throw new ITMException(e); 
		}
		
		return packSize;
	}
	//Changed by Ameya on 06/09/2012 to getting reserve location [START].
	//changed by sankara on 10/09/2012 to change the argument string to arraylist
	//public String getLocCode(String resrvLocInvstat, String locType, int locPrefZone, Connection conn) throws RemoteException,ITMException
	public String getLocCode(String invStat, ArrayList invStatList, String locType, int locPrefZone,String siteCode, Connection conn) throws RemoteException,ITMException
	{
		String sql = "";
		String stockSql = "";
		String resvLocCode = "";
		PreparedStatement pstmt = null;
		PreparedStatement pstmtStock = null;
		ResultSet rs = null;
		ResultSet rsStock = null;
		//Changed by ameya on 14/09/2012
		String invStstPars = "";
		//Changed by ameya on 14/09/2012
		int cntList = 0;
		//Changed by sumit on 28/09/12 on Create distCommon variable.
		DistCommon distCommon = new DistCommon();
		try
		{
			//Changed by sumit on 28/09/12 in case of PGRL stock transfer, suggesting location from PRSV inv_stat start.
			if( invStat.trim().length() > 0 && "PGRL".equalsIgnoreCase(invStat.trim()))
			{
				invStatList.clear();
				invStatList.add(distCommon.getDisparams("999999","PRSRV_INVSTAT",conn));				
			}
			//Changed by sumit on 28/09/12 in case of PGRL stock transfer, suggesting location from PRSV inv_stat end.
			//Changed by ameya on 14/09/2012 Start			
			while(cntList < invStatList.size())
			{
				if(cntList != 0)
				{
					invStstPars = invStstPars + ",?";
				}
				else
				{
					invStstPars = invStstPars + "?";
				}
				cntList++;
			}
			System.out.println( "invStstPars ["+invStstPars+"]");
			//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation 
			// Changed by sankara on 27/08/13 for optimized the sql start.
			//Changed by ameya on 14/09/2012 End
			/*System.out.println(" invStstPars -----> ["+invStstPars+"]");
			sql = "SELECT A.LOC_CODE AS LOC_CODE, A.LOC_TYPE AS LOC_TYPE FROM LOCATION A, INVSTAT B "
				+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
				+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
				+ " AND  A.LOC_TYPE = ? "
				//Changed by sankara on 10/09/2012 to  pass three locations
				//+ " AND A.INV_STAT = ? ORDER BY ABS( A.LOC_ZONE - ?), A.LOC_CODE ";
				//Changed by ameya on 14/09/2012 
				//+ " AND A.INV_STAT IN(?,?,?) ORDER BY ABS( A.LOC_ZONE - ?), A.LOC_CODE ";
				+ " AND A.INV_STAT IN("+invStstPars+") ORDER BY ABS( A.LOC_ZONE - ?), A.LOC_CODE ";
	
			double stockQty = 0d;
			stockSql = "SELECT SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY "
					+  " FROM STOCK WHERE LOC_CODE = ? ";
		
			pstmtStock =  conn.prepareStatement(stockSql);*/
			
			/*sql =  " SELECT LOC_CODE, LOC_ZONE, LOC_TYPE FROM ( SELECT A.LOC_CODE AS LOC_CODE, A.LOC_ZONE AS LOC_ZONE, A.LOC_TYPE AS LOC_TYPE " +
			   " FROM LOCATION A, INVSTAT B , STOCK S WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' " +
			   " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " +
			   " AND S.INV_STAT = A.INV_STAT AND S.INV_STAT = B.INV_STAT AND S.LOC_CODE = A.LOC_CODE AND  A.LOC_TYPE = ? AND A.INV_STAT IN ("+invStstPars+") " +
			   " GROUP BY A.LOC_CODE, A.LOC_ZONE, A.LOC_TYPE HAVING SUM (CASE WHEN S.QUANTITY IS NULL THEN 0 ELSE S.QUANTITY END) < = 0 ) " +
			   " ORDER BY ABS(LOC_ZONE - ?), LOC_CODE " ;*/
			//sql =  " SELECT LOC_CODE,LOC_ZONE,LOC_TYPE FROM (SELECT A.LOC_CODE, A.LOC_ZONE, A.LOC_TYPE FROM LOCATION A ,INVSTAT B "
			/*sql =  " SELECT LOC_CODE,LOC_ZONE,LOC_TYPE FROM (SELECT A.LOC_CODE, A.LOC_ZONE, A.LOC_TYPE FROM LOCATION A ,INVSTAT B "
				   + " WHERE A.INV_STAT =B.INV_STAT AND B.AVAILABLE = 'Y' AND A.LOC_TYPE = ? " 
				   + " AND A.INV_STAT IN ("+invStstPars+") " 
				   + " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " 
				   + " AND A.LOC_CODE NOT IN (SELECT LOC_CODE FROM STOCK WHERE " 
				   + " SITE_CODE= ? AND INV_STAT IN ("+invStstPars+") " 
				   + " GROUP BY LOC_CODE " 
				   + " HAVING SUM (CASE WHEN QUANTITY IS NULL THEN 0 ELSE  QUANTITY END) > 0) " 
				   + " ORDER BY  ABS(A.LOC_ZONE - ?),A.LOC_CODE ) WHERE ROWNUM < 5" ;*/
			sql =  " SELECT LOC_CODE,LOC_ZONE,LOC_TYPE FROM (SELECT A.LOC_CODE, A.LOC_ZONE, A.LOC_TYPE,FN_CHECK_VALID_LOC(?,LOC_CODE) AS LOC_CHECK_COUNT " 
						+" FROM LOCATION A ,INVSTAT B "
						+ " WHERE A.INV_STAT =B.INV_STAT AND B.AVAILABLE = 'Y' AND A.LOC_TYPE = ? " 
						+ " AND A.INV_STAT IN ("+invStstPars+") " 
						+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " 
						+ " AND A.LOC_CODE NOT IN (SELECT LOC_CODE FROM STOCK WHERE " 
						+ " SITE_CODE= ? AND INV_STAT IN ("+invStstPars+") " 
						+ " GROUP BY LOC_CODE " 
						+ " HAVING SUM (CASE WHEN QUANTITY IS NULL THEN 0 ELSE  QUANTITY END) > 0) " 
						+ " ORDER BY  ABS(A.LOC_ZONE - ?),A.LOC_CODE ) WHERE  LOC_CHECK_COUNT > 0 " ;
				  
			// Changed by sankara on 27/08/13 for optimized the sql end.	

			pstmt =  conn.prepareStatement(sql);
			
			//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation 
			//pstmt.setString(1, locType);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, locType);
			
			
			for(cntList=0 ; cntList<invStatList.size(); cntList++)
			{
				System.out.println( "inv stat ["+(String)invStatList.get(cntList)+"]");
				//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation 
				//pstmt.setString( (cntList+2), (String)invStatList.get(cntList));
				pstmt.setString( (cntList+3), (String)invStatList.get(cntList));
			}
			System.out.println( "CNT List count ["+cntList+"]");
			//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.start
			/*pstmt.setString(cntList+2, siteCode);
			int k = cntList+2;*/
			pstmt.setString(cntList+3, siteCode);
			int k = cntList+3;
			//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.end
			for(cntList=0 ; cntList<invStatList.size(); cntList++)
			{
				k = k + 1;
				System.out.println( "Current k value["+k+"]");
				pstmt.setString( k , (String)invStatList.get(cntList));
			}
			System.out.println( "Final k value["+k+"]");
			pstmt.setInt(k + 1, locPrefZone);
			/*pstmt.setString(1, locType);
			//Changed by ameya on 14/09/2012 Start
			//Changed by Sankara on 10/09/2012 to get three locations[start]
			//pstmt.setString(2, resrvLocInvstat);
			//pstmt.setInt(3, locPrefZone);
			
			//pstmt.setString(2, (String)invStatList.get(0));
			//pstmt.setString(3, (String)invStatList.get(1));
			//pstmt.setString(4, (String)invStatList.get(2));
			//pstmt.setInt(5, locPrefZone);
			
			for(cntList=0 ; cntList<invStatList.size(); cntList++)
			{
				pstmt.setString( (cntList+2), (String)invStatList.get(cntList));
			}
			pstmt.setString(cntList+2, siteCode);
			pstmt.setInt(cntList+3, locPrefZone);
			*///Changed by Sankara on 10/09/2012 to get three locations[end]
			//Changed by ameya on 14/09/2012 End
			
			rs = pstmt.executeQuery();
			//while (rs.next())
			if (rs.next())
			{
				resvLocCode = checkNull(rs.getString("LOC_CODE") );
				locType = checkNull(rs.getString("LOC_TYPE") );
				
				/*pstmtStock.setString( 1, resvLocCode );
				rsStock = pstmtStock.executeQuery();
				if ( rsStock.next() )
				{
					stockQty = rsStock.getDouble("STOCK_QTY");
					if(stockQty != 0)
					{
						resvLocCode = "";
					}
					else
					{
						break;
					}
				}
				pstmtStock.clearParameters();
				rsStock.close(); rsStock = null;*/
			}
			
			//pstmtStock.close(); pstmtStock = null;			
		}
		catch(Exception e)
		{
			
		}
		finally
		{
			try
			{
				/*if (rsStock != null)
				{
					rsStock.close();
					rsStock = null;
				}
				if (pstmtStock != null)
				{
					pstmtStock.close();
					pstmtStock = null;
				}*/
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StockTransferGrlIC:default_ItemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return resvLocCode;
	}
	//Changed by Ameya on 06/09/2012 to getting reserve location [END].
}