/*Author Priyanka Chavan.
 * Date :
 */

package ibase.webitm.ejb.gst;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.fin.FinCommon;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Set;

import net.sf.saxon.functions.CurrentDateTime;
import jxl.Sheet;
import jxl.Workbook;
public class GSTUploadExcelTemplate extends ValidatorEJB 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String readExcelfile(Workbook workbook, UserInfoBean userInfo) throws ITMException, SQLException //Read Uploaded Excel Sheet and Insert Data in to Gst Tables..
	{  
		Connection  conn=null;
		ResultSet rs = null;
		PreparedStatement stmt = null;
		Boolean isError = false;
		PreparedStatement gsthdrPstmt=null , gstdtlPstmt=null;
		String sPos="",gstDetailSql ="",taxRegNo="",refIdInv="",refDateInv="",gstCode="",gstCodeAct="",reverseChrg="",document="",documentAct="",ecomRegNo="",transactionId="",siteCode="";
		String taxableAmt="",cessAmt="", lineNo="",errorMessage="",year="",code="",mnth="",finalCode="";
		int caseCount = 0;
		Timestamp refDateAct = null;
		String docDate1 = "";
		
		try
		{
			conn = getConnection();
			/*SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			docDate1 = sdf.format(new Date());
	        System.out.println("doc datee :"+docDate1);

			//System.out.println("docDate:::::::::"+documetDate+"doc_date>>>>>>>>>"+documetDate);		
			String sql = "select code from period where ? between fr_date and to_date";
			stmt = conn.prepareStatement(sql);
			stmt.setTimestamp(1,getTimeStamp(docDate1));
			rs = stmt.executeQuery();	
			if(rs.next())
			{
				 code = rs.getString("code");
				System.out.println("code////"+code);
			}
		
			 year = code.substring(0,4);
			 mnth = code.substring(4,6);
			finalCode = mnth+year;
	        System.out.println("final Code :" +finalCode);*/
	        
			int noOfSheet = workbook.getNumberOfSheets();	
			String[] sheetName = workbook.getSheetNames();
			for (int wbcnt = 0; wbcnt < noOfSheet; wbcnt++) 
			{
				System.out.println("No. of sheet : "+noOfSheet);
				Sheet sheet = workbook.getSheet(wbcnt); 
				int noOfRows = sheet.getRows();
				int noOfColumns = sheet.getColumns();
				String eachSheetName = sheetName[wbcnt];
				System.out.println("row :"+noOfRows);
				System.out.println("Columns :"+noOfColumns);
				System.out.println("sheetNames :"+eachSheetName);
				ArrayList<String> hdrDetColumnNameList = new ArrayList<String>();
				HashMap<String, HashMap<String,Object>> b2bInvoicesHMap = new HashMap<String, HashMap<String,Object>>();
				
				//Read And Insert Data For b2b 
				if("b2b".equalsIgnoreCase(eachSheetName)) //Read b2b sheet and Insert data in to Gst Table.....
				{     
					b2bInvoicesHMap.clear();
					for (int i = 0; i < noOfRows; i++) 
					{
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						String invoiceId = "";
						for (int j = 0; j < noOfColumns; j++) 
						{
							String testData = sheet.getCell(j, i).getContents();
							if(j<=7) //Read Header Data From GSt Excel Sheet .......
							{
								if(i==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(j, i).getContents();
									System.out.println("Table Column field: " +hdrData +j + " "+i);
									hdrDetColumnNameList.add(hdrData);
								}
								if(i>=2)
								{   
									String hdrData2 = sheet.getCell(j, i).getContents();
									System.out.println("HDR DATA  :["+hdrData2+"]");
									if(j==1)
									{
										invoiceId = hdrData2;
									}
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(j), hdrData2);
								}
							}
							else if(j>7)  // Read Detail Data From GSt Excel Sheet .......
							{
								if(i==1)
								{
									String dtlData = sheet.getCell(j, i).getContents();
									//System.out.println("Table Column field of Detail: " +dtlData +j + " "+i);
									hdrDetColumnNameList.add(dtlData);
								}
								if(i>=2)
								{
									String dtlData2 = sheet.getCell(j, i).getContents();
									eachDetailHMap.put(hdrDetColumnNameList.get(j), dtlData2);
									/*System.out.println("excel Detail data: " +dtlData2 +j + " "+i);
									eachDetailHMap.put(hdrDetColumnNameList.get(j), dtlData2);

									System.out.println("invoice id"+invoiceId +"i"+i+" "+j);

									System.out.println("b2bInvoicesHMap "+b2bInvoicesHMap);

									if(b2bInvoicesHMap.containsKey(invoiceId))
									{
										HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
										ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
										tempList.add(eachDetailHMap);
										tempHMap.put("detailData", tempList);
										b2bInvoicesHMap.put(invoiceId, tempHMap);
									}
									else
									{
										ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
										detailDataList.add(eachDetailHMap);
							             			eachInvoiceDataHMap.put("detailData", detailDataList);
										b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
									}*/
								}
							}
							// data From Detail 
						}
						if(i>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+i);
						//	System.out.println("b2bInvoicesHMap= "+b2bInvoicesHMap);
							if(b2bInvoicesHMap.containsKey(invoiceId))
							{
								HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
								ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
								tempList.add(eachDetailHMap);
								tempHMap.put("detailData", tempList);
								b2bInvoicesHMap.put(invoiceId, tempHMap);
							}
							else
							{
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
							}
						}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					//insertsql(b2bInvoicesHMap, userInfo,"b2b");
				}
				//Read And Insert Data For B2C
				if("b2c".equalsIgnoreCase(eachSheetName))  // Read Sheet b2cl and Insert Data INTO GST Table....
				{
					for (int i = 0; i < noOfRows; i++) 
					{
						//b2bInvoicesHMap.clear();
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						String invoiceId = "";
						for (int j = 0; j < noOfColumns; j++) 
						{
							String testData = sheet.getCell(j, i).getContents();
							if(j<=4) //Read Header Data From Gst Excel Sheet .......
							{
								if(i==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(j, i).getContents();
									System.out.println("Table Column field: " +hdrData +j + " "+i);
									hdrDetColumnNameList.add(hdrData);
								}
								if(i>=2)
								{   
									String hdrData2 = sheet.getCell(j, i).getContents();
									System.out.println("HDR DATA  :["+hdrData2+"]");
									if(j==0)
									{
										invoiceId = hdrData2;
									}
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(j), hdrData2);
								}
							}
							else if(j>4) //Read Detail Data From Gst Excel Sheet .......
							{
								if(i==1)
								{
									String dtlData = sheet.getCell(j, i).getContents();
									//System.out.println("Table Column field of Detail: " +dtlData +j + " "+i);
									hdrDetColumnNameList.add(dtlData);
								}
								if(i>=2)
								{
									String dtlData2 = sheet.getCell(j, i).getContents();
									eachDetailHMap.put(hdrDetColumnNameList.get(j), dtlData2);

								}
							}

						}
						if(i>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+i);
							//System.out.println("b2bInvoicesHMap= "+b2bInvoicesHMap);
							if(b2bInvoicesHMap.containsKey(invoiceId))
							{
								HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
								ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
								tempList.add(eachDetailHMap);
								tempHMap.put("detailData", tempList);
								b2bInvoicesHMap.put(invoiceId, tempHMap);
							}
							else
							{
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
							}
						}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					//insertsql( b2bInvoicesHMap, userInfo,"b2c");
				}
				
				//Read And Insert Data For CDN
				if("cdn".equalsIgnoreCase(eachSheetName))
				{
					for (int i = 0; i < noOfRows; i++) 
					{
						//b2bInvoicesHMap.clear();
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						String invoiceId = "";
						for (int j = 0; j < noOfColumns; j++) 
						{
							String testData = sheet.getCell(j, i).getContents();
							if(j<=6) //Read Header Data From Gst Excel Sheet .......
							{
								if(i==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(j, i).getContents();
									System.out.println("Table Column field: " +hdrData +j + " "+i);
									hdrDetColumnNameList.add(hdrData);
								}
								if(i>=2 )
								{   
									String hdrData2 = sheet.getCell(j, i).getContents();
									System.out.println("HDR DATA  :["+hdrData2+"]");
									if(j==1)
									{
										invoiceId = hdrData2;
									}
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(j), hdrData2);
								}
							}
							else if(j>6) //Read Detail Data From Gst Excel Sheet .......
							{
								if(i==1)
								{
									String dtlData = sheet.getCell(j, i).getContents();
									//System.out.println("Table Column field of Detail: " +dtlData +j + " "+i);
									hdrDetColumnNameList.add(dtlData);
								}
								if(i>=2)
								{
									String dtlData2 = sheet.getCell(j, i).getContents();
									eachDetailHMap.put(hdrDetColumnNameList.get(j), dtlData2);

								}
							}
						}
						if(i>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+i);
							//System.out.println("b2bInvoicesHMap= "+b2bInvoicesHMap);
							if(b2bInvoicesHMap.containsKey(invoiceId))
							{
								HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
								ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
								tempList.add(eachDetailHMap);
								tempHMap.put("detailData", tempList);
								b2bInvoicesHMap.put(invoiceId, tempHMap);
							}
							else
							{
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
							}
						}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					insertsql( b2bInvoicesHMap, userInfo,"cdn");
				}
				
				//Read And Insert Data For Export 
				if("exp".equalsIgnoreCase(eachSheetName))
				{
					for (int i = 0; i < noOfRows; i++) 
					{
						//b2bInvoicesHMap.clear();
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						String invoiceId = "";
						for (int j = 0; j < noOfColumns; j++) 
						{
							String testData = sheet.getCell(j, i).getContents();
							if(j<=5) //Read Header Data From Gst Excel Sheet .......
							{
								if(i==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(j, i).getContents();
									System.out.println("Table Column field: " +hdrData +j + " "+i);
									hdrDetColumnNameList.add(hdrData);
								}
								if(i>=2)
								{   
									String hdrData2 = sheet.getCell(j, i).getContents();
									System.out.println("HDR DATA  :["+hdrData2+"]");
									if(j==0)
									{
										invoiceId = hdrData2;
									}
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(j), hdrData2);
								}
							}
							else if(j>5) //Read Detail Data From Gst Excel Sheet .......
							{
								if(i==1)
								{
									String dtlData = sheet.getCell(j, i).getContents();
									//System.out.println("Table Column field of Detail: " +dtlData +j + " "+i);
									hdrDetColumnNameList.add(dtlData);
								}
								if(i>=2)
								{
									String dtlData2 = sheet.getCell(j, i).getContents();
									eachDetailHMap.put(hdrDetColumnNameList.get(j), dtlData2);

								}
							}
						}
						if(i>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+i);
						//	System.out.println("b2bInvoicesHMap= "+b2bInvoicesHMap);
							if(b2bInvoicesHMap.containsKey(invoiceId))
							{
								HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
								ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
								tempList.add(eachDetailHMap);
								tempHMap.put("detailData", tempList);
								b2bInvoicesHMap.put(invoiceId, tempHMap);
							}
							else
							{
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
							}
						}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					//insertsql( b2bInvoicesHMap, userInfo,"exp");
				}
				
				//Read And Insert Data For ADVANCE 
				if("advance".equalsIgnoreCase(eachSheetName))
				{
					int invoiceId = 0;
					for (int row = 0; row < noOfRows; row++) 
					{
						//b2bInvoicesHMap.clear();
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						
						
						for (int column = 0; column < noOfColumns; column++) 
						{
							String testData = sheet.getCell(column,row).getContents();
							if(column<=2) //Read Header Data From Gst Excel Sheet .......
							{
								if(row==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(column, row).getContents();
									System.out.println("Table Column field: " +hdrData +column + " "+row);
									hdrDetColumnNameList.add(hdrData);
								}
								if(row >= 2)
								{   
									String hdrData2 = sheet.getCell(column, row).getContents();
									System.out.println("HDR DATA  :["+hdrData2+"]");
									
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(column), hdrData2);
								}
							}
							else if(column>2) //Read Detail Data From Gst Excel Sheet .......
							{
								if(row==1)
								{
									String dtlData = sheet.getCell(column, row).getContents();
									//System.out.println("Table Column field of Detail: " +dtlData +j + " "+i);
									hdrDetColumnNameList.add(dtlData);
								}
								if(row>=2)
								{
									String dtlData2 = sheet.getCell(column, row).getContents();
									System.out.println("dtl data" +dtlData2);
									//eachDetailHMap.put(Integer.toString(invoiceId), dtlData2);
									eachDetailHMap.put(hdrDetColumnNameList.get(column), dtlData2);
								}
							}
						}
						
						if(row>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+row);
						
							
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(Integer.toString(invoiceId), eachInvoiceDataHMap);
							
						}
						invoiceId++;
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					//insertsql( b2bInvoicesHMap, userInfo,"advance");
				}
				
				//Read And Insert Data For NIL 
				if("nil".equalsIgnoreCase(eachSheetName))
				{
					b2bInvoicesHMap.clear();
					int i,j,tranType=15;
					for (i = 2; i < noOfRows; i++) 
					{
						//b2bInvoicesHMap.clear();
					
						for ( j = 1; j < noOfColumns; j++) 
						{
							String testData = sheet.getCell(j, i).getContents();
							if(j<=3 ) //Read Header Data From Gst Excel Sheet .......
							{
								if(i>=2)
								{   
									String hdrData2 = sheet.getCell(j, i).getContents();
									System.out.println("HDR DATA  :["+hdrData2+"]");
									HashMap<String,Object> HeraderMap = new HashMap<String,Object>();
									HeraderMap.put("tran_type",Integer.toString(tranType));
									HeraderMap.put("amount",hdrData2);
									b2bInvoicesHMap.put(Integer.toString(tranType), HeraderMap)	;
									tranType++;
								}
								if(j>3){break;}
							}
						}
						if(i>4){break;}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					//insertsql( b2bInvoicesHMap, userInfo,"nil");
				}
			}
			errorMessage="Template Upload Successfully";
		}
		catch(Exception e)
		{ 
			System.out.println(e);
		errorMessage = e.getMessage();
		System.out.println("Exception 3::" + errorMessage + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("updategst isError="+isError);
			if(isError)
			{
				conn.rollback();
			}
			else
			{
				conn.commit();
			}
			if(stmt != null){stmt.close();stmt = null;}
		//	if(gstdtlPstmt != null){gstdtlPstmt.close();gstdtlPstmt = null;}
			if(rs != null){rs.close();rs = null;}
			if(conn != null){conn.close();conn = null;}
		}
		return errorMessage;
	}
	public void insertsql(HashMap<String, HashMap<String, Object>> b2bInvoicesHMap,UserInfoBean userInfo,String sheetType)throws Exception , SQLException
	{   FinCommon  finCommon = null;
		finCommon = new FinCommon(); 
		System.out.println("Inside Insert SQL :");
		Connection  conn=null;
		ResultSet rs = null;String headersql="",detailSql="";
		Boolean isError = false,isWithPay=false;
		PreparedStatement pstmt=null , pstmt1=null;
		String taxRegNo="",refIdInv="",refDateInv="",gstCode="",gstCodeAct="",reverseChrg="",document="",documentAct="",ecomRegNo="",transactionId="",siteCode="";
		String  taxableAmt="",cessAmt="", lineNo="",provAssmnt="",ordNo="",subStatus="",addUser="",addTerm="",statusDet="",srnoOldDet="",lineTypeDet="",gscodeDet="";
		String  subDate="",chgUser="",chgTerm="",chgDate="",taxableamtDet="",igstpercDet="",igstamtDet="",cgstpercDet="",cgstamtDet="",sgstpercDet="";
		String  docDate = null,lrDate = null,orderDate = null,ordDate="",refId="",addDate="",sgstamtDet="",gsdescrDet="",unitDet="",quantityDet="",supptypeDet="",cesspercDet="",cessamtDet="";
		String  prdCode = "",recType = "",tranType = "",custCode = "",custName = "",subType="",itctypeDet="",itcigstDet="",itccgstDet="",
				submissionType = "",docCheckSum = "",docNo = "",revCharge = "",lrNo = "",reasCode = "",docNum="",itcsgstDet="",itccessDet="",gstrateDet="",prvAssment = "",orderNo = "",remarks = "",submitStatus = "",tranIdRef="",
				recoStatus = "",refSer = "",prdCodeGstHdr = "",stateCode = "",docType = "",srNoOld = "",lineType = "",gsCode = "",gsDescr = "",unit = "",supplyType = "",remarksDet = "",distOrdTranID = "",
				tranIDPorcp = "",gstType = "",remarksHdr = "", refID = "",tranDate="",sPos="";

		int caseCount = 0;
		double amt=0,invAmt=0, b2clInvVal=0,gstRate=0;
		Timestamp refDateAct = null;
		
		try
		{ 
	        conn = getConnection();
	        b2clInvVal = Double.parseDouble(finCommon.getFinparams("999999", "GST_B2CL_INV_VAL", conn));
	        sPos = getGstStateCode(siteCode,conn);
	        
			for (String key : b2bInvoicesHMap.keySet()) 
			{
				HashMap header = (HashMap) b2bInvoicesHMap.get(key);
				//HashMap HeraderMap = (HashMap) b2bInvoicesHMap.get(key);
				siteCode = userInfo.getSiteCode();
				System.out.println("Inside Insert SQL :");
				transactionId = generateTranId("w_gstr",  siteCode, conn);
				System.out.println("GSTTranId ::::::::::::: " + transactionId);
				taxRegNo = (String) header.get("tax_reg_no");
				System.out.println("taxRegNo="+taxRegNo);
				refIdInv = (String) header.get("ref_id__inv");
				System.out.println("refIdInv="+refIdInv);
				refDateInv = (String) header.get("ref_date__inv");
				System.out.println("refDateInv"+refDateInv);
				refDateAct = getTimeStamp(refDateInv);
				System.out.println("refDateAct="+refDateAct);
				//invAmt =	Double.parseDouble((String) header.get("amount"));
				invAmt = getDouble((String)header.get("amount"));
				System.out.println("invAmt="+invAmt);
				gstCode =  (String) header.get("gst_code");
				if(gstCode != null && gstCode.trim().length() > 0)
				{
					gstCodeAct = gstCode.substring(0, 2);
				}
				System.out.println("gstCodeAct="+gstCodeAct);
				reverseChrg =  (String) header.get("reverse_chrg");
				System.out.println("reverseChrg="+reverseChrg);
				document =  (String) header.get("doc_type");
				System.out.println("document="+document);
				if(document != null && document.trim().length() > 0)
				{
					documentAct = document.split("-")[0];
				}
				System.out.println("documentAct="+documentAct);
				ecomRegNo =  (String) header.get("ecom_reg_no");
				System.out.println("ecomRegNo="+ecomRegNo);
				gstType =  (String) header.get("gst_type");
				if(gstType != null && gstType.trim().length() > 0)
				{
					gstType = gstType.split("-")[0];
				}
				docDate =  (String) header.get("doc_date");
				String prdCodenew=	genericUtility.getValidDateString("19/07/17", genericUtility.getApplDateFormat(), "MMYYYY");
				System.out.println("prdCodenew" +prdCodenew);
	            System.out.println("prdCodenew"+prdCodenew);
				docNo =  (String) header.get("doc_no");
				reasCode =  (String) header.get("reas_code");
				lrNo =  (String) header.get("lr_no");
				lrDate =  (String) header.get("lr_date");
				ordNo =  (String) header.get("order_no");
				tranType =  (String) header.get("tran_type");
				
				if(header.get("detailData")!= null)
				{
					ArrayList<HashMap<String, String>> detailAl = (ArrayList<HashMap<String, String>>) header.get("detailData");
					detailSql = "insert into gst_data_det(TRAN_ID,LINE_NO,STATUS,SR_NO__OLD,LINE_TYPE,GS_CODE,TAXABLE_AMT,IGST_PERC,IGST_AMT,CGST_PERC,CGST_AMT,SGST_PERC,SGST_AMT,GS_DESCR,UNIT,QUANTITY,SUPPLY_TYPE,CESS_PERC,CESS_AMT,REMARKS,ITC_TYPE,ITC_IGST,ITC_CGST,ITC_SGST,ITC_CESS,GST_RATE) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"; //Insert INTO GST_DATA_DET Table....
					pstmt1 = conn.prepareStatement(detailSql);
					for(Iterator<HashMap<String, String>> iter = detailAl.iterator();iter.hasNext();)
					{
						HashMap<String, String> detail = iter.next();
						lineNo =  (String) detail.get("line_no");
						System.out.println("  lineNo="+  lineNo);
						gscodeDet =  (String) detail.get("gs_code");
						gsdescrDet =  (String) detail.get("gs_descr");
						unitDet =  (String) detail.get("unit");
					//	gstRate =  Double.parseDouble(detail.get("gst_rate")) ;
						gstRate = getDouble((String)detail.get("gst_rate"));
						System.out.println(" gstRate="+ gstRate);
						if(gstRate <= 0)
						{
							isWithPay = true;
						}
						taxableamtDet =  (String) detail.get("taxable_amt");
						System.out.println(" taxableAmt="+ taxableamtDet);
						cessamtDet =  (String) detail.get("cess_amt");
						System.out.println(" cessAmt="+ cessamtDet);

						pstmt1.setString(1,transactionId);	
						pstmt1.setString(2,lineNo);
						pstmt1.setString(3,statusDet);
						pstmt1.setString(4,srnoOldDet);
						pstmt1.setString(5,lineTypeDet);
						pstmt1.setString(6,gscodeDet);
						pstmt1.setString(7,taxableamtDet);
						pstmt1.setString(8,igstpercDet);
						pstmt1.setString(9,igstamtDet);
						pstmt1.setString(10,cgstpercDet);
						pstmt1.setString(11,cgstamtDet);
						pstmt1.setString(12,sgstpercDet);
						pstmt1.setString(13,sgstamtDet);
						pstmt1.setString(14,gsdescrDet);
						pstmt1.setString(15,unitDet);
						pstmt1.setString(16,quantityDet);
						pstmt1.setString(17,supptypeDet);
						pstmt1.setString(18,cesspercDet);
						pstmt1.setString(19,cessamtDet);
						pstmt1.setString(20,remarksDet);
						pstmt1.setString(21,itctypeDet);
						pstmt1.setString(22,itcigstDet);
						pstmt1.setString(23,itccgstDet);
						pstmt1.setString(24,itcsgstDet);
						pstmt1.setString(25,itccessDet);
						pstmt1.setDouble(26,gstRate);
						pstmt1.addBatch();
						pstmt1.clearParameters();
					}
				}
				
				if("b2b".equalsIgnoreCase(sheetType) && "N".equalsIgnoreCase(reverseChrg) )
				{
					gstType="I";
				}
				
				else if("b2b".equalsIgnoreCase(sheetType) && "Y".equalsIgnoreCase(reverseChrg))
				{
					gstType="R";
				}
				else if("b2c".equalsIgnoreCase(sheetType))
				{
					gstType="S";
				}
				else if("exp".equalsIgnoreCase(sheetType))
				{
					gstType="E";
				}
				
				else if("nil".equalsIgnoreCase(sheetType))
				{
					gstType="L";
				}
				
				
				if("I".equalsIgnoreCase(gstType)) //B2B Supplies, with SEZ and deemed exports
				{
					if( taxRegNo.length() > 0 
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("R".equalsIgnoreCase(documentAct) || "".equalsIgnoreCase(documentAct))
							&& ("".equalsIgnoreCase(ecomRegNo) || ecomRegNo.length() <=0))
					{
						tranType = "01";
					}
					else if((taxRegNo.length() > 0) 
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("R".equalsIgnoreCase(documentAct) || "".equalsIgnoreCase(documentAct))
							&& (!"".equalsIgnoreCase(ecomRegNo) && ecomRegNo.length() > 0))
					{
						tranType = "03";
					}
					else if((taxRegNo.length() > 0) 
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("Z".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType))
							&& (!"".equalsIgnoreCase(ecomRegNo) && ecomRegNo.length() > 0) && isWithPay) 
					{
						tranType = "08";
					}
					else if((taxRegNo.length() > 0) 
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("Z".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType))
							&& (!"".equalsIgnoreCase(ecomRegNo) && ecomRegNo.length() > 0) && !isWithPay)
					{
						tranType = "09";
					}
					else if((taxRegNo.length() > 0) 
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("DE".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType))
							&& (!"".equalsIgnoreCase(ecomRegNo) && ecomRegNo.length() > 0))
					{
						tranType = "10";
					}
				}
				if("R".equalsIgnoreCase(gstType))
				{
					tranType = "02";
				}
				
				
				else if("S".equalsIgnoreCase(gstType))
				{
					if((taxRegNo.length() == 0)  //B2CL Inter State and inv amt > 250000
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& (ecomRegNo.length() == 0)
							&& (!sPos.equalsIgnoreCase(gstCode))
							&& (invAmt > b2clInvVal))//Should be taken from finParm.
					{
						tranType = "04";
					}
					else if((taxRegNo.length() == 0)  //B2CL Inter State  with ecommerce opt and inv amt > 250000
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& (ecomRegNo.length() > 0)
							&& (!sPos.equalsIgnoreCase(gstCode))
							&& (invAmt > b2clInvVal))//Should be taken from finParm.
					{
						tranType = "05";
					}
					else if((taxRegNo.length() == 0) //B2CS Inter State  with out ecommerce opt and inv amt < 250000
							&& "N".equalsIgnoreCase(reverseChrg) 
							&& (ecomRegNo.length() == 0)
							&& (!sPos.equalsIgnoreCase(gstCode))
							&& (invAmt <= b2clInvVal))//Should be taken from finParm.
					{
						tranType = "11";
					}
					else if((taxRegNo.length() == 0) //B2CS Inter State  with  ecommerce opt and inv amt < 250000								&& "N".equalsIgnoreCase(reverseCharge) 
							&& (ecomRegNo.length() > 0)
							&& (!sPos.equalsIgnoreCase(gstCode))
							&& (invAmt <= b2clInvVal))//Should be taken from finParm.
					{
						tranType = "12";
					}
					else if((taxRegNo.length() == 0) //B2CS Intra State  with out ecommerce opt and inv amt < 250000
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& (ecomRegNo.length() == 0)
							&& (sPos.equalsIgnoreCase(gstCode))
							&& (invAmt <= b2clInvVal))//Should be taken from finParm.
					{
						tranType = "13";
					}
					else if((taxRegNo.length() == 0) //B2CS Intra State  with  ecommerce opt and inv amt < 250000								&& "N".equalsIgnoreCase(reverseCharge) 
							&& (ecomRegNo.length() > 0)
							&& (sPos.equalsIgnoreCase(gstCode))
							&& (invAmt <= b2clInvVal))//Should be taken from finParm.
					{
						tranType = "14";
					}
				}
				else if("E".equalsIgnoreCase(gstType))
				{
					if(isWithPay)
					{
						tranType = "06";
					}
					else if(!isWithPay)
					{
						tranType = "07";
					}
					
				}
				
				else if("C".equalsIgnoreCase(gstType))
				{
					if( taxRegNo.length() > 0) //Credit Note to registered customer 
					{
						tranType = "29";
					}
					else
					{
						tranType = "31"; //Credit Note to un registered customer 
					}
				}
				else if("D".equalsIgnoreCase(gstType))//Debite Note to registered customer 
				{
					if( taxRegNo.length() > 0) //Credit Note to unregistered customer 
					{
						tranType = "30";
					}
					else if( taxRegNo.length() == 0) //Debite Note to unregistered customer 
					{
						tranType = "32";
					}
				}
				
				else if("A".equalsIgnoreCase(gstType))
				{
					if(sPos.equalsIgnoreCase(gstType))
					{
						tranType = "41";
					}
					else if(!sPos.equalsIgnoreCase(gstType))
					{
						tranType = "42";
					}
				}
				else if("T".equalsIgnoreCase(gstType))//Advance adjusted 
				{
					if(sPos.equalsIgnoreCase(gstType))
					{
						tranType = "43";
					}
					else if(!sPos.equalsIgnoreCase(gstType))
					{
						tranType = "44";
					}
				}
				
				headersql="insert into gst_data_hdr(TRAN_ID,TRAN_DATE,TRAN_ID__REF,SITE_CODE,PRD_CODE,REC_TYPE,TRAN_TYPE,CUST_CODE,CUST_NAME,SUBMISSION_TYPE,DOC_CHECKSUM,DOC_TYPE,DOC_NO,DOC_DATE,AMOUNT,REVERSE_CHRG,LR_NO,LR_DATE,REAS_CODE,REF_ID__INV,REF_DATE__INV,PROV_ASSMNT,ORDER_NO,ORDER_DATE,REMARKS,SUBMIT_STATUS,SUBMIT_DATE,ADD_USER,ADD_DATE,ADD_TERM,CHG_USER,CHG_DATE,CHG_TERM,TAX_REG_NO,RECO_STATUS,ECOM_REG_NO,REF_SER,GST_CODE,GST_TYPE,REF_ID) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(headersql);
				System.out.println("PSTMT"+pstmt);
				pstmt.setString(1,transactionId);	
				pstmt.setTimestamp(2,getTimeStamp(tranDate));	
				pstmt.setString(3,tranIdRef);	
				pstmt.setString(4,siteCode);
				pstmt.setString(5,prdCodenew);
				pstmt.setString(6,recType);	
				pstmt.setString(7,tranType);
				pstmt.setString(8,custCode);
				pstmt.setString(9,custName);
				pstmt.setString(10,subType);
				pstmt.setString(11,docCheckSum);	
				pstmt.setString(12,documentAct);
				pstmt.setString(13,docNo);	//doc_no
				pstmt.setTimestamp(14,getTimeStamp(docDate));
				pstmt.setDouble(15,invAmt);
				pstmt.setString(16,reverseChrg);	
				pstmt.setString(17,lrNo);
				pstmt.setTimestamp(18,getTimeStamp(lrDate));	
				pstmt.setString(19,reasCode);
				pstmt.setString(20,refIdInv);
				pstmt.setTimestamp(21,(refDateAct));
				pstmt.setString(22,provAssmnt);
				pstmt.setString(23,ordNo);	
				pstmt.setTimestamp(24,getTimeStamp(ordDate));
				pstmt.setString(25,remarks);		
				pstmt.setString(26,subStatus);
				pstmt.setTimestamp(27,getTimeStamp(subDate));
				pstmt.setString(28,addUser);	
				pstmt.setTimestamp(29,getTimeStamp(addDate));
				pstmt.setString(30,addTerm);	
				pstmt.setString(31,chgUser);
				pstmt.setTimestamp(32,getTimeStamp(chgDate));	
				pstmt.setString(33,chgTerm);
				pstmt.setString(34,taxRegNo);	
				pstmt.setString(35,recoStatus);
				pstmt.setString(36,ecomRegNo);		
				pstmt.setString(37,refSer);
				pstmt.setString(38,gstCodeAct);		
				pstmt.setString(39,gstType);
				pstmt.setString(40,refId);

				caseCount = pstmt.executeUpdate();
				pstmt.close(); pstmt = null;
				System.out.println("Update Count GSTHDR= "+caseCount);
				if(header.get("detailData")!= null)
				{
				int[] count = pstmt1.executeBatch();
				pstmt1.close(); pstmt1 = null;
				}
				System.out.println("Update Count GSTDET= "+caseCount);
			}	
		}
		catch (Exception e)
		{
			System.out.println("Exception 1::"  +headersql+""+ e.getMessage() + ":");
			e.printStackTrace();throw new ITMException(e);
		}
		finally
		{
			System.out.println("updategst isError="+isError);
			if(isError)
			{
				conn.rollback();
			}
			else
			{
				conn.commit();
			}
			if(pstmt != null){pstmt.close();pstmt = null;}
			if(pstmt1 != null){pstmt1.close();pstmt1 = null;}
			if(rs != null){rs.close();rs = null;}
			if(conn != null){conn.close();conn = null;}
		}
	}
	
	
	
	private double getDouble(String amount) 
	{
	double result = 0.0;
	result = Double.parseDouble((amount==null||amount.equals("")) ? "0" : amount);
	return result;
	}
	private String  getGstStateCode(String siteCode , Connection conn) throws ITMException
	{
		String pos ="";
		String sSQL ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			
			sSQL = "SELECT ST.GST_CODE FROM TARODEV.SITE S,TARODEV.STATE ST WHERE S.STATE_CODE = ST.STATE_CODE AND S.SITE_CODE = ?";
			pstmt = conn.prepareStatement(sSQL);
			pstmt.setString(1,siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				pos = rs.getString("GST_CODE");
			}
			
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			} 
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		
		return pos;
	}
	
	public String generateTranId( String windowName, String siteCode, Connection conn )throws Exception
	{
		System.out.println("windowName inside generateTranId =========>>"+windowName);
		System.out.println("siteCode inside generateTranId =========>>"+siteCode);
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Timestamp currDate = null;
		java.sql.Date effDate = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			String currDateStr = sdfAppl.format(currDate);

			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";

			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			xmlValues = xmlValues +        "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +        "<tran_date>" + currDateStr + "</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
		}
		catch (SQLException ex)
		{
			System.out.println("Exception 2::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();throw new ITMException(ex);
		}
		return tranId;
	}
	private Timestamp getTimeStamp(String dateStr) throws ITMException, Exception 
	{
		String dbDateStr = "";
		if(dateStr != null && !dateStr.equals(""))
		{
			dbDateStr =(new E12GenericUtility()).getValidDateTimeString(dateStr, (new E12GenericUtility()).getApplDateTimeFormat(), (new E12GenericUtility()).getDBDateTimeFormat());
			return java.sql.Timestamp.valueOf(dbDateStr);          
		}
		else
		{
			return null;
		}
	}
}


