SET DEFINE OFF

CREATE TABLE FINENT_ACCTPRD
(
	FIN_ENTITY CHAR(10) NOT NULL,
	ACCT_PRD CHAR(6) NOT NULL,
	DESCR VARCHAR2(30),
	FR_DATE DATE NOT NULL,
	TO_DATE DATE NOT NULL,
	IT_FR_DATE DATE,
	IT_TO_DATE DATE,
	CHG_DATE DATE NOT NULL,
	CHG_USER VARCHAR2(10) NOT NULL,
	CHG_TERM VARCHAR2(15) NOT NULL
);
ALTER TABLE FINENT_ACCTPRD ADD CONSTRAINT FINENT_ACCTPRD_X PRIMARY KEY(FIN_ENTITY, ACCT_PRD);

INSERT INTO ITM2MENU 
(
	application,
	level_1,
	level_2,
	level_3,
	level_4,
	level_5,
	win_name,
	descr,
	comments,
	menu_path,
	icon_path,
	obj_type,
	mob_deploy,
	chg_user,
	chg_term,
	chg_date
) 
VALUES 
(
	'ADM',
	2,
	36,
	0,
	0,
	0,
	'w_finent_acctprd',
	'Financial Entitywise Accounting Period',
	'Financial Entitywise Accounting Period',
	'ADM.2.36.0.0.0',
	'e12_logo.gif',
	'T',
	NULL,
	'AALI',
	'BASE',
	fn_sysdate()
);

INSERT INTO  TRANSETUP 
(
	TRAN_WINDOW,
	SAVE_FLAG,
	VAL_FLAG,
	KEY_FLAG,
	KEY_STRING,
	REPEATE_ADD,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	EDI_OPTION,
	TRAN_ID_COL,
	MAIL_OPTION,
	CONFIRM_MODE,
	GARBAGE_OPT,
	TABLE_NAME,
	REF_SER,
	VIEW_MODE,
	APPLICATION
) 
VALUES 
(
	'w_finent_acctprd',
	2,
	2,
	'M',
	'seq10',
	'N',
	fn_sysdate(),
	'AALI',
	'BASE',
	0,
	'FIN_ENTITY:ACCT_PRD',
	0,
	0,
	'N',
	'FINENT_ACCTPRD',
	NULL,
	'F',
	'ADM'
);

INSERT INTO OBJ_FORMS
(
	WIN_NAME,
	TITLE,
	OBJ_BROW_NAME,
	OBJ_EDIT_NAME,
	FORM_NO
) 
VALUES
(
	'w_finent_acctprd',
	'Account Period',
	'd_finent_acctprd11',
	'd_finent_acctprd21',
	'1'
);

INSERT INTO OBJ_ACTIONS 
(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE
)
VALUES 
(
	'finent_acctprd',
	1,
	'A',
	'a',
	'a',
	'Add New',
	'Add',
	'add.gif',
	'1',
	null,
	null,
	'S'
);

INSERT INTO OBJ_ACTIONS 
(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE
)
VALUES 
(
	'finent_acctprd',
	2,
	'E',
	'a',
	'a',
	'Edit',
	'Edit',
	'edit.gif',
	'1',
	null,
	null,
	'S'
);

INSERT INTO OBJ_ITEMCHANGE
(
	OBJ_NAME, 
	FORM_NO, 
	FIELD_NAME, 
	MANDATORY
)
VALUES 
(
	'finent_acctprd', 
	'1', 
	'itm_default', 
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'finent_acctprd',
	'1',
	'fin_entity',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'finent_acctprd',
	'1',
	'acct_prd',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'finent_acctprd',
	'1',
	'it_fr_date',
	'Y'
);


INSERT INTO SYSTEM_EVENTS 
(
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	OVERWRITE_CORE,
	COMP_TYPE,
	COMP_NAME,
	COMM_FORMAT
) 
VALUES 
(
	'finent_acctprd',
	'pre_validate',
	'1',
	'prv_finent_acctprd',
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE',
	'2',
	'0',
	'EJB',
	'FinEntAcctPrd',
	NULL
);

INSERT INTO SYSTEM_EVENT_SERVICES
(
	SERVICE_CODE,
	SERVICE_DESCR,
	SERVICE_URI,
	SERVICE_PROVIDER,
	METHOD_NAME,
	RETURN_VALUE,
	RETURN_TYPE,
	RETURN_DESCR,
	RETURN_XFRM,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
) 
VALUES 
(
	'prv_finent_acctprd',
	'To validate the required fields',
	'http://localhost:9090/axis/services/ValidatorService',
	'base',
	'wfValData',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('prv_finent_acctprd',1,'COMPONENT_TYPE','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('prv_finent_acctprd',2,'COMPONENT_NAME','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','FinEntAcctPrd');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_finent_acctprd',3,'XML_DATA','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_finent_acctprd',4,'XML_DATA_1','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_finent_acctprd',5,'XML_DATA_ALL','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_finent_acctprd',6,'OBJ_CONTEXT','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_finent_acctprd',7,'EDIT_FLAG','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_finent_acctprd',8,'XTRA_PARAMS','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);


INSERT INTO SYSTEM_EVENTS 
(
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	OVERWRITE_CORE,
	COMP_TYPE,
	COMP_NAME,
	COMM_FORMAT
) 
VALUES 
(
	'finent_acctprd',
	'post_item_change',
	'1',
	'poic_finent_acctprd',
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE',
	'2',
	'0',
	'EJB',
	'FinEntAcctPrd',
	NULL
);


INSERT INTO SYSTEM_EVENT_SERVICES
(
	SERVICE_CODE,
	SERVICE_DESCR,
	SERVICE_URI,
	SERVICE_PROVIDER,
	METHOD_NAME,
	RETURN_VALUE,
	RETURN_TYPE,
	RETURN_DESCR,
	RETURN_XFRM,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
) 
VALUES 
(
	'poic_finent_acctprd',
	'For item change on the required fields',
	'http://localhost:9090/axis/services/ValidatorService',
	'base',
	'itemChanged',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_finent_acctprd',1,'COMPONENT_TYPE','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_finent_acctprd',2,'COMPONENT_NAME','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE','FinEntAcctPrd');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_finent_acctprd',3,'XML_DATA','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_finent_acctprd',4,'XML_DATA_1','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_finent_acctprd',5,'XML_DATA_ALL','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_finent_acctprd',6,'OBJ_CONTEXT','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_finent_acctprd',7,'FOCUSED_COLUMN','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('poic_finent_acctprd',8,'EDIT_FLAG','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_finent_acctprd',9,'XTRA_PARAMS','I',NULL,'S',NULL,fn_sysdate(),'AALI','BASE',NULL);


INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'FIN_ENTITY',
	'W_FINENT_ACCTPRD',
	'SELECT FIN_ENTITY, DESCR FROM FINENT',
	'Financial Entity',
	0,
	0,
	fn_sysdate(),
	'AALI',
	'BASE',
	NULL,
	1,
	1
);


INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'ACCT_PRD',
	'W_FINENT_ACCTPRD',
	'SELECT CODE, DESCR FROM ACCTPRD',
	'Account Period',
	0,
	0,
	fn_sysdate(),
	'AALI',
	'BASE',
	NULL,
	1,
	1
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
   MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP01',
	'Financial Entity is empty',
	'Financial Entity is mandatory, please enter Financial Entity',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
   MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP02',
	'Invalid Financial Entity',
	'Entered Financial Entity does not existing in system, please enter valid financial entity',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP03',
	'Accounting Period is empty',
	'Accounting Period is mandatory, please enter Accounting Period',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP04',
	'Invalid Accounting Period',
	'Entered Accounting Period does not exist in system, please enter valid Accounting Period',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(	
	MSG_NO, 
	MSG_STR, 
	MSG_DESCR, 
	MSG_TYPE, 
	MSG_OPT, 
	CHG_DATE, 
	CHG_USER, 
	CHG_TERM
) 
VALUES 
(
	'VMFENACP05',
	'Accounting Period Exists',
	'Entered Accounting Period for the Financial Entity already exists, Please enter new Accounting Period',
	'E',
	'Y',
	fn_sysdate(),
	'AALI ',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP06',
	'Description is empty',
	'Accounting Period Description is mandatory, please enter Accounting Period Description',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP07',
	'From Date is Empty',
	'From Date of Accounting Period is mandatory, please enter from date of accounting period',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP08',
	'From Date Overlap',
	'From Date of Accounting Period is overlapping with the existing Accounting Period, Please enter another From Date',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP09',
	'To Date is Empty',
	'To Date of Accounting Period is mandatory, please enter to date of Accounting Period',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP10',
	'Invalid To Date',
	'To Date should be greater than From Date',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP11',
	'To Date cannot Overlap',
	'To Date of Accounting Period is overlapping with the existing Accounting Period, Please enter another To Date',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP12',
	'To Date is empty',
	'To Date for Income Tax is mandatory when from date of Income Tax is specified',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO MESSAGES 
(
	MSG_NO, 
	MSG_STR, 
	MSG_DESCR, 
	MSG_TYPE, 
	MSG_OPT, 
	CHG_DATE, 
	CHG_USER, 
	CHG_TERM 
) 
VALUES 
(
	'VMFENACP13',
	'From Date Overlap', 
	'From Date of Income Tax is overlapping with the existing Income Tax period, Please enter another IT From Date',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMFENACP14',
	'Invalid To Date',
	'To Date for Income Tax should be greater than From Date of Income Tax',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);


INSERT INTO MESSAGES 
(
	MSG_NO, 
	MSG_STR, 
	MSG_DESCR, 
	MSG_TYPE, 
	MSG_OPT, 
	CHG_DATE, 
	CHG_USER, 
	CHG_TERM
) 
VALUES 
(
	'VMFENACP15',
	'To Date Overlap', 
	'To Date of Income Tax is overlapping with the existing Income Tax period, Please enter another IT To Date',
	'E',
	'Y',
	fn_sysdate(),
	'AALI',
	'BASE'
);

COMMIT;
