package ibase.webitm.ejb.adm.adv;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Properties;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@Stateless
public class MPReqmntConfirmation extends ActionHandlerEJB implements MPReqmntConfirmationLocal,MPReqmntConfirmationRemote
{
	public	String mpreqApprove() throws RemoteException, ITMException
	{
		return "";
	}
	public	String mpreqApprove( String tranID, String xtraParams,String forcedFlag )throws RemoteException, ITMException
	{
		String resultStr = "";		
		Connection conn = null;
			
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			System.out.println("tranID::::::::::"+tranID);
			
			resultStr  = mpreqApprove(tranID,xtraParams, forcedFlag, conn);
			
			System.out.println("resultStr:::::"+resultStr);
			

		}
		catch(Exception e)
		{
			System.out.println("Exception [01][confirm]::"+e.getMessage());
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;					
				}
			}
			catch(Exception ex)
			{
				System.out.println("Exception [01][confirm]::"+ex.getMessage());
				ex.printStackTrace();
				System.out.println("Exception ::"+ex.getMessage());
				throw new ITMException(ex);
			}
		}
		System.out.println("Returning Result from confirm::"+resultStr);
		return resultStr;

	}
	public String mpreqApprove( String tranId,String xtraParams,String xmlString,Connection conn) throws RemoteException,ITMException
	{
		String apprvDateStr="",errString="",approved="",logCode="";
		boolean isError =false;
		int cnt = 0;
		ITMDBAccessLocal itmdbAccessLocal = null ;
		PreparedStatement pstmt =null;
		ResultSet rs = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			itmdbAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date currDate = new java.util.Date();		
			apprvDateStr = sdf.format(currDate);
			logCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			
			
			String sqlcnt ="SELECT COUNT(*) AS CNT FROM MPREQ WHERE VAC_NO=?";
			pstmt=conn.prepareStatement(sqlcnt);
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				cnt = rs.getInt("CNT");
			}
			close(pstmt, rs);
			if(cnt > 0)
			{
				String sql ="SELECT APPROVED FROM MPREQ WHERE VAC_NO=?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					approved = rs.getString("APPROVED");
				}
				close(pstmt, rs);
				
				
				if ((approved != null && approved.trim().length() > 0) && approved.trim().equals("Y"))
				{
					isError = true;
					errString = itmdbAccessLocal.getErrorString("","VTCONFDUP","");
					return errString;
				}
				else
				{
					String sqlUpdate ="UPDATE MPREQ SET APPROVED='Y',APPRV_DATE=?,EMP_CODE__APPRV=? WHERE VAC_NO=? ";
					pstmt=conn.prepareStatement(sqlUpdate);
					pstmt.setString(1, apprvDateStr);
					pstmt.setString(2, logCode);
					pstmt.setString(3, tranId);
					int i = pstmt.executeUpdate();
					System.out.println("row update into mpreq ="+i);
				}	
			}
			else
			{
				isError = true;
				errString = itmdbAccessLocal.getErrorString("","VTMCONF20","");
				return errString;	
			}
			
		}
		catch(Exception e)
		{
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( isError )
					{
						System.out.println("Rolling Back Changes......");
						conn.rollback();
						
					}
					else
					{
						System.out.println("Commiting Changes......");
						conn.commit();
						isError = true;
						errString = itmdbAccessLocal.getErrorString("","VTCONF","");
						return errString;
					}
					
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :CLOSE:==>\n" + e);
				throw new ITMException(e);
			}
		}
		return errString;
	}
	
	private void close(PreparedStatement pstmt,ResultSet rs) //Method to close PreparedStatement & ResultSet
	{
		try
		{
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
}
