package ibase.webitm.util.gst;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.imageio.ImageIO;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.gst.APICallData;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

public class GSTCommonUtil extends ValidatorEJB
{
	
	public String getImagePath(String tranWindow, String tranId, String altColVal, String folderName, Connection conn) throws ITMException
	{
		System.out.println("Common utility to get image path");
		String retImgPath = "", refSer = "", docId = "", docType = "", objName = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		boolean isLocConn = false;
		try
		{
			if (conn == null)
			{
				conn = getConnection();
				isLocConn = true;
			}
			
			objName = tranWindow.substring(tranWindow.indexOf("w_")+2, tranWindow.length());
						
			sql = " SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranWindow);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				refSer = checkNullAndTrim(rs.getString("REF_SER"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}
			
			sql = " SELECT DOC_CONTENTS.DOC_ID,DOC_CONTENTS.DOC_TYPE FROM DOC_CONTENTS, DOC_TRANSACTION_LINK, USERS "
				+ " WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND USERS.CODE = DOC_CONTENTS.ADD_USER "
				+ " AND REF_SER = ? AND REF_ID = ? ORDER BY DOC_CONTENTS.DOC_ID ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refSer);
			pstmt.setString(2, tranId);

			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				docId = checkNullAndTrim(rs.getString("DOC_ID"));
				docType= checkNullAndTrim(rs.getString("DOC_TYPE"));
				retImgPath = "/ibase/WebITMDocumentHandlerServlet?OBJ_NAME="+objName+"&REF_ID="+tranId.trim()+"&ACTION=GET_DOCUMENT&CLIENT=WEB1&DOC_ID="+docId+"&DOC_TYPE="+docType+"";
			}
			else
			{
				retImgPath = getCustomImagePath(tranId.trim(),altColVal,folderName);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				System.out.println("Inside finally isLocCon["+isLocConn+"]");
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				if(isLocConn)
				{
					if (conn != null )
					{
						conn.close();conn = null;
					}
				}
			} 
			catch (Exception e) 
			{
				throw new ITMException(e);
			}
		}
		
		return retImgPath;
	}
	
	public String getCustomImagePath(String value,String altColImg, String object)
	{
		String imagePath = "";
		try
		{
			File objDir = new File (CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object);
			if(!objDir.exists())
			{
				objDir.mkdir();
			}
			if( fileExist(value, object))
			{
				imagePath = File.separator+"ibase"+File.separator+"resource"+File.separator+ object+File.separator + value + ".png";
			}
			else
			{
				File f = new File(CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object+File.separator + value + ".png");
				BufferedImage bi = createLabelImage(altColImg);
				ImageIO.write(bi,"PNG",f);
				imagePath = File.separator+"ibase"+File.separator+"resource"+File.separator+ object+File.separator + value + ".png";
			}
			
		}
		catch(Exception e)
		{
			System.out.println("PopUpDataAccessEJB.getCustomeImagePath()::getCustomImagePath");
			e.printStackTrace();
		}
		return imagePath;		
	}
	public boolean fileExist(String value, String object)
	{
		boolean flag = true;
		try
		{
			String path = CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object+File.separator + value + ".png";
			File f = new File(path);
			if( !f.exists() )
			{
				flag = false;
			}
			else
			{
				flag = true;
			}
		}
		catch (Exception e) 
		{
			System.out.println("PopUpDataAccessEJB.fileExist()"+e.getMessage());
		}
		return flag;
	}
	public BufferedImage createLabelImage(String value)
	{
		int width = 400, height = 400;
		BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		try 
		{
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			File fontFile = new File(CommonConstants.APPLICATION_CONTEXT+"webitm"+File.separator+"css"+File.separator+"fonts"+File.separator+"Museo300-Regular.ttf");
			ge.registerFont(Font.createFont(Font.TRUETYPE_FONT, fontFile));
			Graphics2D g = bi.createGraphics();
			String text = checkNull(dynamicMenuImage(value));
			int centerX = 200, centerY = 200;
			int ovalWidth = 400, ovalHeight = 400;
			Font font = new Font("Museo 300", Font.PLAIN, 200);
			g.setFont(font);
			Color c = Color.decode("#cfbebe");
			g.setColor(c);
			g.fillOval(centerX-ovalWidth/2, centerY-ovalHeight/2,ovalWidth, ovalHeight);
			FontMetrics fm = g.getFontMetrics();
			double textWidth = fm.getStringBounds(text,g).getWidth();
			g.setColor(Color.WHITE);
			g.drawString(text, (int) (centerX - textWidth/2), (int) ( (centerY + fm.getMaxAscent() / 2) ) - 2);
		}
		catch (Exception e) 
		{
			System.out.println("PopUpDataAccessEJB.createLabelImage()"+e.getMessage());
		}
		return bi;
	}
	private String dynamicMenuImage(String objDescr)
	{
		StringBuffer mnIconBuffer = new StringBuffer();
		String[] refSr = null;
		
		objDescr = objDescr.toUpperCase();
		objDescr = checkNull(objDescr);
		objDescr = objDescr.trim();
		if( objDescr != "" )
		{
			if( objDescr.indexOf(" ") != -1 )
			{
				refSr = objDescr.split(" ");
			}
			else if( objDescr.indexOf("-") != -1 )
			{
				refSr = objDescr.split("-");
			}
			else if( objDescr.indexOf("_") != -1 )
			{
				refSr = objDescr.split("_");
			}
			else if( objDescr.indexOf(":") != -1 )
			{
				refSr = objDescr.split(":");
			}
			String menuStr = "";
			
			if( refSr != null )
			{
				for( int i = 0; i <= refSr.length; i++ )
				{
					if( mnIconBuffer.length() < 2 && checkNull( refSr[i] ) != "" )
					{
						menuStr = refSr[i];
						menuStr = menuStr.trim();
						if( menuStr != ":" && !"".equalsIgnoreCase(menuStr) )
						{
							mnIconBuffer.append( menuStr.charAt(0) );
						}
					}
				}
			}
			else
			{
				mnIconBuffer.append( objDescr.charAt(0) );
			}
		}
		
		String menuIconPath = mnIconBuffer.toString();
		
		return menuIconPath;
	}
	
	public String getItm2MenuDtls(String objName)
	{
		String retXML = "", title = "", imgName = "";
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		try
		{
			conn = getConnection();
			
			sql = "SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE WIN_NAME LIKE '%"+objName+"%' AND OBJ_TYPE = 'I'";
			pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			if(rs.next())
			{
				title = rs.getString("DESCR");
				imgName = rs.getString("ICON_PATH");
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			
			retXML = "<root><title><![CDATA["+title+"]]></title>"
				   + "<img><![CDATA["+imgName+"]]></img></root>";
		}
		catch(Exception e)
		{
			System.out.println("GSTCommonUtil.getItm2MenuDtls()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("GSTCommonUtil.getItm2MenuDtls()["+e.getMessage()+"]");
				e.printStackTrace();
			}
		}
		return retXML;
	}
	
	public int updateAPICallLogHistory(APICallData apiCallData, Connection conn) throws ITMException
	{
		String tranId="";
		
		int insertCnt = 0;
		boolean isLocalConnection = false, isError = false;
		
		String insertSql = "";
		PreparedStatement pstmt = null;
		
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		
		try
		{
			if(conn == null)
			{
				conn = getConnection();
				isLocalConnection = true;
			}
			tranId = generateTranId("w_gst_api_call", "", "", conn);
			
			insertSql = " INSERT INTO API_CALL_LOG (TRAN_ID, PRD_CODE, CALL_DATE, SITE_CODE, USER_ID, CALL_TYPE, REC_TYPE, NO_OF_RECORDS, CALL_STATUS, RESPONSE_ID, RESPONSE_INFO, CHG_USER, CHG_DATE, CHG_TERM)"
					  + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			pstmt = conn.prepareStatement(insertSql);
			pstmt.setString(1, tranId);
			pstmt.setString(2, apiCallData.getPeriodCode());
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(apiCallData.getCallDate(), e12GenericUtility.getDBDateTimeFormat())));
			pstmt.setString(4, apiCallData.getSiteCode());
			pstmt.setString(5, apiCallData.getUserId());
			pstmt.setString(6, apiCallData.getCallType());
			pstmt.setString(7, apiCallData.getRecType());
			pstmt.setInt(8, apiCallData.getNoOfRecords());
			pstmt.setString(9, apiCallData.getCallStatus());
			pstmt.setString(10, apiCallData.getResponseId());
			pstmt.setString(11, apiCallData.getResponseJsonStr());
			pstmt.setString(12, apiCallData.getChgUser());
			pstmt.setTimestamp(13, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(apiCallData.getChgDate(), e12GenericUtility.getDBDateTimeFormat())));
			pstmt.setString(14, apiCallData.getChgTerm());
			
			insertCnt = pstmt.executeUpdate();
			
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("GSTCommonUtil.updateAPICallLogHistory()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt!= null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(isLocalConnection)
				{
					if(isError)
					{
						conn.rollback();
					}
					else
					{
						if(insertCnt > 0)
						{
							conn.commit();
						}
					}
					
					if(conn!= null && !conn.isClosed())
					{
						conn.close();
						conn = null;
					}
					
				}
			}
			catch (Exception e) 
			{
				System.out.println("GSTCommonUtil.updateAPICallLogHistory()["+e.getMessage()+"]");
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		
		return insertCnt;
	}
	
	private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException,Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";	

		try
		{
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return tranId;
	}
	
	private static String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}

}
