package ibase.webitm.servlet;
import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.gst.GSTUploadExcelTemplate;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;






import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.Part;
@WebServlet("/GSTExcel")
public class UploadGstExcelServlet extends HttpServlet {
	
	GSTUploadExcelTemplate Ec = new GSTUploadExcelTemplate();
	
	InitialContext ctx = null;
	private static final long serialVersionUID = 1L;
    public UploadGstExcelServlet() {
        super();
    }
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		try
		{
			String excelFilePath = "";
			String objName = "";
			String objDesc = "";
			String tempName = "";
			String submitValue = "";
			String action = "";
			String fileTypeDefault = "";
			String submitAction = "";
			MultipartParser parser = new MultipartParser(request,10 * 1024 * 1024);
			Part part = null;
			UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
			while ((part = parser.readNextPart()) != null)
			{
				
				if (part.isFile())
				{
					FilePart filePart = (FilePart) part;
					String fileName = filePart.getFileName();
					if (fileName != null)
					{
						File DUMP_DIR = new File(CommonConstants.TEMP_FOLDER);
						DUMP_DIR.mkdir();
						long size = filePart.writeTo(DUMP_DIR);
						excelFilePath = DUMP_DIR + File.separator+ fileName;
						File excelFile = new File(excelFilePath);
						System.out.println("filename: " + excelFile);
					//	Workbook workbook = Workbook.getWorkbook(excelFile);
						Workbook workbook = Workbook.getWorkbook(excelFile);
				 //		Workbook workbook = new Workbook(new FileInputStream(excelFile));
						if(workbook.getNumberOfSheets() > 0)
						{
						  String responseTemp= Ec.readExcelfile(workbook, userInfo);
						  if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
							{
								response.setHeader("Content-Encoding", "gzip");
								GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
								gzOutStream.write(responseTemp.getBytes());
								gzOutStream.flush();
								gzOutStream.close();
							}
							else
							{
								response.setHeader("Content-Encoding", "");
								OutputStream outStream = response.getOutputStream();
								outStream.write(responseTemp.getBytes());
								outStream.flush();
								outStream.close();
							}
						  System.out.println("Sheets.." );
						}
						request.getSession().setAttribute("excelFile", excelFilePath);
						request.getSession().setAttribute("objName", objName);
						request.getSession().setAttribute("objDesc", objDesc);
					}
				}
			}
		
		
			
		}catch(Exception  e1)
		{
			
		}
		
		
	}
	
	

}
