package ibase.dashboard.ssc.servlet;
import ibase.dashboard.ssc.ejb.PendingPurcOrderRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;
public class PendingInvoiceServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData =null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}
  
	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		PendingPurcOrderRemote pendingPurcOrdRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginId = "";
		String fromDate = "";
		String toDate = "";
		
		try
		{
			
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();
			dataSourceName  =request.getParameter("dataSourceName"); 
			fromDate  =request.getParameter("fromDate"); 
			toDate    =request.getParameter("toDate"); 
			System.out.println( "login code comming from session =" + loginId );
			context = new InitialContext(appConnectParm.getProperty());
			pendingPurcOrdRemote = (PendingPurcOrderRemote)context.lookup("ibase/PendingPurcOrder/remote");
			JSONObject jsonObjData      = (JSONObject)pendingPurcOrdRemote.getPendingInvoice(loginId,fromDate,toDate, dataSourceName);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for PendingInvoiceServlet build for Graph ===" + jsonObjData);	

		} catch (Exception e)
		{
			System.out.println("Exception : PendingInvoiceServlet :" + e.getMessage());
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
		
	}
}