package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;

import ibase.webitm.bean.gst.BaseData;
import ibase.webitm.bean.gst.InvLineItem;
import ibase.webitm.bean.gst.Invoice;

abstract class BaseSerializer<T extends BaseData> extends JsonSerializer<T> 
{
    final SimpleDateFormat gstFmt = new SimpleDateFormat("dd-MM-yyyy");

    void writeInvoices(T genericInvoice, JsonGenerator json) throws IOException 
    {
        json.writeFieldName("inv");
        json.writeStartArray();

        for(Invoice inv : genericInvoice.invoices)
        {
        	writeInvoice(genericInvoice, json, inv);
        }
        
        json.writeEndArray();
    }

    private void writeInvoice(T genericInvoice, JsonGenerator json, Invoice inv) 
    {
        try 
        {
            json.writeStartObject();
            
            if( (inv.flag != null) && ("A".equalsIgnoreCase(inv.flag) || "M".equalsIgnoreCase(inv.flag) || "D".equalsIgnoreCase(inv.flag)) )
            {
            	json.writeStringField("flag", inv.flag);
            	json.writeStringField("inum", inv.inum);
                json.writeStringField("idt", gstFmt.format(inv.idt));
                json.writeStringField("chksum", inv.checksum);
            }
            else
            {
            	if (inv.oinum != null && inv.oidt != null) 
                {
                	json.writeStringField("oinum", inv.oinum);
                    json.writeStringField("oidt", gstFmt.format(inv.oidt));
                }
                if(inv.cname != null)
                {
                	json.writeStringField("cname", inv.cname);
                }
                if(inv.shippingPortCode != null)
                {
                	json.writeStringField("sbpcode", inv.shippingPortCode);
                }
                if(inv.shippingBillNum != null)
                {
                	json.writeStringField("sbnum", inv.shippingBillNum);
                }
                if(inv.shippingBillDt != null)
                {
                	json.writeStringField("sbdt", gstFmt.format(inv.shippingBillDt));
                }
                
                json.writeStringField("inum", inv.inum);
                json.writeStringField("idt", gstFmt.format(inv.idt));
                json.writeNumberField("val", inv.val);
                json.writeStringField("pos", inv.pos);
                if(genericInvoice.isReverseCharge)
                {
                	json.writeStringField("rchrg", inv.rchrg ? "Y" : "N");
                }
                json.writeStringField("prs", inv.prs ? "Y" : "N");
                if (inv.prs) 
                {
                    json.writeStringField("od_num", inv.od_num);
                    json.writeStringField("od_dt", gstFmt.format(inv.od_dt));
                }
                if(inv.etin!=null)
                {
                	json.writeStringField("etin", inv.etin);
                }

                writeLineItems(genericInvoice, json, inv);
            }

            json.writeEndObject();
        } 
        catch (Exception e) 
        {
        	System.out.println("BaseSerializer.writeInvoice()["+e.getMessage()+"]");
            e.printStackTrace();
        }
    }

    private void writeLineItems(T genericInvoice, JsonGenerator json, Invoice inv) throws IOException 
    {
        json.writeFieldName("itms");
        json.writeStartArray();
        
        for(InvLineItem li : inv.items)
        {
        	writeLineItem(genericInvoice, json, li);
        }

        json.writeEndArray();
    }

    private void writeLineItem(T genericInvoice, JsonGenerator json, InvLineItem li) 
    {
        try 
        {
            json.writeStartObject();
            json.writeNumberField("num", li.num);
            
            json.writeFieldName("itm_det");
            json.writeStartObject();
            json.writeStringField("ty", li.ty);
            json.writeStringField("hsn_sc", li.hsn_sc);
            json.writeNumberField("txval", li.taxval);

            json.writeNumberField("irt", li.irt);
            json.writeNumberField("iamt", li.iamt);
            
        	json.writeNumberField("crt", li.crt);
        	json.writeNumberField("camt", li.camt);
        	
        	json.writeNumberField("srt", li.srt);
        	json.writeNumberField("samt", li.samt);
            
            json.writeNumberField("csrt", li.csrt);
            json.writeNumberField("csamt", li.csamt);
            json.writeEndObject();
            
            json.writeEndObject();
        }
        catch (Exception e) 
        {
        	System.out.println("BaseSerializer.writeLineItem()["+e.getMessage()+"]");
            e.printStackTrace();
        }
    }
}
