package ibase.webitm.servlet.gst;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.gst.GSTDataSubmitWizEJBRemote;
import ibase.webitm.utility.ITMException;

public class GSTDataSubmitWizServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;
	InitialContext ctx = null;

    public GSTDataSubmitWizServlet() {
        super();
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		doPost( request, response );
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ GSTDataSubmitWizServlet START]XXXXXXXXXXXXXXXXXXXX");
		request.setCharacterEncoding(CommonConstants.ENCODING);
		String action = "", responseXML = "";
		GSTDataSubmitWizEJBRemote gstDataSubmitWizRemote = null;
		
		try 
		{	
			action = request.getParameter("action");
			System.out.println("GSTDataSubmitWizServlet ACTION ["+action+"]");
			
			if("".equalsIgnoreCase(action))
			{
				
			}
			else
			{
				HashMap<String,String> requestParamMap = new HashMap<String,String>();
				String paramName = "", paramValue = "";
				
				@SuppressWarnings("unchecked")
				Enumeration<String> reqParams = request.getParameterNames();
				while(reqParams.hasMoreElements())
				{
					Object paramObj = reqParams.nextElement();
					paramName = (String) paramObj;
					paramValue = (String)request.getParameter(paramName);
					if(!paramValue.equalsIgnoreCase(""))
						requestParamMap.put(paramName,paramValue);
				}
				System.out.println("Request Parameter map :"+requestParamMap);
				
				ctx=getInitialContext();
				gstDataSubmitWizRemote = (ibase.webitm.ejb.gst.GSTDataSubmitWizEJBRemote) ctx.lookup("ibase/GSTDataSubmitWizEJB/remote");
				responseXML = gstDataSubmitWizRemote.handleRequest(requestParamMap);
				
				response.setContentType("text/xml");
		         
		         if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(responseXML.getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(responseXML.getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			
		} 
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizServlet.doPost():doPost"+e.getMessage());
			e.printStackTrace();
		}
		
         System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ GSTDataSubmitWizServlet END]XXXXXXXXXXXXXXXXXXXX");
	}
	
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("GSTDataSubmitWizServlet.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizServlet.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
}
