package ibase.dashboard.wms.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class WMS3PLDashboard extends ValidatorEJB implements WMS3PLDashboardRemote, WMS3PLDashboardLocal
{
	/**
	 * Default constructor.
	 */
	public WMS3PLDashboard()
	{
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusSummary(String siteCode, String dataSourceName) throws RemoteException, ITMException 
	{
		JSONObject rawDataOrderStatusSumJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println("********** In WMS3PLDashboard : getOrderStatusSummary Method ****************** ");
			System.out.println("************* dataSourceName :"+dataSourceName);
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			DashboardUtility dashboardUtility = new DashboardUtility();
			if(siteCode.length() == 0)
			{
				siteCode = "'SP110','TA387','TA821','TA160','TC388','MJ614','UT619','CS200','BH204','TL901'";
			}else
			{
				siteCode = dashboardUtility.getCommaSeparated(siteCode);
			}
			System.out.println("************ getOrderStatusSummary siteCode :"+siteCode);
			
			sql = " select distinct(A.site_code) as sitecode, A.site_descr as site_descr, nvl(B.Porder,0) as Porder , nvl(C.Shipment,0) as Shipment ,nvl(D.Credit_Check,0) as Credit_Check, nvl(E.Hold,0) as Hold, nvl(F.WIP,0) as WIP " +
				" from  " +
				" (select distinct(site_code) as site_code,descr as site_descr from site) A " +
				" left outer join  " +
				" ( " +
				" select site_code,count(sale_order) as Porder from sorder  " +
				" where status in ('H','P') and DUE_DATE <= sysdate " +
				" group by site_code) B " +
				" on A.site_code=B.site_code " +
				" left outer join  " +
				" ( Select site_code,count(distinct sale_order) as Shipment from invoice group by site_code " +
				" ) C " +
				" on A.site_code=C.site_code " +
				" left outer join  " +
				" ( Select Sorder.site_code,count(distinct business_logic_check.sale_order) as Credit_Check  " +
				"  from business_logic_check,Sorder " +
				" where Sorder.sale_order=business_logic_check.sale_order and  aprv_stat='F' and  sorder.DUE_DATE <= sysdate " +
				" group by site_code " +
				" ) D " +
				" on A.site_code=D.site_code " +
				" left outer join  " +
				" ( Select  site_code,count(sale_order) as Hold from sorder " +
				" where status='H' and DUE_DATE <=sysdate " +
				" group by site_code " +
				" ) E " +
				" on A.site_code=E.site_code " +
				" left outer join  " +
				" ( Select  site_code,count(sale_order) as WIP from sorder " +
				" where status in ('H','P') and DUE_DATE <= sysdate " +
				" group by site_code " +
				" ) F " +
				" on A.site_code=F.site_code where A.site_code in (" +siteCode+" )" ;

			pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			int porder = 0;
			int shipment = 0;
			int creditCheck = 0;
			int hold = 0;
			int wip = 0;
			while(rs.next())
			{
				porder = rs.getInt("PORDER");
				shipment = rs.getInt("SHIPMENT");
				creditCheck = rs.getInt("CREDIT_CHECK");
				hold = rs.getInt("HOLD");
				wip = rs.getInt("WIP");
				
				if(porder == 0 && shipment == 0 && creditCheck == 0 && hold == 0 && wip == 0)
				{
					rowData = new JSONObject();
					rowData.put("sitecode", checkNull(rs.getString("SITECODE")).trim());
					rowData.put("sitedescr", checkNull(rs.getString("site_descr")).trim());
					rowData.put("lable", "No Data");
					rowData.put("value", "1");
					rawDataOrderStatusSumJson.put(count, rowData);
					count++;
				}else
				{	
					rowData = new JSONObject();
					rowData.put("sitecode", checkNull(rs.getString("SITECODE")).trim());
					rowData.put("sitedescr", checkNull(rs.getString("site_descr")).trim());
					rowData.put("lable", "Pending");
					rowData.put("value", checkNull(rs.getString("PORDER")).trim());
					rawDataOrderStatusSumJson.put(count, rowData);
					count++;
					
					rowData = new JSONObject();
					rowData.put("sitecode", checkNull(rs.getString("SITECODE")).trim());
					rowData.put("sitedescr", checkNull(rs.getString("site_descr")).trim());
					rowData.put("lable", "Shipment");
					rowData.put("value", checkNull(rs.getString("SHIPMENT")).trim());
					rawDataOrderStatusSumJson.put(count, rowData);
					count++;
					
					rowData = new JSONObject();
					rowData.put("sitecode", checkNull(rs.getString("SITECODE")).trim());
					rowData.put("sitedescr", checkNull(rs.getString("site_descr")).trim());
					rowData.put("lable", "Credit Check");
					rowData.put("value", checkNull(rs.getString("CREDIT_CHECK")).trim());
					rawDataOrderStatusSumJson.put(count, rowData);
					count++;
					
					rowData = new JSONObject();
					rowData.put("sitecode", checkNull(rs.getString("SITECODE")).trim());
					rowData.put("sitedescr", checkNull(rs.getString("site_descr")).trim());
					rowData.put("lable", "Hold");
					rowData.put("value", checkNull(rs.getString("HOLD")).trim());
					rawDataOrderStatusSumJson.put(count, rowData);
					count++;
					
					rowData = new JSONObject();
					rowData.put("sitecode", checkNull(rs.getString("SITECODE")).trim());
					rowData.put("sitedescr", checkNull(rs.getString("site_descr")).trim());
					rowData.put("lable", "WIP");
					rowData.put("value", checkNull(rs.getString("WIP")).trim());
					rawDataOrderStatusSumJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("rawDataOrderStatusSumJson :"+rawDataOrderStatusSumJson);
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusSummary:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusSumJson;
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusDetail(String siteCode, String dataSourceName) throws RemoteException, ITMException 
	{
		JSONObject rawDataOrderStatusDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println("********** In WMS3PLDashboard : getOrderStatusDetail Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			double totalCircle=629;	
			DashboardUtility dashboardUtility = new DashboardUtility();
			if(siteCode.length() == 0)
			{
				siteCode = "'SP110','TA387','TA821','TA160','TC388','MJ614','UT619','CS200','BH204','TL901'";
			}else
			{
				siteCode = dashboardUtility.getCommaSeparated(siteCode);
			}
			
			double totalPackingPercnt = 0.0;
			double totalPackingValPercnt = 0.0;
			double totalPackingLinePercnt = 0.0;
			double totalPackingQtyPercnt = 0.0;
			
			double dashOffSetTotalPacking = 0.0;
			double dashOffSetTotalPackingVal = 0.0;
			double dashOffSetTotalPackingLine = 0.0;
			double dashOffSetTotalPackingQty = 0.0;
			
			double totalShipPercnt = 0.0;
			double totalShipValPercnt = 0.0;
			double totalShipLinePercnt = 0.0;
			double totalShipQtyPercnt = 0.0;
			
			double dashOffSetTotalShip = 0.0;
			double dashOffSetTotalShipVal = 0.0;
			double dashOffSetTotalShipLine = 0.0;
			double dashOffSetTotalShipQty = 0.0;
			
			double totalOrder = 0.0;
			
			sql = " Select M.Site_code,M.site_descr, NVL(A.TOT_ORD1,0)+NVL(B.TOT_ORD1,0) Total_Orders , NVL(A.Ord_AMT1,0) + NVL(B.Ord_AMT1,0) Total_Order_Value, " +
					" NVL(C.TOT_LN1,0)+NVL(D.TOT_LN1,0) Total_Order_Line_No,NVL(C.Ord_Qty1,0) +NVL(D.Ord_Qty1,0) Total_Order_Quantity, " +
					" NVL(Total_Picking,0) Total_Picking, NVL(Total_Picking_Value,0) Total_Picking_Value, " +
					" NVL(Total_Picking_Line_NO,0) Total_Picking_Line_NO, NVL(Total_Picking_Quantity,0) Total_Picking_Quantity, " +
					" NVL(E.Total_Shippment,0) Total_Shippment,NVL(E.Total_Shippment_Value,0) Total_Shippment_Value, " +
					" NVL(Total_Shippment_LineNo,0) Total_Shippment_LineNo ,NVL(Total_Shippment_Quantity,0) Total_Shippment_Quantity " +
					" from " +
					" (select site_code,descr as site_descr from site where site_code in(" +siteCode +"))M " +
					" left outer join " +
					" (select Site_code,NVL(count(sale_Order),0) TOT_ORD1,NVL(Sum(TOT_AMT),0) Ord_AMT1 from sorder where status not in ('C','X') and order_date < CURRENT_Date " +
					" group by Site_code)A " +
					" on M.Site_Code=A.Site_code " +
					" left outer join " +
					" (select Site_code,NVL(count(sale_Order),0) TOT_ORD1,NVL(Sum(TOT_AMT),0) Ord_AMT1 from sorder where order_date = CURRENT_Date  group by Site_code)B " +
					" on M.Site_Code=B.Site_code " +
					" left outer join " +
					" (select sorder.Site_code,NVL(count(Sorddet.Line_no),0) TOT_LN1,NVL(SUM(Sorddet.Quantity),0) Ord_Qty1 " +
					" from sorder,Sorddet where sorder.Sale_Order=Sorddet.Sale_Order " +
					" and  sorder.status not in ('C','X') and order_date < CURRENT_Date " +
					" group by sorder.Site_code)C " +
					" on M.Site_Code=C.Site_code " +
					" left outer join " +
					" (select sorder.Site_code,NVL(count(Sorddet.Line_no),0) TOT_LN1,NVL(SUM(Sorddet.Quantity),0) Ord_Qty1 " +
					" from sorder,Sorddet where sorder.Sale_Order=Sorddet.Sale_Order " +
					" and order_date = CURRENT_Date " +
					" group by sorder.Site_code)D " +
					" on M.Site_Code=D.Site_code " +
					" left outer join " +
					" (Select site_code,count(distinct sale_order) Total_Shippment,Sum(Net_AMT)  Total_Shippment_Value from invoice " +
					" where tran_date = CURRENT_Date " +
					" Group by site_code) E " +
					" on M.Site_Code=E.Site_code " +
					" left outer join " +
					" (Select invoice.site_code,count(distinct INVDET.SOrd_Line_NO) Total_Shippment_LineNo,Sum(INVDET.Quantity) Total_Shippment_Quantity " +
					" from invoice ,INVDET " +
					" where invoice.tran_date = CURRENT_Date " +
					" Group by invoice.site_code) F " +
					" on M.Site_Code=F.Site_code " +
					" left outer join " +
					" (select Site_code,count(sale_order) Total_Picking,Sum(Tot_amt) Total_Picking_Value " +
					" from sorder where  status not in ('C','X','H') " +
					" and sorder.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER)='A-PICK' and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = SORDER.sale_order and confirmed = 'Y') " +
					" Group by Site_code)G " +
					" on M.Site_Code=G.Site_code " +
					" left outer join " +
					" (select sorder.Site_code,count(sorddet.Line_NO) Total_Picking_Line_NO,Sum(sorddet.Quantity) Total_Picking_Quantity " +
					" from sorder,sorddet where  sorder.sale_order=sorddet.sale_order " +
					" and sorder.status not in ('C','X','H') " +
					" and sorder.sale_order in " +
					" (select distinct sale_order " +
					" from wave_task_det,Wave_task " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER)='A-PICK' and " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID " +
					" And Hdr.Confirmed = 'Y')) " +
					" and not exists(select 1 from despatch where sord_no = SORDER.sale_order and confirmed = 'Y') " +
					" Group by sorder.Site_code  )H " +
					" on M.Site_Code=H.Site_code ";
			
			
			pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				
				rowData = new JSONObject();
				
				rowData.put("site_code", checkNull(rs.getString("SITE_CODE")).trim());
				rowData.put("site_descr", checkNull(rs.getString("site_descr")).trim());
				totalOrder = rs.getDouble("TOTAL_ORDERS");
				
				rowData.put("totalorders", checkNull(rs.getString("TOTAL_ORDERS")).trim());
				rowData.put("value", checkNull(rs.getString("TOTAL_ORDER_VALUE")).trim());
				rowData.put("lineno", checkNull(rs.getString("TOTAL_ORDER_LINE_NO")).trim());
				rowData.put("quantity", checkNull(rs.getString("TOTAL_ORDER_QUANTITY")).trim());
				
				rowData.put("totalpicking", checkNull(rs.getString("TOTAL_PICKING")).trim());
				rowData.put("pickingval", checkNull(rs.getString("TOTAL_PICKING_VALUE")).trim());
				rowData.put("pickingline", checkNull(rs.getString("TOTAL_PICKING_LINE_NO")).trim());
				rowData.put("pickingqty", checkNull(rs.getString("TOTAL_PICKING_QUANTITY")).trim());
				
				
				rowData.put("totalshippment", checkNull(rs.getString("TOTAL_SHIPPMENT")).trim());
				rowData.put("shippmentval", checkNull(rs.getString("TOTAL_SHIPPMENT_VALUE")).trim());
				rowData.put("shippmentline", checkNull(rs.getString("TOTAL_SHIPPMENT_LINENO")).trim());
				rowData.put("shippmentqty", checkNull(rs.getString("TOTAL_SHIPPMENT_QUANTITY")).trim());
				
				
				/*Start Code block for PACKING */
				if(rs.getDouble("TOTAL_PICKING")!=0 && totalOrder !=0 )
				{
					totalPackingPercnt =( (rs.getDouble("TOTAL_PICKING")/totalOrder) * 100 ) ; 
					dashOffSetTotalPacking = ((totalCircle * totalPackingPercnt) / 100);
					rowData.put("totalpackpercnt", Math.round(totalPackingPercnt));
					rowData.put("dashoffsettotalpack", Math.round(dashOffSetTotalPacking));
				}else
				{
					rowData.put("totalpackpercnt", "0");
					rowData.put("dashoffsettotalpack", "0");
				}
				
				if(rs.getDouble("TOTAL_PICKING_VALUE")!=0 && rs.getDouble("TOTAL_ORDER_VALUE")!=0)
				{
					totalPackingValPercnt =( (rs.getDouble("TOTAL_PICKING_VALUE")/rs.getDouble("TOTAL_ORDER_VALUE")) * 100 ) ; 
					dashOffSetTotalPackingVal = ((totalCircle * totalPackingValPercnt) / 100);	
					rowData.put("totalpackvalpercnt", Math.round(totalPackingValPercnt));
					rowData.put("dashoffsetvalpack", Math.round(dashOffSetTotalPackingVal));
				}else{
					rowData.put("totalpackvalpercnt", "0");
					rowData.put("dashoffsetvalpack", "0");
				}
				
				
				
				if(rs.getDouble("TOTAL_PICKING_LINE_NO")!=0 && rs.getDouble("TOTAL_ORDER_LINE_NO")!=0)
				{
					totalPackingLinePercnt =( (rs.getDouble("TOTAL_PICKING_LINE_NO")/rs.getDouble("TOTAL_ORDER_LINE_NO")) * 100 ) ; 
					dashOffSetTotalPackingLine = ((totalCircle * totalPackingLinePercnt) / 100);
					rowData.put("totalpacklinepercnt", Math.round(totalPackingLinePercnt));
					rowData.put("dashoffsetlinepack", Math.round(dashOffSetTotalPackingLine));
				}else{
					rowData.put("totalpacklinepercnt", "0");
					rowData.put("dashoffsetlinepack", "0");
				}
				
				if(rs.getDouble("TOTAL_PICKING_QUANTITY")!=0 && rs.getDouble("TOTAL_ORDER_QUANTITY")!=0)
				{
					totalPackingQtyPercnt =( (rs.getDouble("TOTAL_PICKING_QUANTITY")/rs.getDouble("TOTAL_ORDER_QUANTITY")) * 100 ) ; 
					dashOffSetTotalPackingQty = ((totalCircle * totalPackingQtyPercnt) / 100);
					rowData.put("totalpackqtypercnt", Math.round(totalPackingQtyPercnt));
					rowData.put("dashoffsettotalqtypack", Math.round(dashOffSetTotalPackingQty));
				}else
				{
					rowData.put("totalpackqtypercnt", "0");
					rowData.put("dashoffsettotalqtypack", "0");
				}
				/*END Code block for PACKING */
				
				/*START Code block for SHIPMENT */
				if(rs.getDouble("TOTAL_SHIPPMENT")!=0 && totalOrder !=0 )
				{
					totalShipPercnt =( (rs.getDouble("TOTAL_SHIPPMENT")/totalOrder) * 100 ) ; 
					dashOffSetTotalShip = ((totalCircle * totalShipPercnt) / 100);
					rowData.put("totalshippercnt", Math.round(totalPackingPercnt));
					rowData.put("dashoffsettotalship", Math.round(dashOffSetTotalShip));
				}else
				{
					rowData.put("totalshippercnt", "0");
					rowData.put("dashoffsettotalship", "0");
				}
				
				if(rs.getDouble("TOTAL_SHIPPMENT_VALUE")!=0 && rs.getDouble("TOTAL_ORDER_VALUE")!=0)
				{
					totalShipValPercnt =( (rs.getDouble("TOTAL_SHIPPMENT_VALUE")/rs.getDouble("TOTAL_ORDER_VALUE")) * 100 ) ; 
					dashOffSetTotalShipVal = ((totalCircle * totalShipValPercnt) / 100);	
					rowData.put("totalshipvalpercnt", Math.round(totalShipValPercnt));
					rowData.put("dashoffsetvalship", Math.round(dashOffSetTotalShipVal));
				}else{
					rowData.put("totalshipvalpercnt", "0");
					rowData.put("dashoffsetvalship", "0");
				}
				
				if(rs.getDouble("TOTAL_SHIPPMENT_LINENO")!=0 && rs.getDouble("TOTAL_ORDER_LINE_NO")!=0)
				{
					totalShipLinePercnt =( (rs.getDouble("TOTAL_SHIPPMENT_LINENO")/rs.getDouble("TOTAL_ORDER_LINE_NO")) * 100 ) ; 
					dashOffSetTotalShipLine = ((totalCircle * totalShipLinePercnt) / 100);
					rowData.put("totalshiplinepercnt", Math.round(totalShipLinePercnt));
					rowData.put("dashoffsetlineship", Math.round(dashOffSetTotalShipLine));
				}else{
					rowData.put("totalshiplinepercnt", "0");
					rowData.put("dashoffsetlineship", "0");
				}
				
				if(rs.getDouble("TOTAL_SHIPPMENT_QUANTITY")!=0 && rs.getDouble("TOTAL_ORDER_QUANTITY")!=0)
				{
					totalShipQtyPercnt =( (rs.getDouble("TOTAL_SHIPPMENT_QUANTITY")/rs.getDouble("TOTAL_ORDER_QUANTITY")) * 100 ) ; 
					dashOffSetTotalShipQty = ((totalCircle * totalShipQtyPercnt) / 100);
					rowData.put("totalshipqtypercnt", Math.round(totalShipQtyPercnt));
					rowData.put("dashoffsettotalqtyship", Math.round(dashOffSetTotalShipQty));
				}else
				{
					rowData.put("totalshipqtypercnt", "0");
					rowData.put("dashoffsettotalqtyship", "0");
				}
				/*END Code block for SHIPMENT */
				rawDataOrderStatusDtlJson.put(count, rowData);
				count++;
			}
			
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusDtlJson;
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getShipmentEfficiencySummary(String siteCode, String dataSourceName) throws RemoteException, ITMException 
	{
		JSONObject rawDataShpmentEffiJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		String delay_time = "";
		String on_time = "";
		double percntVal = 0.0;
		double percentage=0.0,totalCircle=629,dashOffSet=0;	
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println("********** In WMS3PLDashboard : getShipmentEfficiencySummary Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			DashboardUtility dashboardUtility = new DashboardUtility();
			if(siteCode.length() == 0)
			{
				siteCode = "'SP110','TA387','TA821','TA160','TC388','MJ614','UT619','CS200','BH204','TL901'";
			}else
			{
				siteCode = dashboardUtility.getCommaSeparated(siteCode);
			}
			System.out.println("************ getOrderStatusDueDateWiseSummary siteCode :"+siteCode);
			
			sql =   "Select S.Site_Code,S.descr as site_descr, S.Total_Orders, nvl(O.On_Time,0)as ON_TIME," +
					"nvl(D.Delay_Time,0)as DELAY_TIME, nvl(OD.OVER_DUE,0) as OVER_DUE, nvl(ROUND((DT.AVG_DELAY)/(S.Total_Orders),0),0) AVERAGE " +
					"From (Select S.Site_Code, site.descr, nvl(Count(Sale_Order),0) Total_Orders From Sorder S " +
					"inner join Site site On site.site_code = s.site_code where site.site_code in("+siteCode+") " +
					"Group By S.Site_Code,site.descr) S Left Outer Join (SELECT S.SITE_CODE, " +
					"COUNT(S.LINE_NO) ON_TIME From Sorddet S Inner Join (Select Inv.Invoice_Id, Inv.Tran_Date, " +
					"Invd.Sord_No, Invd.Sord_Line_No From Invoice Inv " +
					"Inner Join Invdet Invd On Inv.Invoice_Id = Invd.Invoice_Id) I On S.Sale_Order = I.Sord_No " +
					"And S.Line_No = I.Sord_Line_No Where S.Dsp_Date = I.Tran_Date " +
					"Group By S.Site_Code ) O On S.Site_Code = O.Site_Code " +
					"Left Outer Join (SELECT S.SITE_CODE, ROUND(AVG(I.Tran_Date - S.Dsp_Date),2) DELAY_TIME " +
					"From Sorddet S Inner Join (Select Inv.Invoice_Id, Inv.Tran_Date, Invd.Sord_No, " +
					"Invd.Sord_Line_No From Invoice Inv " +
					"Inner Join Invdet Invd On Inv.Invoice_Id = Invd.Invoice_Id) I On S.Sale_Order = I.Sord_No " +
					"And S.Line_No = I.Sord_Line_No Where S.Dsp_Date < I.Tran_Date " +
					"Group By S.Site_Code) D On S.Site_Code = D.Site_Code " +
					"LEFT OUTER JOIN (SELECT S.SITE_CODE, COUNT(S.LINE_NO) OVER_DUE From Sorddet S " +
					"Inner Join (Select Inv.Invoice_Id, Inv.Tran_Date, Invd.Sord_No, Invd.Sord_Line_No " +
					"From Invoice Inv Inner Join Invdet Invd On Inv.Invoice_Id = Invd.Invoice_Id) " +
					"I On S.Sale_Order = I.Sord_No And S.Line_No = I.Sord_Line_No " +
					"Where S.Dsp_Date < I.Tran_Date Group By S.Site_Code) Od ON S.SITE_CODE = OD.SITE_CODE " +
					"Left Outer Join (SELECT SITE_CODE, nvl(SUM(AVG_DELAY),0) AVG_DELAY FROM (SELECT S.SITE_CODE, " +
					"S.SALE_ORDER, COUNT(s.sale_order) * (ROUND(AVG(I.Tran_Date - S.Dsp_Date),2)) AVG_DELAY " +
					"From Sorddet S Inner Join (Select Inv.Invoice_Id, Inv.Tran_Date, " +
					"Invd.Sord_No, Invd.Sord_Line_No From Invoice Inv " +
					"Inner Join Invdet Invd On Inv.Invoice_Id = Invd.Invoice_Id) I On S.Sale_Order = I.Sord_No " +
					"And S.Line_No = I.Sord_Line_No Where S.Dsp_Date < I.Tran_Date Group By S.Site_Code, " +
					"S.SALE_ORDER)A GROUP BY SITE_CODE) Dt On S.Site_Code = Dt.Site_Code ";
			
            pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				rowData = new JSONObject();
				
				rowData.put("site_code", checkNull(rs.getString("SITE_CODE")).trim());
				rowData.put("site_descr", checkNull(rs.getString("site_descr")).trim());
				rowData.put("total_orders", checkNull(rs.getString("TOTAL_ORDERS")).trim());
				rowData.put("on_time", checkNull(rs.getString("ON_TIME")).trim());
				rowData.put("delay_time", checkNull(rs.getString("DELAY_TIME")).trim());
				rowData.put("over_due", checkNull(rs.getString("OVER_DUE")).trim());
				rowData.put("average", checkNull(rs.getString("AVERAGE")).trim());
				rowData.put("circledisplay", "c100");
			    /*Calculate percentage*/
				double delayTime =  Double.parseDouble(checkNull(rs.getString("DELAY_TIME")).trim());
				double onTime =  Double.parseDouble(checkNull(rs.getString("ON_TIME")).trim());
				double totalTime = delayTime + onTime;
			    
				percentage = (delayTime/(delayTime+onTime))*100;
				rowData.put("percentage", Math.round(percentage));
				rowData.put("spanvalue", Math.round(percentage)+"%");
				
				
				dashOffSet=(totalCircle*percentage)/100;
				rowData.put("dashOffSet", dashOffSet);
				
				rowData.put("total_time", ""+totalTime);
			    rawDataShpmentEffiJson.put(count, rowData);
				count++;
			}
			
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataShpmentEffiJson;
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getOrderStatusDueDateWiseSummary(String siteCode, String dataSourceName) throws RemoteException, ITMException 
	{
		JSONObject rawDataOrdStatusDueDateWiseJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		double percentage=0.0,totalCircle=629,dashOffSet=0;	
		try
		{
			System.out.println("********** In WMS3PLDashboard : getOrderStatusDueDateWiseSummary Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			DashboardUtility dashboardUtility = new DashboardUtility();
			if(siteCode.length() == 0)
			{
				siteCode = "'SP110','TA387','TA821','TA160','TC388','MJ614','UT619','CS200','BH204','TL901'";
			}else
			{
				siteCode = dashboardUtility.getCommaSeparated(siteCode);
			}
			System.out.println("************ getOrderStatusDueDateWiseSummary siteCode :"+siteCode);
			
			sql =   "select M.site_code,M.site_descr, Nvl(A.Total_Order,0) Total_Order," +
					"Nvl(Past_Due_date,0) Past_Due_date, Nvl(B.Pending_Item,0) Pending_Item, " +
					"Nvl(I.Inventory,0) Inventory,Nvl(C.On_Hold,0) On_Hold,Nvl(G.ON_TIME,0) as InitialShipment,Round(Nvl(F.Total_Sku,0)) as TotalSKUOrder, Nvl(E.WIP,0) WIP, " +
					"Case when Nvl(F.Total_Sku,0) >0 then Round(Nvl(G.ON_TIME,0)/Nvl(F.Total_Sku,0)*100,0) " +
					"else 0 end as SKU_Fill_Rate from ( select distinct(site_code) as site_code,descr as site_descr from site where site_code in("+siteCode+") ) M " +
					"left outer join ( select site_code, Nvl(count(Sale_Order),0) Total_Order " +
					"from sorder group by Site_Code)A on M.site_code=A.site_code " +
					"left outer join ( select Sorder.Site_Code, count(Distinct sorditem.item_Code__ORd) as Pending_Item " +
					"from sorditem,Sorder where Sorder.Sale_Order=sorditem.Sale_Order and sorditem.Qty_Ord-sorditem.qty_Desp>0 group by Sorder.Site_Code)B on M.site_code=B.site_code " +
					"left outer join ( select site_code, Nvl(count(Sale_Order),0) On_Hold from sorder " +
					"where status='H' group by Site_Code)C on M.site_code=C.site_code " +
					"left outer join ( select Sorder.Site_Code, count(Distinct sorditem.item_Code__ORd) as Past_Due_date " +
					"from sorditem,Sorder where Sorder.Sale_Order=sorditem.Sale_Order " +
					"and sorditem.Qty_Ord-sorditem.qty_Desp>0 and sorditem.Date_DESP<Current_Date " +
					"group by Sorder.Site_Code)D on M.site_code=D.site_code " +
					"left outer join ( select site_code, Nvl(count(Sale_Order),0) WIP from sorder " +
					"where status in ('H','P') group by Site_Code)E on M.site_code=E.site_code " +
					"left outer join (select sorder.Site_Code, sum(sorddet.quantity) Total_Sku " +
					"from sorder,sorddet where sorder.Sale_order=sorddet.Sale_order " +
					"group by sorder.Site_Code)F on M.site_code=F.site_code " +
					"left outer join (SELECT S.SITE_CODE, COUNT(S.Quantity) ON_TIME " +
					"From Sorddet S Inner Join (Select Inv.Invoice_Id, Inv.Tran_Date, Invd.Sord_No, Invd.Sord_Line_No " +
					"From Invoice Inv Inner Join Invdet Invd On Inv.Invoice_Id = Invd.Invoice_Id) I On S.Sale_Order = I.Sord_No " +
					"And S.Line_No = I.Sord_Line_No Where S.Dsp_Date = I.Tran_Date " +
					"Group By S.Site_Code) G on M.site_code=G.site_code " +
					"left outer join (select H.site_code, Count(H.item_code) Inventory " +
					"from (select SO.site_code,item_code,Sum(Quantity) Order_QTY,(select sum(quantity) " +
					"from stock Stk where stk.Item_code=S.Item_code) as Stock_Qty from sorddet S ,Sorder SO " +
					"where SO.Sale_order=S.Sale_order and SO.Confirmed='Y' and SO.Status not in ('X','C') " +
					"and (select count(1) from sordalloc a where a.sale_order=s.sale_order " +
					"and Trim(s.line_no)=Trim(a.line_no))=0 and S.status not in ('X','C') " +
					"group by SO.site_code,item_code) H where H.Order_QTY > H.Stock_Qty " +
					"group by H.site_code)I on M.site_code=I.site_code";
			pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				rowData = new JSONObject();
				rowData.put("site_code", checkNull(rs.getString("SITE_CODE")).trim());
				rowData.put("site_descr", checkNull(rs.getString("SITE_DESCR")).trim());
				rowData.put("total_order", checkNull(rs.getString("TOTAL_ORDER")).trim());
				rowData.put("past_due_date", checkNull(rs.getString("PAST_DUE_DATE")).trim());
				rowData.put("pending_item", checkNull(rs.getString("PENDING_ITEM")).trim());
				rowData.put("inventory", checkNull(rs.getString("INVENTORY")).trim());
				rowData.put("on_hold", checkNull(rs.getString("ON_HOLD")).trim());
				rowData.put("wip", checkNull(rs.getString("WIP")).trim());
				rowData.put("initialshipment",  checkNull(rs.getString("INITIALSHIPMENT")).trim());
				rowData.put("totalskuorder", checkNull(rs.getString("TOTALSKUORDER")).trim());
				rowData.put("sku_fill_rate", checkNull(rs.getString("SKU_FILL_RATE")).trim());
				percentage = Double.parseDouble(checkNull(rs.getString("SKU_FILL_RATE")));
				dashOffSet=(totalCircle*percentage)/100;
				rowData.put("dashOffSet", dashOffSet);
				rawDataOrdStatusDueDateWiseJson.put(count, rowData);				
				count++;
			}
			
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getOrderStatusDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrdStatusDueDateWiseJson;
	}
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getSalesOrderWiseDetail(String siteCode, String dataSourceName) throws RemoteException, ITMException 
	{
		JSONObject rawDataSalesOrderWiseDetailJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println("********** In WMS3PLDashboard : getSalesOrderWiseDetail Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			
			sql =   "Select sorder.site_code, sorder.sale_order , count(sorddet.line_no) No_Of_Item,sorder.tot_amt as Total_Order_Value," +
					"sorder.status from sorder,sorddet where sorder.sale_order=sorddet.sale_order " +
					"and sorder.status in ('H','P') and sorder.site_code = ? group by sorder.site_code, " +
					"sorder.sale_order,sorder.tot_amt,sorder.status order by sorder.sale_order";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				rowData = new JSONObject();
				rowData.put("site_code", checkNull(rs.getString("SITE_CODE")));
				rowData.put("sale_order", checkNull(rs.getString("SALE_ORDER")));
				rowData.put("no_of_item", checkNull(rs.getString("NO_OF_ITEM")));
				rowData.put("total_order_value", checkNull(rs.getString("TOTAL_ORDER_VALUE")));
				rowData.put("status", checkNull(rs.getString("STATUS")));
				rawDataSalesOrderWiseDetailJson.put(count, rowData);				
				count++;
			}
			
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getSalesOrderWiseDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataSalesOrderWiseDetailJson;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getPickShipSummary(String siteCode, String dataSourceName) throws RemoteException, ITMException 
	{
		JSONObject rawDataOrderStatusDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println("********** In WMS3PLDashboard : getPickShipSummary Method ****************** ");
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;	
			DashboardUtility dashboardUtility = new DashboardUtility();
			if(siteCode.length() == 0)
			{
				siteCode = "'SP110','TA387','TA821','TA160','TC388','MJ614','UT619','CS200','BH204','TL901'";
			}else
			{
				siteCode = dashboardUtility.getCommaSeparated(siteCode);
			}
			
			sql = " Select count(site_code) as sitecount, Sum(Total_Orders) Total_Orders,   " +
					" Sum(Total_Order_Value) Total_Order_Value,  " +
					" Sum(Total_Order_Line_No) Total_Order_Line_No,  " +
					" Sum(Total_Order_Quantity) Total_Order_Quantity,  " +
					" Sum(Total_Picking) Total_Picking,  " +
					" Sum(Total_Picking_Value) Total_Picking_Value,  " +
					" Sum(Total_Picking_Line_NO) Total_Picking_Line_NO,  " +
					" Sum(Total_Picking_Quantity) Total_Picking_Quantity, " +
					" Sum(Total_Shippment) Total_Shippment,  " +
					" Sum(Total_Shippment_Value) Total_Shippment_Value,  " +
					" Sum(Total_Shippment_LineNo) Total_Shippment_LineNo,  " +
					" Sum(Total_Shippment_Quantity) Total_Shippment_Quantity " +
					" from ( " +
					" Select M.Site_code,M.site_descr, NVL(A.TOT_ORD1,0)+NVL(B.TOT_ORD1,0) Total_Orders , NVL(A.Ord_AMT1,0) + NVL(B.Ord_AMT1,0) Total_Order_Value,  " +
					" NVL(C.TOT_LN1,0)+NVL(D.TOT_LN1,0) Total_Order_Line_No,NVL(C.Ord_Qty1,0) +NVL(D.Ord_Qty1,0) Total_Order_Quantity,  " +
					" NVL(Total_Picking,0) Total_Picking, NVL(Total_Picking_Value,0) Total_Picking_Value,  " +
					" NVL(Total_Picking_Line_NO,0) Total_Picking_Line_NO, NVL(Total_Picking_Quantity,0) Total_Picking_Quantity,  " +
					" NVL(E.Total_Shippment,0) Total_Shippment,NVL(E.Total_Shippment_Value,0) Total_Shippment_Value,  " +
					" NVL(Total_Shippment_LineNo,0) Total_Shippment_LineNo ,NVL(Total_Shippment_Quantity,0) Total_Shippment_Quantity  " +
					" from  " +
					" (select site_code,descr as site_descr from site where site_code in("+siteCode+")) M  " +
					" left outer join  " +
					" (select Site_code,NVL(count(sale_Order),0) TOT_ORD1,NVL(Sum(TOT_AMT),0) Ord_AMT1 from sorder where status not in ('C','X') and order_date < CURRENT_Date  " +
					" group by Site_code)A  " +
					" on M.Site_Code=A.Site_code  " +
					" left outer join  " +
					" (select Site_code,NVL(count(sale_Order),0) TOT_ORD1,NVL(Sum(TOT_AMT),0) Ord_AMT1 from sorder where order_date = CURRENT_Date  group by Site_code)B  " +
					" on M.Site_Code=B.Site_code  " +
					" left outer join  " +
					" (select sorder.Site_code,NVL(count(Sorddet.Line_no),0) TOT_LN1,NVL(SUM(Sorddet.Quantity),0) Ord_Qty1  " +
					" from sorder,Sorddet where sorder.Sale_Order=Sorddet.Sale_Order  " +
					" and  sorder.status not in ('C','X') and order_date < CURRENT_Date  " +
					" group by sorder.Site_code)C  " +
					" on M.Site_Code=C.Site_code  " +
					" left outer join  " +
					" (select sorder.Site_code,NVL(count(Sorddet.Line_no),0) TOT_LN1,NVL(SUM(Sorddet.Quantity),0) Ord_Qty1  " +
					" from sorder,Sorddet where sorder.Sale_Order=Sorddet.Sale_Order  " +
					" and order_date = CURRENT_Date  " +
					" group by sorder.Site_code)D  " +
					" on M.Site_Code=D.Site_code  " +
					" left outer join  " +
					" (Select site_code,count(distinct sale_order) Total_Shippment,Sum(Net_AMT)  Total_Shippment_Value from invoice  " +
					" where tran_date = CURRENT_Date  " +
					" Group by site_code) E  " +
					" on M.Site_Code=E.Site_code  " +
					" left outer join  " +
					" (Select invoice.site_code,count(distinct INVDET.SOrd_Line_NO) Total_Shippment_LineNo,Sum(INVDET.Quantity) Total_Shippment_Quantity  " +
					" from invoice ,INVDET  " +
					" where invoice.tran_date = CURRENT_Date  " +
					" Group by invoice.site_code) F  " +
					" on M.Site_Code=F.Site_code  " +
					" left outer join  " +
					" (select Site_code,count(sale_order) Total_Picking,Sum(Tot_amt) Total_Picking_Value  " +
					" from sorder where  status not in ('C','X','H')  " +
					" and sorder.sale_order in  " +
					" (select distinct sale_order  " +
					" from wave_task_det,Wave_task  " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER)='A-PICK' and  " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
					" And Hdr.Confirmed = 'Y'))  " +
					" and not exists(select 1 from despatch where sord_no = SORDER.sale_order and confirmed = 'Y')  " +
					" Group by Site_code)G  " +
					" on M.Site_Code=G.Site_code  " +
					" left outer join  " +
					" (select sorder.Site_code,count(sorddet.Line_NO) Total_Picking_Line_NO,Sum(sorddet.Quantity) Total_Picking_Quantity  " +
					" from sorder,sorddet where  sorder.sale_order=sorddet.sale_order  " +
					" and sorder.status not in ('C','X','H')  " +
					" and sorder.sale_order in  " +
					" (select distinct sale_order  " +
					" from wave_task_det,Wave_task  " +
					" where Wave_task.WAVE_ID=wave_task_det.WAVE_ID and Wave_task.CANCEL='N' and Trim(Ref_SER)='A-PICK' and  " +
					" exists (select 1 from PICK_ISS_HDR HDR,PICK_ISS_DET DET  " +
					" where HDR.PICK_ORDER =WAVE_TASK_DET.REF_ID and HDR.TRAN_ID = DET.TRAN_ID  " +
					" And Hdr.Confirmed = 'Y'))  " +
					" and not exists(select 1 from despatch where sord_no = SORDER.sale_order and confirmed = 'Y')  " +
					" Group by sorder.Site_code  )H  " +
					" on M.Site_Code=H.Site_code ) ";
			
			
			pstmt = conn.prepareStatement(sql);
			rs= pstmt.executeQuery();
			
			while(rs.next())
			{
				
				rowData = new JSONObject();
				
				rowData.put("sitecount", checkNull(rs.getString("sitecount")).trim());
				
				rowData.put("totalorders", checkNull(rs.getString("TOTAL_ORDERS")).trim());
				rowData.put("value", checkNull(rs.getString("TOTAL_ORDER_VALUE")).trim());
				rowData.put("lineno", checkNull(rs.getString("TOTAL_ORDER_LINE_NO")).trim());
				rowData.put("quantity", checkNull(rs.getString("TOTAL_ORDER_QUANTITY")).trim());
				
				rowData.put("totalpicking", checkNull(rs.getString("TOTAL_PICKING")).trim());
				rowData.put("pickingval", checkNull(rs.getString("TOTAL_PICKING_VALUE")).trim());
				rowData.put("pickingline", checkNull(rs.getString("TOTAL_PICKING_LINE_NO")).trim());
				rowData.put("pickingqty", checkNull(rs.getString("TOTAL_PICKING_QUANTITY")).trim());
				
				rowData.put("totalshippment", checkNull(rs.getString("TOTAL_SHIPPMENT")).trim());
				rowData.put("shippmentval", checkNull(rs.getString("TOTAL_SHIPPMENT_VALUE")).trim());
				rowData.put("shippmentline", checkNull(rs.getString("TOTAL_SHIPPMENT_LINENO")).trim());
				rowData.put("shippmentqty", checkNull(rs.getString("TOTAL_SHIPPMENT_QUANTITY")).trim());
				
				rawDataOrderStatusDtlJson.put(count, rowData);
				count++;
			}
			
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getPickShipSummary:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataOrderStatusDtlJson;
	}
	
	private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str ;
   		}

   	}	
	

}
