package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ]
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;  
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EmpPersonalInfo extends ValidatorEJB implements EmpPersonalInfoLocal ,EmpPersonalInfoRemote
{
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		String errString = null;

		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		try
		{
			System.out.println("EmpPersonalInfo xmlString in itemChanged..::["+xmlString+"]");
			System.out.println("EmpPersonalInfo xmlString1 in itemChanged..:: ["+xmlString1+"]");
			System.out.println("EmpPersonalInfo xmlString2 in itemChanged..:: ["+xmlString2+"]");
			
			if(xmlString != null && xmlString.length() > 0)
			{
				dom = genericUtility.parseString(xmlString);				
			}
			if(xmlString1 != null  &&  xmlString1.length() > 0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.length() > 0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn,  editFlag,  xtraParams);
			System.out.println("EmpPersonalInfo errString Returing at Stage 1["+errString+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :EmpPersonalInfo [:" + e.getMessage() + ":]" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println("EmpPersonalInfo errString returing at Stage 2[" + errString+"]");
		return errString;
	}
		
	//Start of itemChanged block
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		String objNameDefault = "";
		
		//Variable defined . Start
		
		String empCode = "";
		String shortName = "";
		String contactCode = "";
		String maritalStatus = "";
		String maritalStatusDate = null;
		String nationality = "";
		String contactPerson = "";
		String sex = "";
		String namePrefix = "";
		String citizen= "";
		String contactCity = "";
		String contactState = "";
		String physicalHandicap = "";
		String drivLicNo= "";
		String shName = "";
		String contPers = "";
		String stateCode = "";
		String drivLicValidUpto = "";
		String handicapCategory = "";
		
		//Variable defined  . End

		int currentFormNo = 0;
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		
		StringBuffer valueXmlString = new StringBuffer();
		
		System.out.println("objContext ..:: ["+objContext+"]");
		System.out.println("currentColumn ..:: ["+currentColumn+"]");
		System.out.println("editFlag ..:: ["+editFlag+"]");
		System.out.println("xtraParams ..:: ["+xtraParams+"]");
		

		if(objContext != null && objContext.trim().length() > 0)
		{
			currentFormNo = Integer.parseInt(objContext);
		}		

		try
		{		
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			objNameDefault  = checkNull(getObjName(dom ,"1"));
			System.out.println("objNameDefault ..:: ["+objNameDefault+"]");
			
			switch (currentFormNo)
			{
				case 1:
						{
							valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+objNameDefault+"' selected='Y'>\r\n");
							empCode = genericUtility.getColumnValue("emp_code",dom2);
							
							if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
							{
								sql = "SELECT SHORT_NAME , CONTACT_CODE , M_STATUS , M_STATUS_DATE , NATIONALITY ,  CONTACT_PERS , SEX , NAME_PREFIX , CITIZEN , CONTACT_CITY , CONTACT_STATE , PHYSICAL_HANDICAP , DRIV_LIC_NO FROM EMPLOYEE WHERE EMP_CODE  = ?";
								
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();
								
								if(rs.next())
								{
									shortName = checkNull(rs.getString("SHORT_NAME"));
									contactCode = checkNull(rs.getString("CONTACT_CODE"));
									maritalStatus = checkNull(rs.getString("M_STATUS"));
									maritalStatusDate = checkNull(rs.getString("M_STATUS_DATE"));
									nationality = checkNull(rs.getString("NATIONALITY"));
									contactPerson = checkNull(rs.getString("CONTACT_PERS"));
									sex = checkNull(rs.getString("SEX"));
									namePrefix = checkNull(rs.getString("NAME_PREFIX"));
									citizen = checkNull(rs.getString("CITIZEN"));
									if (citizen.trim().length() == 0)
									{
										citizen = "Y";
									}
									contactCity = checkNull(rs.getString("CONTACT_CITY"));
									contactState = checkNull(rs.getString("CONTACT_STATE"));
									physicalHandicap = checkNull(rs.getString("PHYSICAL_HANDICAP"));
									drivLicNo  = checkNull(rs.getString("DRIV_LIC_NO"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("shortName ..:: ["+shortName+"]");
								System.out.println("contactCode ..:: ["+contactCode+"]");
								System.out.println("maritalStatus ..:: ["+maritalStatus+"]");
								System.out.println("maritalStatusDate ..:: ["+maritalStatusDate+"]");
								System.out.println("nationality ..:: ["+nationality+"]");
								System.out.println("contactPerson ..:: ["+contactPerson+"]");
								System.out.println("sex ..:: ["+sex+"]");
								System.out.println("namePrefix ..:: ["+namePrefix+"]");
								System.out.println("citizen ..:: ["+citizen+"]");
								System.out.println("contactCity ..:: ["+contactCity+"]");
								System.out.println("contactState ..:: ["+contactState+"]");
								System.out.println("physicalHandicap ..:: ["+physicalHandicap+"]");
								System.out.println("drivLicNo ..:: ["+drivLicNo+"]");
								
								if(shortName == null || shortName.length() == 0)
								{
									if (contactCode != null && contactCode.length() > 0)
									{
										sql = "SELECT SH_NAME FROM CONTACT WHERE CONTACT_CODE = ?";
										
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1,contactCode);
										rs = pstmt.executeQuery();
										
										if(rs.next())
										{
											shName = checkNull(rs.getString("SH_NAME"));
										}
										if( rs != null )
										{
											rs.close();
											rs = null;
										}
										if( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										System.out.println("shName ..:: ["+shName+"]");
										valueXmlString.append("<short_name><![CDATA[").append(shName).append("]]></short_name>\r\n");
									}
								}
								
								// if no value is specified for marital status then system should set K in marital status and should allow to change.
								// Also system should set empty value for marital status date and should not allow to change marital status date
								
								if(maritalStatus == null || maritalStatus.length() == 0)
								{
									valueXmlString.append("<m_status protect=\"0\"><![CDATA[").append("K").append("]]></m_status>\r\n");
									valueXmlString.append("<m_status_date protect=\"1\"></m_status_date>\r\n");
								}
								
								// if value specified for marital status is K, then system should allow to change marital status.  
								// Also system should set empty value for marital status date and should not allow to change marital status date
								
								if(maritalStatus.equalsIgnoreCase("K"))
								{
									valueXmlString.append("<m_status protect=\"0\"><![CDATA[").append(maritalStatus).append("]]></m_status>\r\n");
									valueXmlString.append("<m_status_date protect=\"1\"></m_status_date>\r\n");
								}
								
								// if no value is specified for marital status date then system should allow to change marital status
								
								if(maritalStatusDate == null || maritalStatusDate.length() == 0)
								{
									valueXmlString.append("<m_status protect=\"0\"><![CDATA[").append(maritalStatus).append("]]></m_status>\r\n");
								}
								
								// If no value is specified for marital status date and value for marital status is other then K then 
								//system should allow to change marital status date
								
								if((maritalStatusDate == null || maritalStatusDate.length() == 0) && !(maritalStatus.equalsIgnoreCase("K")))
								{
									valueXmlString.append("<m_status_date  protect=\"0\"><![CDATA[").append(maritalStatusDate).append("]]></m_status_date>\r\n");
								}
								
								// If value for nationality is not specified then system should set default nationality defined in payroll parameter  NATIONAL
								
								if(nationality == null || nationality.length() == 0)
								{
									String defaultNationality =  getEnv( "999999",  "NATIONAL", conn);
									
									if (!defaultNationality.equalsIgnoreCase("NULLFOUND"))
									{
										valueXmlString.append("<nationality><![CDATA[").append(defaultNationality).append("]]></nationality>\r\n");
									}
									
								}
								
								// In case of value for contact person is not specified and contact code is specified
								// then  system should fetch contact person name  from contact master for the contact code and set into contact person
								
								if(contactPerson == null || contactPerson.length() == 0)
								{
									if(contactCode != null && contactCode.length() > 0)
									{
										sql = "SELECT CONT_PERS  FROM CONTACT WHERE CONTACT_CODE = ?";
										
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1,contactCode);
										rs = pstmt.executeQuery();
										
										if(rs.next())
										{
											contPers = checkNull(rs.getString("CONT_PERS"));
										}
										if( rs != null )
										{
											rs.close();
											rs = null;
										}
										if( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										System.out.println("contPers ..:: ["+contPers+"]");
										valueXmlString.append("<contact_pers><![CDATA[").append(contPers).append("]]></contact_pers>\r\n");
									}
								}
								
								// If value for sex is not specified then system should set M (i.e. Male) for sex 
								
								if(sex == null || sex.length()  == 0)
								{
									valueXmlString.append("<sex><![CDATA[").append("M").append("]]></sex>\r\n");
								}
								
								// If value for name prefix is not specified then system should 
								//1.set Mr for name prefix if no value is specified for sex or value specified for sex is M
								//2.set Ms for name prefix if value specified for sex is F
								
								if(namePrefix == null || namePrefix.length() == 0)
								{
									if((sex == null || sex.length()  == 0) || sex.equalsIgnoreCase("M"))
									{
										valueXmlString.append("<name_prefix><![CDATA[").append("Mr").append("]]></name_prefix>\r\n");
									}
									else if(sex.equalsIgnoreCase("F"))
									{
										valueXmlString.append("<name_prefix><![CDATA[").append("Ms").append("]]></name_prefix>\r\n");
									}
								}
								
								// If value for citizen is not specified then system should set Y for citizen
								
								if(citizen == null || citizen.length() == 0)
								{
									valueXmlString.append("<citizen><![CDATA[").append("Y").append("]]></citizen>\r\n");
								}
								
								// If value for contact city is not specified then system should allow to change contact state 
								
								if(contactCity == null || contactCity.length() == 0)
								{
									valueXmlString.append("<contact_state protect=\"0\"><![CDATA[").append(contactState).append("]]></contact_state>\r\n");
								}
								
								// If value for physical handicap is not specified then system should set N for physical handicap
								
								if(physicalHandicap == null || physicalHandicap.length() == 0)
								{
									valueXmlString.append("<physical_handicap><![CDATA[").append("N").append("]]></physical_handicap>\r\n");
								}
								
								// if value for physical handicap is not specified or the value is N for physical handicap then 
								// system should set empty value in physical handicap category and should not allow to enter value for physical handicap category
								
								if((physicalHandicap == null || physicalHandicap.length() == 0) || physicalHandicap.equalsIgnoreCase("N"))
								{
									valueXmlString.append("<handicap_category protect=\"1\"><![CDATA[").append("").append("]]></handicap_category>\r\n");
								}
								
								// If value for driving license is not specified then system set null value in driving license valid uipto and
								//should not allow to enter value for  driving license valid uipto
								
								if(drivLicNo == null || drivLicNo.length() == 0)
								{
									valueXmlString.append("<driv_lic_valid_upto protect=\"1\"></driv_lic_valid_upto>\r\n");
								}
							}
							// If value of sex is M then system should set Mr for name prefix else system should set Ms for name prefix
							else if (currentColumn.equalsIgnoreCase("sex"))
							{
								sex = checkNull(genericUtility.getColumnValue("sex",dom,"1")) ;
								System.out.println("sex::::::::["+sex+"]");
								
								if(sex.equalsIgnoreCase("M"))
								{
									valueXmlString.append("<name_prefix><![CDATA[").append("Mr").append("]]></name_prefix>\r\n");
								}
								else
								{
									valueXmlString.append("<name_prefix><![CDATA[").append("Ms").append("]]></name_prefix>\r\n");
								}
							}
							// 1.If no value is specified for contact city, then system should allow to change contact state
							// 2.if value is specified for contact city, then system should fetch stats code from station master where  description in station master is matches with entered contact city and 
							//should set fetched stats code in contact state and should not allow to change contact state
							
							else if (currentColumn.equalsIgnoreCase("contact_city"))
							{
								contactCity = checkNull(genericUtility.getColumnValue("contact_city",dom,"1")) ;
								contactState = checkNull(genericUtility.getColumnValue("contact_state",dom,"1")) ;
								System.out.println("contactCity::::::::["+contactCity+"]");
								System.out.println("contactState::::::::["+contactState+"]");
								
								if(contactCity == null || contactCity.length() == 0)
								{
									valueXmlString.append("<contact_state protect=\"0\"><![CDATA[").append(contactState).append("]]></contact_state>\r\n");
								}
								else
								{
									sql = "SELECT STATE_CODE  FROM STATION WHERE DESCR = ?";
									
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,contactCity);
									rs = pstmt.executeQuery();
									
									if(rs.next())
									{
										stateCode = checkNull(rs.getString("STATE_CODE"));
									}
									if( rs != null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("stateCode ..:: ["+stateCode+"]");
									valueXmlString.append("<contact_state protect=\"1\"><![CDATA[").append(stateCode).append("]]></contact_state>\r\n");
								}
							}
							// If value of marital status is K then system should set empty value in marital status date and 
							// should not allow to change marital status date

							else if (currentColumn.equalsIgnoreCase("m_status"))
							{
								maritalStatus = checkNull(genericUtility.getColumnValue("m_status",dom,"1"));
								System.out.println("maritalStatus::::::::["+maritalStatus+"]");
								
								maritalStatusDate = checkNull(genericUtility.getColumnValue("m_status_date",dom,"1"));
								System.out.println("maritalStatusDate::::::::["+maritalStatusDate+"]");
								
								if(maritalStatus.equalsIgnoreCase("K"))
								{
									valueXmlString.append("<m_status_date protect=\"1\"><![CDATA[").append("").append("]]></m_status_date>\r\n");
								}
								else
								{
									valueXmlString.append("<m_status_date protect=\"0\"><![CDATA[").append(maritalStatusDate).append("]]></m_status_date>\r\n");
								}
							}
						
							// 1.If driving license is specified then system should allow to change driving license upto date  
							// 2.If driving license is not specified then system should set empty value in driving license upto date and should not allow to change it
							
							else if (currentColumn.equalsIgnoreCase("driv_lic_no"))
							{
								drivLicNo = checkNull(genericUtility.getColumnValue("driv_lic_no",dom,"1"));
								drivLicValidUpto = checkNull(genericUtility.getColumnValue("driv_lic_valid_upto",dom,"1"));
								System.out.println("drivLicNo::::::::["+drivLicNo+"]");
								System.out.println("drivLicValidUpto::::::::["+drivLicValidUpto+"]");
								
								if(drivLicNo != null && drivLicNo.length() > 0 )
								{
									valueXmlString.append("<driv_lic_valid_upto protect=\"0\"><![CDATA[").append(drivLicValidUpto).append("]]></driv_lic_valid_upto>\r\n");
								}
								else
								{
									valueXmlString.append("<driv_lic_valid_upto protect=\"1\"></driv_lic_valid_upto>\r\n");
								}
							}
							
							// 1.If value is specified as Y then system should allow to change handicap category
							// 2.If value is specified as N then system should set empty value for handicap category and should not allow to change it
							
							else if (currentColumn.equalsIgnoreCase("physical_handicap"))
							{
								physicalHandicap = checkNull(genericUtility.getColumnValue("physical_handicap",dom,"1"));
								handicapCategory = checkNull(genericUtility.getColumnValue("handicap_category",dom,"1"));
								
								if(physicalHandicap.equalsIgnoreCase("Y"))
								{
									valueXmlString.append("<handicap_category protect=\"0\"><![CDATA[").append(handicapCategory).append("]]></handicap_category>\r\n");
								}
								else if(physicalHandicap.equalsIgnoreCase("N"))
								{
									valueXmlString.append("<handicap_category protect=\"1\"><![CDATA[").append("").append("]]></handicap_category>\r\n");
								}
							}
							
							valueXmlString.append("</Detail1>\r\n");
						
						}//End of Case 1
						break;
			}//END OF SWITCH
			
		}//End of try block		
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :EmpPersonalInfo [itemChanged(String xmlString)] : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}//End of cacth block
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}			
		}//End of finally block
		
		valueXmlString.append("</Root>\r\n");
		System.out.println("valueXmlString....["+valueXmlString.toString());
		return valueXmlString.toString();
	}//End of itemChanged block


	//Start of wfValData Start
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Came Inside 1 wfValData:::");
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString); 
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1); 
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [EmpPersonalInfo][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
			
		}
		return (errString); 
	}

	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
	
		Node parentNode = null;
		Node childNode = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;

		String errString = "";
		String childNodeName = "";	

		int currentFormNo = 0;		
		int childNodeListLength = 0;

		 
		String msgType = "";
		String errCode = "";
		String errFldName = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		int cnt = 0;
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;


		//Varibles used in case 1 Start
		
		String userId = "";
		String nationality = "";
		String contactState = "";
		String handicapcategory = "";

		//Varibles used in  case 1 End

		int ctr = 0;		
		int count = 0;	
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		
		Connection conn = null;
		try
		{
			
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail"+currentFormNo);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();

					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						
						System.out.println("childNode"+childNode);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						childNodeName = childNode.getNodeName();
						
						if(childNodeName.equalsIgnoreCase("nationality"))
						{ 
							nationality = genericUtility.getColumnValue("nationality",dom,objContext);
							System.out.println("nationality got in the validation ..::["+nationality+"]");
							
							sql = "SELECT COUNT(*) AS COUNTRY_CNT FROM COUNTRY WHERE COUNT_CODE = ?";
							
							pstmt = conn.prepareStatement(sql);		
							pstmt.setString(1,nationality);	
							
							rs = pstmt.executeQuery();		
							
							if( rs.next())
							{
								count  = rs.getInt("COUNTRY_CNT");
							}
							System.out.println("count:::: "+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							
							if(count == 0)
							{
								System.out.println("Invalid country, not defined in master::::");
								
								errList.add( "VMCONT" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMCONT" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("contact_state"))
						{ 
							contactState = genericUtility.getColumnValue("contact_state",dom,objContext);
							System.out.println("contactState got in the validation ..::["+contactState+"]");
							
							if( contactState != null && contactState.length() > 0 )
							{
								sql = "SELECT COUNT(*)  AS STATE_CNT FROM STATE WHERE STATE_CODE = ?";
								
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,contactState);	
								
								rs = pstmt.executeQuery();		
								
								if( rs.next())
								{
									count  = rs.getInt("STATE_CNT");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								
								if(count == 0)
								{
									System.out.println("Invalid country, not defined in master::::");
									
									errList.add( "VESTATCD2" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VESTATCD2" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("handicap_category"))
						{ 
							count = 0;

							handicapcategory = genericUtility.getColumnValue("handicap_category",dom,objContext);
							System.out.println("handicapcategory got in the validation ..::["+handicapcategory+"]");
							
							if(handicapcategory != null && handicapcategory.length() > 0)
							{
								sql = "select count(*) as gen_count from gencodes where fld_name = 'HANDICAP_CATEGORY' and mod_name = 'X' and fld_value = ?";
								
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,handicapcategory);	
								
								rs = pstmt.executeQuery();		
								
								if( rs.next())
								{
									count  = rs.getInt("gen_count");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Invalid Handicape Category, not defined in gencodes::::");
									
									errList.add( "VTINVHDCGR" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VTINVHDCGR" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
				}
			}//End of case
			break;		
		}//End of Switch
			int errListSize = errList.size();
				if ( errList != null && errListSize > 0 )
				{
					for (cnt = 0; cnt < errListSize; cnt++ )
					{
						errCode = (String)errList.get(cnt);
						errFldName = (String)errFields.get(cnt);
						System.out.println("errCode .........."+errCode);
						
						errString = getErrorString( errFldName, errCode, userId );
						System.out.println("errString is : ::::>>>> " + errString);
						msgType =  errorType( conn , errCode );
						if ( errString.length() > 0)
						{
							String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
							bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........."+errStringXml);
							errString = "";
						}
						if ( msgType.equalsIgnoreCase("E"))
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;
					
					errStringXml.append("</Errors></Root>\r\n");
				}
				else
				{
					errStringXml = new StringBuffer( "" );
				}
				errString = errStringXml.toString();

		}
		catch(Exception e)
		{
			System.out.println( "Exception : [EmpPersonalInfo][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				System.out.println( "Exception : [EmpPersonalInfo][wfValData] : ==>\n"+e1.getMessage());
				throw new ITMException(e1);
			}
		}

	
		return errString;
	}
	//Start of wfValData End


	private String checkNull( String input )
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	private String getObjName(Document dom,String objContext)
	{	
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}

	private String errorType( Connection conn , String errorCode ) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}

	public String getEnv(String prdCode, String varName,Connection conn)
	{
		String retValue = "";
		String sql = "";
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT VAR_VALUE FROM PAYRPARM WHERE PRD_CODE = '" + prdCode + "' AND VAR_NAME = '" + varName + "'";

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);

			if (rs.next())
			{
				retValue = rs.getString(1);
			}
			else
			{
				retValue = "NULLFOUND";
			}
			rs.close();
			stmt.close();
		}
		catch (SQLException se)
		{
			System.out.println("Exception :ITMDBAccessEJB :getEnvFin:" + se.getMessage() + ":");
			se.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("Exception :ITMDBAccessEJB :getEnvFin:" + e.getMessage() + ":");
			e.printStackTrace();
		}
		System.out.println("Returning Value From getEnv() :: "+retValue);  
		return retValue;
	}
}