
/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package ibase.e12ria.e12table.client;

//Commented By Prashant Chavan 11-Mar-15 to avoid additional import
//import ibase.e12ria.client.E12CommonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.TextInputCell.ViewData;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * An editable text cell. Click to edit, escape to cancel, return to commit.
 */
public class E12CustomTextCell extends AbstractEditableCell<String, E12CustomTextCell.CellData> 
{

	interface Template extends SafeHtmlTemplates 
	{
		String pophelpDiv = "<div style=\"position: relative;display: inline; top:0; float:right; \" class=\"pophelpImg-datatable icon-pophelp\"></div>";
		
		@Template("<input id=\"{0}\" type=\"text\" class=\"e12-TextBox\" value=\"{1}\" tabindex=\"{2}\" style=\"width:{3}px; text-align:right; \"></input>")
		SafeHtml inputRightAlign(String elementId, String value, int tabIndex, int width);
		
		@Template("<input id=\"{0}\" type=\"text\" class=\"e12-TextBox\" value=\"{1}\" tabindex=\"{2}\" style=\"width:{3}px; text-align:right; \" maxlength=\"{4}\"></input>")
		SafeHtml inputRightAlign(String elementId, String value, int tabIndex, int width, int limit);

		@Template("<input id=\"{0}\" type=\"text\" class=\"e12-TextBox\" value=\"{1}\" tabindex=\"{2}\" style=\"width:{3}px;\"></input>")
		SafeHtml input(String elementId, String value, int tabIndex, int width);
		
		@Template("<input id=\"{0}\" type=\"text\" class=\"e12-TextBox\" value=\"{1}\" tabindex=\"{2}\" style=\"width:{3}px;\" maxlength=\"{4}\"></input>")
		SafeHtml input(String elementId, String value, int tabIndex, int width, int limit);
		
		@Template("<input id=\"{0}\" type=\"text\" class=\"e12-TextBox\" value=\"{1}\" tabindex=\"{2}\" style=\"width:{3}px;\" maxlength=\"{4}\"></input>" + pophelpDiv )
		SafeHtml pophelp_input(String elementId, String value, int tabIndex, int width , int limit );
		
		@Template("<input id=\"{0}\" type=\"text\" class=\"e12-TextBox\" value=\"{1}\" tabindex=\"{2}\" style=\"width:{3}px;\"></input>" + pophelpDiv )
		SafeHtml pophelp_input(String elementId, String value, int tabIndex, int width );
		
		//Changed By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to show popup Image in firefox]
		@Template("<span style=\"white-space: nowrap;overflow: hidden;text-overflow: ellipsis; width:{1}px; \" >{0}</span><div style=\"position: relative;display: inline; top:0; float:right; \" class=\"pophelpImg-datatable icon-pophelp\"></div>")
		SafeHtml pophelp(String value, int width);
		
		// Changes By Arvind on 18-JAN-2014 : added css for overflow data in all column while viewing data
		//@Template("<SPAN><DIV style=\"word-wrap: break-word;word-break: break-all;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;\" >{0}</DIV></SPAN>")
		@Template("<SPAN><DIV style=\"white-space: nowrap;overflow: hidden;text-overflow: ellipsis;\" title=\"{0}\" colname=\"{1}\" >{0}</DIV></SPAN>")
		SafeHtml text(String value,String colName);

		@Template("<SPAN><DIV style=\"white-space: nowrap;overflow: hidden;text-overflow: ellipsis; align:right;\" title=\"{0}\" colname=\"{1}\">{0}</DIV></SPAN>")
		SafeHtml rightAligntext(String value,String colName);
		//Added By Prashant Chavan on 11-Mar-15 [For dashboard report -cell with the link Option] Start
		@Template("<SPAN><DIV style=\"white-space: nowrap;overflow: hidden;text-overflow: ellipsis; align:right;\" title=\"{0}\" colname=\"{2}\"><a href=\"\" linkName=\"{1}\">{0}</a></DIV></SPAN>")
		SafeHtml rightAligntextLink(String value,String linkName,String colName);
		
		@Template("<SPAN><DIV style=\"white-space: nowrap;overflow: hidden;text-overflow: ellipsis;\" title=\"{0}\" colname=\"{2}\" ><a href=\"\" linkName=\"{1}\">{0}</a></DIV></SPAN>")
		SafeHtml linktext(String value,String linkName,String colName);
		//Added By Prashant Chavan on 11-Mar-15 [For dashboard report -cell with the link Option] End
	}

	private static Template template;

	private final SafeHtmlRenderer<String> renderer;
	private final boolean isEditable;
	private final boolean isRightAligned;
	
	private E12CellUpdater<String> valueUpdater;
	
	//Added By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to store current field context,parent, tab increament factor and is already field validate or not]
	public static Context currentContext;
	public static InputElement editableField;
	public static InputElement prvEditableField;
	public static Element currentCellElement;
	public  static int incrFactor;
	public static boolean isValidate;
	//Ended By Mahesh Patidar
	
	//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] start
	public static boolean isKeyDownInitiated = false;
	//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] end
	// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] start
		public static boolean isClickInitiated=false;
		// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] End
	private AbstractDataGrid<DataGridTableRowModel> e12AdvDataGrid = null;

	/**
	 * Construct a new EditTextCell that will use a
	 * {@link SimpleSafeHtmlRenderer}.
	 * 
	 * @param isEditable
	 */
	public E12CustomTextCell(boolean isEditable) 
	{
		this(SimpleSafeHtmlRenderer.getInstance(), isEditable, false);
	}
	
	public E12CustomTextCell(boolean isEditable, boolean isRightAligned) 
	{
		this(SimpleSafeHtmlRenderer.getInstance(), isEditable, isRightAligned);
	}
	//Added By Prashant Chavan on 11-Mar-15 [For Sahboard report -Cell with Link - With additional Parameter linkName] Start
	public E12CustomTextCell(boolean isEditable,String LinkName) 
	{
		this(SimpleSafeHtmlRenderer.getInstance(), isEditable, false);
	}
	

	public E12CustomTextCell(boolean isEditable, boolean isRightAligned,String LinkName) 
	{
		this(SimpleSafeHtmlRenderer.getInstance(), isEditable, isRightAligned,LinkName);
	}
	//Added By Prashant Chavan on 11-Mar-15 [For Sahboard report -Cell with Link - With additional Parameter linkName] End

	/**
	 * Construct a new EditTextCell that will use a given
	 * {@link SafeHtmlRenderer} to render the value when not in edit mode.
	 * 
	 * @param renderer
	 *            a {@link SafeHtmlRenderer SafeHtmlRenderer<String>} instance
	 * @param isRightAligned 
	 */
	public E12CustomTextCell(SafeHtmlRenderer<String> renderer, boolean isEditable, boolean isRightAligned) 
	{
		super("click", "keyup", "keydown", "blur","mouseover","mouseout");
		if (template == null) 
		{
			template = GWT.create(Template.class);
		}
		if (renderer == null) 
		{
			throw new IllegalArgumentException("renderer == null");
		}
		this.renderer = renderer;
		this.isEditable = isEditable;
		this.isRightAligned = isRightAligned;
	}
	//Added By Prashant Chavan on 11-Mar-15 [For Sahboard report -Cell with Link - With additional Parameter linkName] Start 
	public E12CustomTextCell(SafeHtmlRenderer<String> renderer, boolean isEditable, boolean isRightAligned,String LinkName) 
	{
		super("click", "keyup", "keydown", "blur","mouseover","mouseout");
		if (template == null) 
		{
			template = GWT.create(Template.class);
		}
		if (renderer == null) 
		{
			throw new IllegalArgumentException("renderer == null");
		}
		this.renderer = renderer;
		this.isEditable = isEditable;
		this.isRightAligned = isRightAligned;
	}
	//Added By Prashant Chavan on 11-Mar-15 [For Sahboard report -Cell with Link - With additional Parameter linkName] End

	public static class CellData 
	{
		private String name;
		private String data;
		private String originalText;
		private int width;
		private int index;
		private String textCase;

		private boolean isEditing;
		private boolean isEditingAgain;
		private boolean isVisible;

		private boolean isPophelp;
		private boolean isProtect;
		private boolean isNumber;
		private boolean isMandatory;
		private boolean isItemChanged;
		//Added By Mahesh Patidar on 15/MAY/13[WS2FSUN002 | to store the status is already focused field for the item changed field]
		private int limit;
		private boolean isPophelpImgActive;
		private boolean isFocusAgain;
	    //TODO: 
		//String style;
		
		private String summationFormat;
		private String tagMessage;
		
		//Added By Prashant Chavan on 11-Mar-15 [For Dashboard report -cell with the link]
		private String linkName;
		public CellData(String data) 
		{
			this(0, data);
		}

		public CellData(int index, String data) 
		{
			this.isEditing = true;
			this.isEditingAgain = false;
			this.isVisible = false;

			this.index = index;
			this.data = data;
			this.originalText = data;

			this.isProtect = false;
			this.isPophelp = false;
			this.isMandatory = false;
			this.isItemChanged = false;
			this.isNumber = false;
			//Added By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to assign default value]
			this.isPophelpImgActive = false;
			this.isFocusAgain = false;
			this.limit = 0;
			
//			this.width = data.length() * 9; // data Text char size + 9
		}
		//Added By Prashant Chavan on 11-Mar-15 [For Dahsboard report -Cell witj Link] Start
		public CellData(int index, String data,String LinkName) 
		{
			this.isEditing = true;
			this.isEditingAgain = false;
			this.isVisible = false;
			this.index = index;
			this.data = data;
			this.originalText = data;

			this.isProtect = false;
			this.isPophelp = false;
			this.isMandatory = false;
			this.isItemChanged = false;
			this.isNumber = false;
			//Added By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to assign default value]
			this.isPophelpImgActive = false;
			this.isFocusAgain = false;
			this.limit = 0;
			
			this.linkName = LinkName;
//			this.width = data.length() * 9; // data Text char size + 9
		}
		//Added By Prashant Chavan on 11-Mar-15 [For Dahsboard report -Cell witj Link] End

		public boolean isVisible() 
		{
			return isVisible;
		}

		public void setVisible(boolean isVisible) 
		{
			this.isVisible = isVisible;
		}
		
		public boolean isPophelp() 
		{
			return isPophelp;
		}

		public void setPophelp(boolean isPophelp) 
		{
			this.isPophelp = isPophelp;
		}

		public boolean isNumber() 
		{
			return isNumber;
		}

		public void setNumber(boolean isNumber) 
		{
			this.isNumber = isNumber;
		}

		public boolean isItemChanged() 
		{
			return isItemChanged;
		}

		public void setItemChanged(boolean isItemChanged) 
		{
			this.isItemChanged = isItemChanged;
		}

		public boolean isMandatory() 
		{
			return isMandatory;
		}

		public void setMandatory(boolean isMandatory) 
		{
			this.isMandatory = isMandatory;
		}

		public boolean isProtect() 
		{
			return isProtect;
		}

		public void setProtect(boolean isProtect) 
		{
			this.isProtect = isProtect;
		}

		//Added By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to set and get the value isFocusAgain]
		public void setFocusAgain(boolean isFocusAgain) 
		{
			this.isFocusAgain = isFocusAgain;
		}
		
		public boolean isFocusAgain() 
		{
			return isFocusAgain;
		}
		public void setLimit(int limit) 
		{
			this.limit = limit;
		}
		
		public int getLimit() 
		{
			return limit;
		}
		public void setPophelpImgActive(boolean isPophelpImgActive) 
		{
			this.isPophelpImgActive = isPophelpImgActive;
		}
		
		public boolean isPophelpImgActive() 
		{
			return isPophelpImgActive;
		}
		//Ended By Mahesh Patidar
		public boolean isEditing() 
		{
			return isEditing;
		}

		public void setEditing(boolean isEditing) 
		{
			boolean wasEditing = this.isEditing;
			this.isEditing = isEditing;
			this.isVisible = isEditing;
			// This is a subsequent edit, so start from where we left off.
			if (!wasEditing && isEditing) 
			{
				isEditingAgain = true;
				originalText = data;
			}
		}

		public boolean isEditingAgain() 
		{
			return isEditingAgain;
		}

		public int getIndex() 
		{
			return index;
		}

		public int getWidth() 
		{
			return width;
		}

		public void setWidth(String width) 
		{
			try 
			{
				this.width = (int) Double.parseDouble(width) - 14;
			} 
			catch (NumberFormatException nfe) 
			{
				this.width = 14;
			}
		}

		public String getData() 
		{
			changeTextCase();
			return data;
		}

		public void setData(String data) 
		{
			this.data = checkNull( data );
			changeTextCase();
		}
		
		//Added By Prashant Chavan on 11-Mar-15 [For Dashboard report-Cell with Link -getter setter method] Start
		public String getLinkName() 
		{
			
			return linkName;
		}

		public void getLinkName(String linkName) 
		{
			this.linkName = checkNull( linkName );
		}
		//Added By Prashant Chavan on 11-Mar-15 [For Dashboard report-Cell with Link -getter setter method] End

		public String getName() 
		{
			return name;
		}

		public void setName(String name) 
		{
			this.name = name;
		}

		public String getOriginalText() 
		{
			return originalText;
		}

		public void setOriginalText(String originalText) 
		{
			this.originalText = originalText;
		}

		public String getTextCase() 
		{
			return textCase;
		}

		public void setTextCase(String textCase) 
		{
			this.textCase = textCase;
		}

		private void changeTextCase()
		{
			if( "".equalsIgnoreCase( data ) )
			{
				return;
			}
			if( "upper".equalsIgnoreCase(textCase) )
			{
				data = data.toUpperCase();
			}
			else if( "lower".equalsIgnoreCase(textCase) )
			{
				data = data.toLowerCase();
			}
		}
		
		public String getSummationFormat() {
			return checkNull(summationFormat);
		}

		public void setSummationFormat(String summationFormat) {
			this.summationFormat = summationFormat;
		}

		public String getTagMessage() {
			if( checkNull(tagMessage).trim().length() == 0 )
			{
				tagMessage = "Value is Mandatory!";
			}
			return tagMessage;
		}

		public void setTagMessage(String tagMessage) {
			this.tagMessage = tagMessage;
		}

		public String checkNull( String value )
		{
			if( value == "undefined" || value == null || "null".equalsIgnoreCase( value ) )
			{
				value = "";
			}
			return value;
		}
		
		@Override
		public String toString() 
		{
			return "[\n" + "      index: " + index + 
					"\n" + "      name: " + name + 
					"\n" + "      data: " + data + 
					"\n" + "      originalText: " + originalText + 
					"\n" + "      width: " + width + 
					"\n" + "      isEditing: " + isEditing + 
					"\n" + "      isEditingAgain: " + isEditingAgain + 
					"\n" + "      isNumber: " + isNumber + 
					"\n" + "      protect: " + isProtect + 
					"\n" + "      isPophelp: " + isPophelp +
					"\n" + "      isItemChanged: " + isItemChanged + 
					"\n" + "      isMandatory: " + isMandatory + "]";
		}
	}

	@Override
	public boolean isEditing(Context context, Element parent, String value) 
	{
	   return true;
	}
	
	@Override
	public boolean resetFocus(Context context, Element parent, String value) 
	{
	    return true;
	}
	
	@Override
	public void render(Context context, String value, SafeHtmlBuilder sb) 
	{
		try
		{
			if ( isEditable ) 
			{
				Object key = context.getKey();
				int rowID = (int) Double.parseDouble( ( (DataGridTableRowModel)key ).getDomID() );
				int inputTabIndex =  context.getColumn() + (rowID*100);
				
				CellData cellData = getViewData(context);
				
				if (cellData != null && !cellData.isPophelp() && !cellData.isEditing() && value != null && value.equals(cellData.getData())) 
				{
					clearViewData(key);
					cellData = null;
				}
				
				if (cellData != null) 
				{
					int width = cellData.getWidth();
					if(e12AdvDataGrid != null)
					{
						String widthStr = e12AdvDataGrid.getColumnWidth(e12AdvDataGrid.getColumn(context.getColumn()));
						if(widthStr != null && widthStr.indexOf("px") > 0)
						{
							widthStr = widthStr.substring(0,widthStr.indexOf("px"));
						}
						try
						{
							width = (int)Double.parseDouble(widthStr.trim());
							cellData.setWidth(width+"");
						}
						catch(Exception e)
						{
							width = cellData.getWidth();
						}
					}
					if(width > 14)
					{
						width -=14;
					}
					
					String text = cellData.getData();
					text = cellData.checkNull( text );
					String elementId = cellData.getName() + "_" + inputTabIndex;
					if( cellData.isProtect() ) 
					{
						sb.append(template.text(text,cellData.getName()));
					}
					else if ( cellData.isEditing() && cellData.isVisible() ) 
					{
						if ( cellData.isPophelp() ) 
						{
							if(cellData.getLimit() != 0)
							{
								sb.append( template.pophelp_input( elementId, text, inputTabIndex, width - 45, cellData.getLimit() ) );
							}
							else
							{
								sb.append( template.pophelp_input( elementId, text, inputTabIndex, width - 45 ) );
							}
						} 
						else 
						{
							if( cellData.isNumber )
							{
								if(cellData.getLimit() != 0)
								{
									sb.append(template.inputRightAlign(elementId, text, inputTabIndex, width - 15, cellData.getLimit()));
								}
								else
								{
									sb.append(template.inputRightAlign(elementId, text, inputTabIndex, width - 15));
								}
							}
							else
							{
								if(cellData.getLimit() != 0)
								{
									sb.append(template.input(elementId, text, inputTabIndex, width - 15, cellData.getLimit()));
								}
								else
								{
									sb.append(template.input(elementId, text, inputTabIndex, width - 15));
								}

							}
						}
					}
					else 
					{
						if ( cellData.isPophelp() ) 
						{
							width = getStrLenInPx( text, width );
							if( width < 0 ) width = 0;
							sb.append( template.pophelp( text, width ) );
						} 
						else 
						{
							sb.append(template.text(text,cellData.getName()));
						}
					}
				} 
				else if (value != null) 
				{
					sb.append(template.text(value,cellData.getName()));
				}
			}
			else
			{
				//Changed By Prashant Chavan on 11-Mar-15 [For Dahsboard report -Cell with Link attribute Added Condition for Link Cell] Start
				CellData cellData = getViewData(context);
				String link = cellData.getLinkName();
				if( isRightAligned )
				{
					if(cellData.linkName != null && cellData.linkName !="" )
					{
						sb.append(template.rightAligntextLink(value,link,cellData.getName()));	
					}
					else
					{	
					sb.append( template.rightAligntext(value,cellData.getName()) );
					}
				}
				else
				{
					if(cellData.linkName != null && cellData.linkName !="" )
					{
						sb.append(template.linktext(value,link,cellData.getName()));	
					}
					else
					{
						sb.append( template.text(value,cellData.getName()) );
					}
					
				}
				//Changed By Prashant Chavan on 11-Mar-15 [For Dahsboard report -Cell with Link attribute Added Condition for Link Cell ] End	
			}
		}
		catch(Exception e)
		{
		}
	}
	
	@Override
	public void onBrowserEvent(Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) 
	{
		try
		{
			//Changes by Prajyot[Bug Fix : On click of cell data, Right click data gets disappear. ]
			if( !isEditable ) 
			{
				return;
			}
			//Changed By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to set focus on next field after item changed]
			currentCellElement = parent;
			incrFactor = 0;
			currentContext = context;

			this.valueUpdater = (E12CellUpdater<String>) valueUpdater;

			Object key = context.getKey();

			CellData cellData = getViewData( context );
			String type = event.getType();
			
			//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to prevent from typing non numeric value in numeric cell] start
			if ( cellData.isNumber() && ( ( event.getKeyCode() >= 65 &&	event.getKeyCode() <= 90 ) || 
					event.getKeyCode() == 186 || 
					event.getKeyCode() == 187 || 
					event.getKeyCode() == 189 || 
					event.getKeyCode() == 191 || 
					event.getKeyCode() == 192 || 
					event.getKeyCode() == 219 || 
					event.getKeyCode() == 220 || 
					event.getKeyCode() == 221 || 
					event.getKeyCode() == 222 || 
					event.getKeyCode() == 188 || 
					event.getKeyCode() == 191 || 
					event.getKeyCode() == 106 || 
					event.getKeyCode() == 107 || 
					event.getKeyCode() == 109 || 
					event.getKeyCode() == 110 || 
					event.getKeyCode() == 111 || 
					event.getKeyCode() == 32 || 
					event.getKeyCode() == 16) && ( event.getKeyCode() == 190 && cellData.getSummationFormat().indexOf("#.#") == -1 ))
			{
				event.preventDefault();
				return;
			}
			//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to prevent from typing non numeric value in numeric cell] end
			else
			{
				if (cellData != null && cellData.isEditing() && cellData.isVisible() ) 
				{
					if ( "click".equals(type) )
					{
						try
						{
							clickEvent(context, parent, value, cellData, event);
							if(prvEditableField != null)
							{
								prvEditableField.focus();
								prvEditableField.select();
								setValidate(cellData, value);
								editableField = prvEditableField;
							}
						}catch (Exception e) {}
					}
					else if ( "blur".equals(type) )
					{
						try
						{
							//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] start
							if (isKeyDownInitiated == false)
							{
								//isKeyDownInitiated = true;
								blurEvent(context, parent, value, cellData, event);
								isKeyDownInitiated = false;
							}
							else
							{
								isKeyDownInitiated = false;
								//return;
								// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] Start
								if(isClickInitiated==true)
								{
									//isClickInitiated=false;
									event.preventDefault();
									event.stopPropagation();
									commit(context, parent, cellData, value, "blur");
									if(isValidate)
									{
										return;
									}
										if(! cellData.isItemChanged() || cellData.isFocusAgain())
										{
											//edit(context, parent, value, cellData);
											cellData.setFocusAgain(false);
											setViewData(key, cellData);
										}
										else
										{
											cellData.setEditing(true);
											setViewData(key, cellData);
											edit(context, parent, value, cellData);
											cellData.setFocusAgain(true);
											setViewData(key, cellData);
										}
								}
								// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] End
							}
							//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] end
						} catch (Exception e) {}
					}
					else if ( "mouseover".equals(type) )
					{
						cellData.setPophelpImgActive(true);
						return;
					}
					else if ( "mouseout".equals(type) )
					{
						cellData.setPophelpImgActive(false);
						return;
					}
					else 
					{
						try {
							editEvent(context, parent, value, cellData, event);
						} catch (Exception e) {}
					}
				} 
				else 
				{
					int keyCode = event.getKeyCode();
					boolean enterPressed = "keyup".equals(type)	&& keyCode == KeyCodes.KEY_ENTER;
					if ( "click".equals(type) || enterPressed ) 
					{
						// Go into edit mode.
						if(isValidate)
						{
							return;
						}
						else
						{
							cellData = getViewData(context);
							cellData.setEditing(true);
							setViewData(key, cellData);
							edit(context, parent, value, cellData);
							clickEvent(context, parent, value, cellData, event);
						}
					}
				}
				//Ended By Mahesh Patidar
			}
		}
		catch(Exception e)
		{}
	}
	
	/**
	 * Convert the cell to edit mode.
	 * 
	 * @param context the {@link Context} of the cell
	 * @param parent the parent element
	 * @param cellData 
	 * @param value the current value
	 * @param cellData 
	 */
	public void edit(Context context, Element parent, String value, CellData cellData) 
	{
		//Changed By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | To set field focus status remove input field title]
		if( context != null )
		{
			try
			{
				setValue(context, parent, value);
				Object key = context.getKey();
				cellData.setFocusAgain(false);
				setViewData(key, cellData);
			}
			catch(Exception e)
			{
			}
		}
		InputElement input = getInputElement(parent);
		if (input != null) 
		{
			try
			{
				editableField = input;
				input.focus();
				input.select();
				input.click();
				String style = input.getAttribute("style");
				input.setAttribute("style", style +" border: 1px red solid;");
				value = input.getValue();
			}
			catch(Exception e)
			{
			}
		}
		setValidate(cellData, value);
		//Ended By Mahesh Patidar
	}

	private void clickEvent(Context context, Element parent, String value, CellData cellData, NativeEvent event) 
	{
		isKeyDownInitiated =true;
		isClickInitiated=true;
		EventTarget eventTarget = event.getEventTarget();
		//Commented By Prashant Chavan on 11-Mar-15
		//E12CommonUtils.printOnConsole("parent[" + parent  + "]");
		//E12CommonUtils.printOnConsole("eventTarget[" + eventTarget  + "]");
		if (Element.is(eventTarget)) 
		{
			Element target = Element.as(eventTarget);
			if("div".equals(target.getTagName().toLowerCase()) && checkNull( target.getClassName() ).indexOf("pophelpImg") != -1 ) 
			{
				if (this.valueUpdater != null) 
				{
					this.valueUpdater.showPophelp(value);
				}
			}
		}
	}

    private void blurEvent(Context context, Element parent, String value, CellData cellData, NativeEvent event)
    {
    	if(editableField != null)
    	{
    		prvEditableField = editableField;
    	}
    	editableField = null;
		if( event == null )
		{
			commit(context, parent, cellData, /*valueUpdater,*/ value, "blur");
		}
		else
		{
			// Commit the change. Ensure that we are blurring the input element and not the parent element itself.
			EventTarget eventTarget = event.getEventTarget();
			if (Element.is(eventTarget)) 
			{
				Element target = Element.as(eventTarget);
				if ("input".equals(target.getTagName().toLowerCase()) && !cellData.isPophelpImgActive()) 
				{
					commit(context, parent, cellData, /*valueUpdater,*/ value, "blur");
				}
			}
		}
    }
    //Changed By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to set check and set focus n next editable field after item changed]
	private void editEvent(Context context, Element parent, String value, CellData cellData, NativeEvent event) throws Exception 
	{
		String type = event.getType();
		boolean keyUp = "keyup".equals(type);
		boolean keyDown = "keydown".equals(type);
		if (keyUp || keyDown) 
		{
			Object key = context.getKey();
			int keyCode = event.getKeyCode();

//			if( keyCode == KeyCodes.KEY_TAB || keyCode == KeyCodes.KEY_UP || keyCode == KeyCodes.KEY_DOWN )
//			{
//				event.preventDefault();
//				activateNextCell( parent );
//			}
			isValidate = false;
			if( keyDown && keyCode == KeyCodes.KEY_ENTER )
			{
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] start
				isKeyDownInitiated = true;
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] end
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] Start
				isClickInitiated=false;
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] end
				incrFactor = 3;
				commit(context, parent, cellData, value, type+"9");
				if(isValidate)
				{
					return;
				}
				cellData.setFocusAgain(false);
				setViewData(key, cellData);
			}
			else if( keyDown && keyCode == KeyCodes.KEY_UP )
			{
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] start
				isKeyDownInitiated = true;
				
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] end
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] Start
				isClickInitiated=false;
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] end
				if(cellData.isProtect())
				{
					return;
				}
				incrFactor = -1;
				commit(context, parent, cellData, value, type + keyCode);
				if(isValidate)
				{
					return;
				}
				if(! cellData.isItemChanged() || cellData.isFocusAgain())
				{
					editUpDown(context, parent, -1);
					cellData.setFocusAgain(false);
					setViewData(key, cellData);
				}
				else
				{
					cellData.setEditing(true);
					setViewData(key, cellData);
					edit(context, parent, value, cellData);
					cellData.setFocusAgain(true);
					setViewData(key, cellData);
				}
			}
			else if( keyDown && keyCode == KeyCodes.KEY_DOWN )
			{
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] start
				isKeyDownInitiated = true;
				
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] end
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] Start
				isClickInitiated=false;
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] end
				if(cellData.isProtect())
				{
					return;
				}
				incrFactor = 1;
				commit(context, parent, cellData, value, type + keyCode);
				if(isValidate)
				{
					return;
				}
				if(! cellData.isItemChanged() || cellData.isFocusAgain())
				{
					editUpDown(context, parent, 1);
					cellData.setFocusAgain(false);
					setViewData(key, cellData);
				}
				else
				{
					cellData.setEditing(true);
					setViewData(key, cellData);
					edit(context, parent, value, cellData);
					cellData.setFocusAgain(true);
					setViewData(key, cellData);
				}
			}
			else if( keyDown && keyCode == KeyCodes.KEY_TAB )
			{
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] start
				isKeyDownInitiated = true;
				
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] end
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] Start
				isClickInitiated=false;
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] end
				incrFactor = 2;
				boolean isBackwardTab = event.getShiftKey();
				
				event.preventDefault();
				event.stopPropagation();
				commit(context, parent, cellData, value, type + keyCode);
				if(isValidate)
				{
					return;
				}
				if( isBackwardTab )
				{

					try
					{
						if(! cellData.isItemChanged() || cellData.isFocusAgain())
						{
							editPrev(context, parent);
							cellData.setFocusAgain(false);
							setViewData(key, cellData);
						}
						else
						{
							cellData.setEditing(true);
							setViewData(key, cellData);
							edit(context, parent, value, cellData);
							cellData.setFocusAgain(true);
							setViewData(key, cellData);
						}
					} 
					catch (Exception e) 
					{
//						Window.alert("E12CustomTextCell in editEvent Exception : " + e.getMessage() );
					}
				}
				else 
				{

					try
					{
						if(! cellData.isItemChanged() || cellData.isFocusAgain())
						{
							editNext(context, parent);
							cellData.setFocusAgain(false);
							setViewData(key, cellData);
						}
						else
						{
							cellData.setEditing(true);
							setViewData(key, cellData);
							edit(context, parent, value, cellData);
							cellData.setFocusAgain(true);
							setViewData(key, cellData);
						}
					} 
					catch (Exception e) 
					{
//						Window.alert("E12CustomTextCell in editEvent Exception : " + e.getMessage() );
					}
				}
				
			}
			else if (keyDown && keyCode == KeyCodes.KEY_ESCAPE) 
			{
				// Cancel edit mode. 
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] Start
				isClickInitiated=false;
				// Added by Aniket N. on 26-May-2014 [ To stop extra blur event after click event ] end
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] start
				if (cellData.isMandatory() && "".equals(value))
				{
					isKeyDownInitiated = true;
				}
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] end
				String originalText = cellData.getOriginalText();
				if( !validate( cellData, originalText, true ) )
				{
					cellData.setData(originalText);
					cellData.setEditing(true);
					setViewData(key, cellData);
					edit(context, parent, originalText, cellData);
					return;
				}
				cellData.setData(originalText);
				cellData.setEditing(false);
				setViewData(key, cellData);
				prvEditableField = null;
				cancel(context, parent, originalText);
			} 
			else 
			{
				// Update the text in the view data on each key.
				updateViewData(parent, cellData, true);
			}
		} 
	}
	
	public void editNext( Context currContext, Element currCellElem ) throws Exception
	{
		if( e12AdvDataGrid == null || currContext == null || currCellElem == null )
		{
			return;
		}
		List<DataGridTableRowModel> visibleItems = e12AdvDataGrid.getVisibleItems();
		int firstVisibleRowId = e12AdvDataGrid.getVisibleRange().getStart();
		int rowCount = e12AdvDataGrid.getVisibleItemCount() + firstVisibleRowId - 1;
		int columnCount = e12AdvDataGrid.getColumnCount();
		
		boolean isNextEdit = false;
		int nextRow = currContext.getIndex();
		int nextColumn = currContext.getColumn() + 1;
		Element currElement = findCurrentCell(currCellElem);
		if( currElement != null )
		{
			currCellElem = currElement;
		}
		String value = ( (DataGridTableRowModel)currContext.getKey() ).getCellText( currContext.getColumn() );
		if( !validate(getViewData(currContext), value,false) )
		{
			return;
		}
		while( !isNextEdit )
		{
    		try
    		{
				value = ( (DataGridTableRowModel)currContext.getKey() ).getCellText( currContext.getColumn() );


				Element nextCellElem = findCell( currCellElem, "Next" );

				if( nextColumn >= columnCount )
				{
					nextRow += 1;
					nextColumn = 1;
				}
				if( nextRow > rowCount )
				{
					nextRow = firstVisibleRowId;
					nextColumn = 1;
				}
				Object nextKey = visibleItems.get( nextRow - firstVisibleRowId );
				Context nextContext = new Context(nextRow, nextColumn, nextKey);
				String nextValue = ( (DataGridTableRowModel)nextKey ).getCellText( nextColumn );
				CellData cellData = getViewData(nextContext);

				if( cellData != null && !cellData.isProtect() )
				{
					cellData.setEditing(true);
					setViewData(nextKey, cellData);
					Element element = nextCellElem.getFirstChildElement();
					if( element == null )
					{
						element = nextCellElem;
					}
					edit(nextContext, element, nextValue, cellData);
					isNextEdit = true;
					return;
				}
				else
				{
					currContext = nextContext;
					currCellElem = nextCellElem;
					nextColumn = currContext.getColumn() + 1;
					isNextEdit = false;
				}
    		}
    		catch (Exception e) 
    		{
    			isNextEdit = true;
    			throw e;
			}
		}
	}

	public void editPrev( Context currContext, Element currCellElem ) 
	{
		if(e12AdvDataGrid == null)
		{
			return;
		}
		List<DataGridTableRowModel> visibleItems = e12AdvDataGrid.getVisibleItems();
		int firstVisibleRowId = e12AdvDataGrid.getVisibleRange().getStart();
		int rowCount = e12AdvDataGrid.getVisibleItemCount() + firstVisibleRowId - 1;
		int columnCount = e12AdvDataGrid.getColumnCount();
		
		boolean isPrevEdit = false;
		int prevRow = currContext.getIndex();
		int prevColumn = currContext.getColumn() - 1;
		Element currElement = findCurrentCell(currCellElem);
		if( currElement != null )
		{
			currCellElem = currElement;
		}
		String value = ( (DataGridTableRowModel)currContext.getKey() ).getCellText( currContext.getColumn() );
		if( !validate(getViewData(currContext), value,false) )
		{
			return;
		}
		while( !isPrevEdit )
		{
    		try
    		{
				value = ( (DataGridTableRowModel)currContext.getKey() ).getCellText( currContext.getColumn() );


				Element prevCellElem = findCell( currCellElem, "Prev" );

				if( prevColumn <= 0 )
				{
					prevRow -= 1;
					prevColumn = columnCount - 1 ;
				}
				if( prevRow < firstVisibleRowId )
				{
					prevRow = rowCount;
					prevColumn = columnCount - 1 ;
				}
				Object prevKey = visibleItems.get( prevRow - firstVisibleRowId);
				Context prevContext = new Context(prevRow, prevColumn, prevKey);
				String prevValue = ( (DataGridTableRowModel)prevKey ).getCellText( prevColumn );
				CellData cellData = getViewData(prevContext);

				if( cellData != null && !cellData.isProtect() )
				{
					cellData.setEditing(true);
					setViewData(prevKey, cellData);
					Element element = prevCellElem.getFirstChildElement();
					if( element == null )
					{
						element = prevCellElem;
					}
					edit(prevContext, element, prevValue, cellData);
					isPrevEdit = true;
					return;
				}
				else
				{
					currContext = prevContext;
					currCellElem = prevCellElem;
					prevColumn = currContext.getColumn() - 1;
					isPrevEdit = false;
				}
    		}
    		catch (Exception e) 
    		{
    			isPrevEdit = true;
			}
		}
	}
	
	public void editUpDown(Context currContext, Element currCellElem, /*List<DataGridTableRowModel> visibleItems, int rowCount,*/ int incrDecr ) throws Exception 
	{
		if(e12AdvDataGrid == null || isMandantoryCellInRow(currContext, currCellElem) || (incrDecr != -1 && incrDecr != 1))
		{
			return;
		}
		List<DataGridTableRowModel> visibleItems = e12AdvDataGrid.getVisibleItems();
		int firstVisibleRowId = e12AdvDataGrid.getVisibleRange().getStart();
		int rowCount = e12AdvDataGrid.getVisibleItemCount() + firstVisibleRowId - 1;
		boolean isNextEdit = false;
		int nextRow = currContext.getIndex() + incrDecr;
		int currColumn = currContext.getColumn();
		Element currElement = findCurrentCell(currCellElem);
		if( currElement != null )
		{
			currCellElem = currElement;
		}

		String value = ( (DataGridTableRowModel)currContext.getKey() ).getCellText( currColumn );
		if( !validate( getViewData(currContext), value ,false) )
		{
			return;
		}

		while( !isNextEdit )
		{
    		try
    		{
    			if( nextRow < firstVisibleRowId )
    			{
    				nextRow = rowCount;
    			}
    			else if( nextRow > rowCount )
    			{
    				nextRow = firstVisibleRowId;
    			}
				value = ( (DataGridTableRowModel)currContext.getKey() ).getCellText( currColumn );
				Element nextCellElem = findNextRowsCell( currCellElem, currColumn, incrDecr );
				Object nextKey = visibleItems.get( nextRow - firstVisibleRowId );
				Context nextContext = new Context(nextRow, currColumn, nextKey);
				CellData cellData = getViewData(nextContext);
				if( cellData != null && !cellData.isProtect() )
				{
					cellData.setEditing(true);
					setViewData(nextKey, cellData);
					Element element = nextCellElem.getFirstChildElement();
					if( element == null )
					{
						element = nextCellElem;
					}
					edit(nextContext, element, value, cellData);
					isNextEdit = true;
					return;
				}
				else
				{
					currContext = nextContext;
					currCellElem = nextCellElem;
					//nextRow += incrDecr;
					nextRow = currContext.getIndex() + incrDecr;
					isNextEdit = false;
				}
    		}
    		catch (Exception e) 
    		{
//    			Window.alert("E12CustomTextCell in editUpDown Exception : " + e.getMessage() + e.toString() );
    			isNextEdit = true;
			}
		}
	}
	//Ended By Mahesh Patidar
	//Added By Mahesh Patidar on 15/MAY/13[WS2FSUN002 | to set focus on next mandatory field and set item change data to row]
	private boolean isMandantoryCellInRow(Context currContext,Element element) {
		boolean isFieldExist = false;
		CellData cellData = ( (DataGridTableRowModel)currContext.getKey() ).getCellData(currContext.getColumn() + 1);
			if(cellData != null)
			{
				if(cellData.isMandatory() && ! cellData.isProtect())
				{
					if( cellData.getData() == null || cellData.getData().trim().length() == 0)
					{
						Element nextElement = findCell(element,cellData.getIndex()).getFirstChildElement();
						Context nextContext = new Context(currContext.getIndex(), cellData.getIndex(), currContext.getKey());
						cellData.setEditing(true);
						setViewData(currContext.getKey(), cellData);
						edit(nextContext, nextElement, cellData.getData(), cellData);
						isFieldExist = true;
					}
				}
			}
		return isFieldExist;
	}

	public void setItemChangeValues(Context currContext, Element element) {
		DataGridTableRowModel rowModel = (DataGridTableRowModel)currContext.getKey();
		HashMap<Integer, CellData> currRowMap = ( rowModel ).getRowData();
		for (Map.Entry<Integer, CellData> entry : currRowMap.entrySet()) 
		{
			try
			{
				CellData cellData = entry.getValue();
				if(cellData != null && cellData.getIndex() > 0 )
				{
					Element nextElement = findCell(element,cellData.getIndex());
					if(nextElement != null && nextElement.getFirstChildElement() != null)
					{
						nextElement = nextElement.getFirstChildElement();
					}
					Context nextContext = new Context(currContext.getIndex(), cellData.getIndex(), currContext.getKey());
					cellData.setOriginalText(cellData.getData());
					cellData.setEditing(false);
					setViewData(nextContext.getKey(), cellData);
					if(nextElement != null && nextContext != null)
					{
						setValue(nextContext, nextElement, cellData.getOriginalText());
					}
					if( cellData.isNumber() && cellData.getSummationFormat().indexOf("sum(") != -1 )
					{
						e12AdvDataGrid.redrawFooters();
					}
				}
			}
			catch(Exception ex)
			{
//				Window.alert("Exception in setItemChangeValue :[" + ex.toString() + "]");
			}
		}
	}
	//Ended By Mahesh Patidar
	private Element findNextRowsCell(Element elem, int currColumn, int incrDecr) 
	{
		Element nextElem =  findFirstOrLastCell(elem, incrDecr, "First");
		currColumn -= 1;
		while( currColumn > 0 )
		{
			if( nextElem != null )
			{
				nextElem = nextElem.getNextSiblingElement();
				currColumn -= 1;
			}
			else
			{
				break;
			}
		}
		
		if( nextElem != null && "td".equalsIgnoreCase( nextElem.getTagName() ) )
		{
			return nextElem;
		}
		else
		{
			return elem;
		}
	}

//	private TableCellElement findCurrentCell(Element elem) 
	private Element findCurrentCell(Element elem) 
	{
		while ( elem != null ) 
		{
			String tagName = elem.getTagName();
			if ( "td".equalsIgnoreCase(tagName) ) 
			{
				return elem;
			}
			elem = elem.getParentElement();
		}
		return null;
	}

//	private TableCellElement findNextCell(Element elem) 
	private Element findCell(Element elem, String navCmd ) 
	{
		Element cellElem = null;
		
		if( "Next".equalsIgnoreCase( navCmd) )
		{
			cellElem = elem.getNextSiblingElement();
		}
		else if( "Prev".equalsIgnoreCase( navCmd) )
		{
			Node prevNode = elem.getPreviousSibling();
			cellElem = ( prevNode != null ) ? Element.as( prevNode ) : elem;
			//Changed By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to check is first field of row or not]
			if(cellElem.getPreviousSibling() == null)
			{
				cellElem = null;	
			}
		}
		
		if( cellElem != null && "td".equalsIgnoreCase( cellElem.getTagName() ) )
		{
			return cellElem;
		}
		else
		{
			//cellElem =  findNextRowsFirstCell(elem, 1);
			if( "Next".equalsIgnoreCase( navCmd) )
			{
				cellElem =  findFirstOrLastCell(elem, 1, "First");
			}
			else if( "Prev".equalsIgnoreCase( navCmd) )
			{
				cellElem =  findFirstOrLastCell(elem, -1, "Last");
			}
			
			if( cellElem != null && "td".equalsIgnoreCase( cellElem.getTagName() ) )
			{
				return cellElem;
			}
			else
			{
				return elem;
			}
		}
	}
//Added By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to find the cell element for focus set to next mandatory editable field after item changed]
	private Element findCell(Element elem,int index ) 
	{
		Element cellElem = elem;
		while ( elem != null ) 
		{
			elem = elem.getParentElement();
			String tagName = elem.getTagName();
			if ( "tr".equalsIgnoreCase(tagName) ) 
			{
				cellElem = elem.getFirstChildElement();
				while(index != 0)
				{
					cellElem = cellElem.getNextSiblingElement();
					if(cellElem == null)
					{
						break;
					}
					index--;
				}
				break;
			}
		}
		return cellElem;
	}
	//Ended By Mahesh Patidar
	//private TableCellElement findNextRowsFirstCell(Element elem, int incrDecr) 
	private Element findFirstOrLastCell(Element elem, int incrDecr, String pos) 
	{
		Element rowElem = elem.getParentElement();
		if ( rowElem != null ) 
		{
			String tagName = rowElem.getTagName();
			if( "tr".equalsIgnoreCase(tagName) ) 
			{
				Element nextRowElem = rowElem.getNextSiblingElement();
				Node prevRowSiblingNode = rowElem.getPreviousSibling();
				if( incrDecr == -1 && prevRowSiblingNode != null)
				{
					 nextRowElem = Element.as( prevRowSiblingNode );
				}
				//Added By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to set first element if tab from last and set last element if previous tab from first element]
				else if( incrDecr == -1 && prevRowSiblingNode == null)
				{
					nextRowElem = Element.as(rowElem.getParentElement().getLastChild());
				}
				if( incrDecr == 1 && nextRowElem == null)
				{
					nextRowElem = rowElem.getParentElement().getFirstChildElement();
				}
				//Ended by Mahesh Patidar
				if( nextRowElem != null )
				{
					if( "First".equalsIgnoreCase( pos ) )
					{
						elem = nextRowElem.getFirstChildElement().getNextSiblingElement();
					}
					else if( "Last".equalsIgnoreCase( pos ) )
					{
						Node lastNode = nextRowElem.getLastChild();
						elem = ( lastNode != null ) ? Element.as( lastNode ) : elem;
					}
					return elem;
				}
			}
		}
		return elem;
	}

	
	/**
	 * Convert the cell to non-edit mode.
	 * 
	 * @param context the context of the cell
	 * @param parent the parent Element
	 * @param value the value associated with the cell
	 */
	private void cancel(Context context, Element parent, String value) 
	{
		InputElement input = getInputElement(parent);
		if (input != null) 
		{
			clearInput(input);
		}
		setValue(context, parent, value);
	}

	/**
	 * Clear selected from the input element. Both Firefox and IE fire spurious
	 * onblur events after the input is removed from the DOM if selection is not
	 * cleared.
	 * 
	 * @param input the input element
	 */
	private native void clearInput(Element input) /*-{
		if (input.selectionEnd)
			input.selectionEnd = input.selectionStart;
		else if ($doc.selection)
			$doc.selection.clear();
	}-*/;

	
	/**
	 * Commit the current value.
	 * 
	 * @param context the context of the cell
	 * @param parent the parent Element
	 * @param cellData the {@link ViewData} object
	 * @param valueUpdater the {@link ValueUpdater}
	 * @param value
	 * @param type
	 */
	public void commit(Context context, Element parent, CellData cellData, String value, String type) 
	{
		//Changed By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to apply item change if value changed on any event]
		try
		{
	    	if(cellData.isProtect())
	    	{
				isValidate = false;
	    		return;
	    	}
	    	
			if (validate(cellData, value, true)) 
			{
				//Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] start
				isKeyDownInitiated = false;
				////Added by Arvind on 4-Dec-2013 [SY1HBAS001] : [to stop extra blur event from Window.alert call] end
				Object key = context.getKey();
				updateViewData(parent, cellData, false);
				prvEditableField = null;
				InputElement input = getInputElement(parent);
				if (input != null) 
				{
					clearInput(input);
				}
				setValue(context, parent, cellData.getOriginalText());
				if (this.valueUpdater != null) 
				{
					String currData = cellData.checkNull( cellData.getData() );
					if( cellData.isPophelp() || cellData.isItemChanged() )
					{
						if( !currData.equalsIgnoreCase( cellData.getOriginalText() ))
						{
//							boolean isTabClicked = "keydown9".equalsIgnoreCase(type);
//							boolean isUpDownClicked = "keyup38".equalsIgnoreCase(type) || "keyup40".equalsIgnoreCase(type);
							this.valueUpdater.doItemChange(value);
							this.valueUpdater.update(value);	
							cellData.setFocusAgain(false);
							setViewData(key, cellData);
						}
						else
						{
							cellData.setFocusAgain(true);
							setViewData(key, cellData);
						}
					}
				}
				isValidate = false;
			} 
			else 
			{
				edit(context, parent, value, cellData);
			}
		}
		catch(Exception e)
		{
//			Window.alert("Exception:"+e.toString());
		}
		//Ended By Mahesh Patidar
	}

	private boolean validate(CellData cellData, String value,boolean alertFlag) 
	{
		if( cellData == null )
		{
			return false;
		}
		
		if (cellData.isNumber()) 
		{
			return ( isNumber(value,alertFlag) );
		} 
		else if ( cellData.isMandatory() /*|| cellData.isPophelp()*/ ) 
		{
			return (!isEmpty(value,alertFlag,cellData.getTagMessage()));
		}
		return true;
	}

	private boolean isNumber(String value,boolean alertFlag) 
	{
		try 
		{
			int intValue = (int) Double.parseDouble(value);
			return true;
		} 
		catch (Exception e) 
		{
			if(alertFlag)
			{
				Window.alert("Please Enter Numeric Value!");
			}
			return false;
		}
	}

	private boolean isEmpty(String value,boolean alertFlag, String tagMessage) 
	{
		//Changed By Mahesh Patidar on 15/MAY/13 [WS2FSUN002 | to alert when blank mandatory field lost focus]
		boolean isEmpty = false;
		try {
			value = (value != null) ? value.trim() : "";
			isEmpty = "".equalsIgnoreCase(value);
			if(isEmpty && alertFlag)
			{
				//Window.alert("Value is Mandatory!");
				Window.alert( tagMessage );
			}
		}
		catch(Exception e)
		{}
		return isEmpty;
		//Ended By Mahesh patidar
	}

	/**
	 * Get the input element in edit mode.
	 */
	private InputElement getInputElement(Element parent) 
	{
		Node inputNode = parent.getFirstChild();
		if (inputNode != null) 
		{
			return inputNode.<InputElement>cast();
		} 
		else if( "input".equalsIgnoreCase( parent.getTagName() ) )
		{
			return parent.<InputElement>cast();
		}
		else
		{
			return null;
		}
	}

	/**
	 * Update the view data based on the current value.
	 * 
	 * @param parent
	 *            the parent element
	 * @param cellData
	 *            the {@link ViewData} object to update
	 * @param isEditing
	 *            true if in edit mode
	 * @return the new value
	 */
	private String updateViewData(Element parent, CellData cellData, boolean isEditing) 
	{
		InputElement input = getInputElement(parent);
		String value = "";
		if (input != null) 
		{
			value = input.getValue();
		}
		isValidate = false;
		if(cellData.isMandatory() && ! cellData.isProtect() && ( value == null || value.length() == 0))
		{
			isValidate = true;
		}
		else if(cellData.isNumber() && ! cellData.isProtect() && ! isNumber(value,false))
		{
			isValidate = true;
		}
		cellData.setData(value);
		cellData.setEditing(isEditing);
		return value;
	}

    public CellData getViewData( Context context ) 
    {
    	Object key = context.getKey();
    	CellData cellData = ((DataGridTableRowModel) key).getCellData(context.getColumn());
		setViewData(key, cellData);
	    return cellData;
	}

	public void setParent(AbstractDataGrid<DataGridTableRowModel> e12AdvDataGrid) 
	{
		this.e12AdvDataGrid = e12AdvDataGrid;
	}
    
	private int getStrLenInPx( String textStr, int width )
	{
		int retWidth = 0;
		int strWidth = 0;
		Label label = new Label(textStr);
		label.getElement().setAttribute("style", "position:absolute;visibility:hidden");
		RootPanel.get().add( label );
		strWidth = label.getElement().getClientWidth();
		RootPanel.get().remove(label);
		
		if( width > strWidth )
		{
			retWidth = width - strWidth - 25;
		}
		else
		{
			retWidth = strWidth % width;
			retWidth = width - retWidth - 25;
		}
		
		return retWidth;
	}
	private void setValidate(CellData cellData,String value)
	{
		isValidate = false;

		if(cellData.isMandatory() && ! cellData.isProtect() && ( cellData.getOriginalText() == null || cellData.getOriginalText().length() == 0))
		{
			isValidate = true;
		}
		else if(cellData.isNumber() && ! cellData.isProtect() && ( value == null || value.length() == 0))
		{
			isValidate = true;
		}
	}
//  native method  Added by Aniket N. on 22 may 2014 [to Display Alert Message] Start
	public static native void alert(String msg) /*-{
	  $wnd.alert(msg);
	}-*/;
//  native method  Added by Aniket N. on 22 may 2014 [to Display Alert Message] End
	private String checkNull( String value )
	{
		if( value == "undefined" || value == null || "null".equalsIgnoreCase( value ) )
		{
			value = "";
		}
		return value;
	}
}