/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.TextBoxBase;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.MetaDataNodeObj;
import java.util.ArrayList;
import java.util.List;

public class E12Validator {
    protected static boolean existingError = false;

    public static void addValidations(TextBoxBase textBox, MetaDataNodeObj metaDataNodeObj) {
        E12Validator.addValidationsOnBlur(textBox, metaDataNodeObj);
        E12Validator.addValidationsOnKeyPress(textBox, metaDataNodeObj);
    }

    public static void addValidationsOnBlur(TextBoxBase textBox, MetaDataNodeObj metaDataNodeObj) {
        BlurHandler blurHandler = new BlurHandler();
        E12Validator.addMandatoryFieldValidation(metaDataNodeObj, blurHandler);
        E12Validator.addNumericValidation(textBox, metaDataNodeObj, blurHandler);
        textBox.addBlurHandler((com.google.gwt.event.dom.client.BlurHandler)blurHandler);
    }

    public static void addValidationsOnKeyPress(TextBoxBase textBox, MetaDataNodeObj metaDataNodeObj) {
        E12Validator.addMaxLengthValidation(textBox, metaDataNodeObj);
    }

    public static void addMandatoryFieldValidation(MetaDataNodeObj metaDataNodeObj, BlurHandler blurHandler) {
        if ("yes".equalsIgnoreCase(metaDataNodeObj.getRequired())) {
            blurHandler.registerValidator(new Validator(){

                @Override
                public boolean isValid(String text) {
                    if (text == null || "".equals(text.trim())) {
                        Window.alert((String)E12Constants.constants.setFieldMandatory());
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    public static void addMaxLengthValidation(final TextBoxBase textBox, MetaDataNodeObj metaDataNodeObj) {
        try {
            final int maxLength = (int)Double.parseDouble(metaDataNodeObj.getLimit());
            if (maxLength > 0) {
                textBox.addKeyPressHandler(new KeyPressHandler(){

                    public void onKeyPress(KeyPressEvent event) {
                        if (textBox.getText().length() == maxLength && event.getUnicodeCharCode() != 0) {
                            event.preventDefault();
                        }
                    }
                });
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void addNumericValidation(final TextBoxBase textBox, MetaDataNodeObj metaDataNodeObj, BlurHandler blurHandler) {
        if ("[number]".equalsIgnoreCase(metaDataNodeObj.getFormat())) {
            blurHandler.registerValidator(new Validator(){

                @Override
                public boolean isValid(String text) {
                    if (text == null || "".equals(text.trim())) {
                        return true;
                    }
                    try {
                        Double.parseDouble(text);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        Window.alert((String)E12Constants.constants.setInvalidValue());
                        textBox.setText("");
                        return false;
                    }
                }
            });
        }
    }

    protected static class BlurHandler
    implements com.google.gwt.event.dom.client.BlurHandler {
        protected List<Validator> validators = new ArrayList<Validator>();

        protected BlurHandler() {
        }

        public void registerValidator(Validator validator) {
            this.validators.add(validator);
        }

        protected boolean onBlurImpl(String text) {
            for (Validator validator : this.validators) {
                if (validator.isValid(text)) continue;
                return false;
            }
            return true;
        }

        public void onBlur(BlurEvent event) {
            if (existingError) {
                existingError = false;
                return;
            }
            final TextBoxBase textBox = (TextBoxBase)event.getSource();
            String text = textBox.getText();
            boolean valid = this.onBlurImpl(text);
            if (!valid) {
                existingError = true;
                new Timer(){

                    public void run() {
                        textBox.setFocus(true);
                    }
                }.schedule(1);
            }
        }
    }

    protected static interface Validator {
        public boolean isValid(String var1);
    }
}

