package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ejb.Stateless;

@Stateless
public class RelPartyDefConf extends  ActionHandlerEJB implements RelPartyDefConfLocal, RelPartyDefConfRemote{

	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException{

		E12GenericUtility genericUtility= new  E12GenericUtility();
		System.out.println("RelPartyDefConf Confirmed Called");
		ResultSet rs = null;
		PreparedStatement pstmt = null;	
		Connection conn = null;
		String confDateStr = "";
		String sql = "";
		String confirmed = "";
		String errString = "";
		int updateCount = 0;
		String loginEmpCode = "";
		ITMDBAccessEJB itmdbAccess = new ITMDBAccessEJB();
		try{
			
			
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("Login Emp Code ["+ loginEmpCode + "]");
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;
			
			SimpleDateFormat sdf = new SimpleDateFormat( genericUtility.getDBDateTimeFormat());
			Date confDate = new Date();
			confDateStr = sdf.format(confDate);
			System.out.println("confDate is :"+confDate+" confDate str is : "+confDateStr);
			sql = "select confirmed from RELA_PARTY_HDR where TRAN_ID  = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed = checkNull( rs.getString("confirmed") );
			}	
			System.out.println("Confirm String ["+ confirmed + "]");
			if( confirmed != null && "Y".equalsIgnoreCase(confirmed) )
			{
				errString = itmdbAccess.getErrorString("","RPDCONFEMD",loginEmpCode);
				return errString;
			}
			else if(!"Y".equals(confirmed))
			{
				sql = "update RELA_PARTY_HDR set confirmed = 'Y', conf_date = ? where TRAN_ID  = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, Timestamp.valueOf( confDateStr ));
				pstmt.setString(2, tranId );
				updateCount = pstmt.executeUpdate();
				System.out.println("Update Count ["+ updateCount + "]");
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if(updateCount == 0){
				System.out.println("Transaction not confirmed ["+ updateCount +"]");
			}
			if(updateCount > 0)
			{
				
				System.out.println("RelaParty hdr is confirmd VMTRNRPCNR ["+ updateCount+ "]");
				errString = itmdbAccess.getErrorString("", "VMTRNRPCNR", loginEmpCode);
				
			}
		
		}catch (Exception e) {
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
           System.out.println("RelPartyDefConf.confirm()["+e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && !conn.isClosed() )
				{
					conn.commit();
					conn.close();
					conn = null;
				}
				
			}
			catch( Exception e)
			{
				e.printStackTrace();
				System.out.println("RelPartyDefConf.confirm() ["+e.getMessage()+"]");
			}
		}
		
		System.out.println("return String"+errString+"]");
		return errString;
	}

	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}

}
