/**
 *  Purpose: Servlet for default Values, 
 *  Author: Sneha Mestry
 *  Date: 23-11-2016
 */

package ibase.webitm.servlet.wms;

import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import ibase.webitm.ejb.wms.DDProductWizRemote;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;


public class ProdtWizDefaultValuesServlet extends HttpServlet
{
	
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ ProdtWizDefaultValuesServlet ]XXXXXXXXXXXXXXXXXXXX");
		try
		{			
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			
			String action = request.getParameter("ACTION");
			System.out.println("ACTION from request ====>> ["+action+"]");
		
			DDProductWizRemote ddProductWizRemote = null;
			JSONObject jsonObjData = new JSONObject();
			
			if ( action.equalsIgnoreCase("GET_DEFAULT_VALUES"))
			{
				InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
				ddProductWizRemote = (DDProductWizRemote) ctx.lookup("ibase/DDProductWizEJB/remote");

				jsonObjData = (JSONObject)ddProductWizRemote.getDefaultValuesfromJSON();
			}
			
			OutputStream outputStream = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final value form ProdtWizDefaultValuesServlet ===>>" + jsonObjData);	
			
		} 
		catch (Exception e)
		{
			System.out.println("Exception in: ProdtWizDefaultValuesServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}