/*
 * Author:Wasim Ansari
 * Date:03-05-2017
 * Request ID:F17BBAS001 (GST Wizard Post Save Component for Reconciliation Trace)
 */
package ibase.webitm.ejb.gst;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless;

import org.jcodec.codecs.vpx.VP8FixedRateControl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class GstrCustomTranEJB extends ValidatorEJB implements GstrCustomTranEJBRemote,GstrCustomTranEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
    /**
     * Default constructor. 
     */
    public GstrCustomTranEJB() {
        // TODO Auto-generated constructor stub
    }
	@Override
	public String saveRecord(String objName,String tranXml, UserInfoBean userInfo) throws RemoteException, ITMException 
	{
		Connection conn = null;
		String sql = "";
		PreparedStatement pstmt = null;
		Document tranDoc = null;
		NodeList detailNodeList = null;
		String retXmlString = "<root>";
		String errString = "";
		boolean isErrorExist = false;
		String dbDateStr = "";
		String valSql = "";
		PreparedStatement vPstmt = null;
		ResultSet vRs = null;
		String tranid = null,trandate = null,tranidref= null,sitecode = null,prdcode = null,
				rectype= null,trantype = null,custcode= null,custname= null,submissiontype= null,
				docchecksum = null,doctype= null,docno= null,docdate= null,amount= null,
				reversechrg= null,lrno = null,lrdate= null,reascode= null,refidinv= null,
				refdateinv= null,provassmnt= null,orderno= null,orderdate= null,remarks = null,
				submitstatus = null,submitdate= null,adduser = null,adddate= null,addterm = null,
				chguser = null,chgdate= null,chgterm= null,taxregno  = null,recostatus= null,
				ecomregno= null,refser= null,gstcode= null,gsttype= null,refid= null;
		
		try
		{	
			System.out.println("===================Inside GstrCustomTranEJB class========================");
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
			}
			tranDoc = genericUtility.parseString(tranXml);
			detailNodeList = tranDoc.getElementsByTagName("Detail1");
			
			docdate = genericUtility.getColumnValue("doc_date", tranDoc);
			prdcode = genericUtility.getColumnValue("prd_code", tranDoc);
			if(docdate == null || docdate.length() == 0)
			{
				errString = getErrorString("doc_date", "INVDOCDATE", userInfo.getLoginCode());
				isErrorExist = true;
				return errString;
			}
			if(prdcode == null || prdcode.length() == 0)
			{
				errString = getErrorString("doc_date", "INVGSTPCOD", userInfo.getLoginCode());
				isErrorExist = true;
				return errString;
			}
			else
			{
				valSql = "select tran_id from gst_data_hdr where gst_type = 'L' and prd_code = ?";
				vPstmt =  conn.prepareStatement(valSql);
				vPstmt.setString(1, prdcode);
				vRs = vPstmt.executeQuery();
				System.out.println(vRs.getFetchSize());
				if(vRs.next())
				{
					System.out.println("tran_id exist: "+vRs.getString("tran_id"));
					errString = getErrorString("doc_date", "INVGSTPCOD", userInfo.getLoginCode());
					isErrorExist = true;
					return errString;
				}
			}
			
			
			for(int i = 0; i < detailNodeList.getLength() && !isErrorExist; i++)
			{
				Node detailNode = detailNodeList.item(i);

				tranid = null;trandate = null;tranidref= null;sitecode = null;prdcode = null;
				rectype= null;trantype = null;custcode= null;custname= null;submissiontype= null;
				docchecksum = null;doctype= null;docno= null;docdate= null;amount= null;
				reversechrg= null;lrno = null;lrdate= null;reascode= null;refidinv= null;
				refdateinv= null;provassmnt= null;orderno= null;orderdate= null;remarks = null;
				submitstatus = null;submitdate= null;adduser = null;adddate= null;addterm = null;
				chguser = null;chgdate= null;chgterm= null;taxregno  = null;recostatus= null;
				ecomregno= null;refser= null;gstcode= null;gsttype= null;refid= null;

				tranid = generateTranId("w_"+objName, userInfo.getSiteCode(), conn);

				trandate = genericUtility.getColumnValueFromNode("tran_date", detailNode);
				tranidref= genericUtility.getColumnValueFromNode("tran_id__ref", detailNode);
				sitecode = genericUtility.getColumnValueFromNode("site_code", detailNode);
				prdcode = genericUtility.getColumnValueFromNode("prd_code", detailNode);
				rectype= genericUtility.getColumnValueFromNode("rec_type", detailNode);
				trantype = genericUtility.getColumnValueFromNode("tran_type", detailNode);
				custcode= genericUtility.getColumnValueFromNode("cust_code", detailNode);
				custname= genericUtility.getColumnValueFromNode("cust_name", detailNode);
				submissiontype= genericUtility.getColumnValueFromNode("submission_type", detailNode);
				docchecksum = genericUtility.getColumnValueFromNode("doc_checksum", detailNode);
				doctype= genericUtility.getColumnValueFromNode("doc_type", detailNode);
				docno= genericUtility.getColumnValueFromNode("doc_no", detailNode);
				docdate= genericUtility.getColumnValueFromNode("doc_date", detailNode);
				amount= genericUtility.getColumnValueFromNode("amount", detailNode);
				reversechrg= genericUtility.getColumnValueFromNode("reverse_chrg", detailNode);
				lrno = genericUtility.getColumnValueFromNode("lr_no", detailNode);
				lrdate= genericUtility.getColumnValueFromNode("lr_date", detailNode);
				reascode= genericUtility.getColumnValueFromNode("reas_code", detailNode);
				refidinv= genericUtility.getColumnValueFromNode("ref_id__inv", detailNode);
				refdateinv= genericUtility.getColumnValueFromNode("ref_date__inv", detailNode);
				provassmnt= genericUtility.getColumnValueFromNode("prov_assmnt", detailNode);
				orderno= genericUtility.getColumnValueFromNode("order_no", detailNode);
				orderdate= genericUtility.getColumnValueFromNode("order_date", detailNode);
				remarks = genericUtility.getColumnValueFromNode("remarks", detailNode);
				submitstatus = genericUtility.getColumnValueFromNode("submit_status", detailNode);
				submitdate= genericUtility.getColumnValueFromNode("submit_date", detailNode);
				adduser = genericUtility.getColumnValueFromNode("add_user", detailNode);
				adddate= genericUtility.getColumnValueFromNode("add_date", detailNode);
				addterm = genericUtility.getColumnValueFromNode("add_term", detailNode);
				//chguser = genericUtility.getColumnValueFromNode("chg_user", detailNode);
				chguser = userInfo.getLoginCode();
				//chgdate= genericUtility.getColumnValueFromNode("chg_date", detailNode);
				//chgterm= genericUtility.getColumnValueFromNode("chg_term", detailNode);
				chgterm = userInfo.getRemoteHost();
				taxregno  = genericUtility.getColumnValueFromNode("tax_reg_no", detailNode);
				recostatus= genericUtility.getColumnValueFromNode("reco_status", detailNode);
				ecomregno= genericUtility.getColumnValueFromNode("ecom_reg_no", detailNode);
				refser= genericUtility.getColumnValueFromNode("ref_ser", detailNode);
				gstcode= genericUtility.getColumnValueFromNode("gst_code", detailNode);
				gsttype= genericUtility.getColumnValueFromNode("gst_type", detailNode);
				refid= genericUtility.getColumnValueFromNode("ref_id", detailNode);
				
				sql = "Insert into gst_data_hdr (TRAN_ID,TRAN_DATE,TRAN_ID__REF,SITE_CODE,PRD_CODE,REC_TYPE,TRAN_TYPE,CUST_CODE,CUST_NAME,SUBMISSION_TYPE,DOC_CHECKSUM,DOC_TYPE,DOC_NO,DOC_DATE,AMOUNT,REVERSE_CHRG,LR_NO,LR_DATE,REAS_CODE,REF_ID__INV,REF_DATE__INV,PROV_ASSMNT,ORDER_NO,ORDER_DATE,REMARKS,SUBMIT_STATUS,SUBMIT_DATE,ADD_USER,ADD_DATE,ADD_TERM,CHG_USER,CHG_DATE,CHG_TERM,TAX_REG_NO,RECO_STATUS,ECOM_REG_NO,REF_SER,GST_CODE,GST_TYPE,REF_ID) "
						+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranid); //TRAN_ID         NOT NULL CHAR(12)  
				pstmt.setTimestamp(2,getTimeStamp(trandate)); //TRAN_DATE    DATE
				pstmt.setString(3,tranidref); //TRAN_ID__REF             CHAR(12)      
				pstmt.setString(4,sitecode); //SITE_CODE                CHAR(5)       
				pstmt.setString(5,prdcode); //PRD_CODE                 CHAR(6)       
				pstmt.setString(6,rectype); //REC_TYPE                 CHAR(1)       
				pstmt.setString(7,trantype); //TRAN_TYPE                CHAR(2)       
				pstmt.setString(8,custcode); //CUST_CODE                CHAR(10)      
				pstmt.setString(9,custname); //CUST_NAME                VARCHAR2(90)  
				pstmt.setString(10,submissiontype); //SUBMISSION_TYPE          CHAR(1)       
				pstmt.setString(11,docchecksum); //DOC_CHECKSUM             VARCHAR2(100) 
				pstmt.setString(12,doctype); //DOC_TYPE                 CHAR(5)       
				pstmt.setString(13,docno); //DOC_NO                   VARCHAR2(50)  
				pstmt.setTimestamp(14,getTimeStamp(docdate)); //DOC_DATE                 DATE          
				pstmt.setDouble(15,getDouble(amount)); //AMOUNT                   NUMBER(15,2)  
				pstmt.setString(16,reversechrg); //REVERSE_CHRG             CHAR(1)       
				pstmt.setString(17,lrno); //LR_NO                    VARCHAR2(50)  
				pstmt.setTimestamp(18,getTimeStamp(lrdate)); //LR_DATE                  DATE          
				pstmt.setString(19,reascode); //REAS_CODE                VARCHAR2(50)  
				pstmt.setString(20,refidinv); //REF_ID__INV              VARCHAR2(50)  
				pstmt.setTimestamp(21,getTimeStamp(refdateinv)); //REF_DATE__INV            DATE          
				pstmt.setString(22,provassmnt); //PROV_ASSMNT              CHAR(1)       
				pstmt.setString(23,orderno); //ORDER_NO                 VARCHAR2(30)  
				pstmt.setTimestamp(24,getTimeStamp(orderdate)); //ORDER_DATE               DATE          
				pstmt.setString(25,remarks); //REMARKS                  VARCHAR2(100) 
				pstmt.setString(26,submitstatus); //SUBMIT_STATUS            CHAR(1)       
				pstmt.setTimestamp(27,getTimeStamp(submitdate)); //SUBMIT_DATE              DATE          
				pstmt.setString(28,adduser); //ADD_USER                 CHAR(10)      
				pstmt.setTimestamp(29,getTimeStamp(adddate)); //ADD_DATE                 DATE          
				pstmt.setString(30,addterm); //ADD_TERM                 VARCHAR2(15)  
				pstmt.setString(31,chguser); //CHG_USER                 CHAR(10)      
				pstmt.setTimestamp(32,new java.sql.Timestamp(System.currentTimeMillis())); //CHG_DATE                 DATE          
				pstmt.setString(33,chgterm); //CHG_TERM                 VARCHAR2(15)  
				pstmt.setString(34,taxregno); //TAX_REG_NO               VARCHAR2(15)  
				pstmt.setString(35,recostatus); //RECO_STATUS              VARCHAR2(1)   
				pstmt.setString(36,ecomregno); //ECOM_REG_NO              VARCHAR2(15)  
				pstmt.setString(37,refser); //REF_SER                  CHAR(6)       
				pstmt.setString(38,gstcode); //GST_CODE                 CHAR(2)       
				pstmt.setString(39,gsttype); //GST_TYPE                 CHAR(1)       
				pstmt.setString(40,refid); //REF_ID                   CHAR(10)

				pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close(); 
					pstmt = null;
				}
				retXmlString = retXmlString + "<tran_id>"+tranid+"</tran_id>";
			}
			retXmlString = retXmlString + "</root>";
			
			if(isErrorExist)
			{
				conn.rollback();
				retXmlString = errString;
			}
			else
			{
				conn.commit();	
			}
			
		}catch (Exception e) 
		{
			try 
			{
				conn.rollback();
			} catch (SQLException e1) 
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			
			if(isErrorExist)
			{
				try 
				{
					conn.rollback();
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				retXmlString = errString;
			}
			else
			{
				try 
				{
					conn.commit();
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}	
			}
			try 
			{
				conn.close();
			} catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("Return Xml String:"+retXmlString);
		return retXmlString;
	}
	
	
	@Override
	public String updateRecord(String objName,String tranXml, UserInfoBean userInfo) throws RemoteException, ITMException 
	{
		Connection conn = null;
		String sql = "";
		PreparedStatement pstmt = null;
		Document tranDoc = null;
		NodeList detailNodeList = null;
		String retXmlString = "<root>";
		String errString = "";
		boolean isErrorExist = false;
	
		String tranid = null,trantype = null,amount= null;
		
		try
		{	
			System.out.println("===================Inside GstrCustomTranEJB class========================");
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
			}
			tranDoc = genericUtility.parseString(tranXml);
			detailNodeList = tranDoc.getElementsByTagName("Detail1");
			
			for(int i = 0; i < detailNodeList.getLength() && !isErrorExist; i++)
			{
				Node detailNode = detailNodeList.item(i);

				tranid = null;trantype = null;amount= null;

				tranid = genericUtility.getColumnValueFromNode("tran_id", detailNode);
				trantype = genericUtility.getColumnValueFromNode("tran_type", detailNode);
				amount= genericUtility.getColumnValueFromNode("amount", detailNode);
								
				sql = "UPDATE GST_DATA_HDR SET AMOUNT = ? WHERE TRAN_ID = ? AND TRAN_TYPE = ?"; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1, getDouble(amount));
				pstmt.setString(2, tranid);
				pstmt.setString(3, trantype);

				int rowsUpdated = pstmt.executeUpdate();
				if(rowsUpdated == 0)
				{
					System.out.println("Record not found.......");
				}
				if(pstmt != null)
				{
					pstmt.close(); 
					pstmt = null;
				}
				retXmlString = retXmlString + "<tran_id>"+tranid+"</tran_id>";
			}
			retXmlString = retXmlString + "</root>";
			
			if(isErrorExist)
			{
				conn.rollback();
				retXmlString = errString;
			}
			else
			{
				conn.commit();	
			}
			
		}catch (Exception e) 
		{
			try 
			{
				conn.rollback();
			} catch (SQLException e1) 
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			
			if(isErrorExist)
			{
				try 
				{
					conn.rollback();
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				retXmlString = errString;
			}
			else
			{
				try 
				{
					conn.commit();
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}	
			}
			try 
			{
				conn.close();
			} catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("Return Xml String:"+retXmlString);
		return retXmlString;
	}
	
	private double getDouble(String amount) 
	{
		double result = 0.0;
		result = Double.parseDouble((amount==null||amount.equals("")) ? "0" : amount);
		return result;
	}
	@Override
	public String getRecords(String objName,String prdCode, UserInfoBean userInfo) throws RemoteException, ITMException 
	{
		Connection conn = null;
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String retXmlString = "<root>";
		
		try
		{	
			System.out.println("===================Inside GstrCustomTranEJB class========================");
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
			}
			
			sql = "select tran_type,tran_id,amount from gst_data_hdr where gst_type = 'L' and prd_code = ?";
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1, prdCode);
			rs = pstmt.executeQuery();
			System.out.println(rs.getFetchSize());
			while(rs.next())
			{
				retXmlString = retXmlString + "<detail>";
				retXmlString = retXmlString + "<tran_id>"+rs.getString("tran_id")+"</tran_id>";
				retXmlString = retXmlString + "<tran_type>"+rs.getString("tran_type")+"</tran_type>";
				retXmlString = retXmlString + "<amount>"+rs.getDouble("amount")+"</amount>";
				retXmlString = retXmlString + "</detail>";
			}
			retXmlString = retXmlString + "</root>";
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				conn.close();
			} catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("Return Xml String:"+retXmlString);
		return retXmlString;
	}
	
	private Timestamp getTimeStamp(String dateStr) throws ITMException, Exception 
	{
		String dbDateStr = "";
		if(dateStr != null && !dateStr.equals(""))
		{
			dbDateStr =	(new E12GenericUtility()).getValidDateTimeString(dateStr, (new E12GenericUtility()).getApplDateTimeFormat(), (new E12GenericUtility()).getDBDateTimeFormat());
			return java.sql.Timestamp.valueOf(dbDateStr);          
		}
		else
		{
			return null;
		}
	}
	public String generateTranId( String windowName, String siteCode, Connection conn )throws ITMException
	{
		System.out.println("windowName inside generateTranId =========>>"+windowName);
		System.out.println("siteCode inside generateTranId =========>>"+siteCode);
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Timestamp currDate = null;
		java.sql.Date effDate = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			String currDateStr = sdfAppl.format(currDate);

			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";

			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			xmlValues = xmlValues +        "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +        "<tran_date>" + currDateStr + "</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){}
		}
		return tranId;
	}
	
		
}
