package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class ZoneWiseQTQ extends ValidatorEJB implements ZoneWiseQTQLocal,ZoneWiseQTQRemote
{
	public ZoneWiseQTQ()
	{
	}

	@SuppressWarnings("unchecked")
	public JSONObject getDifAllIndiaQTQ(String loginCode,String dataSourceName,String fromDate,String toDate)throws RemoteException, ITMException
	{
		JSONObject rowDataZoneWiseQTQ = new JSONObject();
		JSONObject rowData            = new JSONObject();
		String sql                        = "";
		ResultSet rs                      = null;
		PreparedStatement pstmt           = null;
		Connection conn                   = null;
		ConnDriver connDriver             = new ConnDriver();
		int count                         = 0;
		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                  = null;
		
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
         	if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar   = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("frmDate inside in ZoneWise EJB Dashboard==" + fromDate+" toDate==="+toDate);				
			  }
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy",  "dd-MMM-yy");
			}
         	if(fromDate!=null && toDate!=null&& loginCode!=null)
			{					
			/*sql =    "  select   "  +
					 "  vw_sales_hier.ZONE,  "  +
					 "  a.month,  "  +
					 "  a.year,  "  +
					 "  a.monthname,  "  +
					 "  round(sum(a.daysinfield)/sum(a.availdaysinfield),2) *100 as  DAYINFIELD,  "  +
					 "  round(sum(A.DrMetCalls)/sum(a.daysinfield),2) as CALL_AVG,  "  +
					 "  round(sum(STPERCENTPROD)/ sum(salesd_count),2) as STPERCENTPROD,  "  +
					 "  round(sum(T1PERCENTPROD) / sum(salesd_count),2)as T1PERCENTPROD,  "  +
					 "  round(sum(STPERCENTDRMET)/ sum(salesd_count),2) as STPERCENTDRMET ,  "  +
					 "  ROUND(((B.daysinfield / B.availdaysinfield )*100),2)AS FLM_time  "  +
					 "  from   "  +
					 "   (  "  +
					 "  select   "  +
					 "  count(*) as salesd_count,  "  +
					 "  vqt.DrMetCalls,  "  +
					 "  VQT.sales_pers,  "  +
					 "  VQT.month,  "  +
					 "  VQT.year,  "  +
					 "  VQT.monthname,  "  +
					 "  VQT.daysinfield,  "  +
					 "  VQT.availdaysinfield,  "  +
					 "  sm.mt,  "  +
					 "  VQT.STPERCENTPROD,  "  +
					 "  VQT.T1PERCENTPROD,  "  +
					 "  VQT.STPERCENTDRMET  "  +
					 "  from VW_QTQ_TEAMWISE  VQT  "  +
					 "  left JOIN USERS ON USERS.CODE=VQT.SALES_PERS  "  +
					 "  left join (  "  +
					 "  SELECT   "  +
					 "  sales_pers,  "  +
					 "  count( distinct strg_code) as mt,  "  +
					 "  TO_CHAR(event_date,'mm') mm,  "  +
					 "  TO_CHAR(event_date,'YYYY') year  "  +
					 "  FROM strg_meet  "  +
					 "  where strg_meet.sales_pers in (Select  "  +
					 "  Emp_Code  "  +
					 "  From  "  +
					 "  Employee  "  +
					 "  Start With  "  +
					 "  Emp_Code =(select emp_code from users where code='"+loginCode+"')   "  +     //---pass user id 
					 "    "  +
					 "  Connect By Prior  "  +
					 "  Emp_Code = Report_To)  "  +
					 "  and strg_meet.locality_code<>'DUM'  "  +
					 "  and (strg_code <> '-NA-' or strg_code is not null)  "  +
					 "  group by sales_pers,  "  +
					 "    TO_CHAR(event_date,'mm'),  "  +
					 "    TO_CHAR(event_date,'YYYY')  "  +
					 "      "  +
					 "    ) sm   "  +
					 "    on VQT.sales_pers=sm.sales_pers and VQT.month=sm.mm and VQT.year=sm.year  "  +
					 "    left join sales_pers sp  on sp.sales_pers=VQT.sales_pers  "  +
					 "    left join sub_bu_master sbm on sbm.sub_bu_code=sp.sub_bu_code  "  +
					 "  where VQT.sales_pers in (Select  "  +
					 "  Emp_Code  "  +
					 "  From  "  +
					 "  Employee  "  +
					 "  Start With  "  +
					 "  Emp_Code =(select emp_code from users where code='"+loginCode+"')  "  +   
					 "    "  +
					 "  Connect By Prior  "  +
					 "  Emp_Code = Report_To)   "  +
					 //"  and VQT.year='2015'  "  +
					 "  and VQT.month >= to_char(to_date('"+fromDate+"') ,'MM')      "  +
					 "  and VQT.month <= to_char(to_date('"+toDate+"') ,'MM')       "  +
					 "  and VQT.year >= to_char(to_date('"+fromDate+"') ,'YYYY')  " +  
					 "  and VQT.year <= to_char(to_date('"+toDate+"') ,'YYYY')  " +
					 // "  and sbm.sub_bu_code='T2'  "  +
					 "  AND SP.sub_bu_code<>'OSTEO'  "  +
					 "  AND USERS.PROFILE_ID<>'FLM1'  "  +
					 "  group by   "  +
					 "  VQT.sales_pers,vqt.DrMetCalls,  "  +
					 "  VQT.month,  "  +
					 "  VQT.year,  "  +
					 "  VQT.monthname,  "  +
					 "  VQT.daysinfield,  "  +
					 "  VQT.availdaysinfield,  "  +
					 "  sm.mt,  "  +
					 "  VQT.STPERCENTPROD,  "  +
					 "  VQT.T1PERCENTPROD,  "  +
					 "  VQT.STPERCENTDRMET  "  +
					 "  )A left JOIN   "  +
					 "  (  "  +
					 "  select   "  +
					 "  sum(daysinfield) as daysinfield,  "  +
					 "  sum(availdaysinfield) as availdaysinfield,  "  +
					 "  month,  "  +
					 "  year   "  +
					 "  from VW_FLM_QTQ_TEAMWISE VQT  "  +
					 "  left join  sales_pers sp  on sp.sales_pers=VQT.sales_pers  "  +
					 "  LEFT join sub_bu_master sbm on sbm.sub_bu_code=sp.sub_bu_code  "  +
					 "  left JOIN EMPLOYEE E ON VQT.SALES_PERS=E.EMP_CODE  "  +
					 "  left JOIN USERS U ON U.CODE=E.EMP_CODE  "  +
					 "  where VQT.sales_pers in (  "  +
					 "  Select  "  +
					 "  EMPLOYEE.Emp_Code  "  +
					 "  From  "  +
					 "  Employee  "  +
					 "  Start With  "  +
					 "  EMPLOYEE.Emp_Code =(select emp_code from users where code='"+loginCode+"')      "  +     
					 "  Connect By Prior  "  +
					 "  EMPLOYEE.Emp_Code = EMPLOYEE.Report_To  "  +
					 "  )   "  +
					// "  and VQT.year='2015'  "  +
					 "  and VQT.month >= to_char(to_date('"+fromDate+"') ,'MM')  "  +
					 "  and VQT.month <= to_char(to_date('"+toDate+"') ,'MM')  "  +
					 "  and VQT.year >= to_char(to_date('"+fromDate+"') ,'YYYY')  " +  
					 "  and VQT.year <= to_char(to_date('"+toDate+"') ,'YYYY')  " +
					// "  and sp.sub_bu_code='T2'  "  +
					 "  AND U.PROFILE_ID='FLM1'  "  +
					 "  group by  month,  "  +
					 "  year  "  +
					 "  )b ON A.MONTH=b.month AND a.year=B.YEAR  "  +
					 "  left join vw_sales_hier on vw_sales_hier.repcode=A.sales_pers  "  +
					 "  group by  "  +
					 "  a.month,vw_sales_hier.ZONE,  "  +
					 "  a.year,  "  +
					 "  a.monthname,  "  +
					 "  B.daysinfield,  "  +
					 "  B.availdaysinfield   "  +
					 "  order by month  "  ;*/
         		
         		sql =    "  select   "  +
   					 "  vw_sales_hier.ZONE,  "  +
   					 "  a.month,  "  +
   					 "  a.year,  "  +
   					 "  a.monthname,  "  +
   					 "  round(sum(a.daysinfield)/sum(a.availdaysinfield),2) *100 as  DAYINFIELD,  "  +
   					 "  round(sum(A.DrMetCalls)/sum(a.daysinfield),2) as CALL_AVG,  "  +
   					 "  round(sum(STPERCENTPROD)/ sum(salesd_count),2) as STPERCENTPROD,  "  +
   					 "  round(sum(T1PERCENTPROD) / sum(salesd_count),2)as T1PERCENTPROD,  "  +
   					 "  round(sum(STPERCENTDRMET)/ sum(salesd_count),2) as STPERCENTDRMET ,  "  +
   					 "  ROUND(((B.daysinfield / B.availdaysinfield )*100),2)AS FLM_time  "  +
   					 "  from   "  +
   					 "   (  "  +
   					 "  select   "  +
   					 "  count(*) as salesd_count,  "  +
   					 "  vqt.DrMetCalls,  "  +
   					 "  VQT.sales_pers,  "  +
   					 "  VQT.month,  "  +
   					 "  VQT.year,  "  +
   					 "  VQT.monthname,  "  +
   					 "  VQT.daysinfield,  "  +
   					 "  VQT.availdaysinfield,  "  +
   					 "  sm.mt,  "  +
   					 "  VQT.STPERCENTPROD,  "  +
   					 "  VQT.T1PERCENTPROD,  "  +
   					 "  VQT.STPERCENTDRMET  "  +
   					 "  from VW_QTQ_TEAMWISE  VQT  "  +
   					 "  left JOIN USERS ON USERS.CODE=VQT.SALES_PERS  "  +
   					 "  left join (  "  +
   					 "  SELECT   "  +
   					 "  sales_pers,  "  +
   					 "  count( distinct strg_code) as mt,  "  +
   					 "  TO_CHAR(event_date,'mm') mm,  "  +
   					 "  TO_CHAR(event_date,'YYYY') year  "  +
   					 "  FROM strg_meet  "  +
   					 "  where strg_meet.sales_pers in (Select  "  +
   					 "  Emp_Code  "  +
   					 "  From  "  +
   					 "  Employee  "  +
   					 "  Start With  "  +
   					 "  Emp_Code =(select emp_code from users where code='"+loginCode+"')   "  +     //---pass user id 
   					 "    "  +
   					 "  Connect By Prior  "  +
   					 "  Emp_Code = Report_To)  "  +
   					 "  and strg_meet.locality_code<>'DUM'  "  +
   					 "  and (strg_code <> '-NA-' or strg_code is not null)  "  +
   					 "  group by sales_pers,  "  +
   					 "    TO_CHAR(event_date,'mm'),  "  +
   					 "    TO_CHAR(event_date,'YYYY')  "  +
   					 "      "  +
   					 "    ) sm   "  +
   					 "    on VQT.sales_pers=sm.sales_pers and VQT.month=sm.mm and VQT.year=sm.year  "  +
   					 "    left join sales_pers sp  on sp.sales_pers=VQT.sales_pers  "  +
   					 "    left join sub_bu_master sbm on sbm.sub_bu_code=sp.sub_bu_code  "  +
   					 "  where VQT.sales_pers in (Select  "  +
   					 "  Emp_Code  "  +
   					 "  From  "  +
   					 "  Employee  "  +
   					 "  Start With  "  +
   					 "  Emp_Code =(select emp_code from users where code='"+loginCode+"')  "  +   
   					 "    "  +
   					 "  Connect By Prior  "  +
   					 "  Emp_Code = Report_To)   "  +
   					 //"  and VQT.year='2015'  "  +
   					 "  and VQT.month >= to_char(to_date('"+fromDate+"') ,'MM')      "  +
   					 "  and VQT.month <= to_char(to_date('"+toDate+"') ,'MM')       "  +
   					 "  and VQT.year >= to_char(to_date('"+fromDate+"') ,'YYYY')  " +  
   					 "  and VQT.year <= to_char(to_date('"+toDate+"') ,'YYYY')  " +
   					 // "  and sbm.sub_bu_code='T2'  "  +
   					 "  AND SP.sub_bu_code<>'OSTEO'  "  +
   					 "  AND USERS.PROFILE_ID<>'FLM1'  "  +
   					 "  group by   "  +
   					 "  VQT.sales_pers,vqt.DrMetCalls,  "  +
   					 "  VQT.month,  "  +
   					 "  VQT.year,  "  +
   					 "  VQT.monthname,  "  +
   					 "  VQT.daysinfield,  "  +
   					 "  VQT.availdaysinfield,  "  +
   					 "  sm.mt,  "  +
   					 "  VQT.STPERCENTPROD,  "  +
   					 "  VQT.T1PERCENTPROD,  "  +
   					 "  VQT.STPERCENTDRMET  "  +
   					 "  )A " +
   					 " LEFT JOIN vw_sales_hier " +
   					 "ON vw_sales_hier.repcode=A.sales_pers " +
   					 "LEFT JOIN (SELECT VSH.ZONE, SUM(daysinfield) AS daysinfield, " +
   					 "SUM(availdaysinfield) AS availdaysinfield, MONTH, YEAR " +
   					 "FROM VW_FLM_QTQ_TEAMWISE VQT LEFT JOIN sales_pers sp " +
   					 "ON sp.sales_pers=VQT.sales_pers LEFT JOIN sub_bu_master sbm " +
   					 "ON sbm.sub_bu_code=sp.sub_bu_code LEFT JOIN EMPLOYEE E " +
   					 "ON VQT.SALES_PERS=E.EMP_CODE LEFT JOIN VW_SALES_HIER VSH " +
   					 "ON VSH.ABMCODE=SP.SALES_PERS LEFT JOIN USERS U ON U.CODE  =E.EMP_CODE " +
   					 "WHERE VQT.sales_pers IN (SELECT EMPLOYEE.Emp_Code FROM Employee START WITH " +
   					 "EMPLOYEE.Emp_Code = (SELECT emp_code FROM users WHERE code='"+loginCode+"' ) " +
   					 "CONNECT BY Prior EMPLOYEE.Emp_Code = EMPLOYEE.Report_To ) " +
   					 "AND VQT.month  >= TO_CHAR(to_date('"+fromDate+"') ,'MM') " +
   					 "AND VQT.month  <= TO_CHAR(to_date('"+toDate+"') ,'MM') " +
   					 "AND VQT.year   >= TO_CHAR(to_date('"+fromDate+"') ,'YYYY') " +
   					 "AND VQT.year   <= TO_CHAR(to_date('"+toDate+"') ,'YYYY') " +
   					 "AND U.PROFILE_ID='FLM1' GROUP BY VSH.ZONE, MONTH, YEAR )b " +
   					 "ON A.MONTH=b.month AND a.year     =B.YEAR AND b.zone     =vw_sales_hier.zone " +
   					 "GROUP BY a.month, vw_sales_hier.ZONE, a.year, a.monthname, B.daysinfield, B.availdaysinfield ORDER BY MONTH ";
			
					
	
	    pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
	    rs    = pstmt.executeQuery();
	    String  monthNameString = getMonthNameString(rs);
		rs.beforeFirst();
		String  daysInFeild = getJSONForField("DAYINFIELD",rs,monthNameString);
		rs.beforeFirst();		
		String  callAverage = getJSONForField("CALL_AVG",rs,monthNameString);
		rs.beforeFirst();		
		String  docVisitedAtPf = getJSONForField("STPERCENTPROD",rs,monthNameString);
		rs.beforeFirst();		
		String  docVisitedInT1 = getJSONForField("T1PERCENTPROD",rs,monthNameString);
		rs.beforeFirst();		
		String  superTarget = getJSONForField("STPERCENTDRMET",rs,monthNameString);
		rs.beforeFirst();		
		String  flmCoaching = getJSONForField("FLM_TIME",rs,monthNameString);
		rs.beforeFirst();		
		rowData.put("diffield", daysInFeild);	
		rowData.put("callavg", callAverage);
		rowData.put("docvisitatpf", docVisitedAtPf);
		rowData.put("docvisitint1", docVisitedInT1);
		rowData.put("supertarget", superTarget);
		rowData.put("flm", flmCoaching);
		rowData.put("exporttoExcel", CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png");
		
		
		rowDataZoneWiseQTQ.put(count, rowData);
		count++;		
	}//closed if block
		
         	rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getTask():" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataZoneWiseQTQ;
	}

	@SuppressWarnings("unchecked")
	private String  getJSONForField(String columnName, ResultSet rs, String monthNameString) 	{
		
		
		LinkedHashMap<String, StringBuffer> zonewiseDataMap = null;
		LinkedHashMap<String, Double> monthDataMap = null;
		LinkedHashMap<String, Double> ytdDataMap = null;
		String zoneName = "",monthName = "",ytdYear = "",month = "",columnValue = "";
		StringBuffer zoneValueBuffer = null,finalBuffer = null,monthAvgValBuffer = null;
		//DecimalFormat df =new DecimalFormat("#.##");
		DecimalFormat df =new DecimalFormat("#.#");
		
		double monthAvgValue =0.0D, ytdValue = 0.0D;
		
		
		try 
		{
			zonewiseDataMap = new LinkedHashMap<String, StringBuffer>();
			monthDataMap    = new LinkedHashMap<String, Double>();
			ytdDataMap    = new LinkedHashMap<String, Double>();
			while(rs.next())
			{
				columnValue = checkDouble(rs.getString(columnName));				
				zoneName = checkNull(rs.getString("ZONE"));
				ytdYear =rs.getString("YEAR").substring(2);
				month = rs.getString("MONTHNAME");
				monthName = month+" - "+ytdYear;
				System.out.println("columnValue"+columnValue);
				System.out.println("zoneName"+zoneName);
				
				if (ytdDataMap.containsKey(zoneName)) 
				{
					ytdValue = ytdDataMap.get(zoneName);
					ytdValue = ytdValue + Double.parseDouble(columnValue); 
					ytdDataMap.put(zoneName, ytdValue);
				}
				else 
				{
					ytdDataMap.put(zoneName, Double.parseDouble(columnValue)); 
				}	
				
				if (monthDataMap.containsKey(monthName)) 
				{
					monthAvgValue = monthDataMap.get(monthName);
					monthAvgValue = monthAvgValue + Double.parseDouble(columnValue); 
					monthDataMap.put(monthName, monthAvgValue);
				}
				else 
				{
					monthDataMap.put(monthName, Double.parseDouble(columnValue)); 
				}
				
				if (zonewiseDataMap.containsKey(zoneName)) 
				{
					zoneValueBuffer = zonewiseDataMap.get(zoneName);
					//zoneValueBuffer.append("<td>"+columnValue+"</td>");
					zoneValueBuffer.append(getColValWithImg(columnName,columnValue));
					//monthBuffer.append("<td class='cardHtmlTableHeaderAlignLft' width='5%'>"+monthName+"</td>");
					zonewiseDataMap.put(zoneName, zoneValueBuffer);
				}
				else 
				{
					zoneValueBuffer = new StringBuffer();
					//monthBuffer = new StringBuffer();
					zoneValueBuffer.append("<td class='cardHtmlTableHeaderAlignLft' width='10%'>"+zoneName+"</td>"+getColValWithImg(columnName,columnValue));
					//monthBuffer.append("<td class='cardHtmlTableHeaderAlignLft' width='5%'>"+monthName+"</td>");
					zonewiseDataMap.put(zoneName, zoneValueBuffer);
				}
				finalBuffer = new StringBuffer();
				finalBuffer.append("<tr><td class='cardHtmlTableHeaderAlignLft' width='10%'>ZONES</td>"+monthNameString+" <td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"YTD "+" - "+ytdYear+"</td></tr>");
				
				for (String key : zonewiseDataMap.keySet()) 
				    {
					Double ytdData = (ytdDataMap.get(key))/monthDataMap.size();
					finalBuffer.append("<tr>"+zonewiseDataMap.get(key).toString()+getAllIndiaImg(ytdData,columnName)+"</tr>");
					 
				    }
				
				
			}
			monthAvgValBuffer = new StringBuffer();
			for (String key : monthDataMap.keySet()) 
		    {
				System.out.println("Size of map=="+zonewiseDataMap.size()+"monthDataMap.get(key)=="+monthDataMap.get(key)+"monthDataMap=="+monthDataMap);
				Double monthAvgValue1=(monthDataMap.get(key))/zonewiseDataMap.size();
				monthAvgValBuffer.append(getAllIndiaImg(monthAvgValue1,columnName));

				
		    }
			double allIndiaSum = 0.0;
			for (String key : ytdDataMap.keySet()) 
		    {
				double ytdsum=0.0;
				ytdsum = Double.parseDouble(df.format((ytdDataMap.get(key))/monthDataMap.size()));
				allIndiaSum = allIndiaSum + ytdsum ;
		    }
			Double ytdData = allIndiaSum/zonewiseDataMap.size();
			finalBuffer.append("<tr style='background-color: #EAECEE;'><td class='cardHtmlTableHeaderAlignLft' width='10%' background-color='antiquewhite'>ALL INDIA</td>"+monthAvgValBuffer.toString()+getAllIndiaImg(ytdData,columnName)+"</tr>");
			
		} 
		catch (SQLException e) 
		{
			e.printStackTrace();
		}
		
		return finalBuffer.toString();
	}
	
	private String getAllIndiaImg(Double monthAvg, String columnName) {
		
		StringBuffer allIndiaBuffer = new StringBuffer();
		DecimalFormat df1 =new DecimalFormat("#.0");
		String average="";
		if(monthAvg>0)
		{
			if(monthAvg>1)
			{
				average=df1.format(monthAvg);
			}
			else
			{
				average = "0"+df1.format(monthAvg);
			}
		}
		else
		{
			average=monthAvg.toString();
		}
		
		if("DAYINFIELD".equalsIgnoreCase(columnName))
		{
			if(monthAvg>=90)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<90 && monthAvg>=80)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<80)	
			 {
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if("CALL_AVG".equalsIgnoreCase(columnName))
		{
			if(monthAvg>=10)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<10 && monthAvg>=8)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<8)	
			 {
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if("STPERCENTPROD".equalsIgnoreCase(columnName))
		{
			if(monthAvg>=85)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<85 && monthAvg>=65)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<65)	
			 {
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if("T1PERCENTPROD".equalsIgnoreCase(columnName))
		{
			if(monthAvg>=80)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<80 && monthAvg>=60)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<60)	
			 {
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if("STPERCENTDRMET".equalsIgnoreCase(columnName))
		{
			if(monthAvg>=90)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<90 && monthAvg>=80)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<80)	
			 {
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if("FLM_TIME".equalsIgnoreCase(columnName))
		{
			if(monthAvg>=70)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<70 && monthAvg>=60)
			{
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			}
			else if(monthAvg<60)	
			 {
				allIndiaBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		return allIndiaBuffer.toString();
	}

	private String getColValWithImg(String columnName, String columnValue) {
		
		StringBuffer colValWithImgBuffer  = new StringBuffer();
		double colValue  = Double.parseDouble(columnValue);
		
		DecimalFormat df1 =new DecimalFormat("#.0");
		String average="";
		if(colValue>0)
		{
			if(colValue>1)
			{
				average=df1.format(colValue);
			}
			else
			{
				average = "0"+df1.format(colValue);
			}
		}
		else
		{
			average=colValue+"";
		}
		
		if ("DAYINFIELD".equalsIgnoreCase(columnName)) {
			if(colValue>=90)
		     {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
		     }
			else if(colValue<90 && colValue>=80)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			 }
			else if(colValue<80)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if ("CALL_AVG".equalsIgnoreCase(columnName)) {
			if(colValue >=10)
		     {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
		     }
			else if(colValue<10 && colValue>=8)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			 }
			else if(colValue<8)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if ("STPERCENTPROD".equalsIgnoreCase(columnName)) {
			if(colValue >=85)
		     {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
		     }
			else if(colValue<85 && colValue>=65)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			 }
			else if(colValue<65)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if ("T1PERCENTPROD".equalsIgnoreCase(columnName)) {
			if(colValue >=80)
		     {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
		     }
			else if(colValue<80 && colValue>=60)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			 }
			else if(colValue<60)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		else if ("STPERCENTDRMET".equalsIgnoreCase(columnName)) {
			if(colValue >=90)
		     {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
		     }
			else if(colValue<90 && colValue>=80)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			 }
			else if(colValue<80)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		
		else if ("FLM_TIME".equalsIgnoreCase(columnName)) {
			if(colValue >=70)
		     {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/>"+" "+average+"</td>");
		     }
			else if(colValue<70 && colValue>=60)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/>"+" "+average+"</td>");
			 }
			else if(colValue<60)	
			 {
				colValWithImgBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='5%'>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/>"+" "+average+"</td>");
			 }
		}
		return colValWithImgBuffer.toString();
	}

	
    private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}
	private String checkDouble(String str)
	{
	if (str == null)
	{
	return "0";
	} else
	{
	return str;
	}
	
	}	
	
	private String getMonthNameString(ResultSet rs)
	{
		LinkedHashSet<String> monthNameSet = new LinkedHashSet<String>();
		String ytdYear="", month="", monthName="";
		StringBuffer monthBuffer = new StringBuffer();
		try
		{
			while(rs.next())
			{
				ytdYear =rs.getString("YEAR").substring(2);
				month = rs.getString("MONTHNAME");
				monthName = month+" - "+ytdYear;
				monthNameSet.add("<td class='cardHtmlTableHeaderAlignLft' width='5%'>"+monthName+"</td>");
				
			}
			System.out.println("monthNameSet: "+monthNameSet);
			for (Iterator<String> iterator = monthNameSet.iterator(); iterator.hasNext();) 
			{
				String monthNameStr = (String) iterator.next();
				monthBuffer.append(monthNameStr);
				
			}
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
		}

		return monthBuffer.toString();
	}

}
