<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<script type="text/javascript" src="/ibase/webitm/js/Ammend.js"></script>
<link rel="stylesheet" href="/ibase/webitm/css/DD/default.css" type="text/css" />
<link id="userThemeLink" type="text/css" rel="stylesheet" href=""/>

<body onload="setUserTheme()">

	<form name="Wizard_SuppDetails">

	<table class="tableClass" id="Details" border="0" cellspacing="1" cellpadding="1">
	<thead class="table-head">
	
		<tr>
			<th class="thClass" nowrap="true" width="5%">
				
			</th>
			<th class="thClass" nowrap="true" valign="bottom" width="20%">
				<strong>Code</strong>
			</th>
			<th class="thClass" nowrap="true" valign="bottom" width="75%">
				<strong id="Status">Description</strong>
			</th>	
		</tr>
		</thead>
		<tbody class="table-body"> 
		<xsl:for-each select="//supp_code">
			<xsl:variable name="fieldId"><xsl:value-of select="fieldId"/></xsl:variable>
			<xsl:variable name="fieldValue"><xsl:value-of select="fieldValue"/></xsl:variable>
			<xsl:variable name="otherField"><xsl:value-of select="otherField"/></xsl:variable>
		
			<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			
			<tr id="{normalize-space($dbID)}" onclick="rowChecked(this.id)">
				<td>
					<input type="checkbox" name="selectbox" value="false" id="DetailITCode.{normalize-space($dbID)}.selectbox" onClick="checkone(this.id)"/>
				</td>
				<td>
					<xsl:value-of select="fieldId"/>
					<input type="hidden" name="Detail3.{normalize-space($dbID)}.fieldId" id="DetailITCode.{normalize-space($dbID)}.fieldId" 
						value="{normalize-space($fieldId)}" />
				</td>
				<td>
					<xsl:value-of select="fieldValue"/>
					<input type="hidden" name="Detail3.{normalize-space($dbID)}.fieldValue" id="DetailITCode.{normalize-space($dbID)}.fieldValue" 
						value="{normalize-space($fieldValue)}" />
				</td>			
			</tr>
		</xsl:for-each>
		
</tbody>		
</table>

</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>

