/**
 *  PURPOSE  : post save for Item Attribute Values master
 *  AUTHOR   : Samadhan On 25/05/2015  
 *  Obj_name : itm_attrib_val  
 *  Request Id:  D15BKAT003
 */
package ibase.webitm.ejb.wms;

import ibase.utility.CommonConstants;
import ibase.webitm.bean.wms.Attribute;
import ibase.webitm.ejb.*;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;



@javax.ejb.Stateless
public class ItmAttribValPos extends ValidatorEJB implements ItmAttribValPosLocal, PhyItemVerifyPosRemote
{
	String apiAttribUrl="";
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String domString, String tranId,String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		String errString = "";
		String siteCode = "";

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		int childNodeListLength = 0;
		Document dom = null;
		PreparedStatement pstmt = null;		
		ResultSet rs = null;		
		String empCode = "",loginCode= "";
		CommonWmsUtil wmsUtil = new CommonWmsUtil();

		try
		{
			if(editFlag.equalsIgnoreCase("A"))
			{
				CommonConstants.setIBASEHOME();	
				setDDSalesConfig();

				E12GenericUtility genericUtility = new E12GenericUtility();
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
				System.out.println("STRING{"+domString+"}");
				dom = genericUtility.parseString(domString); 
				siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
				System.out.println("********* login site code ["+siteCode+"]");
				loginCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
				System.out.println("********* login code ["+loginCode+"]");
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength= childNodeList.getLength();

				String attribCode="",attribId="",descr="",shDescr="",activeYN="",sortOrder="",udfStr1="",udfStr2="",udfStr3="",
				udfStr4="",udfStr5="",itemAtrDescr="",shortDescr="";

				for ( int i = 0; i < childNodeListLength; i++ )
				{
					Node childNode = childNodeList.item(i);
					String nodeName = childNode.getNodeName();

					if (nodeName.equalsIgnoreCase("attrib_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							attribCode = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					if (nodeName.equalsIgnoreCase("attrib_id"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							attribId = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					if (nodeName.equalsIgnoreCase("descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							descr = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					//Change by Jagruti on 24/12/2015 [Start]
					if (nodeName.equalsIgnoreCase("sh_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							shortDescr = checkNull(childNode.getFirstChild().getNodeValue());
						}
					}
					//Change by Jagruti on 24/12/2015 [End]
				}

				Attribute objAttrib = new Attribute();
				//Changed by wasim on 14-08-2015 to set apiKey for magento [START]
				String apiKey = wmsUtil.getDDSalesConfig("API_KEY");
				objAttrib.setApiKey(apiKey);
				//Changed by wasim on 14-08-2015 to set apiKey for magento [START]

				//Changed by samadhan start for integrate SIZE attribute only Start
				/*
        		if(attribCode.equalsIgnoreCase("S001") || attribCode.equalsIgnoreCase("S002") || attribCode.equalsIgnoreCase("S003"))
        		{
        			objAttrib.setAttrName("SIZE");
        		}
        		else
        		{
        			objAttrib.setAttrName(attribCode);
        		}
				 */
				objAttrib.setAttrName(attribCode);
				System.out.println("attribCode" +attribCode);
				//Changed by samadhan start for integrate SIZE attribute only End
				/*if(attribCode.equalsIgnoreCase("SIZE"))
        		{
        			objAttrib.setAttrValue(attribId);
        		}
        		else
        		{
        			objAttrib.setAttrValue(descr);
        		}*/

				//Change by Jagruti on 25/12/2015 for SIZE[Start] 
				//objAttrib.setAttrValue(descr);
				if(attribCode.equalsIgnoreCase("SIZE"))
				{
					objAttrib.setAttrValue(attribId);
					objAttrib.setAttrLabels("1:UK "+shortDescr);
					System.out.println("shortDescr in obj" +shortDescr);
					System.out.println("attribute code in obj" +attribId);
				}
				else
				{
					objAttrib.setAttrValue(descr);
					System.out.println("descr in obj" +descr);
				}
				//Change by Jagruti on 25/12/2015 for SIZE[End] 

				int apiAttribCode = 0;
				String sql="";
				int attribCnt = 0;

				sql = "select count(*) from itm_attrib_val where attrib_id = ? and attrib_code='SIZE_TYPE'  ";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1, attribCode);
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					attribCnt = rs.getInt(1);
				}
				pstmt.close();
				rs.close();
				if(attribCnt>0)
				{
					sql = "select udf__str1 from itm_attrib_val where attrib_id = ? and attrib_code = ?  ";
					pstmt= conn.prepareStatement(sql);
					pstmt.setString(1, attribId);
					pstmt.setString(2, "SIZE");
					rs=pstmt.executeQuery();
					if(rs.next())
					{
						apiAttribCode = rs.getInt(1);
					}
				}
				else
				{
					apiAttribCode = wmsUtil.CallAttribute(objAttrib, apiAttribUrl);
				}


				updateAttribUdfStr(apiAttribCode,attribCode,attribId,conn);
			}		
		}
		catch(Exception e)
		{
			try
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{				
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}	

	private void updateAttribUdfStr(int apiAttribCode, String attribCode,String attribId,Connection conn) 
	{
		String sql = "";
		PreparedStatement pstmt = null;
		try
		{
			sql = "update itm_attrib_val set udf__str1 = ? where attrib_code = ? and attrib_id = ? ";
			pstmt = conn.prepareStatement(sql); 
			pstmt.setString(1, String.valueOf(apiAttribCode));
			pstmt.setString(2, attribCode);
			pstmt.setString(3, attribId);
			pstmt.executeUpdate();
			pstmt.close();
			pstmt=null;
		}
		catch(Exception e)
		{

		}
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	private void setDDSalesConfig()
	{
		CommonConstants objCommon =new CommonConstants();
		E12GenericUtility genericUtility=new E12GenericUtility();
		String fileName = null,xmlString = "",xmlFileName = "";
		Document dom=null;
		String sCurrentLine = "";
		String xmlFile="DDSalesConfig";
		System.out.println("  in setDDSalesConfig -------------------------");
		System.out.println("CommonConstants.APPLICATION_CONTEXT-->>["+CommonConstants.APPLICATION_CONTEXT+"]");   
		System.out.println("CommonConstants.JBOSSHOME-->>["+CommonConstants.JBOSSHOME+"]");   
		if(CommonConstants.APPLICATION_CONTEXT != null)
		{
			xmlFileName = CommonConstants.APPLICATION_CONTEXT + "setting" + File.separator + "DDSalesConfig.xml";
		}
		else
		{
			xmlFileName = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator +"setting" + File.separator +"DDSalesConfig.xml";
		}
		StringBuilder sb = new StringBuilder();
		System.out.println("xmlFileName-->>["+xmlFileName+"]");          
		try 
		{ 
			BufferedReader br = new BufferedReader(new FileReader(xmlFileName));
			while (( sCurrentLine = br.readLine()) != null)
			{
				sb.append(sCurrentLine);
			}
			xmlString =sb.toString();
			System.out.println("DDSalesConfig xmlString---->>["+xmlString+"]");            	 
			dom = genericUtility.parseString(xmlString);                 
			if(dom != null)
			{                	
				this.apiAttribUrl = genericUtility.getColumnValue("ATTRIB_OPTION_API_URL",dom);               	 
			}                 
		}
		catch(Exception e)
		{
			e.printStackTrace();
		} 
	}
}



