--//Voucher
alter table voucher add GP_SER CHAR(6); 
alter table voucher add GP_NO VARCHAR2(15)
alter table voucher add GP_DATE DATE;

--//misc voucher
alter table misc_voucher add GP_SER CHAR(6);
alter table misc_voucher add GP_NO VARCHAR2(15);
alter table misc_voucher add GP_DATE DATE;

--drcr Pay(payable dr cr)
alter table drcr_pay add GP_SER CHAR(6);
alter table drcr_pay add GP_NO VARCHAR2(15);
alter table drcr_pay add GP_DATE DATE;

-- table to store calculate tax against advance receipt and adjustments
create table adv_rcp_tax (
tran_id char(10) not null,  -- unique transaction id
tran_date date not null,    -- transaction date
site_code char(5) not null, -- site code of transaction
confirmed char(1),          -- Confirmd flag of transaction, Y  - Yes, N  - No
conf_date date,             -- date of confirmation
add_date  date,             
add_user  char(10),
add_term  varchar2(15),
chg_date  date,
chg_user  char(10),
chg_term  varchar2(15)
) tablespace itm_fin_d2;

alter table adv_rcp_tax add constraint adv_rcp_tax_x primary key (tran_id) 
using index tablespace itm_fin_i1;

-- table to store details of advance receipt or adjustment
create table adv_rcp_tax_det (
tran_id char(10) not null,
line_no number(5) not null,
cust_code char(10) not null,-- customer code from whom advance received
ref_type char(1),       -- reference type,  1 - Advance, 2 - Adjustment
ref_ser char(6),        -- Reference series of the actual tranaction
ref_id char(10),        -- Reference id of the transaction
ref_date date,          -- date of transaction
amount number(14,3),     -- amount of advance or adjusted amount
ref_id__adv char(10),   -- Reference id of advance in case of adjustment
date_adv date,          -- Date of advance in case of adjustment
tax_class char(5),      -- Tax class applicable
tax_chap char(10),      -- Tax chapter applicable
tax_env  char(10)       -- Tax environment applicable
) tablespace itm_fin_d2;

alter table adv_rcp_tax_det add constraint adv_rcp_tax_det_x primary key (tran_id,line_no) 
using index tablespace itm_fin_i1;

alter table adv_rcp_tax_det add constraint fk_adv_rcp_tax_det foreign key(tran_id) references adv_rcp_tax (tran_id) on delete cascade;

-- Account distribution for internal use
create table adv_rcp_tax_acct (
tran_id char(10) not null,
line_no number(5) not null,
acct_code char(10) not null,
cctr_code char(4) not null,
amount number(14,3) not null
) tablespace itm_fin_d2;

alter table adv_rcp_tax_acct add constraint adv_rcp_tax_acct_x primary key (tran_id,line_no) 
using index tablespace itm_fin_i1;
alter table adv_rcp_tax_acct add constraint fk_adv_rcp_tax_acct foreign key(tran_id) references adv_rcp_tax (tran_id) on delete cascade;

