/********************************************************
	Title : EcollectionConf[F14ISUN014]
	Date  : 17/02/15
	Developer: Chandrashekar

 ********************************************************/
package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;


import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.*;
import java.sql.*;
import java.text.SimpleDateFormat;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless;
import java.util.Calendar;

@Stateless
public class EcollectionConf extends ActionHandlerEJB implements EcollectionConfLocal, EcollectionConfRemote
{
	public String confirm(String tranId, String xtraParams, String forcedFlag)throws RemoteException, ITMException
	{
		System.out.println(">>>>>>>>>>>>>>>>>>EcollectionConf confirm called>>>>>>>>>>>>>>>>>>>");
		String confirmed = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
	    String errString = null;
		ResultSet rs = null;
		String loginEmpCode="",status="",refNo="";
	    int cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		Timestamp sysDate = null;
		E12GenericUtility genericUtility= new  E12GenericUtility();

		try 
		{
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			if (tranId != null && tranId.trim().length() > 0) 
			{
				System.out.println("@@@@@tranId"+tranId+"]");

				sql = "	select confirmed,status,ref_no from  receipt_form where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{

					confirmed = rs.getString("confirmed");
					status = rs.getString("status");
					refNo = rs.getString("ref_no");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if ("S".equalsIgnoreCase(status))
				{
					if (refNo == null || refNo.trim().length() == 0)
					{
						errString = itmDBAccessLocal.getErrorString("", "VTNULREFNO", "");
					} else
					{
						if ("Y".equalsIgnoreCase(confirmed))
						{
							errString = itmDBAccessLocal.getErrorString("", "VTINVCONF2", "");

						} else
						{
							loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
							Calendar currentDate = Calendar.getInstance();
							SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String sysDateStr = sdf.format(currentDate.getTime());
							System.out.println("Now the date is :=>  " + sysDateStr);
							sysDate = Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");

							System.out.println(">>>>>>>>sysDate:" + sysDate);
							System.out.println(">>>>>>>>loginEmpCode:" + loginEmpCode);

							sql = " update receipt_form set confirmed = 'Y',conf_date = ?, emp_code__aprv = ? ,status= 'C' where tran_id = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setTimestamp(1, sysDate);
							pstmt.setString(2, loginEmpCode);
							pstmt.setString(3, tranId);
							cnt = pstmt.executeUpdate();
							pstmt.close();
							pstmt = null;
							if (cnt > 0)
							{
								errString = itmDBAccessLocal.getErrorString("", "VCNFSUC1", "");
								conn.commit();
							} else
							{
								errString = itmDBAccessLocal.getErrorString("", "VTNCONFT", "");
							}

						}
					}
				} else
				{
					errString = itmDBAccessLocal.getErrorString("", "VTNSUBCON", "");
				}
			}


			// end if errstrng
		} catch (Exception e) 
		{
			if(conn!=null)
			{
				try {
					conn.rollback();
				} catch (SQLException ex) {

					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{		
			try
			{
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;

				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}



		return errString;
	
	}
	public String submit(String tranId, String xtraParams, String forcedFlag)throws RemoteException, ITMException
	{
		System.out.println(">>>>>>>>>>>>>>>>>>EcollectionConf submit called>>>>>>>>>>>>>>>>>>>");
		String sql = "",status="",confirmed="";
		Connection conn = null;
		PreparedStatement pstmt = null;
		String errString = null;
		ResultSet rs = null;
		int cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try
		{

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			if (tranId != null && tranId.trim().length() > 0)
			{
				System.out.println("tranId>>>["+tranId+"]");
				
				sql = "	select status,confirmed from  receipt_form where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{
					status = rs.getString("status");
					confirmed = rs.getString("confirmed");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if ("S".equalsIgnoreCase(status))
				{
					errString =  itmDBAccessLocal.getErrorString("","VTINVSUB2","");

				} else if ("C".equalsIgnoreCase(status) || "Y".equalsIgnoreCase(confirmed))
				{
					errString =  itmDBAccessLocal.getErrorString("","VTINVSUB3","");

				} else
				{

					sql = " update receipt_form set status = 'S' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					cnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					if (cnt > 0)
					{
						errString = itmDBAccessLocal.getErrorString("", "VTSTATSUBM", "");
						conn.commit();

					} else
					{
						errString = itmDBAccessLocal.getErrorString("", "VTNCONFT", "");
					}
				}
			}

			// end if errstrng
		} catch (Exception e)
		{
			if(conn!=null)
			{
				try {
					conn.rollback();
				} catch (SQLException ex) {

					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;

				}
			} catch (Exception e)
			{
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return errString;

	}
}